/*
 * Decompiled with CFR 0.152.
 */
package excel.jep;

import excel.core.Cell;
import excel.core.WorkSheet;
import excel.core.impl.Cell_;
import excel.core.impl.WorkSheet_;
import excel.jep.ASTVarNode;
import excel.jep.EvaluatorVisitor;
import excel.jep.FunctionTable;
import excel.jep.Node;
import excel.jep.ParseException;
import excel.jep.Parser;
import excel.jep.ParserDumpVisitor;
import excel.jep.SymbolTable;
import excel.jep.function.PostfixMathCommandI;
import excel.jep.function.VBScript.Abs;
import excel.jep.function.VBScript.Asc;
import excel.jep.function.VBScript.Avg;
import excel.jep.function.VBScript.BarCode;
import excel.jep.function.VBScript.CBool;
import excel.jep.function.VBScript.CDate;
import excel.jep.function.VBScript.CInt;
import excel.jep.function.VBScript.CLng;
import excel.jep.function.VBScript.CNumber;
import excel.jep.function.VBScript.CStr;
import excel.jep.function.VBScript.CellInfo;
import excel.jep.function.VBScript.CellText;
import excel.jep.function.VBScript.Chr;
import excel.jep.function.VBScript.Count;
import excel.jep.function.VBScript.Count_distinct;
import excel.jep.function.VBScript.Cumulative;
import excel.jep.function.VBScript.CurrentPageCount;
import excel.jep.function.VBScript.CurrentPageIndex;
import excel.jep.function.VBScript.DaysBetween;
import excel.jep.function.VBScript.HTML2Text;
import excel.jep.function.VBScript.If;
import excel.jep.function.VBScript.Img;
import excel.jep.function.VBScript.IsNaN;
import excel.jep.function.VBScript.IsNull;
import excel.jep.function.VBScript.Join;
import excel.jep.function.VBScript.Max;
import excel.jep.function.VBScript.Mid;
import excel.jep.function.VBScript.Min;
import excel.jep.function.VBScript.Mod;
import excel.jep.function.VBScript.Now;
import excel.jep.function.VBScript.Null;
import excel.jep.function.VBScript.QRCoder;
import excel.jep.function.VBScript.RGB;
import excel.jep.function.VBScript.RMB;
import excel.jep.function.VBScript.RMB2;
import excel.jep.function.VBScript.Random;
import excel.jep.function.VBScript.RandomGuid;
import excel.jep.function.VBScript.Round;
import excel.jep.function.VBScript.Sqrt;
import excel.jep.function.VBScript.Sum;
import excel.jep.function.VBScript.Sum_distinct;
import excel.jep.function.VBScript.Url;
import excel.jep.type.DoubleNumberFactory;
import excel.jep.type.NumberFactory;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Vector;

public class JEP {
    private static final boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab = new FunctionTable();
    private HashMap standardFunction = new HashMap();
    protected Vector errorList;
    private Parser parser;
    private Node topNode = null;
    private EvaluatorVisitor ev;
    private NumberFactory numberFactory;
    WorkSheet Sheet = null;
    private Cell_ clientCell = null;
    private static int DefaultCellInnerRow = -99;
    private int cellInnerRow = -DefaultCellInnerRow;
    private int cellRowIndex;
    private int cellColIndex;

    public void initStandardFunction() {
        this.standardFunction.put("sqrt", new Sqrt());
        this.standardFunction.put("abs", new Abs());
        this.standardFunction.put("mod", new Mod());
        this.standardFunction.put("sum", new Sum());
        this.standardFunction.put("sum_distinct", new Sum_distinct());
        this.standardFunction.put("avg", new Avg());
        this.standardFunction.put("count", new Count());
        this.standardFunction.put("count_distinct", new Count_distinct());
        this.standardFunction.put("cumulative", new Cumulative());
        this.standardFunction.put("mid", new Mid());
        this.standardFunction.put("substring", new Mid());
        this.standardFunction.put("rand", new Random());
        this.standardFunction.put("asc", new Asc());
        this.standardFunction.put("cdate", new CDate());
        this.standardFunction.put("cdbl", new CNumber());
        this.standardFunction.put("parseFloat", new CNumber());
        this.standardFunction.put("parseDouble", new CNumber());
        this.standardFunction.put("chr", new Chr());
        this.standardFunction.put("clng", new CLng());
        this.standardFunction.put("cint", new CInt());
        this.standardFunction.put("floor", new CInt());
        this.standardFunction.put("parseInt", new CInt());
        this.standardFunction.put("cbool", new CBool());
        this.standardFunction.put("cstr", new CStr());
        this.standardFunction.put("round", new Round());
        this.standardFunction.put("now", new Now());
        this.standardFunction.put("if", new If());
        this.standardFunction.put("iif", new If());
        this.standardFunction.put("RandomGuid", new RandomGuid());
        this.standardFunction.put("RMB", new RMB());
        this.standardFunction.put("RMB2", new RMB2());
        this.standardFunction.put("IsNull", new IsNull());
        this.standardFunction.put("isNaN", new IsNaN());
        this.standardFunction.put("html2Text", new HTML2Text());
        this.standardFunction.put("url", new Url());
        this.standardFunction.put("daysbetween", new DaysBetween());
        this.standardFunction.put("max", new Max());
        this.standardFunction.put("min", new Min());
        this.standardFunction.put("rgb", new RGB());
        this.standardFunction.put("pageIndex", new CurrentPageIndex());
        this.standardFunction.put("pageCount", new CurrentPageCount());
        this.standardFunction.put("barCode", new BarCode());
        this.standardFunction.put("img", new Img());
        this.standardFunction.put("join", new Join());
        this.standardFunction.put("NULL", new Null());
        this.standardFunction.put("nullValue", new Null());
        this.standardFunction.put("QRCode", new QRCoder());
    }

    public static JEP newJEP() {
        return new JEP();
    }

    private JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.initSymTab();
        this.addStandardFunctions();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void attachWorkSheet(WorkSheet sheet) {
        this.Sheet = sheet;
    }

    public void attachCell(Cell_ cell) {
        this.clientCell = cell;
    }

    public Cell_ getClientCell() {
        return this.clientCell;
    }

    public Object getTextFromWorkSheet(int row, int col) {
        if (this.Sheet != null) {
            Cell cell = this.Sheet.cells(row, col);
            return cell.getShowText();
        }
        return "";
    }

    public Object getTextFromWorkSheet(String sheetName, int row, int col) {
        WorkSheet sheet;
        if (this.Sheet != null && (sheet = this.Sheet.getWorkBook().getWorkSheet(sheetName)) != null) {
            Cell cell = sheet.cells(row, col);
            return cell.getShowText();
        }
        return "";
    }

    public Object getValueFromWorkSheet(ASTVarNode var) {
        try {
            if (this.Sheet != null) {
                Object v = ((WorkSheet_)this.Sheet).getValueForJEP(this, var, this.cellInnerRow);
                return v;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(0.0);
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initSymTab();
        this.addStandardFunctions();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void addStandardFunctions() {
        this.initStandardFunction();
        this.$addFunction("cellText", new CellText(this));
        this.$addFunction("celltext", new CellText(this));
        this.$addFunction("$rowindex", new CellInfo(this, 1));
        this.$addFunction("$colindex", new CellInfo(this, 2));
        this.$addFunction("$sheetindex", new CellInfo(this, 5));
        for (String funcName : this.standardFunction.keySet()) {
            PostfixMathCommandI func = (PostfixMathCommandI)this.standardFunction.get(funcName);
            this.$addFunction(funcName, func);
        }
    }

    public void $addFunction(String functionName, PostfixMathCommandI function) {
        function.attachJEP(this);
        this.funTab.put(functionName.toLowerCase(), function);
    }

    public void addStandardConstants() {
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        function.attachJEP(this);
        this.funTab.put(functionName.toLowerCase(), function);
    }

    public Double addVariable(String name, double value) {
        Double object = new Double(value);
        this.symTab.put(name.toLowerCase(), object);
        return object;
    }

    public void addVariableAsObject(String name, Object object) {
        this.symTab.put(name.toLowerCase(), object);
    }

    public Object removeVariable(String name) {
        return this.symTab.remove(name.toLowerCase());
    }

    public Object removeFunction(String name) {
        return this.funTab.remove(name.toLowerCase());
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getMessage());
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
        }
    }

    public Object getValueAsObject() throws Exception {
        if (this.topNode != null && !this.hasError()) {
            Object result = this.ev.getValue(this.topNode, this.errorList, this.symTab);
            return result;
        }
        return null;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            int i = 0;
            while (i < this.errorList.size()) {
                str = String.valueOf(str) + this.errorList.elementAt(i) + "\n";
                ++i;
            }
            return str;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public int getCellInnerRow() {
        return this.cellInnerRow;
    }

    public void setCellInnerRow(int cellInnerRow) {
        this.cellInnerRow = cellInnerRow;
    }

    public void resetCellInnerRow() {
        this.cellInnerRow = DefaultCellInnerRow;
    }
}

