/*
 * Decompiled with CFR 0.152.
 */
package excel.jep;

import excel.jep.ASTConstant;
import excel.jep.ASTFunNode;
import excel.jep.ASTStart;
import excel.jep.ASTVarNode;
import excel.jep.Node;
import excel.jep.ParseException;
import excel.jep.ParserVisitor;
import excel.jep.SimpleNode;
import excel.jep.SymbolTable;
import excel.jep.function.PostfixMathCommandI;
import java.util.Stack;
import java.util.Vector;

public class EvaluatorVisitor
implements ParserVisitor {
    private Stack stack = new Stack();
    private Vector errorList = null;
    private SymbolTable symTab = null;
    private boolean errorFlag;
    private static final boolean debug = false;

    private void addToErrorList(String errorStr) {
        if (this.errorList != null) {
            this.errorList.addElement(errorStr);
        }
    }

    public Object getValue(Node topNode, Vector errorList_in, SymbolTable symTab_in) throws Exception {
        this.errorList = errorList_in;
        this.symTab = symTab_in;
        this.errorFlag = false;
        topNode.jjtAccept(this, null);
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    public Object visit(ASTStart node, Object data) {
        return data;
    }

    public Object visit(ASTFunNode node, Object data) {
        if (node == null) {
            return null;
        }
        data = node.childrenAccept(this, data);
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            this.addToErrorList("No function class associated with " + node.getName());
            return data;
        }
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        try {
            pfmc.run(this.stack);
        }
        catch (ParseException e) {
            this.addToErrorList(e.getMessage());
            this.errorFlag = true;
        }
        return data;
    }

    public Object visit(ASTVarNode node, Object data) {
        String message = "Could not evaluate " + node.getName() + ": ";
        if (this.symTab == null) {
            message = String.valueOf(message) + "the symbol table is null";
            this.addToErrorList(message);
            return data;
        }
        Object temp = this.symTab.get(node.getName());
        this.stack.push(temp);
        return data;
    }

    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }
}

