/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.impl.Cell_;
import excel.edit.BasicEdit;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import jun.db.core.ObjectTool;

public class NumericEdit
extends BasicEdit {
    private boolean m_ShowComma = true;
    private int m_DecimalCount = 4;
    private char m_DecimalSeparator;
    private char m_GroupingSeparator;
    private boolean m_AutoSelect = true;
    private int[] keys = new int[]{38, 40, 37, 39, 36, 35, 9, 10, 27, 67, 86, 88};

    public NumericEdit(int DecimalCount, boolean showComma) {
        this.m_ShowComma = showComma;
        this.m_DecimalCount = DecimalCount;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.m_DecimalSeparator = dfs.getDecimalSeparator();
        this.m_GroupingSeparator = dfs.getGroupingSeparator();
        this.setHorizontalAlignment(4);
    }

    public void buildEditText(String value) {
        BigDecimal d;
        Object v;
        if (value == null) {
            Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
            v = cell.getValue(this.currentDBRow);
        } else {
            v = value;
        }
        try {
            d = new BigDecimal(v.toString());
        }
        catch (Exception e) {
            d = null;
        }
        this.SetValue(d);
    }

    public Object getWriteBackValue() {
        double d = this.GetValue();
        Object v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), new BigDecimal(d), this.currentDBRow);
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            return v;
        }
        try {
            return ObjectTool.ChangeType((Object)v, (String)"java.math.BigDecimal");
        }
        catch (Exception e) {
            return new BigDecimal(d);
        }
    }

    public double GetValue() {
        String s = this.getText();
        DecimalFormat df = new DecimalFormat(this.GetPattern());
        df.setGroupingSize(3);
        try {
            return df.parse(s).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void SetValue(double dblValue) {
        String t = this.toString(dblValue);
        this.setText(t);
    }

    public void SetValue(BigDecimal d) {
        if (d == null) {
            this.SetValue(0.0);
        } else {
            this.SetValue(d.doubleValue());
        }
    }

    public String GetPattern() {
        return NumericEdit.GetPattern(this.m_DecimalCount, this.m_DecimalSeparator, this.m_ShowComma, this.m_GroupingSeparator);
    }

    public static String GetPattern(int DecimalCount, char DecimalSeparator, boolean ShowComma, char GroupingSeparator) {
        String pattern;
        if (DecimalCount == 0) {
            pattern = "###,###,###,###,###,###,##0";
        } else {
            String t = "00000000000000000000";
            t = t.substring(0, DecimalCount);
            pattern = "###,###,###,###,###,###,##0." + t;
        }
        if (DecimalSeparator != '.') {
            pattern = pattern.replaceAll(".", String.valueOf(DecimalSeparator));
        }
        if (!ShowComma) {
            pattern = pattern.replaceAll(",", "");
        }
        if (ShowComma && GroupingSeparator != ',') {
            pattern = pattern.replaceAll(",", String.valueOf(GroupingSeparator));
        }
        return pattern;
    }

    static double Round(double num, int i) {
        return ObjectTool.Round((double)num, (int)i);
    }

    String toString(double dblValue) {
        String pattern = this.GetPattern();
        return NumericEdit.toString(dblValue, pattern, this.m_DecimalCount);
    }

    public static String toString(double dblValue, String pattern) {
        int n = pattern.length();
        int p = pattern.indexOf(".");
        if (p < 0) {
            p = n;
        }
        int DecimalCount = n - p;
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(NumericEdit.Round(dblValue, DecimalCount));
    }

    public static String toString(double dblValue, String pattern, int DecimalCount) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(NumericEdit.Round(dblValue, DecimalCount));
    }

    int CaretFarAwayDot() {
        int p = this.getCaretPosition();
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            return n - p;
        }
        return n - p - this.m_DecimalCount - 1;
    }

    int DotPos() {
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            return n;
        }
        return n - this.m_DecimalCount - 1;
    }

    public void SetShowComma(boolean b) {
        this.m_ShowComma = b;
    }

    public boolean GetShowComma() {
        return this.m_ShowComma;
    }

    public int GetDecimalCount() {
        return this.m_DecimalCount;
    }

    public void SetDecimalCount(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 20) {
            n = 20;
        }
        this.m_DecimalCount = n;
    }

    public void focusGained(FocusEvent e) {
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            this.setCaretPosition(n);
        } else {
            this.setCaretPosition(Math.max(n - this.m_DecimalCount - 1, 0));
        }
        if (this.m_AutoSelect) {
            this.setSelectionStart(0);
            this.setSelectionEnd(n);
        }
    }

    private void ProcessBackSpace() {
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        if (cp == 0) {
            return;
        }
        String t = this.getText();
        if (t.charAt(0) == '-' && cp == 1) {
            return;
        }
        int cfad = this.CaretFarAwayDot();
        char c = t.charAt(cp - 1);
        if (c == this.m_DecimalSeparator || c == this.m_GroupingSeparator) {
            this.setCaretPosition(cp - 1);
            return;
        }
        String s = String.valueOf(t.substring(0, cp - 1)) + t.substring(cp);
        s = s.replaceAll(String.valueOf(this.m_GroupingSeparator), "");
        double d = 0.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (Exception e) {
            d = 0.0;
        }
        this.SetValue(d);
        if (cfad >= 0) {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        } else {
            this.setCaretPosition(Math.max(this.DotPos() - cfad - 1, 0));
        }
    }

    private void ProcessDelete() {
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        String t = this.getText();
        if (cp == t.length()) {
            return;
        }
        char c = t.charAt(cp);
        if (c == this.m_GroupingSeparator || c == '-') {
            this.setCaretPosition(cp + 2);
        } else {
            this.setCaretPosition(cp + 1);
        }
        this.ProcessBackSpace();
    }

    private void ProcessNumber(char pch) {
        String s;
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        String t = this.getText();
        int cfad = 0;
        if (cp == t.length()) {
            s = String.valueOf(t) + String.valueOf(pch);
        } else {
            cfad = this.CaretFarAwayDot();
            char c = t.charAt(cp);
            if (c == '-') {
                ++cp;
            }
            s = String.valueOf(t.substring(0, cp)) + String.valueOf(pch) + t.substring(cp);
        }
        s = s.replaceAll(String.valueOf(this.m_GroupingSeparator), "");
        double d = Double.parseDouble(s);
        this.SetValue(d);
        if (cfad >= 0) {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        } else {
            this.setCaretPosition(Math.max(this.DotPos() - cfad + 1, 0));
        }
        if (d == 0.0 && t.charAt(0) == '-') {
            cp = this.getCaretPosition();
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }
    }

    private void ReplaceSel() {
        this.replaceSelection("");
        if (this.getText().indexOf(46) < 0) {
            this.SetValue(this.GetValue());
            this.setCaretPosition(this.DotPos());
        }
    }

    private void ProcessDot() {
        this.ReplaceSel();
        if (this.m_DecimalCount == 0) {
            return;
        }
        this.setCaretPosition(this.DotPos() + 1);
    }

    private void ProcessMINUS() {
        this.ReplaceSel();
        double d = this.GetValue();
        int cp = this.getCaretPosition();
        String t = this.getText();
        int n = t.charAt(0) == '-' ? -1 : 1;
        this.SetValue(-d);
        this.setCaretPosition(cp += n);
        if (d == 0.0 && t.charAt(0) != '-') {
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }
    }

    private void ProcessPLUS() {
        this.ReplaceSel();
        double d = this.GetValue();
        if (d >= 0.0) {
            return;
        }
        this.ProcessMINUS();
    }

    public void keyPressed(KeyEvent e) {
        char c = e.getKeyChar();
        int kc = e.getKeyCode();
        int i = 0;
        while (i < this.keys.length) {
            if (kc == this.keys[i] && (kc != 67 && kc != 86 && kc != 88 || e.isControlDown())) {
                if (kc == 10) {
                    this.textWhenBeginEdit = "";
                }
                super.keyPressed(e);
                return;
            }
            ++i;
        }
        e.consume();
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (c >= '0' && c <= '9') {
            this.ProcessNumber(c);
            e.consume();
        }
        if (c == '.') {
            this.ProcessDot();
        }
        if (c == '-') {
            this.ProcessMINUS();
        }
        if (c == '+') {
            this.ProcessPLUS();
        }
        switch (e.getKeyChar()) {
            case '\b': {
                this.ProcessBackSpace();
                e.consume();
                break;
            }
            case '\u007f': {
                this.ProcessDelete();
                e.consume();
                break;
            }
        }
        super.keyTyped(e);
        char kc = e.getKeyChar();
        int i = 0;
        while (i < this.keys.length) {
            if (kc == this.keys[i]) {
                return;
            }
            ++i;
        }
        e.consume();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(new Color(220, 220, 220));
        int offset = this.m_DecimalCount * 8;
        Graphics2D g2 = (Graphics2D)g;
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.3f);
        g2.setComposite(ac);
        g.fillRect(this.getWidth() - offset, 0, offset, this.getHeight());
        ac = AlphaComposite.getInstance(3, 1.0f);
        g2.setComposite(ac);
    }

    public void adjustEditRect() {
    }
}

