/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.edit.CheckBoxPanel;
import excel.edit.DataList;
import excel.edit.DropDownListBox;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.text.Position;
import jun.db.core.ObjectTool;

class ListFrame
extends JDialog {
    DropDownListBox ddlb;
    DataList dataList = null;
    CheckBoxPanel checkboxPanel = null;
    JScrollPane scrollPane = null;
    int ListCount = 0;
    Object[] showvalues;
    Object[] keyvalues;
    boolean modal;

    public ListFrame(DropDownListBox ddlb_, Frame pf) {
        super(pf, null, ddlb_.Sheet.getWorkBook().getWorkBookView().isInModalDialog() && !ddlb_.ES.isDropDownListEditable());
        this.init(ddlb_);
    }

    public ListFrame(DropDownListBox ddlb_, Dialog pd) {
        super(pd, null, ddlb_.Sheet.getWorkBook().getWorkBookView().isInModalDialog() && !ddlb_.ES.isDropDownListEditable());
        this.init(ddlb_);
    }

    public void init(DropDownListBox ddlb_) {
        JComponent obj;
        this.modal = ddlb_.Sheet.getWorkBook().getWorkBookView().isInModalDialog() && !ddlb_.ES.isDropDownListEditable();
        Tools.log(JOptionPane.getFrameForComponent(ddlb_.View).getClass().getName());
        Container comp = ddlb_.Sheet.getWorkBook().getWorkBookView();
        while (comp != null) {
            Tools.log(comp.getClass().getName());
            comp = comp.getParent();
        }
        this.setUndecorated(true);
        this.ddlb = ddlb_;
        boolean addFocusListener = !ddlb_.ES.isDropDownListEditable();
        this.getContentPane().setLayout(new BorderLayout());
        boolean chk = this.ddlb.ES.isListShowAsDropdownCheckBox();
        if (chk) {
            this.checkboxPanel = new CheckBoxPanel(this.ddlb, this, addFocusListener);
            this.resetList("");
            obj = this.checkboxPanel;
        } else {
            this.dataList = new DataList(this.ddlb, this, addFocusListener, this.ddlb.getItemHeight());
            obj = this.dataList;
            this.resetList("");
        }
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setView(obj);
        this.scrollPane.setFocusable(true);
        this.scrollPane.setBorder(null);
        Border border = BorderFactory.createLineBorder(new Color(0x6C6CFF), 1);
        JPanel main = new JPanel();
        main.setBorder(border);
        main.setLayout(new BorderLayout());
        main.add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)main, "Center");
        if (this.modal || chk) {
            JPanel toolbar = new JPanel();
            toolbar.setPreferredSize(new Dimension(20, 20));
            toolbar.setFocusable(false);
            Color background_color = new Color(0xEFEFEF);
            toolbar.setBackground(background_color);
            main.add((Component)toolbar, "South");
            toolbar.setLayout(new BorderLayout());
            if (chk) {
                JCheckBox jbSelectAll = new JCheckBox("\u5168\u9009");
                jbSelectAll.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JCheckBox jb = (JCheckBox)e.getSource();
                        if (jb.isSelected()) {
                            int i = 0;
                            while (i < ListFrame.this.showvalues.length) {
                                ListFrame.this.ddlb.checkedMap.put(ListFrame.this.showvalues[i], true);
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while (i < ListFrame.this.showvalues.length) {
                                ListFrame.this.ddlb.checkedMap.remove(ListFrame.this.showvalues[i]);
                                ++i;
                            }
                        }
                        ListFrame.this.repaint();
                    }
                });
                jbSelectAll.setBackground(background_color);
                jbSelectAll.setFocusable(false);
                toolbar.add((Component)jbSelectAll, "West");
            }
            JButton jbOK = new JButton("");
            jbOK.setCursor(new Cursor(12));
            JPanel p1 = new JPanel();
            BorderLayout bl = new BorderLayout();
            bl.setHgap(1);
            bl.setVgap(0);
            p1.setLayout(bl);
            JLabel t1 = new JLabel();
            t1.setPreferredSize(new Dimension(2, 2));
            JLabel t2 = new JLabel();
            t2.setPreferredSize(new Dimension(2, 2));
            JLabel t3 = new JLabel();
            t3.setPreferredSize(new Dimension(2, 2));
            p1.add((Component)t1, "East");
            p1.add((Component)t2, "South");
            p1.add((Component)t3, "North");
            p1.add((Component)jbOK, "Center");
            toolbar.add((Component)p1, "East");
            jbOK.setIcon(new ImageIcon(Tools.GetImageFromURL(this, "excel/res/ok.gif")));
            jbOK.setPreferredSize(new Dimension(50, 16));
            jbOK.setFocusable(false);
            jbOK.setBackground(background_color);
            Border GRAY_BORDER = BorderFactory.createLineBorder(Color.gray, 1);
            jbOK.setBorder(null);
            jbOK.setFocusable(false);
            jbOK.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ListFrame.this.ddlb.giveUpFocus();
                    ListFrame.this.ddlb.removeSelf();
                    ListFrame.this.ddlb.repaintCell();
                }
            });
        }
    }

    public void resetList(String filter) {
        this.ddlb.debugInfo("resetList");
        Map<Object, String> map = this.ddlb.map;
        if (map == null) {
            map = new HashMap<Object, String>();
        }
        if (map != null) {
            Iterator<Object> it = map.keySet().iterator();
            ArrayList<String> sv = new ArrayList<String>();
            ArrayList<String> kv = new ArrayList<String>();
            boolean filterIsNull = filter.equals("");
            filter = filter.toLowerCase();
            String[] keys = filter.split("\\s", 9999);
            boolean includeNull = false;
            while (it.hasNext()) {
                String k = "";
                String v = "";
                try {
                    k = (String)ObjectTool.ChangeType((Object)it.next(), (String)"java.lang.String");
                    v = (String)ObjectTool.ChangeType((Object)map.get(k), (String)"java.lang.String");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (k == null || v == null || "".equals(k) || "".equals(v)) {
                    includeNull = true;
                    sv.add(v);
                    kv.add(k);
                    continue;
                }
                if (!filterIsNull && !this.includeKeys(k, keys) && !this.includeKeys(v, keys)) continue;
                sv.add(v);
                kv.add(k);
            }
            if (!(includeNull || this.ddlb.ES.isListShowAsCheckBox() || this.ddlb.ES.isListShowAsRadioButton() || this.ddlb.ES.isListShowAsDropdownCheckBox())) {
                sv.add("");
                kv.add("");
            }
            this.showvalues = sv.toArray();
            this.keyvalues = kv.toArray();
            if (this.dataList != null) {
                this.dataList.setListData(this.showvalues);
            }
            this.ListCount = this.showvalues.length;
        }
    }

    private boolean includeKeys(String v, String[] ks) {
        v = v.toLowerCase();
        int i = 0;
        while (i < ks.length) {
            if (v.indexOf(ks[i]) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean LocateItem() {
        this.ddlb.debugInfo("LocateItem");
        if (this.ListCount == 0) {
            this.ddlb.debugInfo("count = 0");
            return false;
        }
        int index = -1;
        String s = this.ddlb.superGetText();
        this.ddlb.debugInfo("text : " + s);
        if (s.equals("")) {
            return false;
        }
        boolean found = false;
        while (index + 1 < this.ListCount) {
            int ti = index + 1;
            if ((index = this.dataList.getNextMatch(s, ti, Position.Bias.Forward)) < 0) {
                index = 0;
                break;
            }
            if (this.showvalues[index].toString().equals(s) || this.keyvalues[index].toString().equals(s)) {
                found = true;
                break;
            }
            if (index < ti) break;
            ++index;
        }
        if (!found) {
            index = this.dataList.getNextMatch(s, 0, Position.Bias.Forward);
        }
        if (index < 0) {
            index = 0;
        }
        this.dataList.setSelectedIndex(index);
        this.dataList.scrollRectToVisible(this.dataList.getCellBounds(Math.max(0, index - 1), Math.min(index + 1, this.ListCount - 1)));
        return true;
    }

    protected void processWindowEvent(WindowEvent e) {
        System.out.println(String.valueOf(e.getID()) + " ");
        super.processWindowEvent(e);
    }
}

