/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.impl.Cell_;
import excel.edit.BasicEdit;
import excel.setting.ColorPopupMenu;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class HTMLDocumentEditor
extends BasicEdit
implements ActionListener {
    JComboBox fontCombo;
    JComboBox fontSizeCbo;
    ToolButton cutButton;
    ToolButton copyButton;
    ToolButton pasteButton;
    ToolButton pasteExcelButton;
    ToolToggleButton boldButton;
    ToolToggleButton underlineButton;
    ToolToggleButton italicButton;
    ToolToggleButton subscriptButton;
    ToolToggleButton superscriptButton;
    ToolToggleButton strikeThroughButton;
    ToolButton leftAlignButton;
    ToolButton centerButton;
    ToolButton rightAlignButton;
    ToolButton colorButton;
    ToolBarPanel toolPane1;
    ToolBarPanel toolPane2;
    JScrollPane scrollPane;
    int[] fontSizes = new int[]{8, 10, 12, 14, 16, 20, 32};
    private HTMLDocument document;
    private HTMLEditorKit editorKit;
    private JTextPane textPane = new JTextPane();
    private boolean debug = false;
    File currentFile = null;
    protected UndoableEditListener undoHandler = new UndoHandler();
    protected UndoManager undo = new UndoManager();
    private UndoAction undoAction = new UndoAction();
    private RedoAction redoAction = new RedoAction();
    private Action cutAction = new DefaultEditorKit.CutAction();
    private Action copyAction = new DefaultEditorKit.CopyAction();
    private Action pasteAction = new DefaultEditorKit.PasteAction();
    private Action pasteExcelAction = new PasteAction();
    private Action boldAction = new StyledEditorKit.BoldAction();
    private Action underlineAction = new StyledEditorKit.UnderlineAction();
    private Action italicAction = new StyledEditorKit.ItalicAction();
    private Action insertBreakAction = new DefaultEditorKit.InsertBreakAction();
    private HTMLEditorKit.InsertHTMLTextAction unorderedListAction = new HTMLEditorKit.InsertHTMLTextAction("Bullets", "<ul><li> </li></ul>", HTML.Tag.P, HTML.Tag.UL);
    private HTMLEditorKit.InsertHTMLTextAction bulletAction = new HTMLEditorKit.InsertHTMLTextAction("Bullets", "<ul><li> </li><ul>", HTML.Tag.UL, HTML.Tag.LI);

    public HTMLDocumentEditor() {
        this.editorKit = new HTMLEditorKit(){

            protected HTMLEditorKit.Parser getParser() {
                try {
                    Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                    HTMLEditorKit.Parser defaultParser = (HTMLEditorKit.Parser)c.newInstance();
                    return defaultParser;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        if (this.editorKit == null) {
            this.editorKit = new HTMLEditorKit();
        }
        this.document = (HTMLDocument)this.editorKit.createDefaultDocument();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        this.init();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        Container cc = f.getContentPane();
        cc.setLayout(new BorderLayout());
        HTMLDocumentEditor editor = new HTMLDocumentEditor();
        editor.setText("aaaa");
        cc.add((Component)editor, "Center");
        f.setVisible(true);
        f.setBounds(0, 0, 500, 500);
    }

    public void init() {
        this.setEditable(false);
        this.setFocusable(false);
        this.toolPane1 = new ToolBarPanel();
        this.toolPane2 = new ToolBarPanel();
        this.toolPane1.setPreferredSize(new Dimension(500, 26));
        this.toolPane2.setPreferredSize(new Dimension(500, 26));
        FlowLayout fl = new FlowLayout(0);
        fl.setVgap(2);
        this.toolPane1.setLayout(fl);
        this.toolPane2.setLayout(fl);
        this.fontCombo = new JComboBox();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontNames.length) {
            this.fontCombo.addItem(fontNames[i]);
            ++i;
        }
        this.fontCombo.setFocusable(false);
        this.fontCombo.setMaximumRowCount(12);
        this.fontCombo.setPreferredSize(new Dimension(130, 20));
        Border border = BorderFactory.createLoweredBevelBorder();
        this.fontCombo.setBorder(border);
        this.fontCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JComboBox source = (JComboBox)evt.getSource();
                if (!source.isEnabled()) {
                    return;
                }
                String item = (String)source.getSelectedItem();
                StyledEditorKit.FontFamilyAction newFontFamilyAction = new StyledEditorKit.FontFamilyAction("fontFamilyAction", item);
                newFontFamilyAction.actionPerformed(evt);
                HTMLDocumentEditor.this.textPane.repaint();
            }
        });
        this.fontSizeCbo = new JComboBox();
        this.fontSizeCbo.setFocusable(false);
        this.fontSizeCbo.setPreferredSize(new Dimension(40, 20));
        this.fontSizeCbo.setBorder(border);
        this.fontSizeCbo.setMaximumRowCount(this.fontSizes.length);
        int i2 = 0;
        while (i2 < this.fontSizes.length) {
            this.fontSizeCbo.addItem(String.valueOf(this.fontSizes[i2]));
            ++i2;
        }
        this.fontSizeCbo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JComboBox source = (JComboBox)evt.getSource();
                if (!source.isEnabled()) {
                    return;
                }
                String item = source.getSelectedItem().toString();
                StyledEditorKit.FontSizeAction newFontSizeAction = new StyledEditorKit.FontSizeAction(item, new Integer(item));
                newFontSizeAction.actionPerformed(evt);
                HTMLDocumentEditor.this.textPane.repaint();
            }
        });
        this.toolPane1.add(this.fontCombo);
        this.toolPane1.add(this.fontSizeCbo);
        this.cutButton = this.newToolButton(this.cutAction, "button.cut.gif", "\u526a\u5207");
        this.copyButton = this.newToolButton(this.copyAction, "button.copy.gif", "\u590d\u5236");
        this.pasteButton = this.newToolButton(this.pasteAction, "button.paste.gif", "\u7c98\u8d34");
        this.pasteExcelButton = this.newToolButton(this.pasteExcelAction, "button.pasteExcel.gif", "\u7c98\u8d34\u4e3a\u8868\u683c");
        this.boldButton = this.newToolToggleButton(this.boldAction, "button.bold.gif");
        this.underlineButton = this.newToolToggleButton(this.underlineAction, "button.underline.gif");
        this.italicButton = this.newToolToggleButton(this.italicAction, "button.italic.gif");
        this.toolPane1.add(this.cutButton);
        this.toolPane1.add(this.copyButton);
        this.toolPane1.add(this.pasteButton);
        this.toolPane1.add(this.pasteExcelButton);
        this.toolPane1.addSeparator();
        this.toolPane1.add(this.newToolButton(this.undoAction, "button.undo.gif", "\u64a4\u9500"));
        this.toolPane1.add(this.newToolButton(this.redoAction, "button.redo.gif", "\u91cd\u505a"));
        this.toolPane1.addSeparator();
        this.subscriptButton = this.newToolToggleButton(new SubscriptAction(), "button.subscript.gif");
        this.superscriptButton = this.newToolToggleButton(new SuperscriptAction(), "button.superscript.gif");
        this.strikeThroughButton = this.newToolToggleButton(new StrikeThroughAction(), "button.strikethrough.gif");
        this.leftAlignButton = this.newToolButton(new StyledEditorKit.AlignmentAction("Left Align", 0), "button.justifyleft.gif", "\u5de6\u5bf9\u9f50");
        this.centerButton = this.newToolButton(new StyledEditorKit.AlignmentAction("Center", 1), "button.justifycenter.gif", "\u5c45\u4e2d\u5bf9\u9f50");
        this.rightAlignButton = this.newToolButton(new StyledEditorKit.AlignmentAction("Right Align", 2), "button.justifyright.gif", "\u53f3\u5bf9\u9f50");
        this.colorButton = this.newToolButton(null, "button.textcolor.gif", "\u6587\u5b57\u989c\u8272");
        this.colorButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ColorPopupMenu m_color = new ColorPopupMenu();
                m_color.setFocusable(false);
                m_color.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ColorPopupMenu m = (ColorPopupMenu)e.getSource();
                        Color color = m.getColor();
                        StyledEditorKit.ForegroundAction newColorAction = new StyledEditorKit.ForegroundAction("", color);
                        newColorAction.actionPerformed(e);
                    }
                });
                m_color.show(HTMLDocumentEditor.this.colorButton, 0, HTMLDocumentEditor.this.colorButton.getHeight());
            }
        });
        this.toolPane2.add(this.boldButton);
        this.toolPane2.add(this.underlineButton);
        this.toolPane2.add(this.italicButton);
        this.toolPane2.addSeparator();
        this.toolPane2.add(this.subscriptButton);
        this.toolPane2.add(this.superscriptButton);
        this.toolPane2.add(this.strikeThroughButton);
        this.toolPane2.addSeparator();
        this.toolPane2.add(this.leftAlignButton);
        this.toolPane2.add(this.centerButton);
        this.toolPane2.add(this.rightAlignButton);
        this.toolPane2.addSeparator();
        this.toolPane2.add(this.colorButton);
        this.document.addUndoableEditListener(this.undoHandler);
        this.document.setDocumentFilter(new CustDocumentFilter());
        this.resetUndoManager();
        this.textPane = new JTextPane(this.document);
        this.textPane.setContentType("text/html");
        this.scrollPane = new JScrollPane(this.textPane);
        this.scrollPane.setBorder(null);
        this.textPane.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent ce) {
                HTMLDocumentEditor.this.handleCaretPositionChange(ce);
            }
        });
        this.textPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.isControlDown() && e.getKeyCode() == 90) {
                    HTMLDocumentEditor.this.undoAction.actionPerformed(null);
                }
                if (e.isControlDown() && e.getKeyCode() == 89) {
                    HTMLDocumentEditor.this.redoAction.actionPerformed(null);
                }
            }
        });
        JPanel toolPane = new JPanel();
        toolPane.setLayout(new BorderLayout());
        toolPane.add((Component)this.toolPane1, "North");
        toolPane.add((Component)this.toolPane2, "South");
        toolPane.setFocusable(false);
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.add((Component)toolPane, "North");
        this.add((Component)this.scrollPane, "Center");
        this.startNewDocument();
        this.setVisible(true);
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (this.debug) {
            int modifier = ae.getModifiers();
            long when = ae.getWhen();
            String string = ae.paramString();
        }
        if (actionCommand.compareTo("New") == 0) {
            this.startNewDocument();
        } else if (actionCommand.compareTo("Open") == 0) {
            this.openDocument();
        } else if (actionCommand.compareTo("Save") == 0) {
            this.saveDocument();
        } else if (actionCommand.compareTo("Save As") == 0) {
            this.saveDocumentAs();
        } else if (actionCommand.compareTo("Exit") == 0) {
            this.exit();
        } else if (actionCommand.compareTo("Clear") == 0) {
            this.clear();
        } else if (actionCommand.compareTo("Select All") == 0) {
            this.selectAll();
        }
    }

    public ImageIcon newImageIcon(String img) {
        return new ImageIcon(Tools.GetImageFromURL(this, "excel/edit/res/" + img));
    }

    public ToolButton newToolButton(Action action, String img, String tip) {
        ToolButton b = new ToolButton(action, this.newImageIcon(img), null);
        b.setOpaque(false);
        b.setToolTipText(tip);
        return b;
    }

    public ToolToggleButton newToolToggleButton(Action action, String img) {
        ToolToggleButton b = new ToolToggleButton(action, this.newImageIcon(img), null);
        b.setOpaque(false);
        return b;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    public void startNewDocument() {
        Document oldDoc = this.textPane.getDocument();
        if (oldDoc != null) {
            oldDoc.removeUndoableEditListener(this.undoHandler);
        }
        HTMLEditorKit editorKit = new HTMLEditorKit();
        this.document = (HTMLDocument)editorKit.createDefaultDocument();
        this.textPane.setDocument(this.document);
        this.currentFile = null;
        this.textPane.getDocument().addUndoableEditListener(this.undoHandler);
        this.resetUndoManager();
    }

    public void openDocument() {
        try {
            File current = new File(".");
            JFileChooser chooser = new JFileChooser(current);
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new HTMLFileFilter());
            int approval = chooser.showSaveDialog(this);
            if (approval == 0) {
                this.currentFile = chooser.getSelectedFile();
                FileReader fr = new FileReader(this.currentFile);
                Document oldDoc = this.textPane.getDocument();
                if (oldDoc != null) {
                    oldDoc.removeUndoableEditListener(this.undoHandler);
                }
                HTMLEditorKit editorKit = new HTMLEditorKit();
                this.document = (HTMLDocument)editorKit.createDefaultDocument();
                editorKit.read(fr, (Document)this.document, 0);
                this.document.addUndoableEditListener(this.undoHandler);
                this.textPane.setDocument(this.document);
                this.resetUndoManager();
            }
        }
        catch (BadLocationException ble) {
            System.err.println("BadLocationException: " + ble.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("FileNotFoundException: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }

    public void saveDocument() {
        block10: {
            BufferedImage img = new BufferedImage(this.textPane.getWidth(), this.textPane.getHeight(), 1);
            Graphics g = img.getGraphics();
            this.textPane.paint(g);
            try {
                try {
                    byte[] ret = null;
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    BufferedOutputStream bos = new BufferedOutputStream(bo);
                    ImageIO.write((RenderedImage)img, "png", bos);
                    bos.flush();
                    bos.close();
                    ret = bo.toByteArray();
                    FileOutputStream fos = new FileOutputStream("d:/a.png");
                    fos.write(ret);
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    g.dispose();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                g.dispose();
                throw throwable;
            }
            g.dispose();
        }
        if (this.currentFile != null) {
            try {
                FileWriter fw = new FileWriter(this.currentFile);
                fw.write(this.textPane.getText());
                fw.close();
            }
            catch (FileNotFoundException fnfe) {
                System.err.println("FileNotFoundException: " + fnfe.getMessage());
            }
            catch (IOException ioe) {
                System.err.println("IOException: " + ioe.getMessage());
            }
        } else {
            this.saveDocumentAs();
        }
    }

    public void saveDocumentAs() {
        try {
            File current = new File(".");
            JFileChooser chooser = new JFileChooser(current);
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(new HTMLFileFilter());
            int approval = chooser.showSaveDialog(this);
            if (approval == 0) {
                File newFile = chooser.getSelectedFile();
                if (newFile.exists()) {
                    String message = String.valueOf(newFile.getAbsolutePath()) + " already exists. \n" + "Do you want to replace it?";
                    if (JOptionPane.showConfirmDialog(this, message) == 0) {
                        this.currentFile = newFile;
                        FileWriter fw = new FileWriter(this.currentFile);
                        fw.write(this.textPane.getText());
                        fw.close();
                        if (this.debug) {
                            Tools.log("Saved " + this.currentFile.getAbsolutePath());
                        }
                    }
                } else {
                    this.currentFile = new File(newFile.getAbsolutePath());
                    FileWriter fw = new FileWriter(this.currentFile);
                    fw.write(this.textPane.getText());
                    fw.close();
                    if (this.debug) {
                        Tools.log("Saved " + this.currentFile.getAbsolutePath());
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("FileNotFoundException: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }

    public void exit() {
        String exitMessage = "Are you sure you want to exit?";
        if (JOptionPane.showConfirmDialog(this, exitMessage) == 0) {
            System.exit(0);
        }
    }

    public void clear() {
        this.startNewDocument();
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    private String findStyle(Element element) {
        AttributeSet as = element.getAttributes();
        if (as == null) {
            return null;
        }
        Object val = as.getAttribute(HTML.Attribute.CLASS);
        if (val != null && val instanceof String) {
            return (String)val;
        }
        Enumeration<?> e = as.getAttributeNames();
        while (e.hasMoreElements()) {
            AttributeSet eas;
            Object key = e.nextElement();
            if (!(key instanceof HTML.Tag) || (eas = (AttributeSet)as.getAttribute(key)) == null || (val = eas.getAttribute(HTML.Attribute.CLASS)) == null) continue;
            return (String)val;
        }
        return null;
    }

    void handleCaretPositionChange(CaretEvent ce) {
        int caretPos = this.textPane.getCaretPosition();
        Element element = this.document.getCharacterElement(caretPos);
        AttributeSet as = element.getAttributes();
        if (as != null) {
            Object val = as.getAttribute(HTML.Attribute.ALIGN);
            while (val == null) {
                if ((element = element.getParentElement()) == null) break;
                val = as.getAttribute(HTML.Attribute.HALIGN);
            }
        }
        AttributeSet mainAttrs = this.textPane.getCharacterAttributes();
        Enumeration<?> e = mainAttrs.getAttributeNames();
        String activeFontName = "\u5b8b\u4f53";
        int fontsize = 3;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean linethrough = false;
        boolean sub = false;
        boolean super_ = false;
        boolean alignleft = false;
        boolean aligncenter = false;
        boolean alignright = false;
        while (e.hasMoreElements()) {
            Object nexte = e.nextElement();
            Object attrValue = mainAttrs.getAttribute(nexte);
            String attrName = nexte.toString().toLowerCase();
            if (attrName.equals("face") || attrName.equals("font-family")) {
                activeFontName = attrValue.toString();
            }
            if (attrName.equals("font-weight")) {
                bold = attrValue.toString().equals("bold");
            }
            if (attrName.equals("font-style")) {
                italic = attrValue.toString().equals("italic");
            }
            if (attrName.equals("text-decoration")) {
                boolean bl = underline = attrValue.toString().indexOf("underline") >= 0;
            }
            if (attrName.equals("text-decoration")) {
                boolean bl = linethrough = attrValue.toString().indexOf(" line-through") >= 0;
            }
            if (attrName.equals("vertical-align")) {
                sub = attrValue.toString().equals("sub");
            }
            if (attrName.equals("vertical-align")) {
                super_ = attrValue.toString().equals("super");
            }
            if (!attrName.equals("font-size")) continue;
            fontsize = new Integer(attrValue.toString());
        }
        this.fontCombo.setEnabled(false);
        this.fontCombo.getModel().setSelectedItem(activeFontName);
        this.fontCombo.setEnabled(true);
        this.fontSizeCbo.setEnabled(false);
        this.fontSizeCbo.setSelectedIndex(fontsize - 1);
        this.fontSizeCbo.setEnabled(true);
        this.boldButton.setSelected(bold);
        this.underlineButton.setSelected(underline);
        this.italicButton.setSelected(italic);
        this.subscriptButton.setSelected(sub);
        this.superscriptButton.setSelected(super_);
        this.strikeThroughButton.setSelected(linethrough);
        this.leftAlignButton.setSelected(alignleft);
        this.centerButton.setSelected(aligncenter);
        this.rightAlignButton.setSelected(alignright);
    }

    public void buildEditText(String value) {
        String s;
        if (value == null) {
            Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
            s = cell.getEditText(this.currentDBRow);
        } else {
            s = value;
        }
        this.removeFocusListener(this);
        this.removeKeyListener(this);
        this.setFocusable(false);
        if (this.readOnly) {
            this.textPane.setEditable(false);
        }
        ActionEvent evt = new ActionEvent(this.textPane, 0, "12");
        StyledEditorKit.FontSizeAction newFontSizeAction = new StyledEditorKit.FontSizeAction("12", 12);
        newFontSizeAction.actionPerformed(evt);
        this.textPane.setText(s);
        this.textPane.setFocusable(true);
        this.textPane.addKeyListener(this);
        Rectangle validRC = (Rectangle)this.editRC.clone();
        this.setBounds(this.editRC);
        this.textPane.requestFocusInWindow();
    }

    public void longForFocus() {
        this.textPane.requestFocusInWindow();
    }

    public String getText() {
        Object s = this.getWriteBackValue();
        if (s == null) {
            return "";
        }
        return s.toString();
    }

    public void setText(String s) {
        this.textPane.setText(s);
    }

    public Object getWriteBackValue() {
        String s = this.textPane.getText();
        if (s.equals("")) {
            s = null;
        }
        s = Tools.ToGBKHTML(s).toString();
        if (this.Sheet != null) {
            Object v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), s, this.currentDBRow);
            return v;
        }
        return s;
    }

    public void insertSpace() {
        try {
            HTMLEditorKit kit = (HTMLEditorKit)this.textPane.getEditorKit();
            kit.insertHTML(this.document, this.textPane.getCaretPosition(), "&nbsp;", 0, 0, HTML.Tag.TABLE);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void insertBR() {
        try {
            int caretPos = this.textPane.getCaretPosition();
            this.editorKit.insertHTML(this.document, caretPos, "<BR>", 0, 0, HTML.Tag.BR);
            this.textPane.setCaretPosition(caretPos + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 32: {
                this.insertSpace();
                e.consume();
                break;
            }
            case 10: {
                this.insertBR();
                e.consume();
                break;
            }
            case 9: {
                int i = 0;
                while (i < 4) {
                    this.insertSpace();
                    ++i;
                }
                e.consume();
                break;
            }
            case 27: {
                super.keyPressed(e);
                break;
            }
        }
    }

    public void adjustEditRect() {
    }

    class CustDocumentFilter
    extends DocumentFilter {
        String space = " ";
        String spaceSeq = "&nbsp;";
        String tab = "\t";
        String tabSeq = "&nbsp;&nbsp;&nbsp;&nbsp;";

        CustDocumentFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            string = this.doFiltering(string);
            fb.insertString(offset, string, attr);
        }

        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            fb.remove(offset, length);
        }

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = this.doFiltering(text);
            fb.replace(offset, length, text, attrs);
        }

        private String doFiltering(String in) {
            String out = in.replaceAll(this.space, this.spaceSeq);
            return out.replaceAll(this.tab, this.tabSeq);
        }
    }

    class FrameListener
    extends WindowAdapter {
        FrameListener() {
        }

        public void windowClosing(WindowEvent we) {
            System.exit(0);
        }
    }

    class HTMLFileFilter
    extends FileFilter {
        HTMLFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().indexOf(".htm") > 0;
        }

        public String getDescription() {
            return "html";
        }
    }

    class PasteAction
    extends DefaultEditorKit.PasteAction {
        PasteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable cc = sysc.getContents(null);
            if (cc != null) {
                String s = "";
                try {
                    s = cc.getTransferData(DataFlavor.stringFlavor).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                StringBuffer sb = new StringBuffer();
                ArrayList ret = HTMLDocumentEditor.this.parseClipboardData(s);
                if (ret.size() == 0) {
                    return;
                }
                sb.append("<table border=1>");
                int ai = 0;
                while (ai < ret.size()) {
                    ArrayList rowList = (ArrayList)ret.get(ai);
                    sb.append("<tr>");
                    int ri = 0;
                    while (ri < rowList.size()) {
                        String t = (String)rowList.get(ri);
                        if (t.equals("")) {
                            t = "&nbsp;";
                        }
                        sb.append("<td nowrap align=center>").append(t).append("</td>");
                        ++ri;
                    }
                    sb.append("</tr>");
                    ++ai;
                }
                sb.append("</table>&nbsp;");
                try {
                    HTMLEditorKit kit = (HTMLEditorKit)HTMLDocumentEditor.this.textPane.getEditorKit();
                    kit.insertHTML(HTMLDocumentEditor.this.document, HTMLDocumentEditor.this.textPane.getCaretPosition(), sb.toString(), 0, 0, HTML.Tag.TABLE);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                HTMLDocumentEditor.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.update();
            HTMLDocumentEditor.this.undoAction.update();
        }

        protected void update() {
            if (HTMLDocumentEditor.this.undo.canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class StrikeThroughAction
    extends StyledEditorKit.StyledTextAction {
        public StrikeThroughAction() {
            super(StyleConstants.StrikeThrough.toString());
        }

        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean strikeThrough = !StyleConstants.isStrikeThrough(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setStrikeThrough(sas, strikeThrough);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class SubscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SubscriptAction() {
            super(StyleConstants.Subscript.toString());
        }

        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean subscript = !StyleConstants.isSubscript(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setSubscript(sas, subscript);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class SuperscriptAction
    extends StyledEditorKit.StyledTextAction {
        public SuperscriptAction() {
            super(StyleConstants.Superscript.toString());
        }

        public void actionPerformed(ActionEvent ae) {
            JEditorPane editor = this.getEditor(ae);
            if (editor != null) {
                StyledEditorKit kit = this.getStyledEditorKit(editor);
                MutableAttributeSet attr = kit.getInputAttributes();
                boolean superscript = !StyleConstants.isSuperscript(attr);
                SimpleAttributeSet sas = new SimpleAttributeSet();
                StyleConstants.setSuperscript(sas, superscript);
                this.setCharacterAttributes(editor, sas, false);
            }
        }
    }

    class ToolBarPanel
    extends JPanel {
        Image img = null;

        public ToolBarPanel() {
            this.setOpaque(false);
            this.setFocusable(false);
        }

        public void addSeparator() {
            JLabel separator = new JLabel(HTMLDocumentEditor.this.newImageIcon("vsp.gif"));
            separator.setFocusable(false);
            this.add(separator);
        }

        public void paint(Graphics g) {
            if (this.img == null) {
                this.img = Tools.GetImageFromURL(this, "excel/edit/res/bandbkgray.gif");
            }
            Graphics2D g2 = (Graphics2D)g;
            int n = this.getWidth() / 4 + 1;
            int i = 0;
            while (i < n) {
                g.drawImage(this.img, i * 4, 0, this);
                ++i;
            }
            super.paint(g);
        }
    }

    class ToolButton
    extends JButton
    implements MouseListener {
        Border normalBorder;
        Border focusBorder;
        Color normalBGColor;
        Color focusBGColor;

        public ToolButton(Action action, Icon icon, String caption) {
            super(action);
            this.normalBorder = null;
            this.focusBorder = BorderFactory.createLineBorder(new Color(0x4848FF));
            this.focusBGColor = new Color(0xEFE3EF);
            this.setIcon(icon);
            this.setText(caption);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(20, 20));
            this.setFocusable(false);
            this.setBorder(null);
            this.addMouseListener(this);
            this.normalBGColor = this.getBackground();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setBorder(this.focusBorder);
            this.setOpaque(true);
            this.setBackground(this.focusBGColor);
        }

        public void mouseExited(MouseEvent e) {
            this.setBorder(this.normalBorder);
            this.setOpaque(false);
            this.setBackground(this.normalBGColor);
        }

        public void mousePressed(MouseEvent e) {
            HTMLDocumentEditor.this.handleCaretPositionChange(null);
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class ToolToggleButton
    extends JToggleButton
    implements MouseListener {
        Border normalBorder;
        Border focusBorder;
        Color normalBGColor;
        Color focusBGColor;

        public ToolToggleButton(Action action, Icon icon, String caption) {
            super(action);
            this.normalBorder = null;
            this.focusBorder = BorderFactory.createLineBorder(new Color(0x4848FF));
            this.focusBGColor = new Color(12435397);
            this.setIcon(icon);
            this.setText(caption);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(20, 20));
            this.setFocusable(false);
            this.setBorder(null);
            this.addMouseListener(this);
            this.normalBGColor = this.getBackground();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setOpaque(true);
            this.setBackground(this.focusBGColor);
        }

        public void mouseExited(MouseEvent e) {
            this.setOpaque(false);
            this.setBackground(this.normalBGColor);
        }

        public void mousePressed(MouseEvent e) {
            HTMLDocumentEditor.this.handleCaretPositionChange(null);
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                HTMLDocumentEditor.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.update();
            HTMLDocumentEditor.this.redoAction.update();
        }

        protected void update() {
            if (HTMLDocumentEditor.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            HTMLDocumentEditor.this.undo.addEdit(e.getEdit());
            HTMLDocumentEditor.this.undoAction.update();
            HTMLDocumentEditor.this.redoAction.update();
        }
    }
}

