/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.brick.impl.Tree_;
import excel.core.Cell;
import excel.core.EditStyle;
import excel.core.impl.Cell_;
import excel.edit.BasicEdit;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.SwingUtilities;

public class DropDownTree
extends BasicEdit
implements MouseMotionListener {
    public EditStyle ES;
    Tree_ tree;

    public DropDownTree(EditStyle es) {
        this.showDebugInfo = true;
        this.ES = es;
        this.setMargin(new Insets(0, 0, 0, 18));
        this.addMouseMotionListener(this);
        this.setEditable(false);
    }

    public void calcuBuildinButtonRC() {
        this.debugInfo("calcuBuildinButtonRC");
        this.buildinButtonRC = new Rectangle(0, 0, 0, 0);
        if (!this.ES.isDropDownListEditable()) {
            return;
        }
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        if (cell.getNameOfEditButton() != null) {
            int x = this.editRC.width - 17 - 17;
            int y = (this.editRC.height - 16) / 2;
            if (y < 0) {
                y = 0;
            }
            this.buildinButtonRC = new Rectangle(x, y, 16, 16);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        this.drawDDLBButton((Graphics2D)g);
    }

    public void adjustEditRect() {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        this.editRC.width += 16;
    }

    private void drawDDLBButton(Graphics2D g) {
        boolean delta = false;
        int x = this.editRC.width - 16;
        int y0 = 0;
        Cell cell = this.Sheet.cells(this.Row, this.Col);
        if (cell.getDecorate() != null) {
            x += 2;
        }
        int y = y0;
        DropDownTree view = this;
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/normal/ddlb/ddlb_rmt.png");
        int imgH = img.getHeight(view);
        int imgW = img.getWidth(view);
        while (y < this.editRC.height / 2) {
            g.drawImage(img, x, y, view);
            y += imgH;
        }
        img = Tools.GetImageFromURL(view, "excel/res/decorate/normal/ddlb/ddlb_rmb.png");
        while (y < this.editRC.height) {
            g.drawImage(img, x, y, view);
            y += imgH;
        }
        img = Tools.GetImageFromURL(view, "excel/res/decorate/normal/ddlb/ddlb_rmm.png");
        imgH = img.getHeight(view);
        y = y0 + 4 + (this.editRC.height - 4 - 4 - imgH) / 2;
        g.drawImage(img, x, y, view);
    }

    public void removeSelf() {
        this.debugInfo("removeSelf");
        super.removeSelf();
    }

    public String superGetText() {
        return super.getText();
    }

    public String getText() {
        return Tools.$S(this.getWriteBackValue());
    }

    public void buildEditText(String value) {
        this.setEditable(false);
        this.setBackground(Color.white);
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        String s = "";
        this.setText(s);
    }

    public Object getWriteBackValue() {
        this.debugInfo("getWriteBackValue");
        return "";
    }

    public void repaintCell() {
        Cell cell = this.Sheet.Cells(this.Row, this.Col);
        cell.repaint();
    }

    public void keyPressed(KeyEvent e) {
        this.debugInfo("keyPressed  " + e.toString());
        switch (e.getKeyCode()) {
            case 38: {
                e.consume();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DropDownTree.this.debugInfo(" request focus");
                    }
                });
                return;
            }
            case 40: {
                if (e.isControlDown()) {
                    super.keyPressed(e);
                    return;
                }
                this.showTree();
                break;
            }
            default: {
                super.keyPressed(e);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        Point me = e.getPoint();
        if (!e.getSource().equals(this)) {
            me.x -= this.cellRect.x;
            me.y -= this.cellRect.y;
        }
        if (me.x > this.editRC.width - 17) {
            this.showTree();
        }
        super.mouseClicked(e);
    }

    public void showTree() {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.ES.isListShowAsCheckBox() || this.ES.isListShowAsRadioButton()) {
            this.setCursor(new Cursor(12));
            return;
        }
        if (e.getX() > this.editRC.width - 17) {
            this.setCursor(new Cursor(12));
        } else if (this.ES.isDropDownListEditable()) {
            this.setCursor(new Cursor(2));
        } else {
            this.setCursor(new Cursor(0));
        }
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        String bn = cell.getNameOfEditButton();
        if (bn != null && this.buildinButtonRC.contains(e.getPoint())) {
            this.setCursor(new Cursor(12));
        }
    }

    public void copyCell() {
        Object v = this.getWriteBackValue();
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Object sv = v;
        if (sv == null) {
            sv = v;
        }
        StringSelection contents = new StringSelection(sv == null ? "" : sv.toString());
        sysc.setContents(contents, this.Sheet);
    }
}

