/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.impl.Cell_;
import excel.edit.BasicEdit;
import excel.edit.DateChooser;
import excel.util.Tools;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JOptionPane;
import jun.db.core.ObjectTool;

public class DatetimeEdit
extends BasicEdit
implements MouseMotionListener {
    String m_strMask = "YYYY.MM.DD hh:mm:ss";
    String m_strMask2 = "yyyy.MM.dd HH:mm:ss";
    boolean JBGetFocus = false;
    DateChooser dc = null;

    public DatetimeEdit(String mask) {
        this.SetFormat(mask);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int x = this.editRC.width - (this.Sheet.cells(this.Row, this.Col).getDecorate() == null ? 18 : 15);
        int y = (this.editRC.height - 18) / 2;
        if (y < 0) {
            y = 0;
        }
        g.drawImage(Tools.GetImageFromURL(this, "excel/img/calendar18.gif"), x, y, 18, 18, this);
    }

    public void giveUpFocus() {
        super.giveUpFocus();
    }

    public void ShowSelect() {
        this.dc = new DateChooser(JOptionPane.getFrameForComponent(this.View), this.Sheet.getWorkBook().getWorkBookView().isInModalDialog(), this.m_strMask.indexOf("hh") >= 0);
        Point p = new Point(this.getX(), this.getY());
        p = Tools.GetAbsolutePoint(this.View, p);
        --p.x;
        p.y += this.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (p.x + this.dc.getWidth() + 1 > screenSize.width) {
            p.x -= p.x + this.dc.getWidth() + 1 - screenSize.width;
        }
        if (p.y + this.dc.getHeight() + 1 > screenSize.height) {
            p.y -= this.getHeight() + this.dc.getHeight();
        }
        this.dc.DE = this;
        this.dc.setLocation(p.x, p.y);
        this.dc.select(this.GetDateTime());
    }

    public void buildEditText(String value) {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        Object v = cell.getValue(this.currentDBRow);
        this.SetDateTime(v);
    }

    public Object getWriteBackValue() {
        Date d = this.GetDateTime();
        Object v = this.Sheet.getWorkBook().getEM().afterEditFocusLostAndBeforeWriteBackToCell(this.Sheet, this.Sheet.cells(this.Row, this.Col), d, this.currentDBRow);
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return (Date)v;
        }
        try {
            return ObjectTool.ChangeType((Object)v, (String)"java.util.Date");
        }
        catch (Exception e) {
            return d;
        }
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.setSelectionEnd(0);
        this.setCaretPosition(0);
    }

    public void SetFormat(String mask) {
        this.m_strMask = mask;
        this.m_strMask2 = DatetimeEdit.convertMask(mask);
    }

    public static String convertMask(String mask) {
        return mask.replaceAll("YYYY", "yyyy").replaceAll("YY", "yy").replaceAll("DD", "dd").replaceAll("hh", "HH");
    }

    public static String Date2String(Date d, String mask) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            dateFormat.applyPattern(mask);
            dateFormat.setLenient(false);
            return dateFormat.format(d);
        }
        catch (Exception e) {
            String s = mask;
            s = s.replaceAll("y", " ").replaceAll("m", " ").replaceAll("d", " ").replaceAll("h", " ").replaceAll("s", " ").replaceAll("Y", " ").replaceAll("M", " ").replaceAll("D", " ").replaceAll("H", " ").replaceAll("S", " ");
            return s;
        }
    }

    Date validateDate(String vDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            dateFormat.applyPattern(this.m_strMask2);
            dateFormat.setLenient(false);
            Date date = dateFormat.parse(vDate);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void SetDateTime(Object v) {
        try {
            Date d = (Date)ObjectTool.ChangeType((Object)v, (String)"java.sql.Date");
            int p = this.getSelectionStart();
            this.setText(DatetimeEdit.Date2String(d, this.m_strMask2));
            this.setSelectionStart(p);
            this.setSelectionEnd(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date GetDateTime() {
        return this.validateDate(this.getText());
    }

    public void keyTyped(KeyEvent e) {
        e.consume();
        String old = this.getText();
        char nChar = e.getKeyChar();
        int pos = this.getSelectionStart();
        switch (e.getKeyCode()) {
            case 8: 
            case 38: {
                --pos;
                break;
            }
            case 9: {
                break;
            }
        }
        block4 : switch (nChar) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int maskLength;
                if (pos >= this.m_strMask.length()) break;
                char c = this.m_strMask.charAt(pos);
                if (pos < old.length() && pos < this.m_strMask.length() && old.charAt(pos) != nChar && (c == 'D' || c == 'M' || c == 'Y' || c == 'h' || c == 'm' || c == 's')) {
                    String str = String.valueOf(old.substring(0, pos)) + nChar + old.substring(pos + 1);
                    Date d = this.validateDate(str);
                    if (d != null) {
                        this.SetDateTime(d);
                    }
                    int cLeft = 32;
                    int cRight = 32;
                    if (pos > 0) {
                        cLeft = this.m_strMask.charAt(pos - 1);
                    }
                    if (pos + 1 < this.m_strMask.length()) {
                        cRight = this.m_strMask.charAt(pos + 1);
                    }
                    if (d == null && c == 'M') {
                        if (cRight == 77 && nChar == '1') {
                            old = String.valueOf(old.substring(0, pos + 1)) + "0" + old.substring(pos + 2);
                        }
                        if (cLeft == 77 && nChar > '2') {
                            old = String.valueOf(old.substring(0, pos - 1)) + "0" + old.substring(pos);
                        }
                        if ((d = this.validateDate(str = String.valueOf(old.substring(0, pos)) + nChar + old.substring(pos + 1))) != null) {
                            this.SetDateTime(d);
                        } else {
                            int pi = -1;
                            int i = 0;
                            while (i < this.m_strMask.length()) {
                                if (this.m_strMask.charAt(i) == 'D') {
                                    pi = i;
                                    break;
                                }
                                ++i;
                            }
                            if (pi >= 0 && (d = this.validateDate(str = String.valueOf(str.substring(0, pi)) + "01" + str.substring(pi + 2))) != null) {
                                this.SetDateTime(d);
                            }
                        }
                    }
                    if (d == null && c == 'D') {
                        if (cRight == 68 && nChar >= '2') {
                            old = String.valueOf(old.substring(0, pos + 1)) + "0" + old.substring(pos + 2);
                        }
                        if (cLeft == 68 && nChar > '1') {
                            old = String.valueOf(old.substring(0, pos - 1)) + "0" + old.substring(pos);
                        }
                        if ((d = this.validateDate(str = String.valueOf(old.substring(0, pos)) + nChar + old.substring(pos + 1))) != null) {
                            this.SetDateTime(d);
                        }
                    }
                }
                if (++pos >= (maskLength = this.m_strMask.length())) break;
                while (pos < maskLength) {
                    c = this.m_strMask.charAt(pos);
                    if (c == 'D' || c == 'M' || c == 'Y' || c == 'h' || c == 'm' || c == 's') break block4;
                    ++pos;
                }
                break;
            }
        }
        this.setSelectionStart(pos);
        this.setSelectionEnd(pos);
    }

    public void keyPressed(KeyEvent e) {
        String old = this.getText();
        if (this.validateDate(old) == null && e.getKeyCode() != 10) {
            this.SetDateTime(new Date());
        }
        switch (e.getKeyCode()) {
            case 127: {
                if (e.isControlDown()) {
                    super.keyPressed(e);
                    return;
                }
            }
            case 8: {
                e.consume();
                if (this.getSelectionStart() != 0 || this.getSelectionEnd() != this.getText().length()) break;
                this.SetDateTime(null);
                break;
            }
            case 155: {
                e.consume();
                break;
            }
            case 38: 
            case 40: {
                if (e.isControlDown()) {
                    super.keyPressed(e);
                    return;
                }
                e.consume();
                int pos = this.getSelectionStart();
                Date d = this.validateDate(old);
                if (d == null) {
                    return;
                }
                if (pos < this.m_strMask.length()) {
                    char c = this.m_strMask.charAt(pos);
                    if (c != 'D' && c != 'M' && c != 'Y' && c != 'h' && c != 'm' && c != 's' && --pos >= 0) {
                        c = this.m_strMask.charAt(pos);
                    }
                    GregorianCalendar cd = new GregorianCalendar();
                    cd.setTime(d);
                    int nChar = e.getKeyCode();
                    switch (c) {
                        case 'D': {
                            ((Calendar)cd).add(5, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'M': {
                            ((Calendar)cd).add(2, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'Y': {
                            ((Calendar)cd).add(1, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'h': {
                            ((Calendar)cd).add(10, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'm': {
                            ((Calendar)cd).add(12, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 's': {
                            ((Calendar)cd).add(13, nChar != 38 ? -1 : 1);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.SetDateTime(cd.getTime());
                }
                return;
            }
            case 9: 
            case 10: {
                super.keyPressed(e);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getX() > this.editRC.width - 19) {
            this.ShowSelect();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getX() > this.editRC.width - 19) {
            this.setCursor(new Cursor(12));
        } else {
            this.setCursor(new Cursor(2));
        }
    }

    public void removeSelf() {
        if (this.dc != null) {
            this.dc.Close();
            this.dc = null;
        }
        super.removeSelf();
    }

    public void adjustEditRect() {
    }
}

