/*
 * Decompiled with CFR 0.152.
 */
package excel.edit;

import excel.core.Cell;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.EditStyle;
import excel.core.Property;
import excel.core.RowPropertyManage;
import excel.core.WorkSheet;
import excel.core.ZExcel;
import excel.core.impl.Cell_;
import excel.core.impl.ContextMenuConfig;
import excel.core.impl.WorkBookView_;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.edit.Edit;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import jun.db.core.DataStore;
import jun.db.util.Base64Coder;

public abstract class BasicMultilineEdit
extends JTextArea
implements Edit,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    boolean focusLosted = false;
    public static Border splashBorder = BorderFactory.createLineBorder(new Color(0xFF0000), 2);
    Timer focusTimer = new Timer();
    WorkSheet_ Sheet;
    WorkSheetView_ View;
    int Row;
    int Col;
    int mouseOnDBRow = -1;
    int currentDBRow = -1;
    boolean Escape = false;
    boolean beginEditRequestFocus = true;
    boolean clearData = false;
    boolean contextMenuEnabled = true;
    boolean enterKeyPressed = false;
    boolean isShiftDown = false;
    boolean isControlDown = false;
    boolean showDebugInfo = false;
    boolean readOnly = false;
    Rectangle cellRect;
    Rectangle editRC;
    Rectangle buildinButtonRC = null;
    String textWhenBeginEdit = "";
    Image buttonImage = null;
    Timer borderTimer = null;

    public BasicMultilineEdit() {
        this.setBorder(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setRequestFocusEnabled(true);
    }

    public void debugInfo(String info) {
        if (this.showDebugInfo) {
            Tools.log(info);
        }
    }

    public abstract void buildEditText(String var1);

    public abstract Object getWriteBackValue();

    public JComponent getComponent() {
        return this;
    }

    public int getCurrentDBRow() {
        return this.currentDBRow;
    }

    public static void adjustBounds(Rectangle rc, int sign) {
        rc.x -= 1 * sign;
        rc.y -= 1 * sign;
        rc.width += 3 * sign;
        rc.height += 3 * sign;
    }

    public abstract void adjustEditRect();

    public void beginEdit(WorkSheet_ sheet, WorkSheetView_ view, int row, int col, String value, Rectangle rect, MouseEvent mouseEvent, int innerRow, boolean readOnly) {
        boolean needShowFlattoolBar;
        int CHH;
        this.readOnly = readOnly;
        Point mouse = null;
        if (mouseEvent != null) {
            mouse = mouseEvent.getPoint();
        }
        this.cellRect = (Rectangle)rect.clone();
        this.editRC = (Rectangle)rect.clone();
        this.Row = row;
        this.Col = col;
        this.Sheet = sheet;
        this.View = view;
        String s = "";
        Cell_ cell = (Cell_)this.Sheet.Cells(row, col);
        this.editRC = cell.getTextRectangleOfCell(this.editRC);
        BasicMultilineEdit.adjustBounds(this.editRC, 1);
        this.adjustEditRect();
        if (readOnly) {
            this.setEditable(false);
        }
        Property prop = cell.getProperty();
        view.$setCurrentEditingEdit(this);
        cell.setIsEditing(true);
        this.setFont(Tools.GetFont(this.Sheet.getCellProperty(row, col, "font-name").toString(), new Integer(this.Sheet.getCellProperty(row, col, "font-size").toString()), false, false, false));
        DBBindConfig bind = cell.getBind();
        RowPropertyManage RPM = this.Sheet.getRowPropertyManage();
        boolean groupRowVisible = RPM.isGroupRowVisible(this.Row);
        int dbRowHeight = RPM.getDBRowHeight(row);
        int yOffset = RPM.getRowScrolledRowCount(row) * RPM.getDBRowHeight(row);
        boolean isBindToMultiRowDataSource = false;
        if (bind == null) {
            this.mouseOnDBRow = -1;
            this.currentDBRow = -1;
            if (mouse != null) {
                this.mouseOnDBRow = innerRow;
            }
        } else {
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
            if (bind.getDataSourceType() == 1) {
                this.mouseOnDBRow = 0;
            } else if (bind.getDataSourceType() == 4) {
                this.mouseOnDBRow = dsc.getCurrentBindRow();
            } else {
                isBindToMultiRowDataSource = true;
                this.mouseOnDBRow = Math.min(innerRow, dsc.getDataStore().getRowCount() - 1);
                Rectangle rctemp = this.View.getShowRectangleOfCell(false, this.Row, this.Col);
                if (!groupRowVisible) {
                    this.editRC.y += this.mouseOnDBRow * dbRowHeight - yOffset;
                } else {
                    DataStore ds = cell.getDataStore();
                    Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                    int height = 0;
                    int i = 0;
                    while (i < this.mouseOnDBRow) {
                        height += dbRowHeight;
                        Integer key = new Integer(i);
                        if (MapGroups.containsKey(key)) {
                            ArrayList pVec = (ArrayList)MapGroups.get(key);
                            int gc = pVec.size();
                            height += gc * dbRowHeight;
                        }
                        ++i;
                    }
                    this.editRC.y += height - yOffset;
                }
                this.editRC.height = dbRowHeight - 1;
            }
            this.currentDBRow = this.mouseOnDBRow;
        }
        this.setFocusable(true);
        this.addKeyListener(this);
        int RHW = this.Sheet.getRowPropertyManage().getRowHeadWidth();
        if (this.editRC.x < RHW) {
            this.editRC.width = this.editRC.width + this.editRC.x - RHW;
            this.editRC.x = RHW;
        }
        if (this.editRC.y < (CHH = this.Sheet.getColumnPropertyManage().getColumnHeadHeight())) {
            this.editRC.height = this.editRC.height + this.editRC.y - CHH - 1;
            this.editRC.y = CHH + 1;
        }
        if (cell.getDecorate() != null) {
            EditStyle es = cell.getEditStyle();
            boolean needResize = true;
            if (es != null) {
                if (es.getEditType() == 5) {
                    needResize = false;
                }
                if (es.getEditType() == 4 && (es.isListShowAsCheckBox() || es.isListShowAsRadioButton())) {
                    needResize = false;
                }
            }
            if (needResize) {
                this.editRC.x += 2;
                ++this.editRC.y;
                this.editRC.height -= 2;
                this.editRC.width -= 5;
            }
        }
        this.setBounds(this.editRC);
        if (cell.getNameOfEditButton() != null) {
            this.setMargin(new Insets(0, 0, 0, 18));
        }
        this.buildEditText(value);
        this.textWhenBeginEdit = this.getText();
        this.View.$setCurrentEditControlBounds(this.editRC);
        if (this.beginEditRequestFocus) {
            this.longForFocus();
        }
        if ((needShowFlattoolBar = true) && !readOnly) {
            this.View.showFloatToolbar(this.editRC.x, this.editRC.y, this.editRC.width, this.editRC.height, prop.get("align-h", 0) == 0, prop.get("padding-right", 1));
        }
        int delta = 10;
        this.View.repaint(rect.x - delta, rect.y - delta, rect.width + 2 * delta, rect.height + 2 * delta);
        this.Sheet.getWorkBook().getEM().fireBeginEdit(this.Sheet, this.Row, this.Col, this.mouseOnDBRow);
        this.calcuBuildinButtonRC();
        if (mouse != null) {
            this.mouseClicked(mouseEvent);
        }
    }

    public void splash(boolean b) {
        if (!b) {
            if (this.borderTimer == null) {
                return;
            }
            this.borderTimer.cancel();
            this.borderTimer = null;
            this.setBorder(null);
            this.setBackground(Color.white);
            return;
        }
        if (this.borderTimer != null) {
            return;
        }
        this.borderTimer = new Timer();
        this.borderTimer.schedule(new TimerTask(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (BasicMultilineEdit.this.getBorder() == null) {
                            BasicMultilineEdit.this.setSomeBorder();
                        } else {
                            BasicMultilineEdit.this.setBorder(null);
                            BasicMultilineEdit.this.setBackground(Color.white);
                        }
                    }
                });
            }
        }, 500L, 500L);
    }

    public void setSomeBorder() {
        this.setBorder(splashBorder);
        this.setBackground(new Color(14352272));
    }

    public void calcuBuildinButtonRC() {
        this.buildinButtonRC = new Rectangle(0, 0, 0, 0);
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        if (cell.getNameOfEditButton() != null) {
            int x = this.editRC.width - 17;
            int y = (this.editRC.height - 16) / 2;
            if (y < 0) {
                y = 0;
            }
            this.buildinButtonRC = new Rectangle(x, y, 16, 16);
        }
    }

    public void stopFocusTimer() {
        if (this.focusTimer == null) {
            return;
        }
        this.focusTimer.cancel();
        this.focusTimer = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  " + this.hashCode());
        sb.append("  " + (this.getCell() == null ? "" : this.getCell().getName()));
        sb.append("   " + this.getClass().getName());
        return sb.toString();
    }

    public Image getButtonImage() {
        if (this.buttonImage != null) {
            return this.buttonImage;
        }
        this.buttonImage = Tools.GetImageFromURL(this, "excel/img/comment.png");
        return this.buttonImage;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.Sheet == null) {
            return;
        }
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        if (cell.getNameOfEditButton() != null) {
            g.drawImage(this.getButtonImage(), this.buildinButtonRC.x, this.buildinButtonRC.y, this.buildinButtonRC.width, this.buildinButtonRC.height, this);
        }
    }

    public void longForFocus() {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        try {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (this.beginEditRequestFocus) {
                if (fm.getFocusOwner() == this) {
                    throw new Exception(String.valueOf(this.toString()) + "\u5df2\u7ecf\u62e5\u6709\u7126\u70b9");
                }
                this.View.requestFocusInWindow();
                Tools.requestInputFocus(this);
            }
            this.focusGained(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reloadEdit() {
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        DBBindConfig bind = cell.getBind();
        int dbRowHeight = this.Sheet.getRowPropertyManage().getDBRowHeight(this.Row);
        if (bind == null) {
            this.mouseOnDBRow = -1;
            this.currentDBRow = -1;
        } else {
            DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
            if (bind.getDataSourceType() == 1) {
                this.mouseOnDBRow = 0;
            } else if (bind.getDataSourceType() == 4) {
                this.mouseOnDBRow = dsc.getCurrentBindRow();
            } else {
                this.mouseOnDBRow = dsc.getCurrentBindRow();
                dsc.setCurrentBindRow(this.mouseOnDBRow);
                Rectangle rctemp = this.View.getShowRectangleOfCell(false, this.Row, this.Col);
                this.editRC.y += this.mouseOnDBRow * dbRowHeight;
                this.editRC.height = dbRowHeight - 1;
            }
            this.currentDBRow = this.mouseOnDBRow;
        }
        this.buildEditText(null);
        this.textWhenBeginEdit = this.getText();
        this.repaint();
        this.setFocusable(true);
        if (this.beginEditRequestFocus) {
            this.longForFocus();
        }
        this.Sheet.getWorkBook().getEM().fireBeginEdit(this.Sheet, this.Row, this.Col, this.mouseOnDBRow);
    }

    public void giveUpFocus() {
        this.focusLost(null);
    }

    public void focusGained(FocusEvent e) {
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
        try {
            this.setCaretPosition(this.getText().length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Cell getCell() {
        if (this.Sheet == null) {
            return null;
        }
        return this.Sheet.cells(this.Row, this.Col);
    }

    public void removeSelf() {
        try {
            this.removeKeyListener(this);
            this.removeMouseListener(this);
            this.setFocusable(false);
            this.setVisible(false);
            this.setEditable(false);
            this.setEnabled(false);
            if (this.View != null) {
                this.View.remove(this.getComponent());
                this.View.hideFloatToolbar();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fillBack() {
        String currentText;
        if (this.Sheet == null) {
            return;
        }
        if (this.readOnly) {
            return;
        }
        Cell cell = this.Sheet.Cells(this.Row, this.Col);
        Object value = null;
        if (!this.clearData) {
            value = this.getWriteBackValue();
        }
        if (!(currentText = this.getText()).equals(this.textWhenBeginEdit) || this.clearData) {
            cell.setValue(value, this.currentDBRow);
            this.Sheet.getWorkBook().getEM().fireCellValueChangedByEdit(this.Sheet, cell, value, this.currentDBRow);
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.focusLosted) {
            return;
        }
        this.splash(false);
        this.focusLosted = true;
        Cell cell = this.Sheet.Cells(this.Row, this.Col);
        cell.setIsEditing(false);
        this.removeSelf();
        if (this.View == null) {
            return;
        }
        Edit currentEdit = this.View.$getCurrentEditingEdit();
        this.stopFocusTimer();
        if (currentEdit == this) {
            this.View.$clearCurrentEditingEdit(this);
        }
        if (!this.Escape) {
            this.fillBack();
        }
        cell.repaint();
        this.Sheet.getWorkBook().getEM().fireEndEdit(this.Sheet, this.Row, this.Col, this.mouseOnDBRow, this.enterKeyPressed, this.isShiftDown, this.isControlDown);
    }

    public void keyTyped(KeyEvent e) {
        ((WorkBookView_)this.Sheet.getWorkBook().getWorkBookView()).lastKeyEvent = e;
        this.splash(false);
        switch (e.getKeyCode()) {
            case 9: 
            case 10: {
                e.consume();
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        ((WorkBookView_)this.Sheet.getWorkBook().getWorkBookView()).lastKeyEvent = e;
        this.isShiftDown = e.isShiftDown();
        this.isControlDown = e.isControlDown();
        switch (e.getKeyCode()) {
            case 38: 
            case 40: {
                this.enterKeyPressed = true;
                this.focusLost(null);
                this.View.keyPressed(e, this.Row, this.Col, this.mouseOnDBRow);
                e.setKeyChar('\n');
                this.View.keyTyped(e);
                break;
            }
            case 9: {
                this.View.requestFocusInWindow();
                break;
            }
            case 10: {
                this.enterKeyPressed = true;
                this.View.keyPressed(e, this.Row, this.Col, this.mouseOnDBRow);
                this.View.keyTyped(e);
                break;
            }
            case 27: {
                this.Escape = true;
                this.View.requestFocusInWindow();
                this.focusLost(null);
                return;
            }
            case 127: {
                if (!e.isControlDown()) break;
                this.clear();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        ((WorkBookView_)this.Sheet.getWorkBook().getWorkBookView()).lastKeyEvent = e;
        this.View.keyReleased(e, this.Row, this.Col, this.mouseOnDBRow);
    }

    public void clear() {
        this.clearData = true;
        this.giveUpFocus();
    }

    public void paste() {
        byte[] imgData = Tools.getImageFromClipboard();
        if (imgData != null && JOptionPane.showConfirmDialog(this.View, "\u7c98\u8d34\u4e3a\u6587\u672c\u8bf7\u70b9\u51fb[\u662f]\uff0c\u7c98\u8d34\u4e3a\u56fe\u7247\u8bf7\u70b9\u51fb[\u5426]", "\u8bf7\u9009\u62e9\u7c98\u8d34\u7c7b\u578b", 0) == 1) {
            String imgSource = "$#{image}#$" + new String(Base64Coder.encode((byte[])imgData));
            Cell cell = this.Sheet.cells(this.Row, this.Col);
            DBBindConfig bind = cell.getBind();
            if (bind == null) {
                cell.setValue(imgSource);
            } else {
                DataSourceConfig dsc = this.Sheet.getWorkBook().getDataSource(bind.getDataSource());
                DataStore tds = dsc.getDataStore();
                tds.setValue(dsc.getCurrentBindRow(), bind.getDBCol(), (Object)imgSource);
            }
            return;
        }
        super.paste();
        String s = Tools.getStringFromClipboard();
        s.indexOf("\t");
    }

    private static int nextCol(WorkSheet sheet, int row, int col, boolean skipMerged) {
        Cell cell = sheet.cells(row, col);
        if (cell == null) {
            return col;
        }
        if (cell.isMerged() && skipMerged) {
            return cell.getMergedRange().getEndCol() + 1;
        }
        return col + 1;
    }

    private static int nextRow(WorkSheet sheet, int row, int col, boolean skipMerged) {
        Cell cell = sheet.cells(row, col);
        if (cell == null) {
            return col;
        }
        if (cell.isMerged() && skipMerged) {
            return cell.getMergedRange().getEndRow() + 1;
        }
        return row + 1;
    }

    public ArrayList parseClipboardData(String data) {
        ArrayList ret = new ArrayList();
        StringTokenizer stk = new StringTokenizer(data, "\n");
        while (stk.hasMoreElements()) {
            String t = stk.nextToken();
            String[] s = t.split("\\t", -1);
            ArrayList<String> rowList = new ArrayList<String>();
            int i = 0;
            while (i < s.length) {
                rowList.add(s[i]);
                ++i;
            }
            ret.add(rowList);
        }
        return ret;
    }

    private void addContextSubMenu(JMenuItem pmi, LinkedHashMap subMenu) {
        Insets ins = new Insets(0, -17, 0, 0);
        for (final String mn : subMenu.keySet()) {
            ContextMenuConfig cmc = (ContextMenuConfig)subMenu.get(mn);
            JMenuItem mi = null;
            if (cmc.subMenu != null) {
                mi = new JMenu(cmc.caption);
                this.addContextSubMenu(mi, cmc.subMenu);
            } else {
                mi = new JMenuItem(cmc.caption, new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
                mi.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Cell_ cell = (Cell_)BasicMultilineEdit.this.Sheet.Cells(BasicMultilineEdit.this.Row, BasicMultilineEdit.this.Col);
                        BasicMultilineEdit.this.Sheet.getWorkBook().getEM().fireOnContextMenuClicked(BasicMultilineEdit.this.Sheet, cell, BasicMultilineEdit.this.currentDBRow, mn);
                    }
                });
            }
            mi.setBackground(Color.white);
            mi.setEnabled(cmc.enabled);
            pmi.add(mi);
        }
    }

    public void mouseClicked(MouseEvent e) {
        Cell_ cell;
        String bn;
        if (this.Sheet == null) {
            return;
        }
        Point me = e.getPoint();
        if (!e.getSource().equals(this)) {
            me.x -= this.editRC.x;
            me.y -= this.editRC.y;
        }
        if (e.getButton() == 1 && (bn = (cell = (Cell_)this.Sheet.Cells(this.Row, this.Col)).getNameOfEditButton()) != null && this.buildinButtonRC.contains(me)) {
            this.Sheet.getWorkBook().getEM().fireVirtualButtonClicked(this.Sheet, cell, bn);
        }
        if (e.getButton() == 3 && this.contextMenuEnabled) {
            JPopupMenu popupMenu = new JPopupMenu("popup");
            Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
            popupMenu.setBorder(border);
            Insets ins = new Insets(0, -17, 0, 0);
            if (this.Sheet.contextMenuMap != null) {
                for (final String mn : this.Sheet.contextMenuMap.keySet()) {
                    ContextMenuConfig cmc = this.Sheet.contextMenuMap.get(mn);
                    JMenuItem mi = null;
                    if (cmc.subMenu != null) {
                        mi = new JMenu(cmc.caption);
                        this.addContextSubMenu(mi, cmc.subMenu);
                    } else {
                        mi = new JMenuItem(cmc.caption, new ImageIcon(Tools.GetImageFromURL(this, "excel/img/menublack.gif")));
                        if (!ZExcel.isJVM16()) {
                            mi.setMargin(ins);
                        }
                        mi.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Cell_ cell = (Cell_)BasicMultilineEdit.this.Sheet.Cells(BasicMultilineEdit.this.Row, BasicMultilineEdit.this.Col);
                                BasicMultilineEdit.this.Sheet.getWorkBook().getEM().fireOnContextMenuClicked(BasicMultilineEdit.this.Sheet, cell, BasicMultilineEdit.this.currentDBRow, mn);
                            }
                        });
                    }
                    mi.setBackground(Color.white);
                    mi.setEnabled(cmc.enabled);
                    popupMenu.add(mi);
                }
                if (this.Sheet.contextMenuMap.size() > 0) {
                    popupMenu.addSeparator();
                }
            }
            JMenuItem mi_cut = new JMenuItem("\u526a  \u5207", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/cut.gif")));
            JMenuItem mi_clear = new JMenuItem("\u6e05  \u9664", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/erase.gif")));
            JMenuItem mi_copy = new JMenuItem("\u590d  \u5236", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/copy.gif")));
            JMenuItem mi_paste = new JMenuItem("\u7c98  \u8d34", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/paste.gif")));
            JMenuItem mi_refreshddlb = new JMenuItem("\u5237\u65b0\u5355\u5143\u683c\u683c\u5f0f", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/refresh.gif")));
            JMenuItem mi_tipedit = new JMenuItem("\u6279  \u6ce8", new ImageIcon(Tools.GetImageFromURL(this, "excel/img/copy.gif")));
            mi_cut.setFocusable(false);
            mi_clear.setFocusable(false);
            mi_copy.setFocusable(false);
            mi_paste.setFocusable(false);
            mi_tipedit.setFocusable(false);
            mi_refreshddlb.setFocusable(false);
            mi_cut.setToolTipText("\u5feb\u6377\u952e\uff1aCtrl + X");
            mi_clear.setToolTipText("\u5feb\u6377\u952e\uff1aCtrl + Del");
            mi_copy.setToolTipText("\u5feb\u6377\u952e\uff1aCtrl + C");
            mi_paste.setToolTipText("\u5feb\u6377\u952e\uff1aCtrl + V");
            mi_tipedit.setToolTipText("\u7f16\u8f91\u6279\u6ce8");
            mi_refreshddlb.setToolTipText("\u5f53\u5355\u5143\u683c\u7f16\u8f91\u683c\u5f0f\u662f\u5217\u8868\u65f6\uff0c\u53ef\u4ee5\u4f7f\u7528\u672c\u529f\u80fd\u6765\u5237\u65b0\u5217\u8868\u9879\u76ee");
            mi_cut.setBackground(Color.white);
            mi_clear.setBackground(Color.white);
            mi_copy.setBackground(Color.white);
            mi_paste.setBackground(Color.white);
            mi_tipedit.setBackground(Color.white);
            mi_refreshddlb.setBackground(Color.white);
            mi_cut.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BasicMultilineEdit.this.edit_cut();
                }
            });
            mi_clear.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BasicMultilineEdit.this.edit_clear();
                }
            });
            mi_copy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BasicMultilineEdit.this.edit_copy();
                }
            });
            mi_paste.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BasicMultilineEdit.this.edit_paste();
                }
            });
            mi_refreshddlb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BasicMultilineEdit.this.Sheet.refreshEditStyleOfCell(BasicMultilineEdit.this.Sheet, BasicMultilineEdit.this.Sheet.cells(BasicMultilineEdit.this.Row, BasicMultilineEdit.this.Col), BasicMultilineEdit.this.currentDBRow);
                }
            });
            popupMenu.add(mi_cut);
            popupMenu.add(mi_copy);
            popupMenu.add(mi_paste);
            popupMenu.add(mi_clear);
            final DBBindConfig dbc = this.Sheet.cells(this.Row, this.Col).getBind();
            if (dbc != null && this.Sheet.getWorkBook().getDataSource(dbc.getDataSource()).isBalloonTipEditable()) {
                final int innerRow = this.currentDBRow;
                mi_tipedit.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BasicMultilineEdit.this.Sheet.balloonTipEdit(dbc.getDataSource(), dbc.getDBCol(), innerRow);
                    }
                });
                popupMenu.addSeparator();
                popupMenu.add(mi_tipedit);
                popupMenu.addSeparator();
            }
            popupMenu.add(mi_refreshddlb);
            popupMenu.setFocusable(false);
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.splash(false);
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this.Sheet == null) {
            return;
        }
        Cell_ cell = (Cell_)this.Sheet.Cells(this.Row, this.Col);
        String bn = cell.getNameOfEditButton();
        if (bn != null) {
            if (this.buildinButtonRC.contains(e.getPoint())) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(2));
            }
        }
    }

    public void setValue(String s) {
        final String v = s;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BasicMultilineEdit.this.setText(v);
                BasicMultilineEdit.this.focusGained(null);
            }
        });
    }

    public void edit_selectAll() {
        this.selectAll();
    }

    public void edit_copy() {
        this.copy();
    }

    public void edit_paste() {
        this.paste();
    }

    public void edit_cut() {
        this.cut();
    }

    public void edit_clear() {
        this.clear();
        this.setValue("");
    }
}

