/*
 * Decompiled with CFR 0.152.
 */
package excel.core.mouseaction;

import excel.core.ColumnPropertyManage;
import excel.core.RowPropertyManage;
import excel.core.impl.Range_;
import excel.core.impl.WorkSheetView_;
import excel.core.mouseaction.DrawTool;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class RowHeadTool
extends DrawTool {
    int m_row;
    int m_DownCol;
    Point m_LastDrawPos = new Point();
    Rectangle m_headrect = new Rectangle();

    public RowHeadTool() {
        super(2);
        this.m_mousestate = 8;
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        super.OnLButtonDown(pView, e);
        Point point = e.getPoint();
        this.m_mousestate = 9;
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        Rectangle rectCenter = new Rectangle();
        Rectangle client = pView.getBounds();
        ColumnPropertyManage CPM = pView.getWorkSheet().getColumnPropertyManage();
        RowPropertyManage RPM = pView.getWorkSheet().getRowPropertyManage();
        int w = Math.max(20, pView.getWorkSheet().getColumnPropertyManage().getFixedColumnWidth());
        this.m_DownCol = this.m_row = pView.GetRowHeadRect(point, rect);
        this.m_LastDrawPos.x = rect.x;
        this.m_LastDrawPos.y = rect.y + rect.height;
        this.m_headrect = (Rectangle)rect.clone();
        rectLT.setBounds(rect.x, rect.y, rect.width / 4, 3);
        rectLB.setBounds(rect.x, rect.y + rect.height - 3, rect.width / 4, 3);
        rectRT.setBounds(rect.x + rect.width / 4, rect.y, w, 3);
        rectRB.setBounds(rect.x + rect.width / 4, rect.y + rect.height - 3, w, 3);
        rectCenter.setBounds(rect.x, rect.y + 3, rect.width, rect.height - 6);
        if (this.m_row > -1) {
            if (rectLT.contains(point)) {
                pView.setCursor(RowHeadTool.GetCursor("LT2.gif", pView));
                this.m_mousestate = 0;
            }
            if (rectLB.contains(point)) {
                pView.setCursor(RowHeadTool.GetCursor("LB2.gif", pView));
                this.m_mousestate = 1;
            }
            if (rectRT.contains(point)) {
                pView.setCursor(RowHeadTool.GetCursor("RT2.gif", pView));
                this.m_mousestate = 2;
            }
            if (rectRB.contains(point)) {
                pView.setCursor(RowHeadTool.GetCursor("RB2.gif", pView));
                this.m_mousestate = 3;
            }
            if (rectCenter.contains(point)) {
                pView.setCursor(RowHeadTool.GetCursor("right.gif", pView));
                this.m_mousestate = 5;
                int row = pView.GetRowAtPoint(false, e.getY());
                int cc = CPM.getColumnCount();
                pView.getWorkSheet().setSelection(new Range_(row, 0, row, cc - 1));
            }
        }
        if (this.m_mousestate == 0 || this.m_mousestate == 1 || this.m_mousestate == 2 || this.m_mousestate == 3) {
            pView.DrawXorLine(client.x, point.y, client.x + client.width, point.y);
        }
    }

    public void OnLButtonDblClk(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        super.OnLButtonUp(pView, e);
        Point point = e.getPoint();
        Rectangle rect = new Rectangle();
        ColumnPropertyManage CPM = pView.getWorkSheet().getColumnPropertyManage();
        RowPropertyManage RPM = pView.getWorkSheet().getRowPropertyManage();
        int areaCount = RPM.getRowCount();
        Rectangle client = pView.getBounds();
        if (this.m_row > -1) {
            switch (this.m_mousestate) {
                case 0: 
                case 1: {
                    int row2;
                    int row1;
                    if (this.m_mousestate == 0) {
                        row1 = this.m_row - 1;
                        row2 = this.m_row;
                    } else {
                        row1 = this.m_row;
                        row2 = this.m_row;
                        while (++row2 < areaCount - 1 && RPM.getRowHeight(row2) <= 0) {
                        }
                    }
                    pView.DrawXorLine(client.x, point.y, client.x + client.width, point.y);
                    if (row2 >= areaCount) break;
                    int delta = Math.max(0, point.y - (CPM.getColumnHeadHeight() + RPM.getRowY(row1) - (row1 >= RPM.getFixedRowCount() ? pView.getWorkSheet().getYOffset() : 0)));
                    pView.getWorkSheet().setHeightBetweenTwoRow(row1, row2, delta);
                    break;
                }
                case 2: 
                case 3: {
                    int row1 = this.m_mousestate == 2 ? this.m_row - 1 : this.m_row;
                    pView.DrawXorLine(client.x, point.y, client.x + client.width, point.y);
                    int delta = Math.max(0, point.y - (CPM.getColumnHeadHeight() + RPM.getRowY(row1) - (row1 >= RPM.getFixedRowCount() ? pView.getWorkSheet().getYOffset() : 0)));
                    pView.getWorkSheet().setRowHeight(row1, delta);
                    break;
                }
                case 5: {
                    pView.setCursor(RowHeadTool.GetCursor("right.gif", pView));
                }
            }
        }
        pView.repaint();
        this.m_mousestate = 8;
    }

    public boolean canDoResizeRowHeight(WorkSheetView_ pView, MouseEvent e) {
        Point point = e.getPoint();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        if (this.m_mousestate == 8 || this.m_mousestate == 9) {
            this.m_row = pView.GetRowHeadRect(point, rect);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_row > -1) {
            int w = Math.max(20, pView.getWorkSheet().getColumnPropertyManage().getFixedColumnWidth());
            rectLT.setBounds(rect.x, rect.y, rect.width / 4, 3);
            rectLB.setBounds(rect.x, rect.y + rect.height - 3, rect.width / 4, 3);
            rectRT.setBounds(rect.x + rect.width / 4, rect.y, w, 3);
            rectRB.setBounds(rect.x + rect.width / 4, rect.y + rect.height - 3, w, 3);
            if (rectLT.contains(point)) {
                return true;
            }
            if (rectRT.contains(point)) {
                return true;
            }
            if (rectLB.contains(point)) {
                return true;
            }
            if (rectRB.contains(point)) {
                return true;
            }
        }
        return false;
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        Point point = e.getPoint();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        Rectangle rectCenter = new Rectangle();
        String hCur = "DEFAULT";
        if (this.m_mousestate == 8 || this.m_mousestate == 9) {
            this.m_row = pView.GetRowHeadRect(point, rect);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_row > -1) {
            int w = Math.max(20, pView.getWorkSheet().getColumnPropertyManage().getFixedColumnWidth());
            rectLT.setBounds(rect.x, rect.y, rect.width / 4, 3);
            rectLB.setBounds(rect.x, rect.y + rect.height - 3, rect.width / 4, 3);
            rectRT.setBounds(rect.x + rect.width / 4, rect.y, w, 3);
            rectRB.setBounds(rect.x + rect.width / 4, rect.y + rect.height - 3, w, 3);
            rectCenter.setBounds(rect.x, rect.y + 3, rect.width, rect.height - 6);
            if (rectLT.contains(point)) {
                hCur = "LT2.gif";
            }
            if (rectRT.contains(point)) {
                hCur = "RT2.gif";
            }
            if (rectLB.contains(point)) {
                hCur = "LB2.gif";
            }
            if (rectRB.contains(point)) {
                hCur = "RB2.gif";
            }
            if (rectCenter.contains(point)) {
                hCur = "right.gif";
            }
            pView.setCursor(RowHeadTool.GetCursor(hCur, pView));
        }
        super.OnMouseMove(pView, e);
        if (!pView.IsOnRowHeader(point) && !c_IsDraging && hCur == "DEFAULT") {
            pView.setCursor(RowHeadTool.GetCursor("DEFAULT", pView));
            DrawTool.c_drawShape = 0;
        }
    }

    public void OnMouseDrag(WorkSheetView_ pView, MouseEvent e) {
        Point point = e.getPoint();
        Rectangle rect = new Rectangle();
        if (this.m_mousestate == 8 || this.m_mousestate == 9) {
            this.m_row = pView.GetRowHeadRect(point, rect);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_row > -1) {
            switch (this.m_mousestate) {
                case 0: 
                case 1: {
                    if (this.m_mousestate == 0) {
                        pView.setCursor(RowHeadTool.GetCursor("LT2.gif", pView));
                    }
                    if (this.m_mousestate == 1) {
                        pView.setCursor(RowHeadTool.GetCursor("LB2.gif", pView));
                    }
                    Rectangle client = pView.getBounds();
                    pView.DrawXorLine(client.x, RowHeadTool.c_last.y, client.x + client.width, RowHeadTool.c_last.y);
                    pView.DrawXorLine(client.x, point.y, client.x + client.width, point.y);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.m_mousestate == 2) {
                        pView.setCursor(RowHeadTool.GetCursor("RT2.gif", pView));
                    }
                    if (this.m_mousestate == 3) {
                        pView.setCursor(RowHeadTool.GetCursor("RB2.gif", pView));
                    }
                    Rectangle client = pView.getBounds();
                    pView.DrawXorLine(client.x, RowHeadTool.c_last.y, client.x + client.width, RowHeadTool.c_last.y);
                    pView.DrawXorLine(client.x, point.y, client.x + client.width, point.y);
                    break;
                }
                case 5: {
                    pView.setCursor(RowHeadTool.GetCursor("right.gif", pView));
                    ColumnPropertyManage CPM = pView.getWorkSheet().getColumnPropertyManage();
                    int row1 = pView.GetRowAtPoint(false, RowHeadTool.c_down.y);
                    int row2 = pView.GetRowAtPoint(false, e.getY());
                    int cc = CPM.getColumnCount();
                    pView.getWorkSheet().setSelection(new Range_(row1, 0, row2, cc - 1));
                }
            }
        }
        super.OnMouseDrag(pView, e);
    }

    public void OnRButtonDown(WorkSheetView_ pView, MouseEvent e) {
        super.OnRButtonDown(pView, e);
    }
}

