/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.brick.Brick;
import excel.command.CMD_DeleteMultiColumn;
import excel.command.CMD_DeleteMultiRow;
import excel.command.CMD_InsertMultiColumn;
import excel.command.CMD_InsertMultiRow;
import excel.command.CMD_Merge;
import excel.command.CMD_Paste;
import excel.command.CMD_SetColumnWidth;
import excel.command.CMD_SetHeightBetweenTwoRow;
import excel.command.CMD_SetRangeBorder;
import excel.command.CMD_SetRangeProperty;
import excel.command.CMD_SetRowHeight;
import excel.command.CMD_SetSheetName;
import excel.command.CMD_SetWidthBetweenTwoColumn;
import excel.command.CMD_UnMerge;
import excel.command.CommandManage_;
import excel.command.CommandScene;
import excel.core.Cell;
import excel.core.CellPanel;
import excel.core.ClipBoard;
import excel.core.ColumnPropertyManage;
import excel.core.CommandManage;
import excel.core.DBBindConfig;
import excel.core.Depend;
import excel.core.MergedRange;
import excel.core.Property;
import excel.core.Range;
import excel.core.Row;
import excel.core.RowCol;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkBookView;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.ZExcel;
import excel.core.impl.BackGroundImageConfig;
import excel.core.impl.CellPanel_;
import excel.core.impl.Cell_;
import excel.core.impl.ClipBoard_;
import excel.core.impl.ColumnPropertyManage_;
import excel.core.impl.ContextMenuConfig;
import excel.core.impl.MergedRange_;
import excel.core.impl.PageSplitInfo;
import excel.core.impl.PopupContainer;
import excel.core.impl.PrintRange_;
import excel.core.impl.Property_;
import excel.core.impl.Range_;
import excel.core.impl.RedefineBecause;
import excel.core.impl.RowPropertyManage_;
import excel.core.impl.Row_;
import excel.core.impl.WorkBookView_;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheetView_;
import excel.core.mouseaction.DrawTool;
import excel.edit.HTMLDocumentEditor;
import excel.event.WorkBookEventManage;
import excel.jep.ASTVarNode;
import excel.jep.JEP;
import excel.jep.SimpleNode;
import excel.util.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import org.apache.regexp.RE;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkSheet_
implements WorkSheet,
ClipboardOwner {
    int floatToTopStartRow = -1;
    int floatToTopEndRow = -1;
    private String Name = "";
    private String Code = "";
    private String GUID = "";
    private WorkBook Book = null;
    private boolean Visible = true;
    private boolean PaintPermit = true;
    private boolean BalloonVisible = false;
    private CellPanel_ containerCellPanel = null;
    private CommandManage CM;
    private WorkSheetView_ View = null;
    ArrayList SheetRows = null;
    private ColumnPropertyManage_ CPM = null;
    private RowPropertyManage_ RPM = null;
    private Color PaperColor = Color.WHITE;
    private Color GridLineColor = Color.LIGHT_GRAY;
    private boolean GridLineVisible = true;
    private int xOffset = 0;
    private int yOffset = 0;
    private int xPrintOffset = 0;
    private int yPrintOffset = 0;
    private boolean ColumnMovePermited = true;
    private Range_ Selection = new Range_(0, 0, 0, 0);
    private Range_ MovingSelection = null;
    private PopupContainer popupContainer = null;
    private HashMap<Integer, Boolean> oneGroupPrintOnOnePageMap = null;
    private JPanel dockContainerPanel = null;
    HashMap MergeMap = new HashMap();
    HashMap AliasMap = new HashMap();
    ArrayList<CellPanel_> cellPanelList = new ArrayList();
    TreeMap<Integer, HashMap<String, BackGroundImageConfig>> backgroundImageMap = new TreeMap();
    private boolean IsDesignMode = true;
    private int freezedRow = 0;
    private int freezedCol = 0;
    private boolean tabHightLight = false;
    private ArrayList<Range> focusRange = new ArrayList();
    private int currentFocusRangeIndex = -1;
    private PageFormat pageFormat;
    private int currentPrintingPage;
    private int printScale = 0;
    private int viewScale = 100;
    private ArrayList pageRange = new ArrayList();
    private String pageConfig = "";
    private String printServiceName = "";
    private boolean isFormulaBackFillBindEnabled = true;
    private boolean rebuildCellDefineAfterInsertOrDeleteRow = true;
    HashMap<String, Cell> ExpressionMap = null;
    ArrayList<Cell> ExpressionList = null;
    private Object tag = null;
    private boolean isPrintable = true;
    public LinkedHashMap<String, ContextMenuConfig> contextMenuMap = null;
    public String tipInfo = null;
    public Object running = new Object();
    public long lastTime = 0L;

    public void _$WorkSheet_() {
        WorkSheetView view;
        int ri = 0;
        while (ri < this.SheetRows.size()) {
            Row row = (Row)this.SheetRows.get(ri);
            Row_ row_ = (Row_)row;
            if (row_ != null) {
                row_._$Row();
            }
            ++ri;
        }
        this.SheetRows.clear();
        if (this.MergeMap != null) {
            this.MergeMap.clear();
        }
        if (this.oneGroupPrintOnOnePageMap != null) {
            this.oneGroupPrintOnOnePageMap.clear();
        }
        if (this.AliasMap != null) {
            this.AliasMap.clear();
        }
        if (this.cellPanelList != null && (view = this.getWorkSheetView()) != null) {
            int i = 0;
            while (i < this.cellPanelList.size()) {
                view.remove(this.cellPanelList.get(i));
                ++i;
            }
        }
        if (this.focusRange != null) {
            this.focusRange.clear();
        }
        if (this.ExpressionMap != null) {
            this.ExpressionMap.clear();
        }
        if (this.ExpressionList != null) {
            this.ExpressionList.clear();
        }
        if (this.backgroundImageMap != null) {
            this.backgroundImageMap.clear();
        }
        if (this.contextMenuMap != null) {
            this.contextMenuMap.clear();
        }
        if (this.popupContainer != null) {
            this.popupDispose();
        }
    }

    public WorkSheet_(String name, WorkBook book, boolean visible, int defaultRowCount, int defaultColumnCount, String guid, String code) {
        this.Book = book;
        this.CM = new CommandManage_(this);
        this.GUID = guid.trim();
        if (this.GUID.equals("")) {
            this.GUID = Tools.newGUID();
        }
        this.Code = code;
        this.$setName(name);
        if (defaultRowCount < 1) {
            defaultRowCount = 1;
        }
        if (defaultColumnCount < 1) {
            defaultColumnCount = 1;
        }
        if (defaultRowCount > 100000) {
            defaultRowCount = 100000;
        }
        if (defaultColumnCount > 10000) {
            defaultColumnCount = 10000;
        }
        this.RPM = new RowPropertyManage_(defaultRowCount, this);
        this.CPM = new ColumnPropertyManage_(defaultColumnCount, this);
        this.SheetRows = new ArrayList();
        int i = 0;
        while (i < defaultRowCount) {
            this.SheetRows.add(null);
            ++i;
        }
        if (visible) {
            WorkSheetView_ view = new WorkSheetView_(this);
            this.setWorkSheetView(view);
        }
    }

    public void clear() {
        this.Book = null;
        this.CM = null;
        this.View = null;
        this.SheetRows = null;
        this.CPM = null;
        this.RPM = null;
        this.Selection = new Range_(0, 0, 0, 0);
        this.MovingSelection = null;
        this.MergeMap = null;
        this.oneGroupPrintOnOnePageMap = null;
        this.AliasMap = null;
        this.focusRange = null;
        this.pageFormat = null;
        this.pageRange = null;
        this.pageConfig = null;
        this.ExpressionMap = null;
        this.ExpressionList = null;
        this.tag = null;
        this.backgroundImageMap = null;
    }

    @Override
    public WorkSheetView getWorkSheetView() {
        return this.View;
    }

    @Override
    public void unFreezeCell() {
        this.freezedRow = 0;
        this.freezedCol = 0;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public void freezeCell(int row, int col) {
        Cell cell = this.Cells(row, col);
        if (cell == null) {
            return;
        }
        this.freezedRow = row;
        this.freezedCol = col;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public void freezeCell(String cellName) {
        Cell cell = this.Cells(cellName);
        if (cell == null) {
            return;
        }
        this.freezedRow = cell.getRowIndex();
        this.freezedCol = cell.getColumnIndex();
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public Cell getFreezedCell() {
        if (this.freezedRow == 0 && this.freezedCol == 0) {
            return null;
        }
        return this.cells(this.freezedRow, this.freezedCol);
    }

    @Override
    public void setWorkSheetView(WorkSheetView view) {
        WorkBookView bookview = this.Book.getWorkBookView();
        if (this.View != null && bookview != null) {
            bookview.remove(this.View);
        }
        this.View = (WorkSheetView_)view;
        if (bookview != null) {
            bookview.add(this.View);
        }
        boolean active = this.Book.getActiveSheet() == this;
        this.Active(active);
    }

    @Override
    public String getName() {
        return this.Name;
    }

    @Override
    public String getGUID() {
        return this.GUID;
    }

    @Override
    public WorkBook getWorkBook() {
        return this.Book;
    }

    @Override
    public CommandManage getCommandManage() {
        return this.CM;
    }

    @Override
    public void setCode(String newCode) {
        String oldCode = this.Code;
        if (newCode == null) {
            return;
        }
        if (newCode.trim().equals("")) {
            return;
        }
        if (oldCode != null && oldCode.equals(newCode)) {
            return;
        }
        String t = newCode;
        boolean n = false;
        if (this.Book.getWorkSheetByCode(t) != null) {
            return;
        }
        this.Code = newCode;
    }

    @Override
    public String getCode() {
        return this.Code == null ? "" : this.Code;
    }

    @Override
    public void setName(String newname) {
        newname = newname.replaceAll("[!:]", "");
        String oldName = this.Name;
        if (newname == null) {
            return;
        }
        if (newname.trim().equals("")) {
            return;
        }
        if (!this.isDesignMode()) {
            return;
        }
        if (oldName != null && oldName.equals(newname)) {
            return;
        }
        String t = newname;
        int n = 0;
        while (this.Book.getWorkSheet(t) != null) {
            t = String.valueOf(newname) + ++n;
        }
        CommandScene scene = new CommandScene();
        scene.put("newname", t);
        CMD_SetSheetName cmd = new CMD_SetSheetName(this, scene);
        cmd.Execute();
    }

    public void $setName(String newname) {
        String oldName = this.Name;
        this.Name = newname;
        if (!oldName.equals("")) {
            ((WorkBook_)this.getWorkBook()).RebuildAllDefine(this, new RedefineBecause(5, 0, 0, 0, 0));
            WorkBookEventManage EM = this.getWorkBook().getEM();
            if (EM != null) {
                EM.fireNameChanged(this, oldName, this.Name);
            }
        }
    }

    public void Active(boolean active) {
        if (this.View == null) {
            return;
        }
        if (this.getContainerCellPanel() != null) {
            return;
        }
        ((Component)this.View).setVisible(active);
        if (active) {
            WorkBookView_ view = (WorkBookView_)this.Book.getWorkBookView();
            view.getWorkSheetTabContainer().setActiveTabIndex(this.getIndex());
            this.ResetHScrollBarScrollRange();
            this.ResetVScrollBarScrollRange();
            view.requestFocusInWindow();
        }
        int i = 0;
        while (i < this.cellPanelList.size()) {
            this.cellPanelList.get(i).setVisible(active);
            ++i;
        }
    }

    @Override
    public int getIndex() {
        return this.Book.getWorkSheetIndex(this);
    }

    @Override
    public Color getPaperColor() {
        return this.PaperColor;
    }

    @Override
    public void setPaperColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.PaperColor)) {
            return;
        }
        this.PaperColor = color;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public boolean isPaintPermit() {
        return this.PaintPermit;
    }

    @Override
    public void setPaintPermit(boolean paintPermit) {
        this.PaintPermit = paintPermit;
        if (!paintPermit && this.View != null) {
            this.View.getCurrentSnapShot();
        }
        if (this.View != null && paintPermit) {
            this.View.repaint();
        }
        if (paintPermit) {
            this.View.snapShot = null;
        }
    }

    @Override
    public Color getGridLineColor() {
        return this.GridLineColor;
    }

    @Override
    public void setGridLineColor(Color color) {
        if (color == null) {
            return;
        }
        if (color.equals(this.GridLineColor)) {
            return;
        }
        this.GridLineColor = color;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public ColumnPropertyManage getColumnPropertyManage() {
        return this.CPM;
    }

    @Override
    public RowPropertyManage getRowPropertyManage() {
        return this.RPM;
    }

    @Override
    public Cell Cells(int row, int col) {
        return this.cells(row, col);
    }

    @Override
    public Cell Cells(String cellName) {
        return this.cells(cellName);
    }

    @Override
    public Cell cells(int row, int col) {
        return this.CreateCell(row, col);
    }

    @Override
    public Cell cells(String cellName) {
        RowCol rc = this.cellNameToRowColumn(cellName);
        if (rc == null) {
            return null;
        }
        Cell cell = this.Cells(rc.row, rc.col);
        return cell;
    }

    public int getXPrintOffset() {
        return this.xPrintOffset;
    }

    public void setXPrintOffset(int printOffset) {
        this.xPrintOffset = printOffset;
    }

    public int getYPrintOffset() {
        return this.yPrintOffset;
    }

    public void setYPrintOffset(int printOffset) {
        this.yPrintOffset = printOffset;
    }

    @Override
    public int getXOffset() {
        return this.xOffset;
    }

    @Override
    public int getYOffset() {
        return this.yOffset;
    }

    @Override
    public void setXOffset(int xoffset) {
        if (this.xOffset == xoffset) {
            return;
        }
        if (xoffset < 0) {
            xoffset = 0;
        }
        WorkBookView_ BookView = (WorkBookView_)this.getWorkBook().getWorkBookView();
        int max = BookView.hScrollBar.getMaximum();
        this.xOffset = xoffset;
        if (this.View != null) {
            this.View.repaint();
        }
        this.ResetHScrollBarScrollRange();
    }

    public void ResetHScrollBarScrollRange() {
        if (this.containerCellPanel != null) {
            this.containerCellPanel.reCalcuSize();
        } else {
            WorkBookView_ BookView = (WorkBookView_)this.getWorkBook().getWorkBookView();
            if (!this.isDesignMode() && this.View.includeStretchColumn()) {
                this.View.reCalcuColumnsWidth();
            }
            BookView.ResetHScrollBarScrollRange();
        }
    }

    public void ResetVScrollBarScrollRange() {
        if (this.containerCellPanel != null) {
            this.containerCellPanel.reCalcuSize();
        } else {
            if (!this.isDesignMode() && this.View.includeStretchRow()) {
                this.View.reCalcuRowsHeight();
            }
            WorkBookView_ BookView = (WorkBookView_)this.getWorkBook().getWorkBookView();
            BookView.ResetVScrollBarScrollRange();
        }
    }

    @Override
    public void setYOffset(int yoffset) {
        if (this.yOffset == yoffset) {
            return;
        }
        if (yoffset < 0) {
            yoffset = 0;
        }
        this.yOffset = yoffset;
        if (this.View != null) {
            this.View.repaint();
        }
        WorkBookView_ BookView = (WorkBookView_)this.getWorkBook().getWorkBookView();
        this.ResetVScrollBarScrollRange();
    }

    @Override
    public boolean getColumnMovePermited() {
        return this.ColumnMovePermited;
    }

    @Override
    public void setColumnMovePermited(boolean permited) {
        this.ColumnMovePermited = permited;
    }

    @Override
    public Range getSelection() {
        return (Range)this.Selection.clone();
    }

    @Override
    public void setSelection(int startRow, int startCol, int endRow, int endCol) {
        startRow = Math.min(this.getRowCount() - 1, Math.max(0, startRow));
        startCol = Math.min(this.getColumnCount() - 1, Math.max(0, startCol));
        endRow = Math.min(this.getRowCount() - 1, Math.max(0, endRow));
        endCol = Math.min(this.getColumnCount() - 1, Math.max(0, endCol));
        Range_ r = new Range_(startRow, startCol, endRow, endCol);
        this.setSelection(r);
    }

    @Override
    public void setSelection(Cell cell) {
        if (cell == null) {
            return;
        }
        int row = cell.getRowIndex();
        int col = cell.getColumnIndex();
        this.setSelection(row, col, row, col);
    }

    @Override
    public void setSelection(Cell fromCell, Cell toCell) {
        if (fromCell == null) {
            return;
        }
        if (toCell == null) {
            return;
        }
        int startRow = fromCell.getRowIndex();
        int startCol = fromCell.getColumnIndex();
        int endRow = toCell.getRowIndex();
        int endCol = toCell.getColumnIndex();
        this.setSelection(startRow, startCol, endRow, endCol);
    }

    @Override
    public void setSelection(Range range) {
        if (range != null && (range.getStartRow() == -1 || range.getStartCol() == -1 || range.getEndRow() == -1 || range.getEndCol() == -1)) {
            return;
        }
        int oldRow = this.Selection.getStartRow();
        int oldCol = this.Selection.getStartCol();
        this.Selection = this.$copyRangeAndRepaint(this.Selection, range);
        int newRow = this.Selection.getStartRow();
        int newCol = this.Selection.getStartCol();
        if (newRow != oldRow || newCol != oldCol) {
            this.getWorkBook().getEM().fireCellFocusLost(this, oldRow, oldCol);
            this.getWorkBook().getEM().fireCellFocusGained(this, newRow, newCol);
        }
    }

    public void setMovingSelection(Range range) {
        this.MovingSelection = this.$copyRangeAndRepaint(this.MovingSelection, range);
    }

    private Range_ $copyRangeAndRepaint(Range_ target, Range range) {
        Range r = range;
        if (range != null) {
            int sr = range.getStartRow();
            int sc = range.getStartCol();
            int er = range.getEndRow();
            int ec = range.getEndCol();
            int row = range.getStartRow();
            while (row <= range.getEndRow()) {
                int col = range.getStartCol();
                while (col <= range.getEndCol()) {
                    Cell cell = this.$Cells(row, col);
                    if (cell != null && this.MergeMap.containsKey(cell)) {
                        MergedRange tr = (MergedRange)this.MergeMap.get(cell);
                        sr = Math.min(tr.getMergeStart().getRowIndex(), sr);
                        sc = Math.min(tr.getMergeStart().getColumnIndex(), sc);
                        er = Math.max(tr.getMergeEnd().getRowIndex(), er);
                        ec = Math.max(tr.getMergeEnd().getColumnIndex(), ec);
                    }
                    ++col;
                }
                ++row;
            }
            r = new Range_(sr, sc, er, ec);
            if (target != null && target.equals(r)) {
                return target;
            }
        }
        Rectangle oldrc = null;
        Rectangle newrc = null;
        if (this.View != null && target != null) {
            oldrc = this.View.getRectangleOfRange(false, target);
        }
        target = (Range_)r;
        if (this.View != null && target != null) {
            newrc = this.View.getRectangleOfRange(false, target);
        }
        if (oldrc != null || newrc != null) {
            Rectangle rc = null;
            if (oldrc == null) {
                rc = newrc;
            }
            if (newrc == null) {
                rc = oldrc;
            }
            if (oldrc != null && newrc != null) {
                rc = oldrc.union(newrc);
            }
            rc.x -= 3;
            rc.y -= 3;
            rc.width += 6;
            rc.height += 6;
            this.View.repaint(rc);
            Rectangle RowHeadRc = (Rectangle)rc.clone();
            RowHeadRc.x = 0;
            RowHeadRc.width = this.RPM.getRowHeadWidth();
            this.View.repaint(RowHeadRc);
            Rectangle ColHeadRc = (Rectangle)rc.clone();
            ColHeadRc.y = 0;
            ColHeadRc.height = this.CPM.getColumnHeadHeight();
            this.View.repaint(ColHeadRc);
        }
        if (target != null) {
            target = this.$copyRangeAndRepaint(target, target);
        }
        return target;
    }

    public Range getMovingSelection() {
        return this.MovingSelection;
    }

    @Override
    public Object getCellValue(int row, int col) {
        Cell cell = this.Cells(row, col);
        if (cell == null) {
            return "";
        }
        return cell.getValue();
    }

    @Override
    public Object getCellValue(int row, int col, int cellInnerRow) {
        Cell cell = this.Cells(row, col);
        if (cell == null) {
            return "";
        }
        return cell.getValue(cellInnerRow);
    }

    @Override
    public String getCellText(int row, int col) {
        Cell cell = this.Cells(row, col);
        if (cell == null) {
            return "";
        }
        return cell.getShowText();
    }

    @Override
    public String getCellText(int row, int col, int cellInnerRow) {
        Cell cell = this.Cells(row, col);
        if (cell == null) {
            return "";
        }
        return cell.getShowText(cellInnerRow);
    }

    private Object getCellTextForJEP(int row, int col) {
        Cell_ cell = (Cell_)this.Cells(row, col);
        if (cell == null) {
            return "";
        }
        return cell.getShowTextForJEP(-99);
    }

    public Object getCellTextForJEP(int row, int col, int cellInnerRow) {
        Cell_ cell = (Cell_)this.Cells(row, col);
        if (cell == null) {
            return "";
        }
        return cell.getShowTextForJEP(cellInnerRow);
    }

    @Override
    public void setCellValue(int row, int col, Object value) {
        Cell cell = this.CreateCell(row, col);
        cell.setValue(value);
    }

    public Cell $Cells(int row, int col) {
        if (row < 0) {
            return null;
        }
        if (col < 0) {
            return null;
        }
        if (this.RPM == null) {
            return null;
        }
        if (this.CPM == null) {
            return null;
        }
        if (row >= this.RPM.getRowCount()) {
            return null;
        }
        if (col >= this.CPM.getColumnCount()) {
            return null;
        }
        Row r = (Row)this.SheetRows.get(row);
        if (r == null) {
            return null;
        }
        return r.getCell(col);
    }

    public Cell CreateCell(int row, int col) {
        Cell cell = null;
        if (row == -9999) {
            if (col >= this.ExpressionList.size()) {
                return null;
            }
            return this.ExpressionList.get(col);
        }
        if (row < 0) {
            return null;
        }
        if (col < 0) {
            return null;
        }
        if (row >= this.RPM.getRowCount()) {
            return null;
        }
        if (col >= this.CPM.getColumnCount()) {
            return null;
        }
        Row_ r = (Row_)this.SheetRows.get(row);
        if (r != null) {
            cell = r.$getCell(col);
        }
        if (cell != null) {
            return cell;
        }
        Row_ R = (Row_)this.getRow(row);
        cell = new Cell_(this, R);
        R.$setCell(col, cell);
        return cell;
    }

    @Override
    public Object getCellProperty(int row, int col, String propertyName) {
        Property p = Property_.defaultProperty;
        Cell cell = this.Cells(row, col);
        if (cell != null) {
            p = cell.getProperty();
        }
        Object v = p.get(propertyName, (Object)null);
        Object defaultValue = Property_.defaultProperty.get(propertyName, (Object)null);
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (v == null) {
            v = defaultValue;
        }
        try {
            v = ObjectTool.ChangeType((Object)v, (String)defaultValue.getClass().getName());
        }
        catch (Exception e) {
            v = "";
        }
        return v;
    }

    @Override
    public void setCellProperty(int row, int col, String propertyName, Object propertyValue) {
        Cell cell = this.CreateCell(row, col);
        cell.setProperty(propertyName, propertyValue);
    }

    @Override
    public Object getRangeProperty(Range range, String propertyName) {
        return null;
    }

    @Override
    public void setRangeProperty(Range range, String propertyName, Object propertyValue) {
        if (range == null) {
            return;
        }
        if (propertyName == null || propertyValue == null) {
            return;
        }
        CommandScene scene = new CommandScene();
        scene.put("range", range);
        scene.put("propertyname", propertyName);
        scene.put("propertyvalue", propertyValue);
        CMD_SetRangeProperty cmd = new CMD_SetRangeProperty(this, scene);
        cmd.Execute();
    }

    @Override
    public Range newRange(int startRow, int startCol, int endRow, int endCol) {
        return new Range_(startRow, startCol, endRow, endCol);
    }

    @Override
    public void setRangeBorder(int startRow, int startCol, int endRow, int endCol, int whichSide, int style, int width, String color) {
        this.setRangeBorder((Range)new Range_(startRow, startCol, endRow, endCol), whichSide, style, width, color);
    }

    @Override
    public void setRangeBorder(Range range, int whichSide, int style, int width, String color) {
        Color c = Tools.Hex2Color(color);
        this.setRangeBorder(range, whichSide, style, width, c);
    }

    @Override
    public void setRangeBorder(Range range, int whichSide, int style, int width, Color color) {
        if (range == null) {
            return;
        }
        CommandScene scene = new CommandScene();
        Range r = range;
        Cell cell = this.$Cells(range.getStartRow(), range.getStartCol());
        if (cell != null && cell.isMerged() && cell.getMergedRange().equals(range)) {
            r = new Range_(range.getStartRow(), range.getStartCol(), range.getStartRow(), range.getStartCol());
        }
        scene.put("range", r);
        scene.put("side", whichSide);
        scene.put("style", style);
        scene.put("width", width);
        scene.put("color", color);
        CMD_SetRangeBorder cmd = new CMD_SetRangeBorder(this, scene);
        cmd.Execute();
    }

    public boolean $setRangeBorder(Range range, int whichSide, int style, int width, Color color) {
        boolean ret = true;
        switch (whichSide) {
            case 0: {
                ret = this.$setRangeLeftBorder(range, style, width, color);
                break;
            }
            case 1: {
                ret = this.$setRangeRightBorder(range, style, width, color);
                break;
            }
            case 2: {
                ret = this.$setRangeTopBorder(range, style, width, color);
                break;
            }
            case 3: {
                ret = this.$setRangeBottomBorder(range, style, width, color);
                break;
            }
            case 6: {
                boolean b1 = this.$setRangeLeftBorder(range, style, width, color);
                boolean b2 = this.$setRangeRightBorder(range, style, width, color);
                boolean b3 = this.$setRangeTopBorder(range, style, width, color);
                boolean b4 = this.$setRangeBottomBorder(range, style, width, color);
                ret = b1 || b2 || b3 || b4;
                break;
            }
            case 7: {
                boolean b5 = this.$setRangeInnerVBorder(range, style, width, color);
                boolean b6 = this.$setRangeInnerHBorder(range, style, width, color);
                ret = b5 || b6;
                break;
            }
            case 5: {
                ret = this.$setRangeInnerVBorder(range, style, width, color);
                break;
            }
            case 4: {
                ret = this.$setRangeInnerHBorder(range, style, width, color);
                break;
            }
            case 8: {
                boolean b1 = this.$setRangeLeftBorder(range, style, width, color);
                boolean b2 = this.$setRangeRightBorder(range, style, width, color);
                boolean b3 = this.$setRangeTopBorder(range, style, width, color);
                boolean b4 = this.$setRangeBottomBorder(range, style, width, color);
                boolean b5 = this.$setRangeInnerVBorder(range, style, width, color);
                boolean b6 = this.$setRangeInnerHBorder(range, style, width, color);
                ret = b1 || b2 || b3 || b4 || b5 || b6;
            }
        }
        return ret;
    }

    private boolean $setRangeLeftBorder(Range range, int style, int width, Color color) {
        Cell_ cell;
        int col = range.getStartCol();
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            cell = (Cell_)this.CreateCell(row, col);
            cell.$setProperty("border-left-style", style);
            cell.$setProperty("border-left-width", width);
            cell.$setProperty("border-left-color", color);
            ++row;
        }
        if (--col >= 0) {
            row = range.getStartRow();
            while (row <= range.getEndRow()) {
                cell = (Cell_)this.CreateCell(row, col);
                cell.$setProperty("border-right-style", 0);
                ++row;
            }
        }
        return true;
    }

    private boolean $setRangeRightBorder(Range range, int style, int width, Color color) {
        int col;
        int endCol = range.getEndCol();
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            col = range.getStartCol();
            while (col <= range.getEndCol()) {
                boolean needSet = false;
                Cell_ cell = (Cell_)this.CreateCell(row, col);
                if (col == endCol) {
                    needSet = true;
                }
                if (cell.isMerged() && cell.getMergedRange().getEndCol() == endCol) {
                    needSet = true;
                }
                if (needSet) {
                    cell.$setProperty("border-right-style", style);
                    cell.$setProperty("border-right-width", width);
                    cell.$setProperty("border-right-color", color);
                }
                ++col;
            }
            ++row;
        }
        col = endCol + 1;
        if (col < this.getColumnPropertyManage().getColumnCount()) {
            row = range.getStartRow();
            while (row <= range.getEndRow()) {
                Cell_ cell = (Cell_)this.CreateCell(row, col);
                cell.$setProperty("border-left-style", 0);
                ++row;
            }
        }
        return true;
    }

    private boolean $setRangeTopBorder(Range range, int style, int width, Color color) {
        Cell_ cell;
        int row = range.getStartRow();
        int col = range.getStartCol();
        while (col <= range.getEndCol()) {
            cell = (Cell_)this.CreateCell(row, col);
            cell.$setProperty("border-top-style", style);
            cell.$setProperty("border-top-width", width);
            cell.$setProperty("border-top-color", color);
            ++col;
        }
        if (--row >= 0) {
            col = range.getStartCol();
            while (col <= range.getEndCol()) {
                cell = (Cell_)this.CreateCell(row, col);
                cell.$setProperty("border-bottom-style", 0);
                ++col;
            }
        }
        return true;
    }

    private boolean $setRangeBottomBorder(Range range, int style, int width, Color color) {
        Cell_ cell;
        int col;
        int endRow = range.getEndRow();
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            col = range.getStartCol();
            while (col <= range.getEndCol()) {
                cell = (Cell_)this.CreateCell(row, col);
                boolean needSet = false;
                if (row == endRow) {
                    needSet = true;
                }
                if (cell.isMerged() && cell.getMergedRange().getEndRow() == endRow) {
                    needSet = true;
                }
                if (needSet) {
                    cell.$setProperty("border-bottom-style", style);
                    cell.$setProperty("border-bottom-width", width);
                    cell.$setProperty("border-bottom-color", color);
                }
                ++col;
            }
            ++row;
        }
        row = endRow + 1;
        if (row < this.RPM.getRowCount()) {
            col = range.getStartCol();
            while (col <= range.getEndCol()) {
                cell = (Cell_)this.CreateCell(row, col);
                cell.$setProperty("border-top-style", 0);
                ++col;
            }
        }
        return true;
    }

    private boolean $setRangeInnerVBorder(Range range, int style, int width, Color color) {
        int endCol;
        int startRow = range.getStartRow();
        int endRow = range.getEndRow();
        int startCol = range.getStartCol();
        if (startCol == (endCol = range.getEndCol())) {
            return false;
        }
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell_ cell;
                if (col != endCol) {
                    cell = (Cell_)this.CreateCell(row, col);
                    cell.$setProperty("border-right-style", style);
                    cell.$setProperty("border-right-width", width);
                    cell.$setProperty("border-right-color", color);
                }
                if (col != startCol) {
                    cell = (Cell_)this.CreateCell(row, col);
                    cell.$setProperty("border-left-style", 0);
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    private boolean $setRangeInnerHBorder(Range range, int style, int width, Color color) {
        int startRow = range.getStartRow();
        int endRow = range.getEndRow();
        int startCol = range.getStartCol();
        int endCol = range.getEndCol();
        if (startRow == endRow) {
            return false;
        }
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell_ cell;
                if (row != endRow) {
                    cell = (Cell_)this.CreateCell(row, col);
                    cell.$setProperty("border-bottom-style", style);
                    cell.$setProperty("border-bottom-width", width);
                    cell.$setProperty("border-bottom-color", color);
                }
                if (row != startRow) {
                    cell = (Cell_)this.CreateCell(row, col);
                    cell.$setProperty("border-top-style", 0);
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    @Override
    public void Merge(Range range) {
        this.Merge(range.getStartRow(), range.getStartCol(), range.getEndRow(), range.getEndCol());
    }

    @Override
    public void Merge(int startRow, int startCol, int endRow, int endCol) {
        if (startRow == endRow && startCol == endCol) {
            return;
        }
        CommandScene scene = new CommandScene();
        scene.put("startrow", startRow);
        scene.put("startcol", startCol);
        scene.put("endrow", endRow);
        scene.put("endcol", endCol);
        CMD_Merge cmd = new CMD_Merge(this, scene);
        cmd.Execute();
    }

    public boolean $Merge(int startRow, int startCol, int endRow, int endCol) {
        int rc = this.RPM.getRowCount();
        int cc = this.CPM.getColumnCount();
        if (startRow < 0) {
            startRow = 0;
        }
        if (startRow + 1 > rc) {
            startRow = rc - 1;
        }
        if (startCol < 0) {
            startCol = 0;
        }
        if (startCol + 1 > cc) {
            startCol = cc - 1;
        }
        if (endRow < 0) {
            endRow = 0;
        }
        if (endRow + 1 > rc) {
            endRow = rc - 1;
        }
        if (endCol < 0) {
            endCol = 0;
        }
        if (endCol + 1 > cc) {
            endCol = cc - 1;
        }
        int fr = this.RPM.getFixedRowCount();
        int fc = this.CPM.getFixedColumnCount();
        if (startRow == endRow && startCol == endCol) {
            return false;
        }
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell cell = this.$Cells(row, col);
                if (cell != null && cell.isMerged()) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        Cell cellStart = this.Cells(startRow, startCol);
        Cell cellEnd = this.Cells(endRow, endCol);
        MergedRange_ r = new MergedRange_(cellStart, cellEnd);
        int row2 = startRow;
        while (row2 <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell cell = this.Cells(row2, col);
                this.MergeMap.put(cell, r);
                ++col;
            }
            ++row2;
        }
        this.View.repaint();
        return true;
    }

    @Override
    public void UnMerge(Range range) {
        this.UnMerge(range.getStartRow(), range.getStartCol(), range.getEndRow(), range.getEndCol());
    }

    @Override
    public void UnMerge(int startRow, int startCol, int endRow, int endCol) {
        if (startRow == endRow && startCol == endCol) {
            return;
        }
        CommandScene scene = new CommandScene();
        scene.put("startrow", startRow);
        scene.put("startcol", startCol);
        scene.put("endrow", endRow);
        scene.put("endcol", endCol);
        CMD_UnMerge cmd = new CMD_UnMerge(this, scene);
        cmd.Execute();
    }

    public boolean $UnMerge(int startRow, int startCol, int endRow, int endCol) {
        int rc = this.RPM.getRowCount();
        int cc = this.CPM.getColumnCount();
        if (startRow < 0) {
            startRow = 0;
        }
        if (startRow + 1 > rc) {
            startRow = rc - 1;
        }
        if (startCol < 0) {
            startCol = 0;
        }
        if (startCol + 1 > cc) {
            startCol = cc - 1;
        }
        if (endRow < 0) {
            endRow = 0;
        }
        if (endRow + 1 > rc) {
            endRow = rc - 1;
        }
        if (endCol < 0) {
            endCol = 0;
        }
        if (endCol + 1 > cc) {
            endCol = cc - 1;
        }
        boolean realDo = false;
        Range_ r0 = new Range_(startRow, startCol, endRow, endCol);
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell cell = this.$Cells(row, col);
                if (cell != null && cell.isMerged()) {
                    realDo = true;
                    MergedRange mr = (MergedRange)this.MergeMap.get(cell);
                    this.MergeMap.remove(cell);
                    Range r = mr.getMergedRange();
                    if (!r.equals(r0)) {
                        this.$UnMerge(r.getStartRow(), r.getStartCol(), r.getEndRow(), r.getEndCol());
                    }
                }
                ++col;
            }
            ++row;
        }
        this.View.repaint();
        return realDo;
    }

    @Override
    public void setColumnWidth(int colIndex, int width) {
        CommandScene scene = new CommandScene();
        scene.put("col", colIndex);
        scene.put("width", width);
        CMD_SetColumnWidth cmd = new CMD_SetColumnWidth(this, scene);
        cmd.Execute();
    }

    public void $setColumnWidth(int colindex, int width) {
        this.CPM.setColumnWidth(colindex, width);
        this.ResetHScrollBarScrollRange();
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public void setWidthBetweenTwoColumn(int col1, int col2, int delta) {
        CommandScene scene = new CommandScene();
        scene.put("col1", col1);
        scene.put("col2", col2);
        scene.put("delta", delta);
        CMD_SetWidthBetweenTwoColumn cmd = new CMD_SetWidthBetweenTwoColumn(this, scene);
        cmd.Execute();
    }

    public void $setWidthBetweenTwoColumn(int col1, int col2, int delta) {
        int w1 = this.CPM.getColumnWidth(col1);
        int w2 = this.CPM.getColumnWidth(col2);
        int delta2 = delta - w1;
        this.CPM.setColumnWidth(col2, this.CPM.getColumnWidth(col2) - delta2);
        if (this.CPM.getColumnWidth(col2) == 0) {
            this.CPM.setColumnWidth(col1, w1 + w2);
        } else {
            this.CPM.setColumnWidth(col1, Math.max(0, delta));
        }
        this.ResetHScrollBarScrollRange();
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public void setHeightBetweenTwoRow(int row1, int row2, int delta) {
        CommandScene scene = new CommandScene();
        scene.put("row1", row1);
        scene.put("row2", row2);
        scene.put("delta", delta);
        CMD_SetHeightBetweenTwoRow cmd = new CMD_SetHeightBetweenTwoRow(this, scene);
        cmd.Execute();
    }

    @Override
    public void setRowHeight(int rowIndex, int height) {
        CommandScene scene = new CommandScene();
        scene.put("row", rowIndex);
        scene.put("height", height);
        CMD_SetRowHeight cmd = new CMD_SetRowHeight(this, scene);
        cmd.Execute();
    }

    public void $setHeightBetweenTwoRow(int row1, int row2, int delta) {
        int w1 = this.RPM.getRowHeight(row1);
        int w2 = this.RPM.getRowHeight(row2);
        int delta2 = delta - w1;
        this.RPM.setRowHeight(row2, this.RPM.getRowHeight(row2) - delta2);
        if (this.RPM.getRowHeight(row2) == 0) {
            this.RPM.setRowHeight(row1, w1 + w2);
        } else {
            this.RPM.setRowHeight(row1, Math.max(0, delta));
        }
        this.ResetVScrollBarScrollRange();
        if (this.View != null) {
            this.View.repaint();
        }
    }

    public void $setRowHeight(int rowIndex, int height) {
        this.RPM.setRowHeight(rowIndex, height);
        this.ResetVScrollBarScrollRange();
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public HashMap getMergeMap() {
        return this.MergeMap;
    }

    public ArrayList getAllMergeRange() {
        ArrayList<Range> ret = new ArrayList<Range>();
        for (MergedRange mr : this.MergeMap.values()) {
            Range r = mr.getMergedRange();
            if (ret.contains(r)) continue;
            ret.add(r);
        }
        return ret;
    }

    public Object getValueForJEP(JEP jep, ASTVarNode var, int cellInnerRow) {
        Range range = null;
        Double errorRet = new Double(0.0);
        String SheetName = null;
        Object da = null;
        RowCol rc = null;
        WorkSheet sheet = null;
        Vector<Object> vector = null;
        Cell_ clientCell = jep.getClientCell();
        boolean needShowText = false;
        String varName = var.getName();
        switch (var.getToken().kind) {
            case 10: 
            case 11: {
                needShowText = varName.startsWith("$");
                Cell_ ce = (Cell_)this.cells(var.getOriginName());
                if (ce == clientCell && clientCell != null) {
                    Tools.log("JEP.getValueFromWorkSheet \u5355\u5143\u683c:" + this.getName() + " (" + varName + ")\u5faa\u73af\u5f15\u7528");
                    return errorRet;
                }
                Object v = needShowText ? ce.getShowTextForJEP(cellInnerRow) : ce.getValue(cellInnerRow);
                return v;
            }
            case 12: {
                needShowText = varName.startsWith("$");
                range = this.rangeNameToRange(varName);
                vector = new Vector<Object>();
                int row = range.getStartRow();
                while (row <= range.getEndRow()) {
                    int col = range.getStartCol();
                    while (col <= range.getEndCol()) {
                        if (this.cells(row, col) == clientCell && clientCell != null) {
                            Tools.log("JEP.getValueFromWorkSheet \u5355\u5143\u683c:" + this.getName() + " (" + varName + ")\u5faa\u73af\u5f15\u7528" + this.cells(row, col).getName());
                            return errorRet;
                        }
                        vector.add(needShowText ? this.getCellTextForJEP(row, col, cellInnerRow) : this.getCellValue(row, col, cellInnerRow));
                        ++col;
                    }
                    ++row;
                }
                return vector;
            }
            case 13: {
                int p = varName.indexOf("!");
                if (p <= 0) break;
                SheetName = varName.substring(0, p).trim();
                varName = varName.substring(p + 1, varName.length());
                needShowText = varName.startsWith("$");
                sheet = this.getWorkBook().getWorkSheet(SheetName);
                if (sheet == null) {
                    this.getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                }
                rc = ((WorkSheet_)sheet).cellNameToRowColumn(varName);
                if (sheet.cells(rc.row, rc.col) == clientCell && clientCell != null) {
                    Tools.log("JEP.getValueFromWorkSheet \u5355\u5143\u683c:" + sheet.getName() + " (" + varName + ")\u5faa\u73af\u5f15\u7528");
                    return errorRet;
                }
                return needShowText ? ((WorkSheet_)sheet).getCellTextForJEP(rc.row, rc.col, cellInnerRow) : sheet.getCellValue(rc.row, rc.col, cellInnerRow);
            }
            case 15: {
                int p = varName.indexOf("!");
                if (p <= 0) break;
                SheetName = varName.substring(0, p).trim();
                varName = varName.substring(p + 1, varName.length());
                needShowText = varName.startsWith("$");
                sheet = this.getWorkBook().getWorkSheet(SheetName);
                if (sheet == null) {
                    this.getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                }
                rc = ((WorkSheet_)sheet).cellNameToRowColumn(varName);
                return needShowText ? ((WorkSheet_)sheet).getCellTextForJEP(rc.row, rc.col, cellInnerRow) : sheet.getCellValue(rc.row, rc.col, cellInnerRow);
            }
            case 14: {
                int p = varName.indexOf("!");
                if (p <= 0) break;
                SheetName = varName.substring(0, p).trim();
                varName = varName.substring(p + 1, varName.length());
                needShowText = varName.startsWith("$");
                sheet = this.getWorkBook().getWorkSheet(SheetName);
                if (sheet == null) {
                    this.getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                }
                range = ((WorkSheet_)sheet).rangeNameToRange(varName);
                vector = new Vector();
                int row = range.getStartRow();
                while (row <= range.getEndRow()) {
                    int col = range.getStartCol();
                    while (col <= range.getEndCol()) {
                        if (sheet.cells(row, col) == clientCell && clientCell != null) {
                            Tools.log("JEP.getValueFromWorkSheet \u5355\u5143\u683c:" + sheet.getName() + " (" + varName + ")\u5faa\u73af\u5f15\u7528" + sheet.cells(row, col).getName());
                            return errorRet;
                        }
                        vector.add(needShowText ? ((WorkSheet_)sheet).getCellTextForJEP(row, col) : sheet.getCellValue(row, col));
                        ++col;
                    }
                    ++row;
                }
                return vector;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    private WorkBookEventManage getEM() {
        return this.getWorkBook().getEM();
    }

    public static void main(String[] arg) {
        System.out.println(ZExcel.rowColToName(2, 25));
        System.out.println(ZExcel.rowColToName(2, 26));
        System.out.println(ZExcel.rowColToName(2, 36));
        System.out.println(ZExcel.rowColToName(2, 51));
        System.out.println(ZExcel.rowColToName(2, 51));
        System.out.println(ZExcel.rowColToName(2, 52));
    }

    @Override
    public String rowColToName(int row, int col) {
        return ZExcel.rowColToName(row, col);
    }

    @Override
    public RowCol cellNameToRowColumn(String cellName) {
        if (cellName.startsWith("$")) {
            cellName = cellName.substring(1);
        }
        RowCol ret = new RowCol(0, 0);
        if (cellName.equals("")) {
            ret.row = this.getRowCount() - 1;
            ret.col = this.getColumnCount() - 1;
            return ret;
        }
        Cell cell = this.getCellByAlias(cellName);
        if (cell != null) {
            ret.row = cell.getRowIndex();
            ret.col = cell.getColumnIndex();
            return ret;
        }
        try {
            String t = cellName.toUpperCase();
            RE r = new RE("([A-Z]{1,2})([0-9]+)");
            if (r.match(t)) {
                if (r.getParenStart(0) != 0 || r.getParenEnd(0) != cellName.length()) {
                    throw new Exception("");
                }
                if (r.getParenCount() != 3) {
                    throw new Exception("\u4e0d\u5408\u6cd5\u7684\u5355\u5143\u683c\u540d\u79f0");
                }
                String s = cellName.substring(r.getParenStart(1), r.getParenEnd(1)).toUpperCase().trim();
                int i = 0;
                while (i < s.length()) {
                    ret.col = ret.col * 26 + s.charAt(i) - 64;
                    ++i;
                }
                --ret.col;
                ret.row = new Integer(cellName.substring(r.getParenStart(2), r.getParenEnd(2))) - 1;
                if (ret.col + 1 > this.getColumnCount()) {
                    throw new Exception("");
                }
                if (ret.row + 1 > this.getRowCount()) {
                    throw new Exception("");
                }
                return ret;
            }
            throw new Exception("");
        }
        catch (Exception e) {
            cell = this.getCellByAlias(cellName);
            if (cell != null) {
                ret.row = cell.getRowIndex();
                ret.col = cell.getColumnIndex();
            } else {
                ret.row = -1;
                ret.col = -1;
            }
            return ret;
        }
    }

    @Override
    public Range rangeNameToRange(String rangeName) {
        int p = rangeName.indexOf(":");
        if (p < 0) {
            return null;
        }
        String s1 = rangeName.substring(0, p);
        String s2 = rangeName.substring(p + 1, rangeName.length());
        RowCol rc1 = this.cellNameToRowColumn(s1);
        RowCol rc2 = this.cellNameToRowColumn(s2);
        return new Range_(rc1.row, rc1.col, rc2.row, rc2.col);
    }

    @Override
    public boolean getGridLineVisible() {
        return this.GridLineVisible;
    }

    @Override
    public void setGridLineVisible(boolean v) {
        if (this.GridLineVisible == v) {
            return;
        }
        this.GridLineVisible = v;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public boolean isDesignMode() {
        return this.IsDesignMode;
    }

    @Override
    public void setIsDesignMode(boolean isDesignMode) {
        this.IsDesignMode = isDesignMode;
    }

    public void $$insertRowBefore(int beforeRow) {
        int rc;
        if (beforeRow < 0) {
            beforeRow = 0;
        }
        if (beforeRow >= (rc = this.SheetRows.size())) {
            this.SheetRows.add(null);
        } else {
            this.SheetRows.add(beforeRow, null);
        }
    }

    public void $$insertColumnBefore(int beforeCol) {
        int cc;
        if (beforeCol < 0) {
            beforeCol = 0;
        }
        boolean append = beforeCol >= (cc = ((Row_)this.SheetRows.get(0)).getCellCount());
        int rc = this.RPM.getRowCount();
        int row = 0;
        while (row < rc) {
            Row_ R = (Row_)this.SheetRows.get(row);
            if (R != null) {
                R.$insertBefore(beforeCol, append);
            }
            ++row;
        }
    }

    public void $$deleteRow(int row) {
        if (row < 0) {
            return;
        }
        int rc = this.RPM.getRowCount();
        if (row >= rc) {
            return;
        }
        this.SheetRows.remove(row);
    }

    public void $$deleteColumn(int col) {
        if (col < 0) {
            return;
        }
        int cc = this.CPM.getColumnCount();
        if (col >= cc) {
            return;
        }
        int rc = this.RPM.getRowCount();
        int row = 0;
        while (row < rc) {
            Row_ R = (Row_)this.SheetRows.get(row);
            if (R != null) {
                R.$delete(col);
            }
            ++row;
        }
    }

    @Override
    public void insertMultiRow(int startRow, int endRow) {
        CommandScene scene = new CommandScene();
        scene.put("startrow", startRow);
        scene.put("endrow", endRow);
        CMD_InsertMultiRow cmd = new CMD_InsertMultiRow(this, scene);
        cmd.Execute();
    }

    @Override
    public void insertMultiColumn(int startCol, int endCol) {
        CommandScene scene = new CommandScene();
        scene.put("startcol", startCol);
        scene.put("endcol", endCol);
        CMD_InsertMultiColumn cmd = new CMD_InsertMultiColumn(this, scene);
        cmd.Execute();
    }

    public boolean $insertMultiRow(int startRow, int endRow) {
        int i = startRow;
        while (i <= endRow) {
            this.$$insertRowBefore(i);
            ++i;
        }
        this.RPM.$insertMultiRow(startRow, endRow);
        this.MergeCheckAfterInsert(startRow, 0, endRow, this.CPM.getColumnCount() - 1);
        this.ResetVScrollBarScrollRange();
        if (startRow <= this.freezedRow && this.freezedRow > 0) {
            this.freezedRow += Math.abs(endRow - startRow) + 1;
        }
        if (this.View != null) {
            this.View.repaint();
        }
        return true;
    }

    public boolean $insertMultiColumn(int startCol, int endCol) {
        int i = startCol;
        while (i <= endCol) {
            this.$$insertColumnBefore(i);
            ++i;
        }
        this.CPM.$insertMultiColumn(startCol, endCol);
        this.MergeCheckAfterInsert(0, startCol, this.RPM.getRowCount() - 1, endCol);
        this.ResetHScrollBarScrollRange();
        if (startCol <= this.freezedCol && this.freezedCol > 0) {
            this.freezedCol += Math.abs(endCol - startCol) + 1;
        }
        if (this.View != null) {
            this.View.repaint();
        }
        return true;
    }

    private void MergeCheckAfterInsert(int startRow, int startCol, int endRow, int endCol) {
        ArrayList al = this.getAllMergeRange();
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                int ai = 0;
                while (ai < al.size()) {
                    Range r = (Range)al.get(ai);
                    if (r.contains(row, col)) {
                        Cell cell = this.Cells(row, col);
                        this.MergeMap.put(cell, this.MergeMap.get(this.Cells(r.getStartRow(), r.getStartCol())));
                        break;
                    }
                    ++ai;
                }
                ++col;
            }
            ++row;
        }
    }

    private void MergeCheckBeforeDelete(int startRow, int startCol, int endRow, int endCol, boolean checkRow, boolean checkCol) {
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                Cell cell = this.$Cells(row, col);
                if (cell != null && cell.isMerged()) {
                    MergedRange mr = (MergedRange)this.MergeMap.get(cell);
                    this.UnMerge(mr.getMergedRange());
                }
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void deleteMultiRow(int startRow, int endRow) {
        CommandScene scene = new CommandScene();
        scene.put("startrow", startRow);
        scene.put("endrow", endRow);
        CMD_DeleteMultiRow cmd = new CMD_DeleteMultiRow(this, scene);
        cmd.Execute();
    }

    public boolean $deleteMultiRow(int startRow, int endRow) {
        this.MergeCheckBeforeDelete(startRow, 0, endRow, this.CPM.getColumnCount() - 1, true, false);
        int i = endRow;
        while (i >= startRow) {
            this.$$deleteRow(i);
            --i;
        }
        i = endRow;
        while (i >= startRow) {
            this.RPM.$deleteRow(i);
            --i;
        }
        this.ResetVScrollBarScrollRange();
        if (startRow <= this.freezedRow && this.freezedRow > 0) {
            this.freezedRow -= Math.abs(endRow - startRow) + 1;
            this.freezedRow = Math.max(0, this.freezedRow);
        }
        if (this.View != null) {
            this.View.repaint();
        }
        return true;
    }

    @Override
    public void deleteMultiColumn(int startCol, int endCol) {
        CommandScene scene = new CommandScene();
        scene.put("startcol", startCol);
        scene.put("endcol", endCol);
        CMD_DeleteMultiColumn cmd = new CMD_DeleteMultiColumn(this, scene);
        cmd.Execute();
    }

    public boolean $deleteMultiColumn(int startCol, int endCol) {
        int cc = this.getColumnCount();
        if (startCol == 0 && endCol == cc - 1) {
            return false;
        }
        Range r = this.getSelection();
        int sr = r.getStartRow();
        int er = r.getEndRow();
        int sc = endCol < cc - 1 ? startCol : startCol - 1;
        this.setSelection(new Range_(0, 0, 0, 0));
        this.MergeCheckBeforeDelete(0, startCol, this.RPM.getRowCount() - 1, endCol, false, true);
        int i = endCol;
        while (i >= startCol) {
            this.$$deleteColumn(i);
            --i;
        }
        i = endCol;
        while (i >= startCol) {
            this.CPM.$deleteColumn(i);
            --i;
        }
        this.ResetHScrollBarScrollRange();
        if (startCol <= this.freezedCol && this.freezedCol > 0) {
            this.freezedCol -= Math.abs(endCol - startCol) + 1;
            this.freezedCol = Math.max(0, this.freezedCol);
        }
        if (this.View != null) {
            this.View.repaint();
        }
        return true;
    }

    @Override
    public Row getRow(int row) {
        if (row < 0) {
            return null;
        }
        int rc = this.RPM.getRowCount();
        if (row >= rc) {
            return null;
        }
        Row_ R = (Row_)this.SheetRows.get(row);
        if (R == null) {
            R = new Row_(this, this.CPM.getColumnCount());
            this.SheetRows.set(row, R);
        }
        return R;
    }

    public void $setRow(int row, Row r) {
        if (row < 0) {
            return;
        }
        int rc = this.RPM.getRowCount();
        if (row >= rc) {
            return;
        }
        this.SheetRows.set(row, r);
    }

    public ArrayList getColumn(int col) {
        if (col < 0) {
            return null;
        }
        int cc = this.CPM.getColumnCount();
        if (col >= cc) {
            return null;
        }
        ArrayList<Cell> ret = new ArrayList<Cell>();
        int rc = this.RPM.getRowCount();
        int row = 0;
        while (row < rc) {
            ret.add(this.$Cells(row, col));
            ++row;
        }
        return ret;
    }

    public void $setColumn(int col, ArrayList cellCol) {
        if (col < 0) {
            return;
        }
        int cc = this.CPM.getColumnCount();
        if (col >= cc) {
            return;
        }
        int rc = this.RPM.getRowCount();
        int row = 0;
        while (row < rc) {
            Row_ R = (Row_)this.SheetRows.get(row);
            if (R != null) {
                R.$setCell(col, (Cell)cellCol.get(row));
            }
            ++row;
        }
    }

    public void RebuildCellsDefine(WorkSheet trigger, RedefineBecause because) {
        int rc = this.RPM.getRowCount();
        int cc = this.CPM.getColumnCount();
        int row = 0;
        while (row < rc) {
            int col = 0;
            while (col < cc) {
                Cell_ cell = (Cell_)this.$Cells(row, col);
                if (cell != null) {
                    cell.RebuildDefine(trigger, because);
                }
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void onContextMenuClicked(String menuName) {
        Point p = DrawTool.c_last;
        if (p != null) {
            boolean isPrint = false;
            int row = this.View.GetRowAtPoint(isPrint, p.y);
            int col = this.View.GetColAtPoint(isPrint, p.x, row);
            Cell cell = this.cells(row, col);
            int innerRow = -1;
            if (cell != null) {
                innerRow = ((Cell_)cell).getInnerRowAtPoint(p);
            }
            this.getWorkBook().getEM().fireOnContextMenuClicked(this, cell, innerRow, menuName);
        }
    }

    public void refreshEditStyleOfCellAtPoint() {
        Point p = DrawTool.c_last;
        if (p != null) {
            int col;
            boolean isPrint = false;
            int row = this.View.GetRowAtPoint(isPrint, p.y);
            Cell cell = this.cells(row, col = this.View.GetColAtPoint(isPrint, p.x, row));
            if (cell != null) {
                int innerRow = ((Cell_)cell).getInnerRowAtPoint(p);
                this.refreshEditStyleOfCell(this, cell, innerRow);
            }
        } else {
            Tools.log("\u590d\u5236\u6570\u636e\u5230\u526a\u8d34\u677f\u65f6DrawTool.c_last ==null ");
        }
    }

    public void refreshEditStyleOfCell(WorkSheet sheet, Cell cell, int innerRow) {
        if (cell.isMerged()) {
            cell = cell.getLeftTopCorner();
        }
        this.getWorkBook().getEM().fireRefreshEditStyleOfCell(sheet, cell, innerRow);
    }

    @Override
    public String getDataSourceNameAtCurrentMousePoint() {
        int col;
        boolean isPrint;
        int row;
        Cell cell;
        Point p = DrawTool.c_last;
        if (p != null && (cell = this.cells(row = this.View.GetRowAtPoint(isPrint = false, p.y), col = this.View.GetColAtPoint(isPrint, p.x, row))) != null) {
            DBBindConfig dbc;
            if (cell.isMerged()) {
                cell = cell.getLeftTopCorner();
            }
            if ((dbc = cell.getBind()) != null) {
                return dbc.getDataSource();
            }
        }
        return "";
    }

    @Override
    public void copy() {
        this.copyOrCut(1);
    }

    private void copyOrCut(int action) {
        ClipBoard_ cp = new ClipBoard_(this, this.Selection, action);
        this.Book.setClipBoard(cp);
        Point p = DrawTool.c_last;
        if (p != null) {
            int col;
            boolean isPrint = false;
            int row = this.View.GetRowAtPoint(isPrint, p.y);
            Cell cell = this.cells(row, col = this.View.GetColAtPoint(isPrint, p.x, row));
            if (cell != null) {
                if (cell.isMerged()) {
                    cell = cell.getLeftTopCorner();
                }
                int innerRow = ((Cell_)cell).getInnerRowAtPoint(p);
                String s = cell.getShowText(innerRow);
                Tools.log("\u590d\u5236\u6570\u636e\u5230\u526a\u8d34\u677f\uff1a" + s);
                Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection contents = new StringSelection(s);
                sysc.setContents(contents, this);
            }
        } else {
            Tools.log("\u590d\u5236\u6570\u636e\u5230\u526a\u8d34\u677f\u65f6DrawTool.c_last ==null ");
        }
    }

    @Override
    public void cut() {
        this.copyOrCut(2);
    }

    @Override
    public void paste() {
        ClipBoard cp = this.Book.getClipBoard();
        if (cp == null) {
            return;
        }
        if (cp.getWorkSheet() == null) {
            return;
        }
        Range cpr = cp.getRange();
        if (cpr.getStartRow() == this.Selection.getStartRow() && cpr.getStartCol() == this.Selection.getStartCol()) {
            return;
        }
        CommandScene scene = new CommandScene();
        scene.put("action", cp.getAction());
        scene.put("startrow", this.Selection.getStartRow());
        scene.put("startcol", this.Selection.getStartCol());
        scene.put("range", cpr);
        scene.put("source", cp.getScene());
        CMD_Paste cmd = new CMD_Paste(this, scene);
        cmd.Execute();
    }

    @Override
    public int getColumnCount() {
        return this.CPM.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.RPM.getRowCount();
    }

    @Override
    public boolean isCellNull(int row, int col) {
        return this.$Cells(row, col) == null;
    }

    @Override
    public boolean isCellNull(String cellName) {
        RowCol rc = this.cellNameToRowColumn(cellName);
        if (rc == null) {
            return true;
        }
        return this.$Cells(rc.row, rc.col) == null;
    }

    public String $setCellAlias(Cell cell, String alias, boolean replace) {
        if (cell == null) {
            return "";
        }
        if (alias != null && alias.equals("")) {
            alias = null;
        }
        if (alias == null) {
            if (this.AliasMap.containsValue(cell)) {
                this.AliasMap.remove(cell.getAlias().toLowerCase());
            }
        } else {
            Cell c;
            if (this.AliasMap.containsKey(alias = alias.toLowerCase()) && (c = (Cell)this.AliasMap.get(alias)) != cell) {
                if (replace) {
                    c.setAlias("");
                    this.AliasMap.put(alias, cell);
                    return "";
                }
                return String.valueOf(c.getName()) + "\u7684\u522b\u540d\u662f" + alias + "\uff0c\u4e0d\u80fd\u4e3a" + cell.getName() + "\u5b9a\u4e49\u76f8\u540c\u7684\u522b\u540d";
            }
            this.AliasMap.put(alias, cell);
        }
        return "";
    }

    @Override
    public Cell getCellByAlias(String alias) {
        String s = alias;
        if (s != null) {
            s = s.toLowerCase();
        }
        if (this.AliasMap.containsKey(s)) {
            return (Cell)this.AliasMap.get(s);
        }
        Cell cell = null;
        String[] t = alias.split("[.]");
        if (t.length >= 2) {
            String datasource = t[0];
            String dbcol = alias.substring(datasource.length() + 1);
            this.addExpression(alias, datasource, dbcol);
            cell = this.getExpression(alias);
        }
        return cell;
    }

    @Override
    public Cell getCellByName(String name) {
        try {
            int col = 0;
            int row = 0;
            String t = name.toUpperCase();
            RE r = new RE("([A-Z]{1,2})([0-9]+)");
            if (r.match(t)) {
                if (r.getParenStart(0) != 0 || r.getParenEnd(0) != name.length()) {
                    throw new Exception("");
                }
                if (r.getParenCount() != 3) {
                    throw new Exception("\u4e0d\u5408\u6cd5\u7684\u5355\u5143\u683c\u540d\u79f0");
                }
                String s = name.substring(r.getParenStart(1), r.getParenEnd(1)).toUpperCase().trim();
                int i = 0;
                while (i < s.length()) {
                    col = col * 26 + s.charAt(i) - 64;
                    ++i;
                }
                row = new Integer(name.substring(r.getParenStart(2), r.getParenEnd(2))) - 1;
                if (--col + 1 > this.getColumnCount()) {
                    throw new Exception("");
                }
                if (row + 1 > this.getRowCount()) {
                    throw new Exception("");
                }
                return this.cells(row, col);
            }
        }
        catch (Exception e) {
            Tools.log(e.getMessage());
        }
        return null;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public int getCurrentPrintingPage() {
        return this.currentPrintingPage;
    }

    public void setCurrentPrintingPage(int currentPrintingPage) {
        this.currentPrintingPage = currentPrintingPage;
    }

    @Override
    public int getPrintScale() {
        return this.printScale;
    }

    @Override
    public int getPrintScale(double pageWidth) {
        if (this.printScale > 0) {
            return this.printScale;
        }
        ColumnPropertyManage CPM = this.getColumnPropertyManage();
        int cc = CPM.getColumnCount();
        double totalWidth = 0.0;
        int i = 0;
        while (i < cc) {
            totalWidth += (double)CPM.getColumnWidth(i);
            ++i;
        }
        return (int)(pageWidth / totalWidth * 100.0);
    }

    @Override
    public void setPrintScale(int scale) {
        if (scale < 0) {
            return;
        }
        if (scale > 400) {
            return;
        }
        this.printScale = scale;
    }

    @Override
    public void setViewScale(int scale) {
        if (this.viewScale == scale) {
            return;
        }
        if (scale < 0) {
            return;
        }
        if (scale > 1000) {
            return;
        }
        this.viewScale = scale;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public int getViewScale() {
        return this.viewScale;
    }

    public void clearPageRange() {
        this.pageRange.clear();
    }

    public void preparePageRange(int pageWidth, int pageHeight) {
        int headerHeight = this.getPageHeader().getHeight();
        int footerHeight = this.getPageFooter().getHeight();
        pageHeight = pageHeight - headerHeight - footerHeight;
        this.clearPageRange();
        ArrayList splitColumn = new ArrayList();
        ArrayList splitRow = new ArrayList();
        this.splitRowToPrint(pageHeight, splitRow);
        this.splitColumnToPrint(pageWidth, splitColumn);
        int cn = splitColumn.size();
        int rn = splitRow.size();
        if (cn * rn == 0) {
            return;
        }
        int RC = this.getRowCount();
        int CC = this.getColumnCount();
        int m = 0;
        while (m < rn) {
            int n = 0;
            while (n < cn) {
                int row2 = m == rn - 1 ? RC : (((PageSplitInfo)splitRow.get((int)(m + 1))).offset > 0 ? ((PageSplitInfo)splitRow.get((int)(m + 1))).index : ((PageSplitInfo)splitRow.get((int)(m + 1))).index - 1);
                int col2 = n == cn - 1 ? CC : (((PageSplitInfo)splitColumn.get((int)(n + 1))).offset > 0 ? ((PageSplitInfo)splitColumn.get((int)(n + 1))).index : ((PageSplitInfo)splitColumn.get((int)(n + 1))).index - 1);
                PrintRange_ range = new PrintRange_((PageSplitInfo)splitRow.get(m), (PageSplitInfo)splitColumn.get(n), row2, col2);
                this.pageRange.add(range);
                ++n;
            }
            ++m;
        }
        splitRow.clear();
        splitColumn.clear();
    }

    void splitColumnToPrint(int pageWidth, ArrayList pArray) {
        int FCW;
        if (this.getRowCount() * this.getColumnCount() == 0) {
            return;
        }
        int validWidth = pageWidth;
        ColumnPropertyManage CPM = this.getColumnPropertyManage();
        int FixedColumnCount = CPM.getFixedColumnCount();
        int ColumnCount = CPM.getColumnCount();
        pArray.add(new PageSplitInfo(0, 0, 0));
        int widthSum = FCW = CPM.getFixedColumnWidth();
        boolean isFirstPrintColumn = true;
        int col = FixedColumnCount;
        while (col < ColumnCount) {
            int w = CPM.getColumnWidth(col);
            if ((widthSum += w) > validWidth) {
                int subOffset;
                int th;
                PageSplitInfo begin = (PageSplitInfo)pArray.get(pArray.size() - 1);
                if (col != begin.index) {
                    begin.blank = w - (widthSum - validWidth);
                    begin = new PageSplitInfo(col, 0, 0);
                    pArray.add(begin);
                }
                while ((th = validWidth - FCW) + (subOffset = begin.offset) < w) {
                    begin = new PageSplitInfo(col, th + subOffset, 0);
                    pArray.add(begin);
                }
                widthSum = FCW + (w - subOffset);
            }
            ++col;
        }
    }

    void splitRowToPrint(int pageHeight, ArrayList pArray) {
        int FRH;
        if (this.getColumnCount() * this.getRowCount() == 0) {
            return;
        }
        RowPropertyManage RPM = this.getRowPropertyManage();
        int FixedRowCount = RPM.getFixedRowCount();
        int RowCount = RPM.getRowCount();
        pArray.add(new PageSplitInfo(0, 0, 0));
        int HeightSum = FRH = RPM.getFixedRowHeight();
        boolean isFirstPrintRow = true;
        int row = FixedRowCount;
        while (row < RowCount) {
            int h = RPM.getRowHeight(row);
            int maxDBRowCount = RPM.getMaxDBRowCount(row);
            if ((HeightSum += h) > pageHeight || maxDBRowCount > 1) {
                PageSplitInfo begin = (PageSplitInfo)pArray.get(pArray.size() - 1);
                if (maxDBRowCount <= 1 && HeightSum > pageHeight) {
                    int subOffset;
                    int th;
                    if (row != begin.index) {
                        begin.blank = h - (HeightSum - pageHeight);
                        begin = new PageSplitInfo(row, 0, 0);
                        pArray.add(begin);
                    }
                    while ((th = pageHeight - FRH) + (subOffset = begin.offset) < h) {
                        begin = new PageSplitInfo(row, th + subOffset, 0);
                        pArray.add(begin);
                    }
                    HeightSum = FRH + (h - subOffset);
                } else {
                    int dbh = RPM.getDBRowHeight(row);
                    int gh = RPM.getGroupRowHeight(row);
                    HeightSum -= h;
                    DataStore ds = RPM.getMaximalDataSourceConfig(row).getDataStore();
                    int rc = ds.getRowCount();
                    ArrayList<Integer> heightList = new ArrayList<Integer>();
                    Hashtable MapGroups = (Hashtable)ds.getFriendlyProperty("m_MapGroups");
                    ArrayList<Integer> groupRowPoint = new ArrayList<Integer>();
                    int di = 0;
                    while (di < rc) {
                        heightList.add(new Integer(dbh));
                        Integer key = new Integer(di);
                        if (MapGroups.containsKey(key)) {
                            ArrayList pVec = (ArrayList)MapGroups.get(key);
                            int gc = pVec.size();
                            int gi = 0;
                            while (gi < gc) {
                                heightList.add(new Integer(gh));
                                ++gi;
                            }
                            if (this.oneGroupPrintOnOnePageMap != null) {
                                for (int groupLevel : this.oneGroupPrintOnOnePageMap.keySet()) {
                                    if (!this.oneGroupPrintOnOnePageMap.get(groupLevel).booleanValue() || !((ArrayList)MapGroups.get(key)).contains(groupLevel)) continue;
                                    groupRowPoint.add(heightList.size());
                                    break;
                                }
                            }
                        }
                        ++di;
                    }
                    int listCount = heightList.size();
                    int offset = 0;
                    int k = 0;
                    while (k < listCount) {
                        int dbr = (Integer)heightList.get(k);
                        if ((HeightSum += dbr) > pageHeight || groupRowPoint.contains(k)) {
                            begin.blank = dbr - (HeightSum - pageHeight);
                            begin = new PageSplitInfo(row, offset, 0);
                            pArray.add(begin);
                            HeightSum = FRH + dbr;
                        }
                        offset += dbr;
                        ++k;
                    }
                }
            }
            ++row;
        }
    }

    public ArrayList getPageRange() {
        return this.pageRange;
    }

    @Override
    public String getPageConfig() {
        return this.pageConfig;
    }

    @Override
    public void setPageConfig(String pageConfig) {
        this.pageConfig = pageConfig;
    }

    @Override
    public String getPrintServiceName() {
        return this.printServiceName;
    }

    @Override
    public void setPrintServiceName(String printServiceName) {
        this.printServiceName = printServiceName;
    }

    @Override
    public ArrayList parseDependList(String expression) {
        ArrayList ret = new ArrayList();
        if (expression == null) {
            return ret;
        }
        if (expression.startsWith("=")) {
            expression = expression.substring(1, expression.length());
        }
        JEP Jep = null;
        try {
            Jep = ((WorkBook_)this.getWorkBook()).getIdleJEPInstance();
            Jep.attachWorkSheet(this);
            Jep.attachCell(null);
            Jep.parseExpression(expression);
            SimpleNode node = (SimpleNode)Jep.getTopNode();
            if (node == null) {
                Tools.log("\u516c\u5f0f\u9519\u8bef\uff1a" + Jep.getErrorInfo());
                ArrayList arrayList = ret;
                return arrayList;
            }
            try {
                ret = WorkSheet_.parseDepend(node, this, ret);
            }
            catch (Exception e) {
                Tools.log(" Cell_.ParseDependAffect \u53d1\u751f\u9519\u8bef:" + expression + "   " + e.getMessage());
            }
        }
        finally {
            ((WorkBook_)this.getWorkBook()).releaseJEPInstance(Jep);
        }
        return ret;
    }

    public static ArrayList parseDepend(SimpleNode node, WorkSheet_ Sheet, ArrayList DependList) {
        Range range = null;
        String SheetGuid = null;
        String SheetName = null;
        Depend da = null;
        RowCol rc = null;
        ASTVarNode var = null;
        if (node instanceof ASTVarNode) {
            var = (ASTVarNode)node;
            String varName = var.getName();
            switch (var.getToken().kind) {
                case 10: 
                case 11: {
                    rc = Sheet.cellNameToRowColumn(varName);
                    range = new Range_(rc.row, rc.col, rc.row, rc.col);
                    break;
                }
                case 12: {
                    range = Sheet.rangeNameToRange(varName);
                    break;
                }
                case 13: {
                    int p = varName.indexOf("!");
                    if (p <= 0) break;
                    SheetName = varName.substring(0, p).trim();
                    WorkSheet_ otherSheet = (WorkSheet_)Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (otherSheet == null) {
                        Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                        break;
                    }
                    rc = otherSheet.cellNameToRowColumn(varName.substring(p + 1, varName.length()));
                    range = new Range_(rc.row, rc.col, rc.row, rc.col);
                    break;
                }
                case 15: {
                    int p = varName.indexOf("!");
                    if (p <= 0) break;
                    SheetName = varName.substring(0, p).trim();
                    WorkSheet_ otherSheet = (WorkSheet_)Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (otherSheet == null) {
                        Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                        break;
                    }
                    rc = otherSheet.cellNameToRowColumn(varName.substring(p + 1, varName.length()));
                    range = new Range_(rc.row, rc.col, rc.row, rc.col);
                    break;
                }
                case 14: {
                    int p = varName.indexOf("!");
                    if (p <= 0) break;
                    SheetName = varName.substring(0, p).trim();
                    WorkSheet_ otherSheet = (WorkSheet_)Sheet.getWorkBook().getWorkSheet(SheetName);
                    if (otherSheet == null) {
                        Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                        break;
                    }
                    range = otherSheet.rangeNameToRange(varName.substring(p + 1, varName.length()));
                }
            }
        }
        if (range != null) {
            SheetGuid = Sheet.getGUID();
            if (SheetName != null) {
                WorkSheet sheet = Sheet.getWorkBook().getWorkSheet(SheetName);
                if (sheet == null) {
                    Sheet.getWorkBook().getEM().fireError("\u6307\u5b9a\u7684\u5de5\u4f5c\u8868[" + SheetName + "]\u4e0d\u5b58\u5728");
                } else {
                    SheetGuid = sheet.getGUID();
                }
            }
            MergedRange_ mr = new MergedRange_(Sheet.getWorkBook().getWorkSheetByGuid(SheetGuid), range);
            da = new Depend(SheetGuid, mr, var);
            if (DependList == null) {
                DependList = new ArrayList<Depend>();
            }
            DependList.add(da);
        }
        int cc = node.jjtGetNumChildren();
        int i = 0;
        while (i < cc) {
            SimpleNode child = (SimpleNode)node.jjtGetChild(i);
            DependList = WorkSheet_.parseDepend(child, Sheet, DependList);
            ++i;
        }
        return DependList;
    }

    @Override
    public Object evaluate(String formula) {
        return this.evaluate(formula, -99);
    }

    @Override
    public Object evaluate(String formula, boolean returnException, Object defaultValue) {
        return this.evaluate(formula, -99, returnException, defaultValue);
    }

    @Override
    public Object evaluate(String formula, int innerRow) {
        return this.evaluate(formula, innerRow, true, null);
    }

    @Override
    public Object evaluate(String formula, int innerRow, boolean returnException, Object defaultValue) {
        Object ret = null;
        if (formula == null) {
            return null;
        }
        if ((formula = formula.trim()).startsWith("=")) {
            formula = formula.substring(1).trim();
        }
        JEP Jep = null;
        try {
            Jep = ((WorkBook_)this.getWorkBook()).getIdleJEPInstance();
            Jep.setCellInnerRow(innerRow);
            Jep.attachWorkSheet(this);
            Jep.parseExpression(formula);
            ret = Jep.hasError() ? (returnException ? Jep.getErrorInfo() : defaultValue) : Jep.getValueAsObject();
            if (ret == null && returnException) {
                ret = defaultValue;
            }
            Object object = ret;
            return object;
        }
        catch (Exception e) {
            String errorInfo = e.getMessage();
            if (returnException) {
                System.out.println("\u516c\u5f0f" + formula + "\u89e3\u6790\u5f02\u5e38\u3002\u539f\u56e0\u662f" + e.getMessage());
                String string = errorInfo;
                return string;
            }
            Object object = defaultValue;
            return object;
        }
        finally {
            ((WorkBook_)this.getWorkBook()).releaseJEPInstance(Jep);
        }
    }

    @Override
    public boolean isVisible() {
        return this.Visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.Visible == visible) {
            return;
        }
        this.Visible = visible;
        WorkBookView_ view = (WorkBookView_)this.Book.getWorkBookView();
        if (view != null) {
            view.getWorkSheetTabContainer().Layout();
        }
        if (!visible && this.Book.getActiveSheet().getIndex() == this.getIndex()) {
            int i = 0;
            while (i < this.Book.getWorkSheetCount()) {
                if (i != this.getIndex() && this.Book.getWorkSheet(i).isVisible()) {
                    this.Book.setActiveSheet(i);
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean isTabHighLight() {
        return this.tabHightLight;
    }

    @Override
    public void setTabHighLight(boolean b) {
        if (this.tabHightLight == b) {
            return;
        }
        this.tabHightLight = b;
        WorkBookView_ view = (WorkBookView_)this.Book.getWorkBookView();
        if (view != null) {
            view.getWorkSheetTabContainer().Layout();
        }
    }

    @Override
    public Cell addExpression(String name, String expression) {
        if (this.ExpressionMap == null) {
            this.ExpressionMap = new HashMap();
        }
        if (this.ExpressionList == null) {
            this.ExpressionList = new ArrayList();
        }
        name = name.toLowerCase();
        Cell cell = null;
        if (this.ExpressionMap.containsKey(name)) {
            cell = this.ExpressionMap.get(name);
        } else {
            cell = new Cell_(this, null);
            this.ExpressionMap.put(name, cell);
            this.ExpressionList.add(cell);
        }
        cell.setValue(expression);
        return cell;
    }

    @Override
    public Cell addExpression(String name, String datasource, String dbcol) {
        if (this.ExpressionMap == null) {
            this.ExpressionMap = new HashMap();
        }
        if (this.ExpressionList == null) {
            this.ExpressionList = new ArrayList();
        }
        name = name.toLowerCase();
        Cell cell = null;
        if (this.ExpressionMap.containsKey(name)) {
            cell = this.ExpressionMap.get(name);
        } else {
            cell = new Cell_(this, null);
            this.ExpressionMap.put(name, cell);
            this.ExpressionList.add(cell);
            cell.setBind(datasource, dbcol);
        }
        return cell;
    }

    @Override
    public boolean removeExpression(String name) {
        if (this.ExpressionMap == null) {
            return false;
        }
        name = name.toLowerCase();
        Object cell = null;
        if (this.ExpressionMap.containsKey(name)) {
            this.ExpressionMap.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public Cell getExpression(String name) {
        if (this.ExpressionMap == null) {
            return null;
        }
        name = name.toLowerCase();
        Cell cell = null;
        if (this.ExpressionMap.containsKey(name)) {
            cell = this.ExpressionMap.get(name);
        }
        return cell;
    }

    @Override
    public boolean isFormulaBackFillBindEnabled() {
        return this.isFormulaBackFillBindEnabled;
    }

    @Override
    public void setFormulaBackFillBindEnabled(boolean auto) {
        this.isFormulaBackFillBindEnabled = auto;
    }

    @Override
    public void reCalculateAllFormula() {
        int RC = this.getRowCount();
        int CC = this.getColumnCount();
        int row = 0;
        while (row < RC) {
            int col = 0;
            while (col < CC) {
                Cell cell = this.$Cells(row, col);
                if (cell != null) {
                    ((Cell_)cell).setInvalid();
                }
                ++col;
            }
            ++row;
        }
    }

    @Override
    public void clearFocusRange() {
        this.focusRange.clear();
        this.currentFocusRangeIndex = 0;
    }

    @Override
    public void addFocusRange(int startRow, int startCol, int endRow, int endCol) {
        Range_ r = new Range_(startRow, startCol, endRow, endCol);
        this.focusRange.add(r);
    }

    @Override
    public boolean removeFocusRange(int startRow, int startCol, int endRow, int endCol) {
        int i = 0;
        while (i < this.focusRange.size()) {
            Range_ r = (Range_)this.focusRange.get(i);
            if (r.StartRow == startRow && r.StartCol == startCol && r.EndRow == endRow && r.EndCol == endCol) {
                this.focusRange.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setFocusRangeNo(int startRow, int startCol, int endRow, int endCol, int no) {
        if (no < 0) {
            return;
        }
        if (no >= this.focusRange.size()) {
            return;
        }
        int i = 0;
        while (i < this.focusRange.size()) {
            Range_ r = (Range_)this.focusRange.get(i);
            if (r.StartRow == startRow && r.StartCol == startCol && r.EndRow == endRow && r.EndCol == endCol) {
                this.focusRange.remove(i);
                this.focusRange.add(no, r);
            }
            ++i;
        }
    }

    @Override
    public ArrayList<Range> getFocusRangeList() {
        return this.focusRange;
    }

    @Override
    public Range getCurrentFocusRange() {
        int n = this.focusRange.size();
        if (n == 0) {
            return new Range_(0, 0, this.getRowCount() - 1, this.getColumnCount() - 1);
        }
        if (this.currentFocusRangeIndex < 0 || this.currentFocusRangeIndex >= n) {
            this.currentFocusRangeIndex = 0;
        }
        return this.focusRange.get(this.currentFocusRangeIndex);
    }

    @Override
    public void moveToNextFocusRange() {
        ++this.currentFocusRangeIndex;
        if (this.currentFocusRangeIndex == this.focusRange.size()) {
            this.currentFocusRangeIndex = 0;
        }
    }

    @Override
    public void moveToPriorFocusRange() {
        --this.currentFocusRangeIndex;
        if (this.currentFocusRangeIndex < 0) {
            this.currentFocusRangeIndex = this.focusRange.size() - 1;
        }
    }

    @Override
    public void moveToFocusRange(int row, int col) {
        int n = this.focusRange.size();
        if (n == 0) {
            return;
        }
        int i = 0;
        while (i < n) {
            Range_ r = (Range_)this.focusRange.get(i);
            if (r.contains(row, col)) {
                this.currentFocusRangeIndex = i;
                return;
            }
            ++i;
        }
    }

    @Override
    public boolean isInLastFocusRange() {
        int n = this.focusRange.size();
        if (n == 0) {
            return true;
        }
        return this.currentFocusRangeIndex == n - 1;
    }

    @Override
    public boolean isInFirstFocusRange() {
        int n = this.focusRange.size();
        if (n == 0) {
            return true;
        }
        return this.currentFocusRangeIndex == 0;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public void removeBackgroundImage(String id) {
        for (Integer lay : this.backgroundImageMap.keySet()) {
            HashMap<String, BackGroundImageConfig> map = this.backgroundImageMap.get(lay);
            if (!map.containsKey(id)) continue;
            map.remove(id);
        }
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public String addBackGroundImage(String id, String url, String startCell, String endCell, String x_position, String y_position, String x_repeat, String y_repeat, int layer, boolean needPrint) {
        HashMap<Object, Object> map;
        Integer lay = new Integer(layer);
        if (this.backgroundImageMap.containsKey(lay)) {
            map = this.backgroundImageMap.get(lay);
        } else {
            map = new HashMap();
            this.backgroundImageMap.put(lay, map);
        }
        if (map.containsKey(id)) {
            return String.valueOf(id) + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u53d6\u4e2a\u540d\u79f0";
        }
        BackGroundImageConfig config = new BackGroundImageConfig();
        config.id = id;
        config.url = url;
        config.x_position = x_position;
        config.y_position = y_position;
        config.x_repeat = x_repeat;
        config.y_repeat = y_repeat;
        config.startCell = startCell;
        config.endCell = endCell;
        config.needPrint = needPrint;
        map.put(id, config);
        if (this.View != null) {
            this.View.repaint();
        }
        return "";
    }

    @Override
    public Brick getBrick(String name) {
        int RC = this.getRowCount();
        int CC = this.getColumnCount();
        Brick brick = null;
        int row = 0;
        while (row < RC) {
            int col = 0;
            while (col < CC) {
                Cell cell = this.$Cells(row, col);
                if (cell != null && (brick = cell.getBrick(name)) != null) {
                    return brick;
                }
                ++col;
            }
            ++row;
        }
        return null;
    }

    @Override
    public void addContextMenu(String name, String caption) {
        this.addContextMenu(name, caption, "");
    }

    ContextMenuConfig findContextMenu(LinkedHashMap map, String name) {
        if (map == null) {
            return null;
        }
        if (map.containsKey(name)) {
            return (ContextMenuConfig)map.get(name);
        }
        for (String s : map.keySet()) {
            ContextMenuConfig cmc = (ContextMenuConfig)map.get(s);
            ContextMenuConfig ret = this.findContextMenu(cmc.subMenu, name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public void addContextMenu(String name, String caption, String parentMenuName) {
        if (this.contextMenuMap == null) {
            this.contextMenuMap = new LinkedHashMap();
        }
        if (this.findContextMenu(this.contextMenuMap, name) != null) {
            System.out.println(String.valueOf(name) + "\u83dc\u5355\u5df2\u7ecf\u5b58\u5728 ");
            return;
        }
        LinkedHashMap parentMap = null;
        ContextMenuConfig pmc = null;
        if (parentMenuName.equals("")) {
            parentMap = this.contextMenuMap;
            pmc = null;
        } else {
            pmc = this.findContextMenu(this.contextMenuMap, parentMenuName);
            if (pmc == null) {
                System.out.println(String.valueOf(parentMenuName) + "\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6dfb\u52a0\u5b50\u83dc\u5355 ");
                return;
            }
            if (pmc.subMenu == null) {
                pmc.subMenu = new LinkedHashMap();
            }
            parentMap = pmc.subMenu;
        }
        ContextMenuConfig cmc = new ContextMenuConfig();
        cmc.name = name;
        cmc.caption = caption;
        cmc.enabled = true;
        cmc.parentMenu = pmc;
        parentMap.put(name, cmc);
    }

    @Override
    public void removeContextMenu(String name) {
        ContextMenuConfig pmc = this.findContextMenu(this.contextMenuMap, name);
        if (pmc == null) {
            return;
        }
        pmc.parentMenu.subMenu.remove(name);
        pmc.parentMenu = null;
        pmc.subMenu = null;
    }

    @Override
    public void setContextMenuEnabled(String name, boolean enabled) {
        ContextMenuConfig cmc = this.findContextMenu(this.contextMenuMap, name);
        cmc.enabled = enabled;
    }

    @Override
    public boolean isContextMenuEnabled(String name) {
        ContextMenuConfig cmc = this.findContextMenu(this.contextMenuMap, name);
        if (cmc == null) {
            return false;
        }
        return cmc.enabled;
    }

    @Override
    public void setTipInfo(String info) {
        this.tipInfo = info;
        if (this.tipInfo.equals("")) {
            this.tipInfo = null;
        }
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public String getTipInfo() {
        return this.tipInfo;
    }

    @Override
    public void setPrintable(boolean b) {
        this.isPrintable = b;
    }

    @Override
    public boolean isPrintable() {
        return this.isPrintable;
    }

    @Override
    public void setRebuildCellDefineAfterInsertOrDeleteRow(boolean b) {
        this.rebuildCellDefineAfterInsertOrDeleteRow = b;
    }

    @Override
    public boolean isRebuildCellDefineAfterInsertOrDeleteRow() {
        return this.rebuildCellDefineAfterInsertOrDeleteRow;
    }

    @Override
    public Cell getPageHeader() {
        String name = "zexcel_worksheet_pageheader";
        Cell ret = this.getExpression(name);
        if (ret == null) {
            this.addExpression(name, "");
            ret = this.getExpression(name);
        }
        return ret;
    }

    @Override
    public Cell getPageFooter() {
        String name = "zexcel_worksheet_pagefooter";
        Cell ret = this.getExpression(name);
        if (ret == null) {
            this.addExpression(name, "");
            ret = this.getExpression(name);
        }
        return ret;
    }

    @Override
    public void setFloatToTop(int startRow, int endRow) {
        this.floatToTopStartRow = startRow;
        this.floatToTopEndRow = endRow;
    }

    @Override
    public int getFloatToTopStartRow() {
        return this.floatToTopStartRow;
    }

    @Override
    public int getFloatToTopEndRow() {
        return this.floatToTopEndRow;
    }

    @Override
    public void insertWorkSheetToCell(WorkSheet which, Cell toWhere) {
        CellPanel_ cp = new CellPanel_(which, toWhere, false, false);
        this.cellPanelList.add(cp);
    }

    @Override
    public void insertWorkSheetToCell(WorkSheet which, Cell toWhere, boolean appendRight, boolean appendBottom) {
        CellPanel_ cp = new CellPanel_(which, toWhere, appendRight, appendBottom);
        this.cellPanelList.add(cp);
    }

    public void resetInnerCellPanelSize() {
        int i = 0;
        while (i < this.cellPanelList.size()) {
            this.cellPanelList.get(i).reCalcuSize();
            ++i;
        }
    }

    @Override
    public CellPanel getContainerCellPanel() {
        return this.containerCellPanel;
    }

    @Override
    public void setContainerCellPanel(CellPanel containerCellPanel) {
        this.containerCellPanel = (CellPanel_)containerCellPanel;
    }

    @Override
    public void popup(String caption, int width, int height, boolean modal, int x, int y, int borderThick, Color borderColor) {
        this.popup(caption, width, height, modal, x, y, borderThick, borderColor, true, true);
    }

    @Override
    public void popup(String caption, int width, int height, boolean modal, int x, int y, int borderThick, Color borderColor, boolean showTitleBar, boolean showButtonBar) {
        if (this.popupContainer != null) {
            return;
        }
        this.setVisible(false);
        this.popupContainer = new PopupContainer(this, caption, borderThick, borderColor, width, height, modal, x, y, showTitleBar, showButtonBar);
        this.popupContainer.setVisible(true);
    }

    @Override
    public void popupDispose() {
        if (this.popupContainer != null) {
            this.popupContainer.getContentPane().removeAll();
            this.popupContainer.dispose();
            this.popupContainer = null;
        }
    }

    @Override
    public void showOnDockPanel(String where, int width, int height) {
        if (this.dockContainerPanel != null) {
            return;
        }
        this.dockContainerPanel = new JPanel();
        this.setVisible(false);
        this.dockContainerPanel.setPreferredSize(new Dimension(width, height));
        this.dockContainerPanel.setLayout(new BorderLayout());
        CellPanel_ cp = new CellPanel_((WorkSheet)this, this.dockContainerPanel, false, false);
        Container cc = this.Book.getWorkBookView().getParent();
        ((BorderLayout)cc.getLayout()).setHgap(1);
        ((BorderLayout)cc.getLayout()).setVgap(1);
        cc.setBackground(Color.LIGHT_GRAY);
        cc.add((Component)this.dockContainerPanel, where);
        cc.getParent().doLayout();
        cp.componentResized(null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((WorkBookView_)WorkSheet_.this.getWorkBook().getWorkBookView()).componentResized(null);
            }
        });
    }

    @Override
    public void setDockPanelPreferredSize(int width, int height) {
        if (this.dockContainerPanel == null) {
            return;
        }
        this.dockContainerPanel.setPreferredSize(new Dimension(width, height));
        Container cc = this.Book.getWorkBookView().getParent();
        cc.doLayout();
        cc.getParent().doLayout();
    }

    public boolean isShowInDockPanel() {
        return this.dockContainerPanel != null;
    }

    @Override
    public int getDockPanelPreferredWidth() {
        if (this.dockContainerPanel == null) {
            return 0;
        }
        return this.dockContainerPanel.getPreferredSize().width;
    }

    @Override
    public int getDockPanelPreferredHeight() {
        if (this.dockContainerPanel == null) {
            return 0;
        }
        return this.dockContainerPanel.getPreferredSize().height;
    }

    @Override
    public boolean isOneGroupPrintOnOnePage(int groupLevel) {
        if (this.oneGroupPrintOnOnePageMap == null) {
            return false;
        }
        if (this.oneGroupPrintOnOnePageMap.containsKey(groupLevel)) {
            return this.oneGroupPrintOnOnePageMap.get(groupLevel);
        }
        return false;
    }

    @Override
    public void setOneGroupPrintOnOnePage(int groupLevel, boolean b) {
        if (this.oneGroupPrintOnOnePageMap == null) {
            this.oneGroupPrintOnOnePageMap = new HashMap();
        }
        this.oneGroupPrintOnOnePageMap.put(groupLevel, b);
    }

    @Override
    public void setBalloonVisible(boolean v) {
        if (this.BalloonVisible == v) {
            return;
        }
        this.BalloonVisible = v;
        if (this.View != null) {
            this.View.repaint();
        }
    }

    @Override
    public boolean isBalloonVisible() {
        return this.BalloonVisible;
    }

    @Override
    public void balloonTipEdit(String dsname, String dbcol, int innerRow) {
        if (!this.getEM().fireIsBalloonTipEditPermit(dsname, dbcol, innerRow)) {
            return;
        }
        final DataStore ds = this.Book.getDataSource(dsname).getDataStore();
        final JDialog f = new JDialog(JOptionPane.getFrameForComponent(this.View), "\u6279\u6ce8", true);
        f.setDefaultCloseOperation(2);
        final Point origin = new Point();
        f.setUndecorated(true);
        JPanel outBorder = new JPanel();
        outBorder.setBorder(BorderFactory.createLineBorder(new Color(13481215), 3));
        outBorder.setLayout(new BorderLayout());
        f.getContentPane().add((Component)outBorder, "Center");
        JPanel cc = new JPanel();
        cc.setBorder(BorderFactory.createLineBorder(new Color(10317055), 1));
        cc.setLayout(new BorderLayout());
        outBorder.add((Component)cc, "Center");
        JPanel titleBar = new JPanel();
        titleBar.setLayout(new BorderLayout());
        JLabel title = new JLabel();
        title.setPreferredSize(new Dimension(2000, 20));
        title.setOpaque(true);
        title.setBackground(new Color(13481215));
        title.setForeground(Color.black);
        title.setCursor(new Cursor(13));
        title.setText(" \u6279\u6ce8");
        title.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                Point p = f.getLocation();
                f.setLocation(p.x + e.getX() - origin.x, p.y + e.getY() - origin.y);
            }
        });
        title.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                origin.x = e.getX();
                origin.y = e.getY();
            }
        });
        JLabel jb_exit2 = new JLabel();
        jb_exit2.setIcon(new ImageIcon(Tools.GetImageFromURL(this.View, "excel/res/cancel2.gif")));
        jb_exit2.setOpaque(true);
        jb_exit2.setBackground(new Color(13481215));
        jb_exit2.setBorder(null);
        jb_exit2.setPreferredSize(new Dimension(16, 16));
        jb_exit2.setCursor(new Cursor(12));
        jb_exit2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                f.dispose();
            }
        });
        titleBar.add((Component)title, "Center");
        titleBar.add((Component)jb_exit2, "East");
        cc.add((Component)titleBar, "North");
        final HTMLDocumentEditor editor = new HTMLDocumentEditor();
        cc.add((Component)editor, "Center");
        String s = ds.getBalloonTip(innerRow, dbcol, "comment");
        editor.setText(s);
        f.setBounds(0, 0, 500, 300);
        Tools.MoveToScreenCenter(f);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        JButton jb_ok = new JButton("\u786e\u5b9a");
        jb_ok.setPreferredSize(new Dimension(80, 28));
        final String $dsname = dsname;
        final String $dbcol = dbcol;
        final int $innerRow = innerRow;
        jb_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String v = editor.getText();
                if (Tools.HTML2Text(v).toString().trim().equals("")) {
                    ds.setBalloonTip($innerRow, $dbcol, "comment", "");
                } else {
                    ds.setBalloonTip($innerRow, $dbcol, "comment", v);
                }
                ArrayList cellList = WorkSheet_.this.Book.getDataSource($dsname).getAllCellsWhichBindTheCol($dbcol);
                f.dispose();
                int i = 0;
                while (i < cellList.size()) {
                    Cell_ cell = (Cell_)cellList.get(i);
                    cell.destroyBalloonTipControl($innerRow);
                    cell.repaint();
                    ++i;
                }
            }
        });
        JButton jb_exit = new JButton("\u53d6\u6d88");
        jb_exit.setPreferredSize(new Dimension(80, 28));
        jb_exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        p.add(jb_ok);
        p.add(jb_exit);
        cc.add((Component)p, "South");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                f.setVisible(true);
            }
        });
        this.setBalloonVisible(true);
    }

    public static LinkedHashMap menuConfig2HashMap(JSONArray ja) {
        LinkedHashMap<String, ContextMenuConfig> map = new LinkedHashMap<String, ContextMenuConfig>();
        int i = 0;
        while (i < ja.length()) {
            String name = ja.getJSONObject(i).getString("name", "");
            String caption = ja.getJSONObject(i).getString("caption", "");
            JSONArray subMenu = ja.getJSONObject(i).getJSONArray("submenu", null);
            ContextMenuConfig cmc = new ContextMenuConfig();
            cmc.name = name;
            cmc.caption = caption;
            cmc.enabled = true;
            if (subMenu != null) {
                cmc.subMenu = WorkSheet_.menuConfig2HashMap(subMenu);
            }
            map.put(name, cmc);
            ++i;
        }
        return map;
    }

    @Override
    public void showPopupMenu(String menuConfig) {
        JPopupMenu popupMenu = new JPopupMenu("popup");
        Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
        popupMenu.setBorder(border);
        JSONArray ja = new JSONArray(menuConfig);
        LinkedHashMap map = WorkSheet_.menuConfig2HashMap(ja);
        Tools.addContextMenu(this, popupMenu, map, 0);
        Point p = DrawTool.c_last;
        popupMenu.setFocusable(false);
        popupMenu.show(this.View, p.x, p.y);
    }

    @Override
    public boolean save2Image(String imgFile) {
        if (this.View == null) {
            return false;
        }
        return this.View.save2Image(imgFile);
    }

    @Override
    public boolean isEditing() {
        if (this.View == null) {
            return false;
        }
        return this.View.$getCurrentEditingEdit() != null;
    }
}

