/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Cell;
import excel.core.CellDecorate;
import excel.core.WorkSheetView;
import excel.util.Tools;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public class DecorateStar
implements CellDecorate {
    int padding_V = 0;
    int padding_H = 0;
    int align = 0;

    public DecorateStar(int align, int ph, int pv) {
        this.align = align;
        this.padding_H = ph;
        this.padding_V = pv;
    }

    public void paint(Graphics2D g, Cell cell, Rectangle cellRect) {
        WorkSheetView view = cell.getWorkSheet().getWorkSheetView();
        Image img = Tools.GetImageFromURL(view, "excel/res/star2.png");
        int imgH = img.getHeight(view);
        int imgW = img.getWidth(view);
        int x = 0;
        int y = 0;
        if (this.align == 0) {
            x = cellRect.x + 1;
            y = cellRect.y + (cellRect.height - imgH) / 2 + 1;
        }
        if (this.align == 1) {
            x = cellRect.x + cellRect.width - imgW - 1;
            y = cellRect.y + (cellRect.height - imgH) / 2 + 1;
        }
        g.drawImage(img, x, y, view);
    }

    public int getHPadding() {
        return this.padding_H;
    }

    public int getVPadding() {
        return this.padding_V;
    }
}

