/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Cell;
import excel.core.CellDecorate;
import excel.core.Property;
import excel.core.WorkSheetView;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public class DecorateDDLB
implements CellDecorate {
    int padding_V = 0;
    int padding_H = 0;
    String theme = "normal";

    public DecorateDDLB(int ph, int pv, String theme) {
        this.padding_V = pv;
        this.padding_H = ph;
        this.theme = theme;
    }

    public void paint(Graphics2D g, Cell cell, Rectangle cellBounds) {
        if (!cell.isEditable()) {
            return;
        }
        Property prop = cell.getProperty();
        Rectangle cellRect = (Rectangle)cellBounds.clone();
        cellRect.y += this.padding_V + prop.get("padding-top", 1);
        cellRect.height -= this.padding_V * 2 - prop.get("padding-top", 1) - prop.get("padding-bottom", 1);
        cellRect.x += this.padding_H + prop.get("padding-left", 1);
        cellRect.width -= this.padding_H * 2 + prop.get("padding-left", 1) + prop.get("padding-right", 1);
        Shape oc = g.getClip();
        Object clip = null;
        String style = "";
        style = "ddlb";
        WorkSheetView view = cell.getWorkSheet().getWorkSheetView();
        this.drawRightMiddle(view, g, cell, cellRect, style);
        Tools.setClip(g, oc);
    }

    private void drawRightMiddle(WorkSheetView view, Graphics2D g, Cell cell, Rectangle cellRect, String style) {
        Rectangle clip = (Rectangle)cellRect.clone();
        ++clip.y;
        clip.x = cellRect.x + cellRect.width / 2;
        clip.width = clip.width / 2 + 1;
        --clip.height;
        Tools.clip(g, clip, false);
        Image img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rmt.png");
        int imgH = img.getHeight(view);
        int imgW = img.getWidth(view);
        int x = cellRect.x + cellRect.width - imgW + 1;
        int y = clip.y;
        while (y < clip.y + clip.height / 2) {
            g.drawImage(img, x, y, view);
            y += imgH;
        }
        img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rmb.png");
        while (y < clip.y + clip.height) {
            g.drawImage(img, x, y, view);
            y += imgH;
        }
        img = Tools.GetImageFromURL(view, "excel/res/decorate/" + this.theme + "/" + style + "/" + style + "_rmm.png");
        imgH = img.getHeight(view);
        y = cellRect.y + 4 + (cellRect.height - 4 - 4 - imgH) / 2;
        g.drawImage(img, x, y, view);
        g.setColor(new Color(15988215));
        g.drawLine(x, cellRect.y, x, cellRect.y + cellRect.height);
        Color splitLineColor = cell.getSplitLineColor();
        g.setColor(splitLineColor);
        g.drawLine(x - 1, cellRect.y, x - 1, cellRect.y + cellRect.height);
    }

    public int getHPadding() {
        return this.padding_H;
    }

    public int getVPadding() {
        return this.padding_V;
    }
}

