/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.RowProperty;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import java.util.ArrayList;

public final class ColumnPropertyManage_
implements ColumnPropertyManage {
    private ArrayList widthList;
    private boolean showColumnIndex = false;
    private int ColumnHeadHeight = 19;
    private WorkSheet Sheet;

    public ColumnPropertyManage_(int columnCount, WorkSheet sheet) {
        this.Sheet = sheet;
        this.widthList = new ArrayList();
        int i = 0;
        while (i < columnCount) {
            this.widthList.add(new ColumnConfig(72));
            ++i;
        }
    }

    public void _$ColumnPropertyManage_() {
        this.widthList.clear();
        this.widthList = null;
        this.Sheet = null;
    }

    public int getColumnCount() {
        return this.widthList.size();
    }

    public int getFixedColumnCount() {
        Cell cell = this.Sheet.getFreezedCell();
        if (cell == null) {
            return 0;
        }
        return cell.getColumnIndex();
    }

    public int getColumnHeadHeight() {
        return this.ColumnHeadHeight;
    }

    public void setColumnHeadHeight(int Height) {
        this.ColumnHeadHeight = Math.max(0, Height);
    }

    public int getColumnWidth(int col) {
        if (col < 0) {
            return 0;
        }
        if (col >= this.getColumnCount()) {
            return 0;
        }
        return ((ColumnConfig)this.widthList.get((int)col)).size;
    }

    public int getColumnStretchWidth(int col) {
        if (col < 0) {
            return 0;
        }
        if (col >= this.getColumnCount()) {
            return 0;
        }
        return ((ColumnConfig)this.widthList.get((int)col)).stretchSize;
    }

    public int getColumnX(int col) {
        int ret = 0;
        int i = 0;
        while (i < col) {
            if (col >= this.widthList.size()) break;
            ret += ((ColumnConfig)this.widthList.get((int)i)).size;
            ++i;
        }
        return ret;
    }

    public void setColumnWidth(int col, int newWidth) {
        if (col < 0) {
            return;
        }
        if (col >= this.getColumnCount()) {
            return;
        }
        if (newWidth == ((ColumnConfig)this.widthList.get((int)col)).size) {
            return;
        }
        if (newWidth < 0) {
            return;
        }
        int oldWidth = ((ColumnConfig)this.widthList.get((int)col)).size;
        ((ColumnConfig)this.widthList.get((int)col)).size = newWidth;
        WorkSheetView view = this.Sheet.getWorkSheetView();
        ((WorkSheet_)this.Sheet).resetInnerCellPanelSize();
        if (view != null) {
            view.repaint();
            view.EM().FireColumnWidthChanged(col, oldWidth, newWidth);
        }
    }

    public void setColumnStretchWidth(int col, int percent) {
        if (col < 0) {
            return;
        }
        if (col >= this.getColumnCount()) {
            return;
        }
        if (percent == ((ColumnConfig)this.widthList.get((int)col)).stretchSize) {
            return;
        }
        if (percent < 0) {
            return;
        }
        ((ColumnConfig)this.widthList.get((int)col)).stretchSize = percent;
        WorkSheetView_ view = (WorkSheetView_)this.Sheet.getWorkSheetView();
        if (view != null) {
            view.reCalcuColumnsWidth();
        }
    }

    public int getFixedColumnWidth() {
        return this.getColumnX(this.getFixedColumnCount());
    }

    public int getAllColumnsWidth() {
        int ret = 0;
        int n = this.getColumnCount();
        int i = 0;
        while (i < n) {
            ret += ((ColumnConfig)this.widthList.get((int)i)).size;
            ++i;
        }
        return ret;
    }

    public int getColumnIndex(String name) {
        return 0;
    }

    public String getColumnName(int col) {
        if (col < 0) {
            return "";
        }
        String s = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int a = (int)Math.floor(col / 26);
        String ret = "";
        int b = col - a * 26;
        ret = col >= 26 ? String.valueOf(s.substring(a - 1, a)) + s.substring(b, b + 1) : s.substring(col, col + 1);
        return ret;
    }

    public void $$insertBefore(int beforeCol) {
        if (beforeCol < 0) {
            beforeCol = 0;
        }
        RowProperty RP = new RowProperty();
        int cc = this.getColumnCount();
        if (beforeCol >= cc) {
            this.widthList.add(new ColumnConfig(72));
        } else {
            this.widthList.add(beforeCol, new ColumnConfig(72));
        }
    }

    public void $insertMultiColumn(int startCol, int endCol) {
        int i = startCol;
        while (i <= endCol) {
            this.$$insertBefore(i);
            ++i;
        }
    }

    public void $deleteColumn(int col) {
        if (col < 0) {
            return;
        }
        int cc = this.getColumnCount();
        if (col >= cc) {
            return;
        }
        this.widthList.remove(col);
    }

    public boolean isShowColumnIndex() {
        return this.showColumnIndex;
    }

    public void setShowColumnIndex(boolean b) {
        if (this.showColumnIndex == b) {
            return;
        }
        this.showColumnIndex = b;
        WorkSheetView view = this.Sheet.getWorkSheetView();
        if (view != null) {
            view.repaint();
        }
    }

    public String getColumnShowText(int col) {
        String s = this.getColumnName(col);
        if (this.showColumnIndex) {
            s = String.valueOf(col + 1);
        }
        return s;
    }

    public Object getColumnTag(int col) {
        return ((ColumnConfig)this.widthList.get((int)col)).tag;
    }

    public void setColumnTag(int col, Object tag) {
        ((ColumnConfig)this.widthList.get((int)col)).tag = tag;
    }

    public int getColumnWidth2(int col) {
        return ((ColumnConfig)this.widthList.get((int)col)).size2;
    }

    public void setColumnWidth2(int col, int newWidth) {
        ((ColumnConfig)this.widthList.get((int)col)).size2 = newWidth;
    }

    class ColumnConfig {
        int size;
        int size2 = -1;
        int stretchSize = 0;
        Object tag = null;

        public ColumnConfig(int size_) {
            this.size = size_;
        }
    }
}

