/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.command.CommandScene;
import excel.core.ClipBoard;
import excel.core.Range;
import excel.core.impl.Cell_;
import excel.core.impl.Range_;
import excel.core.impl.WorkSheet_;
import java.lang.ref.WeakReference;

public final class ClipBoard_
implements ClipBoard {
    private WeakReference ref;
    private Range range;
    private int Action;
    private CommandScene Scene = new CommandScene();

    public ClipBoard_(WorkSheet_ sheet, Range r, int action) {
        this.ref = new WeakReference<WorkSheet_>(sheet);
        this.range = new Range_(r.getStartRow(), r.getStartCol(), r.getEndRow(), r.getEndCol());
        this.Action = action;
        ClipBoard_.SaveCellRangeToScene(sheet, r, this.Scene);
    }

    public static void SaveCellRangeToScene(WorkSheet_ sheet, Range range, CommandScene Scene) {
        int r1 = range.getStartRow();
        int c1 = range.getStartCol();
        int r2 = range.getEndRow();
        int c2 = range.getEndCol();
        int row = r1;
        while (row <= r2) {
            int col = c1;
            while (col <= c2) {
                Cell_ cell = (Cell_)sheet.$Cells(row, col);
                if (cell == null) {
                    Scene.put(String.valueOf(row) + "-" + col, (Object)null);
                } else {
                    Scene.put(String.valueOf(row) + "-" + col, cell.getAllField());
                }
                ++col;
            }
            ++row;
        }
    }

    public static boolean RestoreCellRangeFromScene(WorkSheet_ sheet, int startRow, int startCol, CommandScene source, Range scenePos, boolean aliasReplace) {
        int r1 = scenePos.getStartRow();
        int c1 = scenePos.getStartCol();
        int r2 = scenePos.getEndRow();
        int c2 = scenePos.getEndCol();
        int dr = startRow - r1;
        int dc = startCol - c1;
        if (source == null) {
            return false;
        }
        int row = r1;
        while (row <= r2) {
            int col = c1;
            while (col <= c2) {
                CommandScene cs = (CommandScene)source.get(String.valueOf(row) + "-" + col, (Object)null);
                Cell_ cell = (Cell_)sheet.$Cells(row + dr, col + dc);
                if (cell != null || cs != null) {
                    if (cell == null) {
                        cell = (Cell_)sheet.Cells(row + dr, col + dc);
                    }
                    if (cell != null) {
                        cell.$CopyFrom(cs, aliasReplace);
                    }
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public WorkSheet_ getWorkSheet() {
        WorkSheet_ sheet = (WorkSheet_)this.ref.get();
        if (sheet == null) {
            return null;
        }
        if (sheet.getIndex() < 0) {
            return null;
        }
        return sheet;
    }

    public Range getRange() {
        return this.range;
    }

    public int getAction() {
        return this.Action;
    }

    public CommandScene getScene() {
        return this.Scene;
    }
}

