/*
 * Decompiled with CFR 0.152.
 */
package excel.core.impl;

import excel.util.Tools;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.apache.regexp.RE;

public class BackGroundImageConfig {
    public String id;
    public String startCell;
    public String endCell;
    public String x_position;
    public String y_position;
    public String x_repeat;
    public String y_repeat;
    public String url;
    public boolean needPrint;
    private Image img = null;
    private int width = 0;
    private int height = 0;

    public Image getImage(Component pwnd) {
        if (this.img != null) {
            return this.img;
        }
        this.img = Tools.GetImageFromURL(pwnd, this.url);
        return this.img;
    }

    public int getImageWidth(Component pwnd) {
        this.getImageSize(pwnd);
        return this.width;
    }

    public int getImageHeight(Component pwnd) {
        this.getImageSize(pwnd);
        return this.height;
    }

    private void getImageSize(Component pwnd) {
        if (this.width > 0 && this.height > 0) {
            return;
        }
        Image img = this.getImage(pwnd);
        this.width = img.getWidth(pwnd);
        this.height = img.getHeight(pwnd);
    }

    public int getX(Rectangle rc, Component pwnd) {
        RE r = new RE("[-]{0,1}[0-9]+");
        String t = this.x_position.trim().toLowerCase();
        if (r.match(t) && r.getParenStart(0) == 0 && r.getParenEnd(0) == t.length()) {
            return rc.x + Integer.valueOf(t);
        }
        r = new RE("[0-9]{1,2}%");
        if (r.match(t) && r.getParenStart(0) == 0 && r.getParenEnd(0) == t.length()) {
            return (int)((double)rc.x + (double)rc.width * Double.valueOf(t.substring(r.getParenStart(1), r.getParenEnd(1))) / 100.0);
        }
        this.getImageSize(pwnd);
        if (t.equals("left")) {
            return rc.x;
        }
        if (t.equals("center")) {
            return rc.x + (rc.width - this.width) / 2;
        }
        if (t.equals("right")) {
            return rc.x + rc.width - this.width;
        }
        return rc.x;
    }

    public int getY(Rectangle rc, Component pwnd) {
        RE r = new RE("[-]{0,1}[0-9]+");
        String t = this.y_position.trim().toLowerCase();
        if (r.match(t) && r.getParenStart(0) == 0 && r.getParenEnd(0) == t.length()) {
            return rc.y + Integer.valueOf(t);
        }
        r = new RE("[0-9]{1,2}%");
        if (r.match(t) && r.getParenStart(0) == 0 && r.getParenEnd(0) == t.length()) {
            return (int)((double)rc.y + (double)rc.height * Double.valueOf(t.substring(r.getParenStart(1), r.getParenEnd(1))) / 100.0);
        }
        this.getImageSize(pwnd);
        if (t.equals("top")) {
            return rc.y;
        }
        if (t.equals("center")) {
            return rc.y + (rc.height - this.height) / 2;
        }
        if (t.equals("bottom")) {
            return rc.y + rc.height - this.height;
        }
        return rc.y;
    }

    public ArrayList getAllX(int x0, Rectangle rc, Rectangle rcClip, Component pwnd) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(x0));
        String t = this.x_repeat.trim().toLowerCase();
        this.getImageSize(pwnd);
        if (this.width == 0) {
            return list;
        }
        if (t.equals("")) {
            return list;
        }
        if (t.equals("no-repeat")) {
            return list;
        }
        if (t.equals("repeat")) {
            while (x0 < (this.endCell.equals("") ? rcClip.x + rcClip.width : rc.x + rc.width)) {
                list.add(new Integer(x0 += this.width));
                if (list.size() > 5000) break;
            }
        }
        return list;
    }

    public ArrayList getAllY(int y0, Rectangle rc, Rectangle rcClip, Component pwnd) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(y0));
        String t = this.y_repeat.trim().toLowerCase();
        this.getImageSize(pwnd);
        if (this.height == 0) {
            return list;
        }
        if (t.equals("")) {
            return list;
        }
        if (t.equals("no-repeat")) {
            return list;
        }
        if (t.equals("repeat")) {
            while (y0 < (this.endCell.equals("") ? rcClip.y + rcClip.height : rc.y + rc.height)) {
                list.add(new Integer(y0 += this.height));
                if (list.size() > 5000) break;
            }
        }
        return list;
    }

    public static void main(String[] args) {
        RE r = new RE("([0-9]{1,2})%");
        String t = "23%";
        if (r.match(t)) {
            Tools.log(r.getParenStart(0));
            Tools.log(r.getParenEnd(0));
            Tools.log(r.getParenStart(1));
            Tools.log(r.getParenEnd(1));
            Tools.log(r.getParenStart(0) == 0 && r.getParenEnd(0) == t.length());
        }
    }
}

