/*
 * Decompiled with CFR 0.152.
 */
package excel.core;

import excel.core.WorkBook;
import excel.core.impl.WorkBook_;

public abstract class ZExcel {
    private static String jvmVer = null;
    private static boolean jvm16 = false;

    public static boolean isJVM16() {
        if (jvmVer == null) {
            jvmVer = System.getProperties().getProperty("java.vm.version");
            jvm16 = Double.valueOf(jvmVer.substring(0, 3)) >= 1.6;
        }
        return jvm16;
    }

    private ZExcel() {
    }

    public static void clearWorkBook(WorkBook book) {
        if (book == null) {
            return;
        }
        ((WorkBook_)book)._$WorkBook_();
    }

    public static WorkBook newWorkBook(int defaultSheetCount, boolean withGUI) {
        ZExcel.showVerInfo();
        return ZExcel.newWorkBook(defaultSheetCount, withGUI, null, null, null, null);
    }

    public static WorkBook newWorkBook(int defaultSheetCount, boolean withGUI, int[] rowCount, int[] colCount, String[] guids, String[] codes) {
        ZExcel.showVerInfo();
        WorkBook_ book = new WorkBook_(defaultSheetCount, withGUI, rowCount, colCount, guids, codes);
        return book;
    }

    private static void showVerInfo() {
        System.out.println("ZExcel Ver: 1.0 ");
    }

    public static String rowColToName(int row, int col) {
        String s = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int a = (int)Math.floor(col / 26);
        String ret = "";
        int b = col - a * 26;
        try {
            ret = col >= 26 ? String.valueOf(s.substring(a - 1, a)) + s.substring(b, b + 1) : s.substring(col, col + 1);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(s) + "  length: " + s.length() + "  a=" + a + " b=" + b + "  row=" + row + "  col=" + col);
        }
        return String.valueOf(ret) + String.valueOf(row + 1);
    }
}

