/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.command.CommandBase;
import excel.command.CommandScene;
import excel.core.Cell;
import excel.core.Range;
import excel.core.WorkSheet;
import excel.core.impl.Cell_;
import java.awt.Color;
import java.util.ArrayList;

public class CMD_SetRangeBorder
extends CommandBase {
    public static final int BORDER_LEFT = 0;
    public static final int BORDER_RIGHT = 1;
    public static final int BORDER_TOP = 2;
    public static final int BORDER_BOTTOM = 3;
    public static final int BORDER_INNERH = 4;
    public static final int BORDER_INNERV = 5;
    public static final int BORDER_OUTER = 6;
    public static final int BORDER_INNER = 7;
    public static final int BORDER_ALL = 8;

    public CMD_SetRangeBorder(WorkSheet sheet, CommandScene scene) {
        super(sheet, scene);
    }

    private void SaveLeft(Range range, ArrayList backup) {
        int col = range.getStartCol();
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            backup.add(this.getProperty(row, col, "border-left-style"));
            backup.add(this.getProperty(row, col, "border-left-width"));
            backup.add(this.getProperty(row, col, "border-left-color"));
            ++row;
        }
        if (--col >= 0) {
            row = range.getStartRow();
            while (row <= range.getEndRow()) {
                backup.add(this.getProperty(row, col, "border-right-style"));
                ++row;
            }
        }
    }

    private void SaveRight(Range range, ArrayList backup) {
        int col = range.getEndCol();
        int row = range.getStartRow();
        while (row <= range.getEndRow()) {
            backup.add(this.getProperty(row, col, "border-right-style"));
            backup.add(this.getProperty(row, col, "border-right-width"));
            backup.add(this.getProperty(row, col, "border-right-color"));
            ++row;
        }
        if (++col < this.Sheet.getColumnPropertyManage().getColumnCount()) {
            row = range.getStartRow();
            while (row <= range.getEndRow()) {
                backup.add(this.getProperty(row, col, "border-left-style"));
                ++row;
            }
        }
    }

    private void SaveTop(Range range, ArrayList backup) {
        int row = range.getStartRow();
        int col = range.getStartCol();
        while (col <= range.getEndCol()) {
            backup.add(this.getProperty(row, col, "border-top-style"));
            backup.add(this.getProperty(row, col, "border-top-width"));
            backup.add(this.getProperty(row, col, "border-top-color"));
            ++col;
        }
        if (--row >= 0) {
            col = range.getStartCol();
            while (col <= range.getEndCol()) {
                backup.add(this.getProperty(row, col, "border-bottom-style"));
                ++col;
            }
        }
    }

    private void SaveBottom(Range range, ArrayList backup) {
        int row = range.getEndRow();
        int col = range.getStartCol();
        while (col <= range.getEndCol()) {
            backup.add(this.getProperty(row, col, "border-bottom-style"));
            backup.add(this.getProperty(row, col, "border-bottom-width"));
            backup.add(this.getProperty(row, col, "border-bottom-color"));
            ++col;
        }
        if (++row < this.Sheet.getRowPropertyManage().getRowCount()) {
            col = range.getStartCol();
            while (col <= range.getEndCol()) {
                backup.add(this.getProperty(row, col, "border-top-style"));
                ++col;
            }
        }
    }

    private void SaveInnerV(Range range, ArrayList backup) {
        int startRow = range.getStartRow();
        int endRow = range.getEndRow();
        int startCol = range.getStartCol();
        int endCol = range.getEndCol();
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                if (col != endCol) {
                    backup.add(this.getProperty(row, col, "border-right-style"));
                    backup.add(this.getProperty(row, col, "border-right-width"));
                    backup.add(this.getProperty(row, col, "border-right-color"));
                }
                if (col != startCol) {
                    backup.add(this.getProperty(row, col, "border-left-style"));
                }
                ++col;
            }
            ++row;
        }
    }

    private void SaveInnerH(Range range, ArrayList backup) {
        int startRow = range.getStartRow();
        int endRow = range.getEndRow();
        int startCol = range.getStartCol();
        int endCol = range.getEndCol();
        int row = startRow;
        while (row <= endRow) {
            int col = startCol;
            while (col <= endCol) {
                if (row != endRow) {
                    backup.add(this.getProperty(row, col, "border-bottom-style"));
                    backup.add(this.getProperty(row, col, "border-bottom-width"));
                    backup.add(this.getProperty(row, col, "border-bottom-color"));
                }
                if (row != startRow) {
                    backup.add(this.getProperty(row, col, "border-top-style"));
                }
                ++col;
            }
            ++row;
        }
    }

    public void $SaveScene() {
        Range range = (Range)this.Scene.get("range");
        int whichSide = this.Scene.get("side", 0);
        int style = this.Scene.get("style", 0);
        int width = this.Scene.get("width", 0);
        ArrayList backup = new ArrayList();
        switch (whichSide) {
            case 0: {
                this.SaveLeft(range, backup);
                break;
            }
            case 1: {
                this.SaveRight(range, backup);
                break;
            }
            case 2: {
                this.SaveTop(range, backup);
                break;
            }
            case 3: {
                this.SaveBottom(range, backup);
                break;
            }
            case 6: {
                this.SaveLeft(range, backup);
                this.SaveRight(range, backup);
                this.SaveTop(range, backup);
                this.SaveBottom(range, backup);
                break;
            }
            case 7: {
                this.SaveInnerV(range, backup);
                this.SaveInnerH(range, backup);
                break;
            }
            case 5: {
                this.SaveInnerV(range, backup);
                break;
            }
            case 4: {
                this.SaveInnerH(range, backup);
                break;
            }
            case 8: {
                this.SaveLeft(range, backup);
                this.SaveRight(range, backup);
                this.SaveTop(range, backup);
                this.SaveBottom(range, backup);
                this.SaveInnerV(range, backup);
                this.SaveInnerH(range, backup);
            }
        }
        this.Scene.put("backup", backup);
    }

    private CommandScene getProperty(int row, int col, String propertyName) {
        Cell cell = this.Sheet.CreateCell(row, col);
        CommandScene cs = new CommandScene();
        cs.put("row", row);
        cs.put("col", col);
        cs.put("propertyname", propertyName);
        cs.put("propertyvalue", cell.getPropertyValue(propertyName));
        return cs;
    }

    public boolean $Execute() {
        Range range = (Range)this.Scene.get("range");
        int whichSide = this.Scene.get("side", 0);
        int style = this.Scene.get("style", 0);
        int width = this.Scene.get("width", 0);
        Color color = this.Scene.get("color", Color.BLACK);
        return this.Sheet.$setRangeBorder(range, whichSide, style, width, color);
    }

    public boolean $Undo() {
        ArrayList backup = (ArrayList)this.Scene.get("backup");
        int ci = 0;
        while (ci < backup.size()) {
            CommandScene cs = (CommandScene)backup.get(ci);
            int row = cs.get("row", 0);
            int col = cs.get("col", 0);
            String propertyName = cs.get("propertyname", "");
            Object propertyValue = cs.get("propertyvalue", (Object)null);
            Cell_ cell = (Cell_)this.Sheet.Cells(row, col);
            if (propertyValue == null || !propertyValue.equals(cell.getPropertyValue(propertyName))) {
                cell.$setProperty(propertyName, propertyValue);
            }
            ++ci;
        }
        return true;
    }
}

