/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.command.CommandBase;
import excel.command.CommandScene;
import excel.core.Row;
import excel.core.RowProperty;
import excel.core.RowPropertyManage;
import excel.core.WorkSheet;
import excel.core.impl.RedefineBecause;
import excel.core.impl.RowPropertyManage_;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheet_;

public class CMD_DeleteMultiRow
extends CommandBase {
    public CMD_DeleteMultiRow(WorkSheet sheet, CommandScene scene) {
        super(sheet, scene);
    }

    public void $SaveScene() {
        int startRow = this.Scene.get("startrow", 0);
        int endRow = this.Scene.get("endrow", 0);
        CMD_DeleteMultiRow.SaveScene(this.Scene, this.Sheet, startRow, endRow);
    }

    public boolean $Execute() {
        int startRow = this.Scene.get("startrow", 0);
        int endRow = this.Scene.get("endrow", 0);
        boolean ret = this.Sheet.$deleteMultiRow(startRow, endRow);
        if (this.Sheet.isRebuildCellDefineAfterInsertOrDeleteRow()) {
            ((WorkBook_)this.Sheet.getWorkBook()).RebuildAllDefine(this.Sheet, new RedefineBecause(3, startRow, 0, endRow, 0));
        }
        return ret;
    }

    public boolean $Undo() {
        int startRow = this.Scene.get("startrow", 0);
        int endRow = this.Scene.get("endrow", 0);
        this.Sheet.$insertMultiRow(startRow, endRow);
        RowPropertyManage_ RPM = (RowPropertyManage_)this.Sheet.getRowPropertyManage();
        CMD_DeleteMultiRow.RestoreData(this.Scene, this.Sheet, startRow, endRow);
        if (this.Sheet.isRebuildCellDefineAfterInsertOrDeleteRow()) {
            ((WorkBook_)this.Sheet.getWorkBook()).RebuildAllDefine(this.Sheet, new RedefineBecause(1, startRow, 0, endRow, 0));
        }
        return true;
    }

    public static void SaveScene(CommandScene Scene, WorkSheet_ Sheet, int startRow, int endRow) {
        RowPropertyManage RPM = Sheet.getRowPropertyManage();
        int i = startRow;
        while (i <= endRow) {
            Row r = Sheet.getRow(i);
            Scene.put("row:" + i, r);
            Scene.put("rp:" + i, RPM.getRowProperty(i));
            ++i;
        }
    }

    public static void RestoreData(CommandScene Scene, WorkSheet_ Sheet, int startRow, int endRow) {
        RowPropertyManage_ RPM = (RowPropertyManage_)Sheet.getRowPropertyManage();
        int i = startRow;
        while (i <= endRow) {
            Row r = (Row)Scene.get("row:" + i);
            Sheet.$setRow(i, r);
            RowProperty rp = (RowProperty)Scene.get("rp:" + i);
            RPM.$setRowProperty(i, rp);
            ++i;
        }
    }
}

