/*
 * Decompiled with CFR 0.152.
 */
package excel.command;

import excel.command.CommandBase;
import excel.command.CommandScene;
import excel.core.ColumnPropertyManage;
import excel.core.WorkSheet;
import excel.core.impl.ColumnPropertyManage_;
import excel.core.impl.RedefineBecause;
import excel.core.impl.WorkBook_;
import excel.core.impl.WorkSheet_;
import java.util.ArrayList;

public class CMD_DeleteMultiColumn
extends CommandBase {
    public CMD_DeleteMultiColumn(WorkSheet sheet, CommandScene scene) {
        super(sheet, scene);
    }

    public void $SaveScene() {
        int startCol = this.Scene.get("startcol", 0);
        int endCol = this.Scene.get("endcol", 0);
        CMD_DeleteMultiColumn.SaveScene(this.Scene, this.Sheet, startCol, endCol);
    }

    public boolean $Execute() {
        int startCol = this.Scene.get("startcol", 0);
        int endCol = this.Scene.get("endcol", 0);
        boolean ret = this.Sheet.$deleteMultiColumn(startCol, endCol);
        ((WorkBook_)this.Sheet.getWorkBook()).RebuildAllDefine(this.Sheet, new RedefineBecause(4, 0, startCol, 0, endCol));
        return ret;
    }

    public boolean $Undo() {
        int startCol = this.Scene.get("startcol", 0);
        int endCol = this.Scene.get("endcol", 0);
        this.Sheet.$insertMultiColumn(startCol, endCol);
        ColumnPropertyManage_ CPM = (ColumnPropertyManage_)this.Sheet.getColumnPropertyManage();
        CMD_DeleteMultiColumn.RestoreData(this.Scene, this.Sheet, startCol, endCol);
        ((WorkBook_)this.Sheet.getWorkBook()).RebuildAllDefine(this.Sheet, new RedefineBecause(2, 0, startCol, 0, endCol));
        return true;
    }

    public static void SaveScene(CommandScene Scene, WorkSheet_ Sheet, int startCol, int endCol) {
        ColumnPropertyManage CPM = Sheet.getColumnPropertyManage();
        int i = startCol;
        while (i <= endCol) {
            ArrayList r = Sheet.getColumn(i);
            Scene.put("col:" + i, r);
            Scene.put("cp:" + i, CPM.getColumnWidth(i));
            ++i;
        }
    }

    public static void RestoreData(CommandScene Scene, WorkSheet_ Sheet, int startCol, int endCol) {
        ColumnPropertyManage_ CPM = (ColumnPropertyManage_)Sheet.getColumnPropertyManage();
        int i = startCol;
        while (i <= endCol) {
            ArrayList r = (ArrayList)Scene.get("col:" + i);
            Sheet.$setColumn(i, r);
            int w = Scene.get("cp:" + i, 72);
            CPM.setColumnWidth(i, w);
            ++i;
        }
    }
}

