/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.PageBar;
import excel.core.impl.WorkSheetView_;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Timer;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PageRowcountBarEdit
extends JTextField
implements FocusListener,
KeyListener {
    PageBar brick;
    WorkSheetView_ view;
    boolean hadRetrieved = false;
    Timer focusTimer = new Timer();

    public PageRowcountBarEdit(PageBar brick, WorkSheetView_ view) {
        this.brick = brick;
        this.view = view;
        this.setFont(Tools.GetFont("\u5b8b\u4f53", 12, false, false, false));
        Rectangle editRC = brick.getPageRowCountBounds();
        editRC.x += 3;
        editRC.y += 3;
        editRC.width -= 5;
        editRC.height -= 5;
        this.setBounds(editRC);
        Border border = BorderFactory.createLineBorder(new Color(0, 0, 255));
        this.setText("" + brick.getOnceRetrieveRowCount());
        this.setBorder(null);
        this.setFocusable(true);
        view.add(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        Tools.requestInputFocus(this);
        this.selectAll();
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 9: 
            case 10: {
                this.gotoPage();
                break;
            }
            case 27: {
                this.focusLost(null);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void gotoPage() {
        if (this.hadRetrieved) {
            return;
        }
        this.hadRetrieved = true;
        String s = this.getText().trim();
        try {
            Integer i = new Integer(s);
            this.brick.setOnceRetrieveRowCount(Math.max(1, i));
            this.brick.setPageIndex(0, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.view.remove(this);
        this.brick.invalidate();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.gotoPage();
    }
}

