/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.ImageButton;
import excel.brick.PageBar;
import excel.brick.impl.BasicBrick;
import excel.brick.impl.ImageButton_;
import excel.brick.impl.PageBarEdit;
import excel.brick.impl.PageRowcountBarEdit;
import excel.core.Cell;
import excel.core.Range;
import excel.core.impl.Range_;
import excel.core.impl.WorkSheetView_;
import excel.util.Tools;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import jun.db.core.DataStore;

public class PageBar_
extends BasicBrick
implements PageBar {
    private HashMap buttonMap = new HashMap();
    int onceRetrieveRowCount = 100;
    int currentPageIndex = 0;
    int pageCount = 0;
    int dbRowCount = 0;
    private ImageButton_ jb_First;
    private ImageButton_ jb_Prior;
    private ImageButton_ jb_Next;
    private ImageButton_ jb_Last;
    int textSize = 100;
    int leftBlank = 2;
    int w = 24;
    int h = 24;
    int sp = 2;

    public void calcuPageCount() {
        this.pageCount = Math.max(0, (this.dbRowCount - 1) / this.onceRetrieveRowCount + 1);
        this.currentPageIndex = 0;
        this.setButtonState();
    }

    public void reset(int dbRowCount) {
        this.dbRowCount = dbRowCount;
        this.calcuPageCount();
    }

    public PageBar_(String name, String dataSource, int pageRowCount) {
        super(name, 17);
        this.setDataSource(dataSource);
        this.onceRetrieveRowCount = pageRowCount;
        String path = "excel/img/";
        this.jb_First = new ImageButton_(String.valueOf(name) + "_jb_First", String.valueOf(path) + "page-first.gif", String.valueOf(path) + "page-first-focus.gif", String.valueOf(path) + "page-first-down.gif", String.valueOf(path) + "page-first-disabled.gif"){

            public void OnClick() {
                PageBar_.this.gotoFirstPage();
            }
        };
        this.jb_Prior = new ImageButton_(String.valueOf(name) + "_jb_Prior", String.valueOf(path) + "page-prev.gif", String.valueOf(path) + "page-prev-focus.gif", String.valueOf(path) + "page-prev-down.gif", String.valueOf(path) + "page-prev-disabled.gif"){

            public void OnClick() {
                PageBar_.this.gotoPriorPage();
            }
        };
        this.jb_Next = new ImageButton_(String.valueOf(name) + "_jb_Next", String.valueOf(path) + "page-next.gif", String.valueOf(path) + "page-next-focus.gif", String.valueOf(path) + "page-next-down.gif", String.valueOf(path) + "page-next-disabled.gif"){

            public void $OnClick() {
                PageBar_.this.gotoNextPage();
            }
        };
        this.jb_Last = new ImageButton_(String.valueOf(name) + "_jb_Last", String.valueOf(path) + "page-last.gif", String.valueOf(path) + "page-last-focus.gif", String.valueOf(path) + "page-last-down.gif", String.valueOf(path) + "page-last-disabled.gif"){

            public void OnClick() {
                PageBar_.this.gotoLastPage();
            }
        };
        this.jb_First.dynamicCreate = true;
        this.jb_Prior.dynamicCreate = true;
        this.jb_Next.dynamicCreate = true;
        this.jb_Last.dynamicCreate = true;
        this.jb_First.setBounds(this.leftBlank, -this.h - 2, this.w, this.h);
        this.jb_Prior.setBounds(this.leftBlank + this.w + this.sp, -this.h - 2, this.w, this.h);
        this.jb_Next.setBounds(this.leftBlank + this.textSize + (this.w + this.sp) * 2 + this.sp, -this.h - 2, this.w, this.h);
        this.jb_Last.setBounds(this.leftBlank + this.textSize + (this.w + this.sp) * 3 + this.sp, -this.h - 2, this.w, this.h);
        this.buttonMap.put("first", this.jb_First);
        this.buttonMap.put("next", this.jb_Next);
        this.buttonMap.put("prev", this.jb_Prior);
        this.buttonMap.put("last", this.jb_Last);
    }

    public void setButtonEnabled(String whatButton, boolean enabled) {
        ImageButton button = (ImageButton)this.buttonMap.get(whatButton);
        if (button == null) {
            return;
        }
        button.setEnabled(enabled);
    }

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        super.paint(isPrint, g, parentRC);
        Rectangle rc = this.getBounds(parentRC);
        Rectangle trc = new Rectangle(rc.x + this.leftBlank + (this.w + this.sp) * 2, rc.y + rc.height - this.h - 2, this.textSize, this.h - 1);
        String t = "\u6ca1\u6709\u6570\u636e";
        Tools.DrawString(g, trc, "\u9875\u7801", 0, Color.white, Color.black, "\u5b8b\u4f53", 12, false, false, false, 0, 2);
        trc.x += 26;
        trc.width = 45;
        Color bc = new Color(0x6C6CFF);
        g.setColor(bc);
        trc.y += 2;
        trc.height -= 4;
        g.drawRoundRect(trc.x, trc.y, trc.width, trc.height, 5, 5);
        t = "" + (this.currentPageIndex + 1);
        if (this.pageCount == 0) {
            t = "0";
        }
        Tools.DrawString(g, trc, t, 0, Color.white, Color.black, "\u5b8b\u4f53", 12, false, false, false, 2, 2);
        trc.x += trc.width + 3;
        Tools.DrawString(g, trc, "/" + this.pageCount, 0, Color.white, Color.black, "\u5b8b\u4f53", 12, false, false, false, 0, 2);
        trc.x = rc.x + this.leftBlank + this.textSize + (this.w + this.sp) * 4 + this.sp + 10;
        trc.width = 150;
        Tools.DrawString(g, trc, "         \u884c/\u9875", 0, Color.white, Color.black, "\u5b8b\u4f53", 12, false, false, false, 0, 2);
        trc.width = 45;
        Tools.DrawString(g, trc, "" + this.getOnceRetrieveRowCount(), 0, Color.white, Color.black, "\u5b8b\u4f53", 12, false, false, false, 1, 2);
        trc.width += this.sp;
        g.setColor(bc);
        g.drawRoundRect(trc.x, trc.y, trc.width, trc.height, 5, 5);
    }

    public void afterAddToCell() {
        this.pCell.addBrick(this.jb_First);
        this.pCell.addBrick(this.jb_Prior);
        this.pCell.addBrick(this.jb_Next);
        this.pCell.addBrick(this.jb_Last);
    }

    public void gotoFirstPage() {
        if (this.pageCount == 0) {
            return;
        }
        this.currentPageIndex = 0;
        this.setButtonState();
        this.retrieve();
    }

    public void setButtonState() {
        if (this.pageCount == 0) {
            this.setButtonEnabled("first", false);
            this.setButtonEnabled("prev", false);
            this.setButtonEnabled("next", false);
            this.setButtonEnabled("last", false);
            return;
        }
        if (this.currentPageIndex == 0) {
            this.setButtonEnabled("first", false);
            this.setButtonEnabled("prev", false);
        } else {
            this.setButtonEnabled("first", true);
            this.setButtonEnabled("prev", true);
        }
        if (this.currentPageIndex == this.pageCount - 1) {
            this.setButtonEnabled("next", false);
            this.setButtonEnabled("last", false);
        } else {
            this.setButtonEnabled("next", true);
            this.setButtonEnabled("last", true);
        }
    }

    public void retrieve() {
        DataStore ds = this.pCell.getWorkSheet().getWorkBook().getDataSource(this.getDataSource()).getDataStore();
        ds.ignoreTopRow(this.currentPageIndex * this.onceRetrieveRowCount);
        ds.setOnceRetrieveCount(this.getOnceRetrieveRowCount());
        ds.retrieveWithLastSelect();
    }

    public void gotoPriorPage() {
        if (this.currentPageIndex == 0) {
            return;
        }
        --this.currentPageIndex;
        this.setButtonState();
        this.retrieve();
    }

    public void gotoNextPage() {
        if (this.currentPageIndex + 1 == this.pageCount) {
            return;
        }
        ++this.currentPageIndex;
        this.setButtonState();
        this.retrieve();
    }

    public void gotoLastPage() {
        if (this.currentPageIndex == this.pageCount - 1) {
            return;
        }
        this.currentPageIndex = this.pageCount - 1;
        this.setButtonState();
        this.retrieve();
    }

    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
        Point p = e.getPoint();
        Rectangle rc = this.getPageIndexBounds();
        if (rc.contains(p)) {
            PageBarEdit pe = new PageBarEdit(this, pView);
            return;
        }
        Rectangle rc2 = this.getPageRowCountBounds();
        if (rc2.contains(p)) {
            PageRowcountBarEdit pe = new PageRowcountBarEdit(this, pView);
            return;
        }
    }

    public int getOnceRetrieveRowCount() {
        return this.onceRetrieveRowCount;
    }

    public void setOnceRetrieveRowCount(int rc) {
        this.onceRetrieveRowCount = rc;
        if (this.onceRetrieveRowCount == 0) {
            this.onceRetrieveRowCount = 100;
        }
        this.calcuPageCount();
    }

    public void setPageCount(int pc) {
        this.pageCount = pc;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageIndex(int pi) {
        this.setPageIndex(pi, false);
    }

    public void setPageIndex(int pi, boolean forceRetrieve) {
        if (pi < 0) {
            return;
        }
        if (pi > this.pageCount - 1) {
            return;
        }
        if (this.currentPageIndex == pi && !forceRetrieve) {
            return;
        }
        this.currentPageIndex = pi;
        this.setButtonState();
        this.retrieve();
    }

    public int getPageIndex() {
        return this.currentPageIndex;
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        super.OnMouseMove(pView, e);
        Point p = e.getPoint();
        Rectangle rc = this.getPageIndexBounds();
        Rectangle rc2 = this.getPageRowCountBounds();
        if (rc.contains(p) || rc2.contains(p)) {
            pView.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            pView.setCursor(new Cursor(0));
        }
    }

    public Rectangle getPageIndexBounds() {
        WorkSheetView_ pView = (WorkSheetView_)this.pCell.getWorkSheet().getWorkSheetView();
        Cell cell = this.pCell;
        if (this.pCell.isMerged()) {
            cell = this.pCell.getLeftTopCorner();
        }
        Range r = new Range_(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex());
        if (cell.isMerged()) {
            r = cell.getMergedRange();
        }
        Rectangle rc = pView.getRectangleOfRange(false, r);
        rc = this.getBounds(rc);
        Rectangle trc = new Rectangle(rc.x + this.leftBlank + (this.w + this.sp) * 2, rc.y + rc.height - this.h - 2, this.textSize, this.h - 1);
        trc.x += 26;
        trc.width = 45;
        return trc;
    }

    public Rectangle getPageRowCountBounds() {
        WorkSheetView_ pView = (WorkSheetView_)this.pCell.getWorkSheet().getWorkSheetView();
        Cell cell = this.pCell;
        if (this.pCell.isMerged()) {
            cell = this.pCell.getLeftTopCorner();
        }
        Range r = new Range_(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex());
        if (cell.isMerged()) {
            r = cell.getMergedRange();
        }
        Rectangle rc = pView.getRectangleOfRange(false, r);
        rc = this.getBounds(rc);
        Rectangle trc = new Rectangle(rc.x + this.leftBlank + this.textSize + (this.w + this.sp) * 4 + this.sp + 10, rc.y + rc.height - this.h - 2, 45 + this.sp, this.h - 1);
        return trc;
    }
}

