/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.DBBar;
import excel.brick.impl.BasicBrick;
import excel.core.DataSourceConfig;
import excel.core.WorkBook;
import excel.core.impl.WorkSheetView_;
import excel.util.Tools;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import jun.db.core.DataStore;

public class DBBar_
extends BasicBrick
implements DBBar {
    private int Action = 0;
    private transient Image currentImg = null;
    private transient Image normalImg = null;
    private transient Image disabledImg = null;
    private transient Image downImg = null;
    private transient Image focusImg = null;
    private transient Cursor HandCursor = null;

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        if (!this.isVisible()) {
            return;
        }
        if (isPrint && !this.Printable) {
            return;
        }
        this.LoadImage();
        Rectangle rc = this.getBounds(parentRC);
        Shape oc = g.getClip();
        try {
            try {
                Tools.clip(g, rc);
                g.drawImage(this.currentImg, rc.x, rc.y, this.pCell.getWorkSheet().getWorkSheetView());
            }
            catch (Exception exception) {
                Tools.setClip(g, oc);
            }
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    public DBBar_(String name, String dataSource, int action) {
        super(name, action);
        this.setDataSource(dataSource);
        this.Action = action;
        this.FixedSize = true;
        this.Width = 48;
        this.Height = 23;
        if (this.Action == 2) {
            this.Caption = "\u540e\u63d2";
        }
        if (this.Action == 1) {
            this.Caption = "\u524d\u63d2";
        }
        if (this.Action == 3) {
            this.Caption = "\u5220\u9664";
        }
        if (this.Action == 20) {
            this.Caption = "\u514b\u9686";
        }
        this.setPrintable(false);
    }

    private void LoadImage() {
        if (this.currentImg != null) {
            return;
        }
        String file = "";
        if (this.Action == 2) {
            file = "insert_after";
        }
        if (this.Action == 1) {
            file = "insert_before";
        }
        if (this.Action == 3) {
            file = "del_cn";
        }
        if (this.Action == 20) {
            file = "clone_cn";
        }
        this.normalImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/img/" + file + ".gif");
        this.downImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/img/" + file + "_down.gif");
        this.focusImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/img/" + file + "_focus.gif");
        this.disabledImg = Tools.GetImageFromURL(this.pCell.getWorkSheet().getWorkSheetView(), "excel/img/" + file + "_disabled.gif");
        this.currentImg = this.isEnabled() ? this.normalImg : this.disabledImg;
        Cursor HandCursor = new Cursor(12);
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        pView.setCursor(this.HandCursor);
    }

    public void OnClick() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (this.pCell.getWorkSheet().isDesignMode()) {
            return;
        }
        WorkBook book = this.pCell.getWorkSheet().getWorkBook();
        WorkSheetView_ pView = (WorkSheetView_)this.pCell.getWorkSheet().getWorkSheetView();
        pView.forceCurrentEditControlGiveUpFocus();
        String DataSource = this.getDataSource();
        DataSourceConfig dsc = book.getDataSource(DataSource);
        if (dsc == null) {
            Tools.log(String.valueOf(DataSource) + "\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u636e\u5b9a\u4e49");
            return;
        }
        if (dsc.getDataSourceType() == 1) {
            Tools.log(String.valueOf(DataSource) + "\u662f\u5355\u884c\u6570\u636e\u96c6\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u672c\u64cd\u4f5c");
            return;
        }
        DataStore ds = dsc.getDataStore();
        if (ds == null) {
            return;
        }
        int currentRow = dsc.getCurrentBindRow();
        if (this.Action == 2) {
            ds.insertRow(currentRow + 1);
        }
        if (this.Action == 1) {
            ds.insertRow(currentRow);
        }
        if (this.Action == 3) {
            if (!Tools.confirm(pView, "\u786e\u4fe1\u8981\u5220\u9664\u5417?")) {
                return;
            }
            ds.deleteRow(currentRow);
            if (ds.getRowCount() == 0) {
                dsc.setCurrentBindRow(-1);
            }
        }
        if (this.Action == 20) {
            if (currentRow < 0) {
                return;
            }
            if (!Tools.confirm(pView, "\u786e\u4fe1\u8981\u514b\u9686\u672c\u884c\u5417?")) {
                return;
            }
            int newRow = ds.insertRow(currentRow + 1);
            String cols = ("|" + ds.getAsNoDataIfOnlySuchColumnsHoldData() + "|").toLowerCase();
            int i = 0;
            while (i < ds.getColumnCount()) {
                String colName = ds.getColumnName(i).toLowerCase();
                if (cols.indexOf(colName) < 0) {
                    ds.setValue(newRow, i, ds.getValue(currentRow, i));
                }
                ++i;
            }
        }
    }

    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnMouseEntered(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.focusImg;
        this.pCell.repaint();
    }

    public void OnMouseExited(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.normalImg;
        this.pCell.repaint();
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.downImg;
        this.pCell.repaint();
        pView.setCursor(this.HandCursor);
        super.OnLButtonDown(pView, e);
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.currentImg = this.normalImg;
        this.pCell.repaint();
        pView.setCursor(this.HandCursor);
        super.OnLButtonUp(pView, e);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.currentImg != null) {
            this.currentImg = null;
            this.LoadImage();
        }
        if (this.pCell != null) {
            this.pCell.repaint();
        }
    }
}

