/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;

public class CylinderRenderer
extends BarRenderer3D {
    public CylinderRenderer() {
    }

    public CylinderRenderer(double d, double d1) {
        super(d, d1);
    }

    public void drawItem(Graphics2D graphics2d, CategoryItemRendererState categoryitemrendererstate, Rectangle2D rectangle2d, CategoryPlot categoryplot, CategoryAxis categoryaxis, ValueAxis valueaxis, CategoryDataset categorydataset, int i, int j, int k) {
        EntityCollection entitycollection;
        CategoryItemLabelGenerator categoryitemlabelgenerator;
        Number number = categorydataset.getValue(i, j);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        Rectangle2D.Double double1 = new Rectangle2D.Double(rectangle2d.getX(), rectangle2d.getY() + this.getYOffset(), rectangle2d.getWidth() - this.getXOffset(), rectangle2d.getHeight() - this.getYOffset());
        PlotOrientation plotorientation = categoryplot.getOrientation();
        double d1 = this.calculateBarW0(categoryplot, plotorientation, double1, categoryaxis, categoryitemrendererstate, i, j);
        double[] ad = this.calculateBarL0L1(d);
        if (ad == null) {
            return;
        }
        RectangleEdge rectangleedge = categoryplot.getRangeAxisEdge();
        float f = (float)valueaxis.valueToJava2D(ad[0], (Rectangle2D)double1, rectangleedge);
        float f1 = (float)valueaxis.valueToJava2D(ad[1], (Rectangle2D)double1, rectangleedge);
        float f2 = Math.min(f, f1);
        float f3 = Math.abs(f1 - f);
        GeneralPath generalpath = new GeneralPath();
        Ellipse2D.Double double2 = null;
        if (plotorientation == PlotOrientation.HORIZONTAL) {
            generalpath.moveTo((float)((double)f2 + this.getXOffset() / 2.0), (float)d1);
            generalpath.lineTo((float)((double)(f2 + f3) + this.getXOffset() / 2.0), (float)d1);
            Arc2D.Double double3 = new Arc2D.Double(f2 + f3, d1, this.getXOffset(), categoryitemrendererstate.getBarWidth(), 90.0, 180.0, 0);
            generalpath.append(double3, true);
            generalpath.lineTo((float)((double)f2 + this.getXOffset() / 2.0), (float)(d1 + categoryitemrendererstate.getBarWidth()));
            double3 = new Arc2D.Double(f2, d1, this.getXOffset(), categoryitemrendererstate.getBarWidth(), 270.0, -180.0, 0);
            generalpath.append(double3, true);
            generalpath.closePath();
            double2 = new Ellipse2D.Double(f2 + f3, d1, this.getXOffset(), categoryitemrendererstate.getBarWidth());
        } else {
            generalpath.moveTo((float)d1, (float)((double)f2 - this.getYOffset() / 2.0));
            generalpath.lineTo((float)d1, (float)((double)(f2 + f3) - this.getYOffset() / 2.0));
            Arc2D.Double double4 = new Arc2D.Double(d1, (double)(f2 + f3) - this.getYOffset(), categoryitemrendererstate.getBarWidth(), this.getYOffset(), 180.0, 180.0, 0);
            generalpath.append(double4, true);
            generalpath.lineTo((float)(d1 + categoryitemrendererstate.getBarWidth()), (float)((double)f2 - this.getYOffset() / 2.0));
            double4 = new Arc2D.Double(d1, (double)f2 - this.getYOffset(), categoryitemrendererstate.getBarWidth(), this.getYOffset(), 0.0, -180.0, 0);
            generalpath.append(double4, true);
            generalpath.closePath();
            double2 = new Ellipse2D.Double(d1, (double)f2 - this.getYOffset(), categoryitemrendererstate.getBarWidth(), this.getYOffset());
        }
        Paint obj = this.getItemPaint(i, j);
        if (this.getGradientPaintTransformer() != null && obj instanceof GradientPaint) {
            GradientPaint gradientpaint = (GradientPaint)obj;
            obj = this.getGradientPaintTransformer().transform(gradientpaint, (Shape)generalpath);
        }
        graphics2d.setPaint(obj);
        graphics2d.fill(generalpath);
        if (obj instanceof GradientPaint) {
            graphics2d.setPaint(((GradientPaint)obj).getColor2());
        }
        if (double2 != null) {
            graphics2d.fill(double2);
        }
        if (this.isDrawBarOutline() && categoryitemrendererstate.getBarWidth() > 3.0) {
            graphics2d.setStroke(this.getItemOutlineStroke(i, j));
            graphics2d.setPaint(this.getItemOutlinePaint(i, j));
            graphics2d.draw(generalpath);
            if (double2 != null) {
                graphics2d.draw(double2);
            }
        }
        if ((categoryitemlabelgenerator = this.getItemLabelGenerator(i, j)) != null && this.isItemLabelVisible(i, j)) {
            this.drawItemLabel(graphics2d, categorydataset, i, j, categoryplot, categoryitemlabelgenerator, generalpath.getBounds2D(), d < 0.0);
        }
        if (categoryitemrendererstate.getInfo() != null && (entitycollection = categoryitemrendererstate.getEntityCollection()) != null) {
            String s = null;
            CategoryToolTipGenerator categorytooltipgenerator = this.getToolTipGenerator(i, j);
            if (categorytooltipgenerator != null) {
                s = categorytooltipgenerator.generateToolTip(categorydataset, i, j);
            }
            String s1 = null;
            if (this.getItemURLGenerator(i, j) != null) {
                s1 = this.getItemURLGenerator(i, j).generateURL(categorydataset, i, j);
            }
            CategoryItemEntity categoryitementity = new CategoryItemEntity((Shape)generalpath.getBounds2D(), s, s1, categorydataset, categorydataset.getRowKey(i), categorydataset.getColumnKey(j));
            entitycollection.add((ChartEntity)categoryitementity);
        }
    }
}

