/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.Chart;
import excel.brick.impl.BasicBrick;
import excel.brick.impl.CylinderRenderer;
import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.DataSourceConfig;
import excel.core.Depend;
import excel.core.MergedRange;
import excel.core.Range;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.impl.DataStoreEventAdapter;
import excel.core.impl.WorkSheetView_;
import excel.core.impl.WorkSheet_;
import excel.jep.ASTVarNode;
import excel.util.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GanttRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.TableOrder;

public class Chart_
extends BasicBrick
implements Chart {
    private String rangeOrDataSource = null;
    int startRow = -1;
    int firstCol;
    int endRow = -1;
    int secondCol;
    int thirdCol;
    int fourthCol;
    int endCol;
    WorkSheet dataSheet;
    String type = "";
    String categoryAxisLabel = "";
    String valueAxisLabel = "";
    float alpha;
    String highlightCategory = null;
    JFreeChart chart = null;
    String seriesCol = "";
    String categoryCol = "";
    String seriesColMap = "";
    String categoryColMap = "";
    String valueCol = "";
    String valueCol2 = "";
    boolean bindDB = false;
    DataStore ds = null;
    boolean seriesAngled = false;

    public Chart_(String type, String name, String caption, String categoryAxisLabel, String valueAxisLabel, float alpha, boolean seriesAngled, String range) {
        this(type, name, caption, categoryAxisLabel, valueAxisLabel, alpha, seriesAngled, range, "", "", "", "");
    }

    public Chart_(String type, String name, String caption, String categoryAxisLabel, String valueAxisLabel, float alpha, boolean seriesAngled, String rangeOrDataSource, String seriesCol, String categoryCol, String valueCol, String valueCol2) {
        super(name, 15);
        this.setCaption(caption);
        this.categoryAxisLabel = categoryAxisLabel;
        this.valueAxisLabel = valueAxisLabel;
        this.rangeOrDataSource = rangeOrDataSource;
        this.type = type;
        this.alpha = alpha;
        this.seriesCol = seriesCol;
        this.categoryCol = categoryCol;
        this.valueCol = valueCol;
        this.valueCol2 = valueCol2;
        this.seriesAngled = seriesAngled;
    }

    public void bind() {
        this.startRow = -1;
        this.endRow = -1;
        this.fourthCol = -1;
        this.thirdCol = -1;
        Cell pCell = this.getParentCell();
        WorkSheet sheet = pCell.getWorkSheet();
        WorkBook book = sheet.getWorkBook();
        DataSourceConfig dsc = book.getDataSource(this.rangeOrDataSource);
        boolean bl = this.bindDB = dsc != null;
        if (this.bindDB) {
            this.ds = dsc.getDataStore();
            DataStoreEventAdapter dsa = (DataStoreEventAdapter)this.ds.getEvent().findListener(this.rangeOrDataSource);
            dsa.addSubscriber(this);
            return;
        }
        ArrayList list = sheet.parseDependList(this.rangeOrDataSource);
        if (list.size() == 0) {
            return;
        }
        Depend depend = (Depend)list.get(0);
        ASTVarNode var = depend.node;
        int varKind = var.getToken().kind;
        this.dataSheet = this.getParentCell().getWorkSheet().getWorkBook().getWorkSheetByGuid(depend.SheetGuid);
        this.startRow = depend.range.getMergeStart().getRowIndex();
        this.firstCol = depend.range.getMergeStart().getColumnIndex();
        this.endRow = depend.range.getMergeEnd().getRowIndex();
        this.endCol = depend.range.getMergeEnd().getColumnIndex();
        this.secondCol = this.dataSheet.cells(this.startRow, this.firstCol).isMerged() ? this.dataSheet.cells(this.startRow, this.firstCol).getMergedRange().getEndCol() + 1 : this.firstCol + 1;
        this.thirdCol = this.dataSheet.cells(this.startRow, this.secondCol).isMerged() ? this.dataSheet.cells(this.startRow, this.secondCol).getMergedRange().getEndCol() + 1 : this.secondCol + 1;
        if (this.thirdCol > this.endCol) {
            this.thirdCol = -1;
        }
        if (this.thirdCol > 0) {
            this.fourthCol = this.dataSheet.cells(this.startRow, this.thirdCol).isMerged() ? this.dataSheet.cells(this.startRow, this.thirdCol).getMergedRange().getEndCol() + 1 : this.thirdCol + 1;
            if (this.fourthCol > this.endCol) {
                this.fourthCol = -1;
            }
        }
        int row = this.startRow;
        while (row <= this.endRow) {
            if (!this.dataSheet.isCellNull(row, this.firstCol) && !this.dataSheet.isCellNull(row, this.secondCol)) {
                this.dataSheet.cells(row, this.firstCol).addSubscriber(this);
                this.dataSheet.cells(row, this.secondCol).addSubscriber(this);
                if (this.thirdCol != -1) {
                    this.dataSheet.cells(row, this.thirdCol).addSubscriber(this);
                }
            }
            ++row;
        }
    }

    public void unBind() {
        try {
            Cell pCell = this.getParentCell();
            WorkSheet sheet = pCell.getWorkSheet();
            WorkBook book = sheet.getWorkBook();
            if (this.bindDB) {
                DataSourceConfig dsc = book.getDataSource(this.rangeOrDataSource);
                DataStoreEventAdapter dsa = (DataStoreEventAdapter)dsc.getDataStore().getEvent().findListener(this.rangeOrDataSource);
                dsa.removeSubscriber(this);
            } else {
                int row = this.startRow;
                while (row <= this.endRow) {
                    if (!this.dataSheet.isCellNull(row, this.firstCol) && !this.dataSheet.isCellNull(row, this.secondCol)) {
                        this.dataSheet.cells(row, this.firstCol).removeSubscriber(this);
                        this.dataSheet.cells(row, this.secondCol).removeSubscriber(this);
                        if (this.thirdCol != -1) {
                            this.dataSheet.cells(row, this.thirdCol).removeSubscriber(this);
                        }
                        if (this.fourthCol != -1) {
                            this.dataSheet.cells(row, this.fourthCol).removeSubscriber(this);
                        }
                    }
                    ++row;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHightCategory(String category) {
        this.highlightCategory = category;
    }

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
        block8: {
            if (!this.isVisible()) {
                return;
            }
            if (this.chart == null) {
                this.chart = this.createChart();
            }
            if (this.chart == null) {
                return;
            }
            Rectangle rc = this.getBounds(parentRC);
            Shape oc = g.getClip();
            try {
                try {
                    Tools.clip(g, rc);
                    Rectangle rc2 = new Rectangle(rc.x + 1, rc.y + 1, rc.width - 1, rc.height - 1);
                    this.chart.draw(g, (Rectangle2D)rc2);
                }
                catch (Exception exception) {
                    Tools.setClip(g, oc);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Tools.setClip(g, oc);
                throw throwable;
            }
            Tools.setClip(g, oc);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public BufferedImage getImage() {
        Cell cell = this.getParentCell();
        int drawRow = cell.getRowIndex();
        int drawCol = cell.getColumnIndex();
        WorkSheet sheet = cell.getWorkSheet();
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int h = RPM.getRowHeight(drawRow);
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        int w = CPM.getColumnWidth(drawCol);
        Rectangle cellRect = new Rectangle();
        cellRect.setBounds(0, 0, w, h);
        if (cell.isMerged()) {
            Range r = ((MergedRange)sheet.getMergeMap().get(cell)).getMergedRange();
            cellRect = ((WorkSheetView_)((WorkSheet_)sheet).getWorkSheetView()).getRectangleOfRange(false, r);
        }
        cellRect.x = 0;
        cellRect.y = 0;
        Rectangle rc = this.getBounds(cellRect);
        Rectangle rc2 = new Rectangle(0, 0, rc.width - 2, rc.height - 2);
        BufferedImage img = new BufferedImage(rc.width - 2, rc.height - 2, 1);
        Graphics graphics = img.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, rc.width - 2, rc.height - 2);
        if (this.chart == null) {
            this.chart = this.createChart();
        }
        this.chart.draw((Graphics2D)graphics, (Rectangle2D)rc2);
        return img;
    }

    private Vector getColData(int col) {
        Vector<Object> ret = new Vector<Object>();
        int row = this.startRow;
        while (row <= this.endRow) {
            Object v = this.dataSheet.cells(row, col).getValue();
            if (v instanceof Vector) {
                ret.addAll((Vector)v);
            } else {
                ret.add(v);
            }
            ++row;
        }
        return ret;
    }

    private ArrayList getData() {
        ArrayList list = null;
        if (this.bindDB) {
            list = this.getDataFromDB();
        } else {
            if (this.startRow == -1) {
                return null;
            }
            list = new ArrayList();
            Vector colseries = null;
            Vector colCategory = null;
            Vector colValue = null;
            Vector colValue2 = null;
            if (this.thirdCol == -1) {
                colCategory = this.getColData(this.firstCol);
                colValue = this.getColData(this.secondCol);
            } else if (this.type.equalsIgnoreCase("gant")) {
                if (this.fourthCol == -1) {
                    colCategory = this.getColData(this.firstCol);
                    colValue = this.getColData(this.secondCol);
                    colValue2 = this.getColData(this.thirdCol);
                } else {
                    colseries = this.getColData(this.firstCol);
                    colCategory = this.getColData(this.secondCol);
                    colValue = this.getColData(this.thirdCol);
                    colValue2 = this.getColData(this.fourthCol);
                }
            } else {
                colseries = this.getColData(this.firstCol);
                colCategory = this.getColData(this.secondCol);
                colValue = this.getColData(this.thirdCol);
            }
            int n = colValue.size();
            int i = 0;
            while (i < n) {
                HashMap map = new HashMap();
                map.put("series", colseries == null ? null : (Object)colseries.get(i));
                map.put("category", colCategory.get(i));
                Object v = colValue.get(i);
                map.put("value", v);
                if (colValue2 == null) {
                    map.put("value2", v);
                } else {
                    Object v2 = colValue2.get(i);
                    map.put("value2", v2);
                }
                list.add(map);
                ++i;
            }
        }
        Cell pCell = this.getParentCell();
        WorkSheet sheet = pCell.getWorkSheet();
        WorkBook book = sheet.getWorkBook();
        book.getEM().fireChartDataDecorate(sheet, this, list);
        return list;
    }

    private ArrayList getDataFromDB() {
        ArrayList list = new ArrayList();
        if (this.ds.getRowCount() == 0) {
            return list;
        }
        if (this.type.equals("gant")) {
            int n = this.ds.getRowCount();
            int i = 0;
            while (i < n) {
                Date d1 = this.ds.getDate(i, this.valueCol);
                Date d2 = this.ds.getDate(i, this.valueCol2);
                if (d1 == null) {
                    d1 = new Date();
                }
                if (d2 == null) {
                    d2 = new Date();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("series", this.ds.getValue(i, this.seriesCol));
                map.put("category", this.ds.getValue(i, this.categoryCol));
                map.put("value", d1);
                map.put("value2", d2);
                list.add(map);
                ++i;
            }
            return list;
        }
        DataStore ds2 = (DataStore)this.ds.clone();
        ds2.createGroups(this.seriesCol.equals("") ? this.categoryCol : String.valueOf(this.seriesCol) + "|" + this.categoryCol);
        String valueColSum = String.valueOf(this.valueCol) + "_temp_sum_741211";
        ds2.createAggregate(0, 1, valueColSum, this.valueCol);
        ArrayList m_VectorGroups = (ArrayList)ds2.getFriendlyProperty("m_VectorGroups");
        ArrayList groupInfo = (ArrayList)m_VectorGroups.get(m_VectorGroups.size() - 1);
        int n = groupInfo.size();
        int i = 0;
        while (i < n) {
            int row = (Integer)groupInfo.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("series", ds2.getValue(row, this.seriesCol));
            map.put("category", ds2.getValue(row, this.categoryCol));
            map.put("value", ds2.getValue(row, valueColSum));
            list.add(map);
            ++i;
        }
        return list;
    }

    private PieDataset createPieDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        ArrayList list = this.getData();
        if (list == null) {
            return dataset;
        }
        int n = list.size();
        int i = 0;
        while (i < n) {
            HashMap map = (HashMap)list.get(i);
            Object v = map.get("category");
            if (v != null) {
                Object v2 = map.get("value");
                try {
                    v2 = ObjectTool.ChangeType(v2, (String)"java.lang.Double");
                }
                catch (Exception e) {
                    v2 = new Double(0.0);
                }
                dataset.setValue((Comparable)((Object)v.toString()), (Number)((Double)v2));
            }
            ++i;
        }
        return dataset;
    }

    private CategoryDataset CategoryDataset() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        ArrayList list = this.getData();
        if (list == null) {
            return dataset;
        }
        int n = list.size();
        int i = 0;
        while (i < n) {
            HashMap map = (HashMap)list.get(i);
            Object series = map.get("series");
            if (series == null) {
                series = "";
            }
            series = series.toString();
            Object category = map.get("category");
            if (category != null) {
                Object v2 = map.get("value");
                try {
                    v2 = ObjectTool.ChangeType(v2, (String)"java.lang.Double");
                }
                catch (Exception e) {
                    v2 = new Double(0.0);
                }
                dataset.addValue((Number)((Double)v2), (Comparable)((Object)category.toString()), (Comparable)((Object)series.toString()));
            }
            ++i;
        }
        return dataset;
    }

    public IntervalCategoryDataset createDataset() {
        TaskSeriesCollection taskseriescollection = new TaskSeriesCollection();
        HashMap seriesMap = new HashMap();
        ArrayList list = this.getData();
        int n = list.size();
        int i = 0;
        while (i < n) {
            HashMap map = (HashMap)list.get(i);
            Object series = map.get("series");
            if (series == null) {
                series = "";
            }
            series = series.toString();
            TaskSeries taskseries = null;
            if (seriesMap.containsKey(series)) {
                taskseries = (TaskSeries)seriesMap.get(series);
            } else {
                taskseries = new TaskSeries((String)series);
                seriesMap.put(series, taskseries);
                taskseriescollection.add(taskseries);
            }
            Object category = map.get("category");
            if (category != null) {
                Object v1 = map.get("value");
                try {
                    v1 = ObjectTool.ChangeType(v1, (String)"java.util.Date");
                }
                catch (Exception e) {
                    v1 = new Date();
                }
                Object v2 = map.get("value2");
                try {
                    v2 = ObjectTool.ChangeType(v2, (String)"java.util.Date");
                }
                catch (Exception e) {
                    v2 = new Date();
                }
                taskseries.add(new Task((String)category, (TimePeriod)new SimpleTimePeriod((Date)v1, (Date)v2)));
            }
            ++i;
        }
        return taskseriescollection;
    }

    public String getRealCaption() {
        String s = this.getCaption().trim();
        if (!s.startsWith("=")) {
            return s;
        }
        Object v = this.getParentCell().getWorkSheet().evaluate(s);
        s = v == null ? "" : v.toString();
        return s;
    }

    private JFreeChart createChart() {
        PiePlot pplot;
        CategoryPlot categoryplot;
        String title = this.getRealCaption();
        JFreeChart chart = null;
        boolean hadseries = true;
        if (this.thirdCol == -1) {
            if (this.type.equalsIgnoreCase("pie")) {
                chart = ChartFactory.createPieChart((String)title, (PieDataset)this.createPieDataset(), (boolean)hadseries, (boolean)true, (boolean)false);
            }
            if (this.type.equalsIgnoreCase("pie3d")) {
                chart = ChartFactory.createPieChart3D((String)title, (PieDataset)this.createPieDataset(), (boolean)hadseries, (boolean)true, (boolean)false);
            }
        } else {
            if (this.type.equalsIgnoreCase("pie")) {
                chart = ChartFactory.createMultiplePieChart((String)title, (CategoryDataset)this.CategoryDataset(), (TableOrder)TableOrder.BY_COLUMN, (boolean)hadseries, (boolean)true, (boolean)false);
            }
            if (this.type.equalsIgnoreCase("pie3d")) {
                chart = ChartFactory.createMultiplePieChart3D((String)title, (CategoryDataset)this.CategoryDataset(), (TableOrder)TableOrder.BY_COLUMN, (boolean)hadseries, (boolean)true, (boolean)false);
            }
        }
        if (this.type.equalsIgnoreCase("ring")) {
            chart = ChartFactory.createRingChart((String)title, (PieDataset)this.createPieDataset(), (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("bar")) {
            chart = ChartFactory.createBarChart((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("bar3d")) {
            chart = ChartFactory.createBarChart3D((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("area")) {
            chart = ChartFactory.createAreaChart((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("cylinder")) {
            chart = ChartFactory.createBarChart3D((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
            categoryplot = (CategoryPlot)chart.getPlot();
            Paint[] apaint = Chart_.createPaint();
            CustomCylinderRenderer customcylinderrenderer = new CustomCylinderRenderer(apaint);
            customcylinderrenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
            customcylinderrenderer.setBaseOutlinePaint(Color.gray);
            customcylinderrenderer.setBaseOutlineStroke(new BasicStroke(0.3f));
            categoryplot.setRenderer((CategoryItemRenderer)customcylinderrenderer);
        }
        if (this.type.equalsIgnoreCase("stack")) {
            chart = ChartFactory.createStackedBarChart((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("stack3d")) {
            chart = ChartFactory.createStackedBarChart3D((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("line")) {
            chart = ChartFactory.createLineChart((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.CategoryDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)hadseries, (boolean)true, (boolean)false);
        }
        if (this.type.equalsIgnoreCase("gant")) {
            chart = ChartFactory.createGanttChart((String)title, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (IntervalCategoryDataset)this.createDataset(), (this.fourthCol > 0 ? 1 : 0) != 0, (boolean)true, (boolean)false);
            categoryplot = (CategoryPlot)chart.getPlot();
            categoryplot.getDomainAxis().setMaximumCategoryLabelWidthRatio(10.0f);
            categoryplot.setRangeCrosshairVisible(true);
            GanttRenderer ganttrenderer = (GanttRenderer)categoryplot.getRenderer();
            ganttrenderer.setDrawBarOutline(false);
        }
        if (chart == null) {
            return null;
        }
        Plot plot = chart.getPlot();
        if (plot instanceof MultiplePiePlot) {
            plot = ((MultiplePiePlot)plot).getPieChart().getPlot();
        }
        plot.setForegroundAlpha(this.alpha);
        plot.setNoDataMessage("\u6ca1\u6709\u6570\u636e");
        if (plot instanceof PiePlot) {
            pplot = (PiePlot)plot;
            StandardPieSectionLabelGenerator generator = new StandardPieSectionLabelGenerator("{0}[{1}]\n[{2}]", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0.00%"));
            pplot.setLabelGenerator((PieSectionLabelGenerator)generator);
            pplot.setSectionOutlinesVisible(false);
            pplot.setLabelFont(new Font("\u5b8b\u4f53", 0, 12));
            pplot.setSimpleLabels(false);
            pplot.setLabelLinkStyle(PieLabelLinkStyle.CUBIC_CURVE);
            if (this.highlightCategory != null) {
                pplot.setExplodePercent((Comparable)((Object)this.highlightCategory), 0.25);
            }
        }
        if (plot instanceof CategoryPlot) {
            pplot = (CategoryPlot)plot;
            CategoryPlot categoryplot2 = (CategoryPlot)plot;
            categoryplot2.setBackgroundPaint((Paint)Color.white);
            categoryplot2.setDomainGridlinesVisible(true);
            categoryplot2.setDomainGridlinePaint((Paint)new Color(13948635));
            categoryplot2.setRangeGridlinesVisible(true);
            categoryplot2.setRangeGridlinePaint((Paint)new Color(13948635));
            CategoryAxis categoryaxis = categoryplot2.getDomainAxis();
            if (this.seriesAngled) {
                categoryaxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
            }
        }
        if (plot instanceof RingPlot) {
            pplot = (RingPlot)plot;
            pplot.setCircular(false);
        }
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBackgroundImageAlpha(100.0f);
        return chart;
    }

    private static Paint[] createPaint() {
        Paint[] apaint = new Paint[]{new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.blue, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.orange, 0.0f, 0.0f, Color.white), new GradientPaint(0.0f, 0.0f, Color.magenta, 0.0f, 0.0f, Color.white)};
        return apaint;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.changed();
    }

    public void changed() {
        this.chart = null;
        super.changed();
    }

    public String getRangeOrDataSource() {
        return this.rangeOrDataSource;
    }

    public void setRangeOrDataSource(String rangeOrDataSource) {
        if (rangeOrDataSource == null) {
            rangeOrDataSource = "";
        }
        this.rangeOrDataSource = rangeOrDataSource;
        this.unBind();
        this.bind();
        this.changed();
    }

    public String getCategoryAxisLabel() {
        return this.categoryAxisLabel;
    }

    public void setCategoryAxisLabel(String categoryAxisLabel) {
        if (categoryAxisLabel == null) {
            categoryAxisLabel = "";
        }
        this.categoryAxisLabel = categoryAxisLabel;
        this.changed();
    }

    public String getValueAxisLabel() {
        return this.valueAxisLabel;
    }

    public void setValueAxisLabel(String valueAxisLabel) {
        if (valueAxisLabel == null) {
            valueAxisLabel = "";
        }
        this.valueAxisLabel = valueAxisLabel;
        this.changed();
    }

    public int getAlpha() {
        return (int)(this.alpha * 100.0f);
    }

    public void setAlpha(int alpha) {
        this.alpha = (float)alpha / 100.0f;
        this.changed();
    }

    public String getHighlightCategory() {
        return this.highlightCategory;
    }

    public void setHighlightCategory(String highlightCategory) {
        if (highlightCategory == null) {
            highlightCategory = "";
        }
        this.highlightCategory = highlightCategory;
        this.changed();
    }

    public String getSeriesCol() {
        return this.seriesCol;
    }

    public void setSeriesCol(String seriesCol) {
        if (seriesCol == null) {
            seriesCol = "";
        }
        this.seriesCol = seriesCol;
        this.changed();
    }

    public String getCategoryCol() {
        return this.categoryCol;
    }

    public void setCategoryCol(String categoryCol) {
        if (categoryCol == null) {
            categoryCol = "";
        }
        this.categoryCol = categoryCol;
        this.changed();
    }

    public String getSeriesColMap() {
        if (this.seriesColMap == null) {
            return "";
        }
        return this.seriesColMap;
    }

    public void setSeriesColMap(String seriesColMap_) {
        if (seriesColMap_ == null) {
            seriesColMap_ = "";
        }
        this.seriesColMap = seriesColMap_;
        this.changed();
    }

    public String getCategoryColMap() {
        return this.categoryColMap;
    }

    public void setCategoryColMap(String categoryColMap) {
        if (categoryColMap == null) {
            categoryColMap = "";
        }
        this.categoryColMap = categoryColMap;
        this.changed();
    }

    public String getValueCol() {
        return this.valueCol;
    }

    public void setValueCol(String valueCol) {
        this.valueCol = valueCol;
        this.changed();
    }

    public String getValueCol2() {
        return this.valueCol2;
    }

    public void setValueCol2(String valueCol2) {
        this.valueCol2 = valueCol2;
        this.changed();
    }

    public boolean isSeriesAngled() {
        return this.seriesAngled;
    }

    public void setSeriesAngled(boolean seriesAngled) {
        this.seriesAngled = seriesAngled;
        this.changed();
    }

    public boolean isBindDB() {
        return this.bindDB;
    }

    public void OnLButtonDblClk(WorkSheetView_ pView, MouseEvent e) {
        Rectangle rc = ((WorkSheetView_)this.pCell.getWorkSheet().getWorkSheetView()).getShowRectangleOfCell(false, this.pCell.getRowIndex(), this.pCell.getColumnIndex());
        rc = this.getBounds(rc);
        rc.intersects(-10.0, -10.0, -10.0, -10.0);
        JDialog jf = new JDialog(JOptionPane.getFrameForComponent(pView), "\u56fe\u5f62\u5206\u6790", true);
        jf.getContentPane().add((Component)new ChartPanel(this.chart));
        jf.setBounds(rc);
        jf.setDefaultCloseOperation(2);
        Tools.MoveToScreenCenter(jf);
        jf.setVisible(true);
    }

    class CustomCylinderRenderer
    extends CylinderRenderer {
        private Paint[] colors;

        public Paint getItemPaint(int i, int j) {
            return this.colors[j % this.colors.length];
        }

        public CustomCylinderRenderer(Paint[] apaint) {
            this.colors = apaint;
        }
    }
}

