/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.swing.JButton;
import javax.swing.JDialog;

public class Camera
extends JDialog
implements WindowListener,
MouseListener,
MouseMotionListener {
    public static Player player = null;
    private CaptureDeviceInfo di = null;
    private MediaLocator ml = null;
    private JButton capture;
    private Buffer buf = null;
    private BufferToImage btoi = null;
    private Image img = null;
    Component comp;
    private int W;
    private int H;
    private int CW;
    private int CH;
    private Point mousePoint;
    Timer timer = null;
    private byte[] ret = null;

    public Camera(int w, int h, int cw, int ch) {
        super((Frame)null, true);
        this.W = w;
        this.H = h;
        this.CW = cw;
        this.CH = ch;
        Container cc = this.getContentPane();
        cc.setLayout(new BorderLayout());
        String str1 = "vfw:Logitech USB Video Camera:0";
        String str2 = "vfw:Microsoft WDM Image Capture (Win32):0";
        this.di = CaptureDeviceManager.getDevice((String)str2);
        this.ml = this.di.getLocator();
        try {
            player = Manager.createRealizedPlayer((MediaLocator)this.ml);
            player.start();
            this.comp = player.getVisualComponent();
            if (this.comp != null) {
                this.comp.setSize(new Dimension(this.W, this.H));
                this.add(this.comp, "Center");
                DrawFocus df = new DrawFocus();
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)df, 0L, 10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JButton jb = new JButton("action");
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Camera.this.Action();
            }
        });
        this.setLocation(10, 10);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.comp.addMouseListener(this);
        this.comp.addMouseMotionListener(this);
    }

    public void Action() {
        FrameGrabbingControl fgc = (FrameGrabbingControl)player.getControl("javax.media.control.FrameGrabbingControl");
        this.buf = fgc.grabFrame();
        this.btoi = new BufferToImage((VideoFormat)this.buf.getFormat());
        this.img = this.btoi.createImage(this.buf);
        BufferedImage bi = (BufferedImage)this.createImage(this.CW, this.CH);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(this.img, -(this.mousePoint.x - this.CW / 2), -(this.mousePoint.y - this.CH / 2), null);
        try {
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bo);
                ImageIO.write((RenderedImage)bi, "png", bos);
                bos.flush();
                bos.close();
                this.ret = bo.toByteArray();
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                g2.dispose();
            }
        }
        finally {
            g2.dispose();
        }
    }

    public byte[] getImage() {
        return this.ret;
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (player != null) {
                player.stop();
                player.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        this.Action();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.mousePoint = e.getPoint();
    }

    class DrawFocus
    extends TimerTask {
        DrawFocus() {
        }

        public void run() {
            try {
                if (Camera.this.mousePoint == null) {
                    return;
                }
                Graphics g = Camera.this.comp.getGraphics();
                g.setColor(Color.WHITE);
                g.drawRect(((Camera)Camera.this).mousePoint.x - Camera.this.CW / 2 - 1, ((Camera)Camera.this).mousePoint.y - Camera.this.CH / 2 - 1, Camera.this.CW + 2, Camera.this.CH + 2);
                g.setColor(Color.BLACK);
                g.drawRect(((Camera)Camera.this).mousePoint.x - Camera.this.CW / 2 - 2, ((Camera)Camera.this).mousePoint.y - Camera.this.CH / 2 - 2, Camera.this.CW + 4, Camera.this.CH + 4);
                g.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

