/*
 * Decompiled with CFR 0.152.
 */
package excel.brick.impl;

import excel.brick.Brick;
import excel.core.Cell;
import excel.core.ChangeListener;
import excel.core.WorkSheetView;
import excel.core.impl.Cell_;
import excel.core.impl.WorkSheetView_;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class BasicBrick
implements Brick,
Cloneable,
Serializable,
ChangeListener {
    boolean dynamicCreate = false;
    public int fontSize = 12;
    String Caption = "";
    String connection = "";
    transient Cell_ pCell;
    int X;
    int Y;
    int Height;
    int Width;
    int Action;
    boolean FixedSize = false;
    boolean OnFocus = false;
    String Name = "";
    boolean Printable = true;
    public boolean DownAtMe = false;
    public boolean UpAtMe = false;
    public boolean m_Enabled = true;
    public boolean m_Visible = true;
    public boolean m_Locked = false;
    private Object tag = null;
    private String DataSource;
    public static Cursor HandCursor = new Cursor(12);
    public static Cursor WaitCursor = new Cursor(3);
    public String rootValue;
    public String rootLabel;
    public String m_select;
    boolean m_autoLoad = true;
    boolean lazyLoading = true;
    boolean isMulti = false;
    boolean isExportAllWithoutDataPageLimit = false;

    public BasicBrick(String name, int action) {
        this.Action = action;
        this.Name = name;
    }

    public void afterAddToCell() {
    }

    public void bind() {
    }

    public void unBind() {
    }

    public boolean isDynamicCreate() {
        return this.dynamicCreate;
    }

    public void paint(boolean isPrint, Graphics2D g, Rectangle parentRC) {
    }

    public Rectangle getBounds(Rectangle pRect) {
        int t = 0;
        Rectangle tc = new Rectangle();
        int left = pRect.x;
        int right = pRect.x + pRect.width;
        int top = pRect.y;
        int bottom = pRect.y + pRect.height;
        int viewWidth = pRect.width;
        int viewHeight = pRect.height;
        WorkSheetView view = this.getWorkSheetView();
        if (view != null) {
            Rectangle viewRC = view.getBounds();
            viewWidth = viewRC.width;
            viewHeight = viewRC.height;
        }
        tc.x = (t = this.X) >= 0 ? Math.min(left + t, right) : Math.max(left, Math.max(right + t, 0));
        t = this.Y;
        tc.y = t >= 0 ? Math.min(top + t, bottom) : Math.max(top, Math.max(bottom + t, 0));
        t = this.Width;
        if (t == 0) {
            tc.width = right - tc.x;
        }
        if (t > 0) {
            tc.width = Math.min(tc.x + t, right) - tc.x;
        }
        if (t < 0) {
            tc.width = Math.max(tc.x, Math.max(right + t, 0)) - tc.x;
        }
        if (t <= -10000) {
            tc.width = Math.max(tc.x, Math.max(viewWidth + (t + 10000), 0)) - tc.x;
        }
        if ((t = this.Height) == 0) {
            tc.height = bottom - tc.y;
        }
        if (t > 0) {
            tc.height = Math.min(tc.y + t, bottom) - tc.y;
        }
        if (t < 0) {
            tc.height = Math.max(tc.y, Math.max(bottom + t, 0)) - tc.y;
        }
        if (t <= -10000) {
            tc.height = Math.max(tc.y, Math.max(viewHeight + (t + 10000), 0)) - tc.y;
        }
        if (tc.height < 0) {
            tc.height = 0;
        }
        if (tc.width < 0) {
            tc.width = 0;
        }
        return tc;
    }

    public Cell getParentCell() {
        return this.pCell;
    }

    public void invalidate() {
        this.pCell.repaint();
    }

    public void setParentCell(Cell parentCell) {
        this.pCell = (Cell_)parentCell;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.X = x;
        this.Y = y;
        if (!this.FixedSize) {
            this.Height = h;
            this.Width = w;
        }
    }

    public void setParent(Cell parentCell) {
        this.pCell = (Cell_)parentCell;
    }

    public void keyPressed(WorkSheetView_ pView, KeyEvent e) {
    }

    public void keyReleased(WorkSheetView_ pView, KeyEvent e) {
    }

    public void OnLButtonClick(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnLButtonDblClk(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnLButtonDown(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.DownAtMe = this.contains(e.getPoint());
    }

    public void OnLButtonUp(WorkSheetView_ pView, MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        this.UpAtMe = this.contains(e.getPoint());
        if (this.DownAtMe && this.UpAtMe) {
            this.OnClick();
        }
        this.DownAtMe = false;
    }

    public void OnMouseDrag(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnMouseEntered(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnMouseExited(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnMouseMove(WorkSheetView_ pView, MouseEvent e) {
    }

    public void OnRButtonDown(WorkSheetView_ pView, MouseEvent e) {
    }

    public boolean isOnFocus() {
        return this.OnFocus;
    }

    public void setFocus(boolean focus) {
        this.OnFocus = focus;
    }

    public boolean contains(Point p) {
        Rectangle rc = ((WorkSheetView_)this.getWorkSheetView()).getShowRectangleOfCell(false, this.pCell.getRowIndex(), this.pCell.getColumnIndex());
        rc = this.getBounds(rc);
        return rc.contains(p);
    }

    public boolean isPrintable() {
        return this.Printable;
    }

    public void setPrintable(boolean b) {
        this.Printable = b;
    }

    public void OnClick() {
    }

    public Object clone() {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
            ObjectOutputStream oo = new ObjectOutputStream(bao);
            oo.writeObject(this);
            oo.flush();
            oo.close();
            ByteArrayInputStream bai = new ByteArrayInputStream(bao.toByteArray());
            ObjectInputStream oi = new ObjectInputStream(bai);
            return (BasicBrick)oi.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getAction() {
        return this.Action;
    }

    public String getName() {
        return this.Name;
    }

    public int getX() {
        return this.X;
    }

    public void setX(int x) {
        this.X = x;
    }

    public int getY() {
        return this.Y;
    }

    public void setY(int y) {
        this.Y = y;
    }

    public int getHeight() {
        return this.Height;
    }

    public void setHeight(int height) {
        this.Height = height;
    }

    public int getWidth() {
        return this.Width;
    }

    public void setWidth(int width) {
        this.Width = width;
    }

    public String getCaption() {
        return this.Caption;
    }

    public void setCaption(String caption) {
        if (caption == null) {
            caption = "";
        }
        this.Caption = caption;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        if (tag == null) {
            tag = "";
        }
        this.tag = tag;
    }

    public String getDataSource() {
        return this.DataSource;
    }

    public void setDataSource(String dataSource) {
        if (dataSource == null) {
            dataSource = null;
        }
        this.DataSource = dataSource;
    }

    public void changed() {
        if (this.getParentCell() != null) {
            this.getParentCell().repaint();
        }
    }

    public boolean isEnabled() {
        if (this.pCell != null && this.pCell.getWorkSheet().getWorkBook().isAllBrickDisabled()) {
            return false;
        }
        return this.m_Enabled;
    }

    public boolean isVisible() {
        return this.m_Visible;
    }

    public void setEnabled(boolean enabled) {
        this.m_Enabled = enabled;
        this.changed();
    }

    public void setVisible(boolean visible) {
        this.m_Visible = visible;
        this.changed();
    }

    public boolean isLocked() {
        return this.m_Locked;
    }

    public void setLocked(boolean lock) {
        this.m_Locked = lock;
        this.changed();
    }

    public WorkSheetView getWorkSheetView() {
        if (this.pCell == null) {
            return null;
        }
        return this.pCell.getWorkSheet().getWorkSheetView();
    }

    public void setValue(Object v) {
    }

    public Object getValue() {
        return null;
    }

    public String getCurrentGroup() {
        return null;
    }

    public void setCurrentGroup(String group) {
    }

    public String getFilter() {
        return null;
    }

    public void setFilter(String key) {
    }

    public String getSelect() {
        return this.m_select;
    }

    public void setSelect(String sql) {
        this.m_select = sql;
        if (this.m_select == null) {
            this.m_select = "";
        }
    }

    public String getRootValue() {
        return this.rootValue;
    }

    public void setRootValue(String v) {
        this.rootValue = v;
        if (this.rootValue == null) {
            this.rootValue = "";
        }
    }

    public String getRootLabel() {
        return this.rootLabel;
    }

    public void setRootLabel(String label) {
        this.rootLabel = label;
        if (this.rootLabel == null) {
            this.rootLabel = "";
        }
    }

    public boolean isMultiSelection() {
        return this.isMulti;
    }

    public void setMultiSelection(boolean m) {
        this.isMulti = m;
    }

    public boolean isAutoLoad() {
        return this.m_autoLoad;
    }

    public void setAutoLoad(boolean auto) {
        this.m_autoLoad = auto;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String dbpool) {
        this.connection = dbpool;
        if (this.connection == null) {
            this.connection = "";
        }
    }

    public void setLazyLoading(boolean lazy) {
        this.lazyLoading = lazy;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setExportAllWithoutDataPageLimit(boolean b) {
        this.isExportAllWithoutDataPageLimit = b;
    }

    public boolean isExportAllWithoutDataPageLimit() {
        return this.isExportAllWithoutDataPageLimit;
    }
}

