/*
 * Decompiled with CFR 0.152.
 */
package excel.barcode;

import excel.barcode.BarCode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.JApplet;

public class BarCodeApplet
extends JApplet {
    public BarCode barcode = null;

    public void start() {
        this.barcode.barType = 17;
        this.barcode.code = "90HF232423423423232323424";
    }

    public void refresh() {
        this.barcode.paint(this.barcode.getGraphics());
        this.paintAll(this.getGraphics());
    }

    public void init() {
        if (this.barcode == null) {
            this.barcode = new BarCode();
        }
    }

    private void initParameter() {
        try {
            this.setParameter("barType", this.getParameter("barType"));
            this.setParameter("code", this.getParameter("barcode"));
            this.setParameter("st", this.getParameter("st"));
            this.setParameter("textFont", this.getParameter("textFont"));
            this.setParameter("fontColor", this.getParameter("fontColor"));
            this.setParameter("barColor", this.getParameter("barColor"));
            this.setParameter("backColor", this.getParameter("backColor"));
            this.setParameter("rotate", this.getParameter("rotate"));
            this.setParameter("barHeightCM", this.getParameter("barHeightCM"));
            this.setParameter("x", this.getParameter("x"));
            this.setParameter("n", this.getParameter("n"));
            this.setParameter("leftMarginCM", this.getParameter("leftMarginCM"));
            this.setParameter("topMarginCM", this.getParameter("topMarginCM"));
            this.setParameter("checkCharacter", this.getParameter("checkCharacter"));
            this.setParameter("checkCharacterInText", this.getParameter("checkCharacterInText"));
            this.setParameter("Code128Set", this.getParameter("Code128Set"));
            this.setParameter("UPCESytem", this.getParameter("UPCESytem"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.barcode.code = "Parameter Error";
        }
    }

    public void setParameter(String s, String s1) {
        if (s1 != null) {
            if (s.equals("code")) {
                this.barcode.code = s1;
            } else if (s.equals("st")) {
                this.barcode.showText = s1.equalsIgnoreCase("y");
            } else if (s.equals("textFont")) {
                this.barcode.textFont = this.convertFont(s1);
            } else if (s.equals("fontColor")) {
                this.barcode.fontColor = this.convertColor(s1);
            } else if (s.equals("barColor")) {
                this.barcode.barColor = this.convertColor(s1);
            } else if (s.equals("backColor")) {
                this.barcode.backColor = this.convertColor(s1);
            } else if (s.equals("rotate")) {
                this.barcode.rotate = new Integer(s1);
            } else if (s.equals("barHeightCM")) {
                this.barcode.barHeightCM = new Double(s1);
            } else if (s.equals("x")) {
                this.barcode.X = new Double(s1);
            } else if (s.equals("n")) {
                this.barcode.N = new Double(s1);
            } else if (s.equals("leftMarginCM")) {
                this.barcode.leftMarginCM = new Double(s1);
            } else if (s.equals("topMarginCM")) {
                this.barcode.topMarginCM = new Double(s1);
            } else if (s.equals("checkCharacter")) {
                this.barcode.checkCharacter = s1.equalsIgnoreCase("y");
            } else if (s.equals("checkCharacterInText")) {
                this.barcode.checkCharacterInText = s1.equalsIgnoreCase("y");
            } else if (s.equals("Code128Set")) {
                this.barcode.Code128Set = s1.charAt(0);
            } else if (s.equals("UPCESytem")) {
                this.barcode.UPCESytem = s1.charAt(0);
            } else if (s.equals("barType")) {
                if (s1.equalsIgnoreCase("CODE39")) {
                    this.barcode.barType = 0;
                } else if (s1.equalsIgnoreCase("CODE39EXT")) {
                    this.barcode.barType = 1;
                } else if (s1.equalsIgnoreCase("INTERLEAVED25")) {
                    this.barcode.barType = 2;
                } else if (s1.equalsIgnoreCase("CODE11")) {
                    this.barcode.barType = 3;
                } else if (s1.equalsIgnoreCase("CODABAR")) {
                    this.barcode.barType = 4;
                } else if (s1.equalsIgnoreCase("MSI")) {
                    this.barcode.barType = 5;
                } else if (s1.equalsIgnoreCase("UPCA")) {
                    this.barcode.barType = 6;
                } else if (s1.equalsIgnoreCase("IND25")) {
                    this.barcode.barType = 7;
                } else if (s1.equalsIgnoreCase("MAT25")) {
                    this.barcode.barType = 8;
                } else if (s1.equalsIgnoreCase("CODE93")) {
                    this.barcode.barType = 9;
                } else if (s1.equalsIgnoreCase("EAN13")) {
                    this.barcode.barType = 10;
                } else if (s1.equalsIgnoreCase("EAN8")) {
                    this.barcode.barType = 11;
                } else if (s1.equalsIgnoreCase("UPCE")) {
                    this.barcode.barType = 12;
                } else if (s1.equalsIgnoreCase("CODE128")) {
                    this.barcode.barType = 13;
                    this.barcode.Code128Set = (char)48;
                } else if (s1.equalsIgnoreCase("CODE128A")) {
                    this.barcode.barType = 13;
                    this.barcode.Code128Set = (char)65;
                }
            }
        }
        if (s1.equalsIgnoreCase("CODE128B")) {
            this.barcode.barType = 13;
            this.barcode.Code128Set = (char)66;
        }
        if (s1.equalsIgnoreCase("CODE128C")) {
            this.barcode.barType = 13;
            this.barcode.Code128Set = (char)67;
        } else if (s1.equalsIgnoreCase("CODE93EXT")) {
            this.barcode.barType = 14;
        } else if (s1.equalsIgnoreCase("POSTNET")) {
            this.barcode.barType = 15;
        } else if (s1.equalsIgnoreCase("PLANET")) {
            this.barcode.barType = 16;
        } else if (s1.equalsIgnoreCase("UCC128")) {
            this.barcode.barType = 17;
        }
    }

    private Font convertFont(String s) {
        StringTokenizer stringtokenizer = new StringTokenizer(s, "|");
        String s1 = stringtokenizer.nextToken();
        String s2 = stringtokenizer.nextToken();
        String s3 = stringtokenizer.nextToken();
        int byte0 = -1;
        if (s2.trim().toUpperCase().equals("PLAIN")) {
            byte0 = 0;
        } else if (s2.trim().toUpperCase().equals("BOLD")) {
            byte0 = 1;
        } else if (s2.trim().toUpperCase().equals("ITALIC")) {
            byte0 = 2;
        }
        return new Font(s1, byte0, new Integer(s3));
    }

    private Color convertColor(String s) {
        Color color = null;
        if (s.trim().toUpperCase().equals("RED")) {
            color = Color.red;
        } else if (s.trim().toUpperCase().equals("BLACK")) {
            color = Color.black;
        } else if (s.trim().toUpperCase().equals("BLUE")) {
            color = Color.blue;
        } else if (s.trim().toUpperCase().equals("CYAN")) {
            color = Color.cyan;
        } else if (s.trim().toUpperCase().equals("DARKGRAY")) {
            color = Color.darkGray;
        } else if (s.trim().toUpperCase().equals("GRAY")) {
            color = Color.gray;
        } else if (s.trim().toUpperCase().equals("GREEN")) {
            color = Color.green;
        } else if (s.trim().toUpperCase().equals("LIGHTGRAY")) {
            color = Color.lightGray;
        } else if (s.trim().toUpperCase().equals("MAGENTA")) {
            color = Color.magenta;
        } else if (s.trim().toUpperCase().equals("ORANGE")) {
            color = Color.orange;
        } else if (s.trim().toUpperCase().equals("PINK")) {
            color = Color.pink;
        } else if (s.trim().toUpperCase().equals("WHITE")) {
            color = Color.white;
        } else if (s.trim().toUpperCase().equals("YELLOW")) {
            color = Color.yellow;
        }
        return color;
    }

    public void paint(Graphics g) {
        this.barcode.setSize(this.barcode.width, this.barcode.height);
        if (this.barcode.autoSize) {
            BufferedImage bufferedimage = new BufferedImage(this.barcode.getSize().width, this.barcode.getSize().height, 13);
            Graphics2D graphics2d = bufferedimage.createGraphics();
            this.barcode.paint(graphics2d);
            this.barcode.invalidate();
            graphics2d.dispose();
        }
        BufferedImage bufferedimage1 = new BufferedImage(this.barcode.getSize().width, this.barcode.getSize().height, 1);
        Graphics2D graphics2d1 = bufferedimage1.createGraphics();
        this.barcode.paint(graphics2d1);
        g.drawImage(bufferedimage1, 0, 0, null);
    }
}

