/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.sip.sdk.isv;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Properties loadProperties(String fullPath) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            File file = new File(fullPath);
            if (file.exists()) {
                fis = new FileInputStream(fullPath);
                props.load(fis);
            } else {
                System.out.println(fullPath + " not exist ");
            }
        }
        catch (Exception e) {
            System.out.println("loadProperties error " + e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return props;
    }

    public static StringBuffer parseParam2QueryString(Map<String, String[]> parameterMap) {
        StringBuffer url = new StringBuffer();
        if (parameterMap == null || parameterMap.size() <= 0) {
            return url;
        }
        for (String key : parameterMap.keySet()) {
            String[] value = parameterMap.get(key);
            for (int i = 0; i < value.length; ++i) {
                url.append(key);
                url.append("=");
                url.append(value[i]);
                url.append("&");
            }
        }
        url.deleteCharAt(url.length() - 1);
        return url;
    }

    public static String encodeURL(Object target) {
        String result = target != null ? target.toString() : "";
        try {
            result = URLEncoder.encode(result, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }
}

