/*
 * Decompiled with CFR 0.152.
 */
package com.alisoft.sip.sdk.isv;

import com.alisoft.sip.sdk.isv.Constants;
import com.alisoft.sip.sdk.isv.SignatureUtil;
import com.alisoft.sip.sdk.isv.SipResult;
import com.alisoft.sip.sdk.isv.SipStatus;
import com.alisoft.sip.sdk.isv.SipUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestConnector {
    private static Properties config;

    public SipResult invoke(String sip_apiname, String apiURL, Map<String, String> params, String method) throws Exception {
        return this.invoke(sip_apiname, apiURL, params, method, false);
    }

    public SipResult invokeFree(String sip_apiname, String apiURL, Map<String, String> params, String method) throws Exception {
        return this.invoke(sip_apiname, apiURL, params, method, true);
    }

    private SipResult invoke(String sip_apiname, String apiURL, Map<String, String> params, String method, boolean isfree) throws Exception {
        if (apiURL == null) {
            throw new IllegalArgumentException("apiURL is null");
        }
        if (config == null) {
            throw new IllegalArgumentException("config is null");
        }
        String sip_appkey = config.getProperty("sip_appkey");
        String sip_appsecret = config.getProperty("sip_appsecret");
        if (sip_appkey == null) {
            throw new IllegalArgumentException("sip_appkey is null in config");
        }
        if (sip_appsecret == null) {
            throw new IllegalArgumentException("sip_appsecret is null in config");
        }
        if (sip_apiname == null) {
            throw new IllegalArgumentException("sip_apiname is null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params is null");
        }
        if (method == null) {
            method = "GET";
        }
        String sip_timestamp = Constants.SIP_TIMESTAMP_FORMATER.format(new Date());
        params.put("sip_appkey", sip_appkey);
        params.put("sip_apiname", sip_apiname);
        params.put("sip_timestamp", sip_timestamp);
        if (!isfree) {
            String sign = SignatureUtil.Signature(params, sip_appsecret);
            params.put("sip_sign", sign);
        }
        return this.sendRequest(apiURL, params, method);
    }

    private SipResult sendRequest(String apiURL, Map<String, String> params, String method) throws Exception {
        String line;
        String queryString = null == params ? "" : this.delimit(params.entrySet(), true);
        HttpURLConnection conn = (HttpURLConnection)new URL(apiURL).openConnection();
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.connect();
        conn.getOutputStream().write(queryString.getBytes());
        String charset = this.getChareset(conn.getContentType());
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer buffer = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        reader.close();
        String code = conn.getHeaderField("sip_status");
        conn.disconnect();
        SipResult result = new SipResult(SipStatus.getStatus(code), buffer.toString());
        return result;
    }

    private String getChareset(String contentType) {
        int i = contentType == null ? -1 : contentType.indexOf("charset=");
        return i == -1 ? "UTF-8" : contentType.substring(i + 8);
    }

    private String delimit(Collection<Map.Entry<String, String>> entries, boolean doEncode) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        boolean notFirst = false;
        for (Map.Entry<String, String> entry : entries) {
            if (notFirst) {
                buffer.append("&");
            } else {
                notFirst = true;
            }
            String value = entry.getValue();
            buffer.append(entry.getKey()).append("=").append((Object)(doEncode ? SipUtil.encodeURL(value) : value));
        }
        return buffer.toString();
    }

    public static Properties getConfig() {
        return config;
    }

    public static void setConfig(Properties prop) {
        config = prop;
    }
}

