/*
 * Decompiled with CFR 0.152.
 */
package org2.mozilla.javascript.tools.debugger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org2.mozilla.javascript.tools.debugger.SwingGui;

class Menubar
extends JMenuBar
implements ActionListener {
    static final long serialVersionUID = 3217170497245911461L;
    private Vector interruptOnlyItems = new Vector();
    private Vector runOnlyItems = new Vector();
    SwingGui debugGui;
    JMenu windowMenu;
    JCheckBoxMenuItem breakOnExceptions;
    JCheckBoxMenuItem breakOnEnter;
    JCheckBoxMenuItem breakOnReturn;

    JMenu getDebugMenu() {
        return this.getMenu(2);
    }

    Menubar(SwingGui debugGui) {
        KeyStroke k;
        JMenuItem item;
        this.debugGui = debugGui;
        String[] fileItems = new String[]{"\u6253\u5f00...", "\u8fd0\u884c...", "", "\u9000\u51fa"};
        String[] fileCmds = new String[]{"Open", "Load", "", "Exit"};
        char[] cArray = new char[4];
        cArray[0] = 48;
        cArray[1] = 78;
        cArray[3] = 88;
        char[] fileShortCuts = cArray;
        int[] nArray = new int[4];
        nArray[0] = 79;
        nArray[1] = 78;
        nArray[3] = 81;
        int[] fileAccelerators = nArray;
        String[] editItems = new String[]{"\u526a\u5207", "\u590d\u5236", "\u7c98\u8d34", "\u8df3\u8f6c\u5230\u51fd\u6570..."};
        char[] editShortCuts = new char[]{'T', 'C', 'P', 'F'};
        String[] debugItems = new String[]{"\u4e2d\u65ad", "\u8fd0\u884c", "\u5355\u6b65\u8fdb\u5165", "\u5355\u6b65\u6267\u884c", "\u5355\u6b65\u8df3\u51fa"};
        char[] debugShortCuts = new char[]{'B', 'G', 'I', 'O', 'T'};
        String[] plafItems = new String[]{"Metal", "Windows", "Motif"};
        char[] plafShortCuts = new char[]{'M', 'W', 'F'};
        int[] nArray2 = new int[7];
        nArray2[0] = 19;
        nArray2[1] = 116;
        nArray2[2] = 122;
        nArray2[3] = 118;
        nArray2[4] = 119;
        int[] debugAccelerators = nArray2;
        JMenu fileMenu = new JMenu("\u6587\u4ef6");
        fileMenu.setMnemonic('F');
        JMenu editMenu = new JMenu("\u7f16\u8f91");
        editMenu.setMnemonic('E');
        JMenu plafMenu = new JMenu("Platform");
        plafMenu.setMnemonic('P');
        JMenu debugMenu = new JMenu("\u8c03\u8bd5");
        debugMenu.setMnemonic('D');
        this.windowMenu = new JMenu("\u7a97\u53e3");
        this.windowMenu.setMnemonic('W');
        int i = 0;
        while (i < fileItems.length) {
            if (fileItems[i].length() == 0) {
                fileMenu.addSeparator();
            } else {
                item = new JMenuItem(fileItems[i], fileShortCuts[i]);
                item.setActionCommand(fileCmds[i]);
                item.addActionListener(this);
                fileMenu.add(item);
                if (fileAccelerators[i] != 0) {
                    k = KeyStroke.getKeyStroke(fileAccelerators[i], 2);
                    item.setAccelerator(k);
                }
            }
            ++i;
        }
        i = 0;
        while (i < editItems.length) {
            item = new JMenuItem(editItems[i], editShortCuts[i]);
            item.addActionListener(this);
            editMenu.add(item);
            ++i;
        }
        i = 0;
        while (i < plafItems.length) {
            item = new JMenuItem(plafItems[i], plafShortCuts[i]);
            item.addActionListener(this);
            plafMenu.add(item);
            ++i;
        }
        i = 0;
        while (i < debugItems.length) {
            item = new JMenuItem(debugItems[i], debugShortCuts[i]);
            item.addActionListener(this);
            if (debugAccelerators[i] != 0) {
                k = KeyStroke.getKeyStroke(debugAccelerators[i], 0);
                item.setAccelerator(k);
            }
            if (i != 0) {
                this.interruptOnlyItems.add(item);
            } else {
                this.runOnlyItems.add(item);
            }
            debugMenu.add(item);
            ++i;
        }
        this.breakOnExceptions = new JCheckBoxMenuItem("\u53d1\u751f\u5f02\u5e38\u65f6\u4e2d\u65ad");
        this.breakOnExceptions.setMnemonic('X');
        this.breakOnExceptions.addActionListener(this);
        this.breakOnExceptions.setSelected(false);
        debugMenu.add(this.breakOnExceptions);
        this.breakOnEnter = new JCheckBoxMenuItem("\u5728\u51fd\u6570\u5f00\u59cb\u4e2d\u65ad");
        this.breakOnEnter.setMnemonic('E');
        this.breakOnEnter.addActionListener(this);
        this.breakOnEnter.setSelected(false);
        debugMenu.add(this.breakOnEnter);
        this.breakOnReturn = new JCheckBoxMenuItem("\u5728\u51fd\u6570\u8fd4\u56de\u65f6\u4e2d\u65ad");
        this.breakOnReturn.setMnemonic('R');
        this.breakOnReturn.addActionListener(this);
        this.breakOnReturn.setSelected(false);
        debugMenu.add(this.breakOnReturn);
        this.add(fileMenu);
        this.add(editMenu);
        this.add(debugMenu);
        JMenuItem item2 = new JMenuItem("\u5c42\u53e0", 65);
        this.windowMenu.add(item2);
        item2.addActionListener(this);
        item2 = new JMenuItem("\u6807\u9898", 84);
        this.windowMenu.add(item2);
        item2.addActionListener(this);
        this.windowMenu.addSeparator();
        item2 = new JMenuItem("\u63a7\u5236\u53f0", 67);
        this.windowMenu.add(item2);
        item2.addActionListener(this);
        this.add(this.windowMenu);
        this.updateEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        String plaf_name = null;
        if (cmd.equals("Metal")) {
            plaf_name = "javax.swing.plaf.metal.MetalLookAndFeel";
        } else if (cmd.equals("Windows")) {
            plaf_name = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        } else if (cmd.equals("Motif")) {
            plaf_name = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
        } else {
            Object source = e.getSource();
            if (source == this.breakOnExceptions) {
                this.debugGui.dim.breakOnExceptions = this.breakOnExceptions.isSelected();
            } else if (source == this.breakOnEnter) {
                this.debugGui.dim.breakOnEnter = this.breakOnEnter.isSelected();
            } else if (source == this.breakOnReturn) {
                this.debugGui.dim.breakOnReturn = this.breakOnReturn.isSelected();
            } else {
                this.debugGui.actionPerformed(e);
            }
            return;
        }
        try {
            UIManager.setLookAndFeel(plaf_name);
            SwingUtilities.updateComponentTreeUI(this.debugGui);
            SwingUtilities.updateComponentTreeUI(this.debugGui.dlg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addFile(String url) {
        JMenuItem item;
        int count = this.windowMenu.getItemCount();
        if (count == 4) {
            this.windowMenu.addSeparator();
            ++count;
        }
        JMenuItem lastItem = this.windowMenu.getItem(count - 1);
        boolean hasMoreWin = false;
        int maxWin = 5;
        if (lastItem != null && lastItem.getText().equals("More Windows...")) {
            hasMoreWin = true;
            ++maxWin;
        }
        if (!hasMoreWin && count - 4 == 5) {
            JMenuItem item2 = new JMenuItem("More Windows...", 77);
            this.windowMenu.add(item2);
            item2.setActionCommand("More Windows...");
            item2.addActionListener(this);
            return;
        }
        if (count - 4 <= maxWin) {
            if (hasMoreWin) {
                --count;
                this.windowMenu.remove(lastItem);
            }
            String shortName = SwingGui.getShortName(url);
            item = new JMenuItem(String.valueOf((char)(48 + (count - 4))) + " " + shortName, 48 + (count - 4));
            this.windowMenu.add(item);
            if (hasMoreWin) {
                this.windowMenu.add(lastItem);
            }
        } else {
            return;
        }
        item.setActionCommand(url);
        item.addActionListener(this);
    }

    void updateEnabled(boolean interrupted) {
        JMenuItem item;
        int i = 0;
        while (i != this.interruptOnlyItems.size()) {
            item = (JMenuItem)this.interruptOnlyItems.elementAt(i);
            item.setEnabled(interrupted);
            ++i;
        }
        i = 0;
        while (i != this.runOnlyItems.size()) {
            item = (JMenuItem)this.runOnlyItems.elementAt(i);
            item.setEnabled(!interrupted);
            ++i;
        }
    }
}

