/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class EvaluatorVisitor
implements ParserVisitor {
    private Stack stack = new Stack();
    private Vector errorList = null;
    private SymbolTable symTab = null;
    private boolean errorFlag;
    private static final boolean debug = false;

    private void addToErrorList(String errorStr) {
        if (this.errorList != null) {
            this.errorList.addElement(errorStr);
        }
    }

    public Object getValue(Node topNode, Vector errorList_in, SymbolTable symTab_in) throws Exception {
        if (topNode == null) {
            throw new IllegalArgumentException("topNode parameter is null");
        }
        this.errorList = errorList_in;
        this.symTab = symTab_in;
        this.errorFlag = false;
        topNode.jjtAccept(this, null);
        if (this.errorFlag || this.stack.size() != 1) {
            throw new Exception("EvaluatorVisitor.getValue(): Error during evaluation");
        }
        return this.stack.pop();
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }

    public Object visit(ASTStart node, Object data) {
        return data;
    }

    public Object visit(ASTFunNode node, Object data) {
        if (node == null) {
            return null;
        }
        data = node.childrenAccept(this, data);
        PostfixMathCommandI pfmc = node.getPFMC();
        if (pfmc == null) {
            this.addToErrorList("No function class associated with " + node.getName());
            return data;
        }
        if (pfmc.getNumberOfParameters() == -1) {
            pfmc.setCurNumberOfParameters(node.jjtGetNumChildren());
        }
        try {
            pfmc.run(this.stack);
        }
        catch (ParseException e) {
            this.addToErrorList(e.getMessage());
            this.errorFlag = true;
        }
        return data;
    }

    public Object visit(ASTVarNode node, Object data) {
        String message = "Could not evaluate " + node.getName() + ": ";
        if (this.symTab == null) {
            message = String.valueOf(message) + "the symbol table is null";
            this.addToErrorList(message);
            return data;
        }
        Object temp = this.symTab.get(node.getName());
        if (temp == null) {
            message = String.valueOf(message) + "the variable was not found in the symbol table";
            this.addToErrorList(message);
        } else {
            this.stack.push(temp);
        }
        return data;
    }

    public Object visit(ASTConstant node, Object data) {
        this.stack.push(node.getValue());
        return data;
    }
}

