/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import excel.brick.Brick;
import excel.brick.Chart;
import excel.brick.DBBar;
import excel.brick.PageBar;
import excel.brick.Tree;
import excel.brick.TreeDataProvider;
import excel.brick.VirtualButton;
import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.Depend;
import excel.core.EditStyle;
import excel.core.Range;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.ZExcel;
import excel.jep.ASTVarNode;
import excel.jep.function.PostfixMathCommand;
import excel.jep.function.PostfixMathCommandI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import jun.db.core.DataStore;
import jun.db.core.DataStoreActionAdapter;
import jun.db.core.DataStoreListener;
import jun.db.core.ObjectTool;
import jun.db.impl.DataStoreFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kxml.Attribute;
import org.kxml.kdom.Document;
import org.kxml.kdom.Element;
import org.kxml.parser.KXML;
import org2.mozilla.javascript.Context;
import wiseoa.flow.applet.AfterSetBind;
import wiseoa.flow.applet.BrickisEnable;
import wiseoa.flow.applet.FlowForm;
import wiseoa.flow.applet.FlowFormTreeDataProvider;
import wiseoa.flow.applet.RhinoTools;
import wiseoa.flow.applet.Tools;
import wiseoa.flow.applet.WorkBookEvent;

public class ZExcelTool {
    public static int REMOTE_RETRIEVE_LIMIT = 100000;
    public static final String ShowComma = "show-comma";
    public static final String DecimalCount = "decimal-count";
    public static final String ZeroVisibleWhenEditable = "zerovisiblewheneditable";
    public static final String ZeroVisibleWhenUneditable = "zerovisiblewhenuneditable";
    public static final String DatetimeFormat = "datetime-format";
    public static final String DropDownListEditable = "ddlb-editable";
    public static final String DropDownListStyle = "ddlb-style";
    public static final String DropDownDataMap = "ddlb-data-map";
    public static final String CheckOnValue = "check-on-value";
    public static final String CheckOffValue = "check-off-value";
    public static final String CheckBoxTipText = "checkbox-tip-text";

    public static WorkBook InitUI(RPCParameter p, KXML xml, String HomeURL, HashMap funcMap, boolean designMode) throws Exception {
        Element sheetE;
        WorkBook book = null;
        Document document = new Document();
        document.parse(xml);
        Element uiConfig = document.getRootElement();
        String theme = uiConfig.getAttributeValue("theme", "");
        boolean showTabOnBottom = uiConfig.getAttributeValue("showTabOnBottom", true);
        Element[] sheetsE = uiConfig.getElements("worksheet");
        int sheetCount = sheetsE.length;
        if (sheetCount == 0) {
            return null;
        }
        int[] RC = new int[sheetCount];
        int[] CC = new int[sheetCount];
        String[] GUIDS = new String[sheetCount];
        String[] CodeS = new String[sheetCount];
        int si = 0;
        while (si < sheetsE.length) {
            sheetE = sheetsE[si];
            int index = si;
            int src = sheetE.getAttributeValue("rowcount", 100);
            int scc = sheetE.getAttributeValue("columncount", 10);
            String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
            String code = sheetE.getAttributeValue("code", null);
            if (index >= 0 && index < sheetCount) {
                RC[index] = src;
                CC[index] = scc;
                GUIDS[index] = guid;
                CodeS[index] = code;
            }
            ++si;
        }
        book = ZExcel.newWorkBook((int)sheetCount, (boolean)uiConfig.getAttributeValue("gui", true), (int[])RC, (int[])CC, (String[])GUIDS, (String[])CodeS);
        book.setTheme(theme);
        book.setUndoEnabled(false);
        book.setShowTabOnBottom(showTabOnBottom);
        if (funcMap != null) {
            for (String name : funcMap.keySet()) {
                PostfixMathCommand func = (PostfixMathCommand)funcMap.get(name);
                book.addFunction(name, (PostfixMathCommandI)func);
            }
        }
        book.setAllBrickDisabled(true);
        book.setInitOK(false);
        ZExcelTool.InitDB(book, p, HomeURL);
        int i = 0;
        while (i < sheetsE.length) {
            String tag;
            boolean gv;
            boolean cv;
            sheetE = sheetsE[i];
            String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
            WorkSheet sheet = book.getWorkSheetByGuid(guid);
            sheet.setPaintPermit(false);
            sheet.setName(sheetE.getAttributeValue("name", ""));
            boolean rv = sheetE.getAttributeValue("rowheadervisible", true);
            if (!rv) {
                sheet.getRowPropertyManage().setRowHeadWidth(0);
            }
            if (!(cv = sheetE.getAttributeValue("columnheadervisible", true))) {
                sheet.getColumnPropertyManage().setColumnHeadHeight(0);
            }
            if (gv = sheetE.getAttributeValue("gridlinevisible", true)) {
                String cs = sheetE.getAttributeValue("gridlinecolor", "");
                if (!cs.equals("")) {
                    sheet.setGridLineColor(Tools.Hex2Color(cs));
                }
            } else {
                sheet.setGridLineVisible(gv);
            }
            if ((tag = sheetE.getAttributeValue("tag", null)) != null) {
                sheet.setTag((Object)tag);
            }
            int freezedRow = sheetE.getAttributeValue("freezedrow", 0);
            int freezedCol = sheetE.getAttributeValue("freezedcol", 0);
            sheet.freezeCell(freezedRow, freezedCol);
            sheet.setIsDesignMode(false);
            if (sheetE.getAttributeValue("mode", "design").equalsIgnoreCase("design")) {
                sheet.setIsDesignMode(true);
            }
            ZExcelTool.InitRowHeight(sheet, sheetE);
            ZExcelTool.InitColumnWidth(sheet, sheetE, designMode);
            ZExcelTool.InitSheetAliasCells(book, sheet, sheetE, HomeURL);
            ZExcelTool.InitSheetFocusRange(book, sheet, sheetE, HomeURL);
            ++i;
        }
        si = 0;
        while (si < sheetsE.length) {
            sheetE = sheetsE[si];
            String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
            WorkSheet sheet = book.getWorkSheetByGuid(guid);
            ZExcelTool.InitSheetCells(book, sheet, sheetE, HomeURL);
            ++si;
        }
        return book;
    }

    public static WorkSheet reCreateWorkSheetUI(WorkSheet sheet, KXML xml, String HomeURL) {
        WorkBook book = sheet.getWorkBook();
        String workSheetGuid = sheet.getGUID();
        String workSheetName = sheet.getName();
        try {
            try {
                String tag;
                boolean gv;
                boolean cv;
                Document document = new Document();
                document.parse(xml);
                Element uiConfig = document.getRootElement();
                Element[] sheetsE = uiConfig.getElements("worksheet");
                Element sheetE = null;
                int si = 0;
                while (si < sheetsE.length) {
                    sheetE = sheetsE[si];
                    String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
                    if (guid.equals(workSheetGuid)) break;
                    ++si;
                }
                int index = sheetE.getAttributeValue("index", 0);
                int src = sheetE.getAttributeValue("rowcount", 100);
                int scc = sheetE.getAttributeValue("columncount", 10);
                String name = sheetE.getAttributeValue("name", "");
                String code = sheetE.getAttributeValue("code", null);
                book.deleteWorkSheet(workSheetName);
                sheet = book.newWorkSheet(name, src, scc, workSheetGuid, code);
                book.setWorkSheetIndex(sheet, index);
                boolean rv = sheetE.getAttributeValue("rowheadervisible", true);
                if (!rv) {
                    sheet.getRowPropertyManage().setRowHeadWidth(0);
                }
                if (!(cv = sheetE.getAttributeValue("columnheadervisible", true))) {
                    sheet.getColumnPropertyManage().setColumnHeadHeight(0);
                }
                if (gv = sheetE.getAttributeValue("gridlinevisible", true)) {
                    String cs = sheetE.getAttributeValue("gridlinecolor", "");
                    if (!cs.equals("")) {
                        sheet.setGridLineColor(Tools.Hex2Color(cs));
                    }
                } else {
                    sheet.setGridLineVisible(gv);
                }
                if ((tag = sheetE.getAttributeValue("tag", null)) != null) {
                    sheet.setTag((Object)tag);
                }
                int freezedRow = sheetE.getAttributeValue("freezedrow", 0);
                int freezedCol = sheetE.getAttributeValue("freezedcol", 0);
                sheet.freezeCell(freezedRow, freezedCol);
                sheet.setIsDesignMode(false);
                if (sheetE.getAttributeValue("mode", "design").equalsIgnoreCase("design")) {
                    sheet.setIsDesignMode(true);
                }
                ZExcelTool.InitRowHeight(sheet, sheetE);
                ZExcelTool.InitColumnWidth(sheet, sheetE, false);
                int cn = sheet.getColumnCount();
                ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
                int ci = 0;
                while (ci < cn) {
                    int w2 = CPM.getColumnWidth2(ci);
                    if (w2 != -1) {
                        CPM.setColumnWidth2(ci, w2);
                    }
                    ++ci;
                }
                ZExcelTool.InitSheetAliasCells(book, sheet, sheetE, HomeURL);
                ZExcelTool.InitSheetCells(book, sheet, sheetE, HomeURL);
            }
            catch (Exception exception) {
                sheet.setPaintPermit(true);
            }
        }
        finally {
            sheet.setPaintPermit(true);
        }
        return sheet;
    }

    public static void InitRowHeight(WorkSheet sheet, Element sheetE) {
        Element[] rowsE = sheetE.getElements("row");
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int ri = 0;
        while (ri < rowsE.length) {
            Element rowE = rowsE[ri];
            int index = rowE.getAttributeValue("index", 0);
            int height = rowE.getAttributeValue("height", 21);
            int dbheight = rowE.getAttributeValue("dbrowheight", 21);
            int stretch = rowE.getAttributeValue("stretchheight", 0);
            boolean columnscrollenabled = rowE.getAttributeValue("columnscrollenabled", true);
            RPM.setRowHeight(index, height);
            RPM.setDBRowHeight(index, dbheight);
            RPM.setGroupRowHeight(index, dbheight);
            RPM.setColumnScrollEnable(index, columnscrollenabled);
            RPM.setRowStretchHeight(index, stretch);
            ++ri;
        }
    }

    public static void InitColumnWidth(WorkSheet sheet, Element sheetE, boolean designMode) {
        Element[] colsE = sheetE.getElements("column");
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        int ci = 0;
        while (ci < colsE.length) {
            Element colE = colsE[ci];
            int index = colE.getAttributeValue("index", 0);
            int width = colE.getAttributeValue("width", 72);
            int width2 = colE.getAttributeValue("width2", -1);
            int stretch = colE.getAttributeValue("stretchwidth", 0);
            CPM.setColumnWidth(index, width);
            CPM.setColumnStretchWidth(index, stretch);
            CPM.setColumnWidth2(index, width2);
            if (!designMode) {
                CPM.setColumnWidth(index, width2);
            }
            ++ci;
        }
    }

    public static void InitSheetCells(WorkBook book, WorkSheet sheet, Element sheetE, String HomeURL) {
        Element[] cellsE = sheetE.getElements("cell");
        int ci = 0;
        while (ci < cellsE.length) {
            Element cellE = cellsE[ci];
            ZExcelTool.InitSheetCell(book, sheet, cellE, HomeURL);
            ++ci;
        }
    }

    public static void InitSheetAliasCells(WorkBook book, WorkSheet sheet, Element sheetE, String HomeURL) {
        Element[] cellsE = sheetE.getElements("cell");
        int ci = 0;
        while (ci < cellsE.length) {
            Cell cell;
            Element cellE = cellsE[ci];
            int row = cellE.getAttributeValue("row", 0);
            int col = cellE.getAttributeValue("col", 0);
            String alias = cellE.getAttributeValue("alias", "");
            if (alias.length() > 0 && (cell = sheet.Cells(row, col)) != null) {
                cell.setAlias(alias);
            }
            ++ci;
        }
    }

    public static void InitSheetFocusRange(WorkBook book, WorkSheet sheet, Element sheetE, String HomeURL) {
        Element[] cellsE = sheetE.getElements("focusrange");
        int ci = 0;
        while (ci < cellsE.length) {
            Element cellE = cellsE[ci];
            int startRow = cellE.getAttributeValue("startrow", 0);
            int startCol = cellE.getAttributeValue("startcol", 0);
            int endRow = cellE.getAttributeValue("endrow", 0);
            int endCol = cellE.getAttributeValue("endcol", 0);
            sheet.addFocusRange(startRow, startCol, endRow, endCol);
            ++ci;
        }
    }

    public static void InitSheetCell(WorkBook book, WorkSheet sheet, Element cellE, String HomeURL) {
        int row = cellE.getAttributeValue("row", 0);
        int col = cellE.getAttributeValue("col", 0);
        Vector attrs = cellE.getAttributes();
        Cell cell = sheet.Cells(row, col);
        if (cell == null) {
            return;
        }
        String cvnl = cellE.getAttributeValue("customValueNameList", "");
        if (cvnl.length() > 0) {
            String[] cks = cvnl.split(",", 9999);
            int i = 0;
            while (i < cks.length) {
                String key = cks[i];
                if (!key.equals("")) {
                    String value = cellE.getAttributeValue(key, "");
                    cell.setCustomValue(key, value);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < attrs.size()) {
            try {
                Attribute attr = (Attribute)attrs.get(i);
                String attrName = attr.getName().toLowerCase().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("row") && !attrName.equals("col")) {
                    if (attrName.equals("value")) {
                        cell.setValue((Object)attrValue);
                    }
                    if (attrName.equals("tag")) {
                        cell.setTag((Object)attrValue);
                    }
                    if (attrName.equals("tooltip")) {
                        cell.setToolTip(attrValue);
                    }
                    if (attrName.equals("formulaispriority")) {
                        cell.setFormulaIsPriority(Tools.String2Int(attrValue));
                    }
                    if (attrName.equals("cellvaluetype")) {
                        cell.setCellValueType(Tools.String2Int(attrValue));
                    }
                    if (attrName.equals("rowspan")) {
                        int mr = ObjectTool.toInt((Object)cellE.getAttributeValue("rowspan", "1"));
                        int mc = ObjectTool.toInt((Object)cellE.getAttributeValue("colspan", "1"));
                        sheet.Merge(row, col, row + mr - 1, col + mc - 1);
                    }
                    if (attrName.equals("border-left-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-left-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-left-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-right-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-right-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-right-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-top-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-top-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-top-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-bottom-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-bottom-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-bottom-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-bottom")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-left")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-right")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-top")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-mode")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-image")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-position-x")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-position-y")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-repeat-x")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-repeat-y")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-name")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-size")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-bold")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-italic")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-underline")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("word-wrap")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("align-h")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("align-v")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("display")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-color-expression") && !attrValue.equals("")) {
                        attrValue = attrValue.trim();
                        sheet.addExpression(attrValue, attrValue);
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("display-expression") && !attrValue.equals("")) {
                        attrValue = attrValue.trim();
                        sheet.addExpression(attrValue, attrValue);
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-color-expression") && !attrValue.equals("")) {
                        attrValue = attrValue.trim();
                        sheet.addExpression(attrValue, attrValue);
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }

    public static Element InitDB(WorkBook book, RPCParameter p, String homeURL) {
        Element dbConfig = null;
        DataSourceConfig[] dscs = book.getDataSources();
        int i = 0;
        while (i < book.getDataSourceCount()) {
            book.removeDataSource(dscs[i].getName());
            ++i;
        }
        byte[] bs = (byte[])p.get("db");
        if (bs.length == 0) {
            return null;
        }
        KXML xml = KXML.newInstance((byte[])bs);
        try {
            Document document = new Document();
            document.parse(xml);
            dbConfig = document.getRootElement();
            Element[] dsc = dbConfig.getElements("datasource");
            int ei = 0;
            while (ei < dsc.length) {
                Element whereE;
                Element tableE;
                Element e = dsc[ei];
                String dsname = e.getAttributeValue("name", "");
                String comment = e.getAttributeValue("comment", "");
                String cons = e.getAttributeValue("connection", "default");
                int dstype = e.getAttributeValue("rowcount", "single").equalsIgnoreCase("single") ? 1 : 2;
                DataStore ds = (DataStore)p.get(dsname);
                book.AddDataSource(dsname, ds, dstype);
                book.getDataSource(dsname).setDBPoolName(cons);
                book.getDataSource(dsname).setComment(comment);
                ds.setRemoteFactoryURL(homeURL);
                ds.setOnceRetrieveCount(REMOTE_RETRIEVE_LIMIT);
                if (e.getAttributeValue("type", "").equals("table") && (tableE = e.getElement("table")) != null && tableE.getAttributeValue("updatable", true)) {
                    String whereClause;
                    String updatableTable = tableE.getAttributeValue("name", "");
                    String updatableColumns = tableE.getAttributeValue("updatablecolumns", "*");
                    String primaryKey = tableE.getAttributeValue("primarykey", "");
                    if (!primaryKey.equals("id")) {
                        System.out.println("\u8868" + updatableTable + "\u7684\u4e3b\u952e\u662f\uff1a" + primaryKey);
                    }
                    if (!(whereClause = tableE.getAttributeValue("whereclause", primaryKey)).equals("id")) {
                        System.out.println("\u8868" + updatableTable + "\u7684where\u5b50\u53e5\u662f\uff1a" + whereClause);
                    }
                    ds.setUpdateProperty(updatableTable, primaryKey, updatableColumns, whereClause);
                    ds.setRemoteFactoryURL(homeURL);
                }
                if ((whereE = e.getElement("whereDefine")) != null) {
                    Element[] ws = whereE.getElements("where");
                    ArrayList<String> list = new ArrayList<String>();
                    int wi = 0;
                    while (wi < ws.length) {
                        String t = ws[wi].getText().trim();
                        if (!t.equals("")) {
                            list.add(t);
                            System.out.println(String.valueOf(dsname) + "\u52a8\u6001\u68c0\u7d22\u6761\u4ef6\uff1a" + t);
                        }
                        ++wi;
                    }
                    ds.setTag("retrieveWhere", list);
                }
                ++ei;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dbConfig;
    }

    public static Element InitBind(WorkBook book, RPCParameter p, String HomeURL, AfterSetBind afterSetBind) {
        return ZExcelTool.InitBind(book, p, HomeURL, "", afterSetBind);
    }

    public static Element InitBind(WorkBook book, RPCParameter p, String HomeURL, String onlyWorkSheetGuid, AfterSetBind afterSetBind) {
        Element bindConfig = null;
        KXML xml = KXML.newInstance((byte[])((byte[])p.get("bind")));
        try {
            Document document = new Document();
            document.parse(xml);
            bindConfig = document.getRootElement();
            Element[] sheetsE = bindConfig.getElements("worksheet");
            int si = 0;
            while (si < sheetsE.length) {
                Element sheetE = sheetsE[si];
                String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
                WorkSheet sheet = book.getWorkSheetByGuid(guid);
                if (onlyWorkSheetGuid.endsWith("") || onlyWorkSheetGuid.equals(sheet.getGUID())) {
                    ZExcelTool.InitSheetBinds(book, sheet, sheetE, HomeURL, afterSetBind);
                }
                ++si;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bindConfig;
    }

    public static void InitSheetBinds(WorkBook book, WorkSheet sheet, Element sheetE, String HomeURL, AfterSetBind afterSetBind) {
        Element[] cellsE = sheetE.getElements("bind");
        int ci = 0;
        while (ci < cellsE.length) {
            Element cellE = cellsE[ci];
            ZExcelTool.InitSheetBind(book, sheet, cellE, HomeURL, afterSetBind);
            ++ci;
        }
    }

    public static void InitSheetBind(WorkBook book, WorkSheet sheet, Element bindE, String HomeURL, AfterSetBind afterSetBind) {
        try {
            int row = bindE.getAttributeValue("row", 0);
            int col = bindE.getAttributeValue("col", 0);
            Vector attrs = bindE.getAttributes();
            Cell cell = sheet.Cells(row, col);
            int i = 0;
            while (i < attrs.size()) {
                Attribute attr = (Attribute)attrs.get(i);
                String attrName = attr.getName().toLowerCase().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("row") && !attrName.equals("col") && attrName.equals("dbcol")) {
                    String ds = bindE.getAttributeValue("datasource", "default");
                    cell.setBind(ds, attrValue);
                    if (afterSetBind != null) {
                        afterSetBind.afterSetBind(cell);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Element InitEditStyle(WorkBook book, RPCParameter p, String HomeURL) {
        Element bindConfig = null;
        KXML xml = KXML.newInstance((byte[])((byte[])p.get("editstyle")));
        try {
            Document document = new Document();
            document.parse(xml);
            bindConfig = document.getRootElement();
            Element[] sheetsE = bindConfig.getElements("worksheet");
            int si = 0;
            while (si < sheetsE.length) {
                Element sheetE = sheetsE[si];
                String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
                WorkSheet sheet = book.getWorkSheetByGuid(guid);
                ZExcelTool.InitSheetEditStyles(book, sheet, sheetE, HomeURL);
                ++si;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bindConfig;
    }

    public static void InitSheetEditStyles(WorkBook book, WorkSheet sheet, Element sheetE, String HomeURL) {
        Element[] cellsE = sheetE.getElements("editstyle");
        int ci = 0;
        while (ci < cellsE.length) {
            Element cellE = cellsE[ci];
            ZExcelTool.InitSheetEditStyle(book, sheet, cellE, HomeURL);
            ++ci;
        }
    }

    public static void InitSheetEditStyle(WorkBook book, WorkSheet sheet, Element bindE, String HomeURL) {
        try {
            int row = bindE.getAttributeValue("row", 0);
            int col = bindE.getAttributeValue("col", 0);
            Vector attrs = bindE.getAttributes();
            Cell cell = sheet.Cells(row, col);
            cell.setEditable(false);
            int i = 0;
            while (i < attrs.size()) {
                Attribute attr = (Attribute)attrs.get(i);
                String attrName = attr.getName().toLowerCase().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("row") && !attrName.equals("col")) {
                    if (attrName.equals("editable")) {
                        boolean b = ObjectTool.toBool((Object)attrValue);
                        if (!b) {
                            cell.setEditable(false);
                        } else {
                            DBBindConfig dbc = cell.getBind();
                            if (dbc != null && (b = true) && dbc.getDataSourceType() == 1) {
                                cell.setEditable(b, true);
                            }
                            cell.setEditable(b);
                        }
                    }
                    if (attrName.equals("edittype")) {
                        String name;
                        if (attrValue.equalsIgnoreCase("normal")) {
                            cell.setEditStyle(null);
                        }
                        if (attrValue.equalsIgnoreCase("multiline")) {
                            String name2 = "multiline";
                            EditStyle es = book.getEditStyle(name2);
                            if (es == null) {
                                es = book.newEditStyle(book, name2, 2);
                                book.AddEditStyle(es);
                            }
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("numeric")) {
                            boolean showComma = bindE.getAttributeValue(ShowComma, true);
                            int decimalCount = bindE.getAttributeValue(DecimalCount, 2);
                            boolean zeroVisibleWhenEditable = bindE.getAttributeValue(ZeroVisibleWhenEditable, true);
                            boolean zeroVisibleWhenUneditable = bindE.getAttributeValue(ZeroVisibleWhenUneditable, true);
                            name = String.valueOf(attrValue.toLowerCase()) + String.valueOf(showComma) + String.valueOf(decimalCount);
                            EditStyle es = book.getEditStyle(name);
                            if (es == null) {
                                es = book.newEditStyle(book, name, 1);
                                es.setShowComma(showComma);
                                es.setDecimalCount(decimalCount);
                                es.setZeroVisibleWhenEditable(zeroVisibleWhenEditable);
                                es.setZeroVisibleWhenUneditable(zeroVisibleWhenUneditable);
                                book.AddEditStyle(es);
                            }
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("datetime")) {
                            String datetime_format = bindE.getAttributeValue(DatetimeFormat, "YYYY.MM.DD");
                            String name3 = String.valueOf(attrValue.toLowerCase()) + datetime_format;
                            EditStyle es = book.getEditStyle(name3);
                            if (es == null) {
                                es = book.newEditStyle(book, name3, 3);
                                es.setDatetimeFormat(datetime_format);
                                book.AddEditStyle(es);
                            }
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("checkbox")) {
                            String CheckOnValue = bindE.getAttributeValue(CheckOnValue, "");
                            String CheckOffValue = bindE.getAttributeValue(CheckOffValue, "");
                            String CheckBoxTipText = bindE.getAttributeValue(CheckBoxTipText, "");
                            String name4 = String.valueOf(attrValue.toLowerCase()) + CheckOnValue + CheckOffValue + CheckBoxTipText;
                            EditStyle es = book.getEditStyle(name4);
                            if (es == null) {
                                es = book.newEditStyle(book, name4, 5);
                                es.setCheckOnValue(CheckOnValue);
                                es.setCheckOffValue((Object)CheckOffValue);
                                es.setCheckBoxTipText(CheckBoxTipText);
                                book.AddEditStyle(es);
                            }
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("ddlb")) {
                            EditStyle es;
                            String editstyle = bindE.getAttributeValue("editstyle", "");
                            String style = bindE.getAttributeValue(DropDownListStyle, "ddlb");
                            boolean ddlbeditable = bindE.getAttributeValue(DropDownListEditable, false);
                            String ddlbstyle = bindE.getAttributeValue(DropDownListStyle, "ddlb");
                            name = String.valueOf(attrValue.toLowerCase()) + editstyle + String.valueOf(ddlbeditable) + ddlbstyle;
                            DBBindConfig dbc = null;
                            if (editstyle.equals("selfvalue")) {
                                dbc = cell.getBind();
                                name = dbc == null ? String.valueOf(attrValue.toLowerCase()) + "_selfvalue___" + editstyle : String.valueOf(attrValue.toLowerCase()) + "_selfvalue_" + dbc.getDataSource() + "_" + dbc.getDBCol() + "_" + editstyle;
                            }
                            if ((es = book.getEditStyle(name)) == null) {
                                es = book.newEditStyle(book, name, 4);
                                HashMap map = null;
                                RPCParameter p = new RPCParameter();
                                p.put("editstyle", editstyle);
                                if (dbc != null) {
                                    p.put("table", dbc.getDataSource());
                                    p.put("dsn", book.getDataSource(dbc.getDataSource()).getDBPoolName());
                                    p.put("col", dbc.getDBCol());
                                }
                                p = RPC.Call(String.valueOf(HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "getDDLBMap", p);
                                if (p.Success) {
                                    map = (HashMap)p.get("map");
                                    JSONObject ddlbConfig = (JSONObject)p.get("ddlbconfig");
                                    if (ddlbConfig.getString("filterby", "").trim().length() > 0) {
                                        es.setDDLBFilterBy(ddlbConfig.toString());
                                    }
                                    if (ddlbConfig.getString("datasource", "").equals("script")) {
                                        FlowForm.$log(ddlbConfig.getString("sql"));
                                        es.setDDLBFilterBy(ddlbConfig.toString());
                                        map = ZExcelTool.buildMapFromJSONArray(sheet, ddlbConfig, -99, HomeURL);
                                    }
                                }
                                es.setDropDownData2ViewMap(map);
                                es.setDropDownListEditable(ddlbeditable);
                                book.AddEditStyle(es);
                            }
                            if (style.equals("radio")) {
                                es.setListShowAsRadioButton();
                            }
                            if (style.equals("checkbox")) {
                                es.setListShowAsCheckBox();
                            }
                            if (style.equals("ddlbcheckbox")) {
                                es.setListShowAsDropdownCheckBox();
                            }
                            es.setDDLBName(editstyle);
                            es.setColumnCountOnRow(bindE.getAttributeValue("columncount", 1));
                            es.setDDLBWidthPercent(bindE.getAttributeValue("DDLBWidthPercent", 100));
                            es.setShowRealData(bindE.getAttributeValue("isShowRealData", false));
                            es.setValueMustInDDLB(bindE.getAttributeValue("valueMustInDDLB", false));
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("richedit")) {
                            String name5 = "htmlrichedit";
                            EditStyle es = book.getEditStyle(name5);
                            if (es == null) {
                                es = book.newEditStyle(book, name5, 7);
                                book.AddEditStyle(es);
                            }
                            cell.setEditStyle(es);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LinkedHashMap buildMapFromJSONArray(WorkSheet sheet, JSONObject ddlbConfig, int innerRow, String HomeURL) {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        String filterBy = ddlbConfig.getString("filterby", "");
        String sql = ddlbConfig.getString("sql", "");
        String dataCol = ddlbConfig.getString("datacol", "");
        String showCol = ddlbConfig.getString("showcol", "");
        int currentRow = innerRow;
        if (innerRow < 0) {
            currentRow = WorkBookEvent.getCurrentBindRowOfExpression(sheet, sql);
        }
        if (currentRow == -9999) {
            FlowForm.$log(String.valueOf(filterBy) + "\u4e2d\u5b9a\u4e49\u7684\u5355\u5143\u683c\u4e0d\u5b58\u5728\uff0c\u6240\u4ee5\u4e0d\u8fdb\u884c\u811a\u672c\u6267\u884c\u3002");
            return null;
        }
        FlowForm.$log(" currentRow=" + currentRow);
        Object s = sheet.evaluate(sql, currentRow);
        try {
            try {
                Context cx = Context.enter();
                Object j = RhinoTools.jsToJava(s, cx);
                if (j instanceof Object[]) {
                    Object[] ja = (Object[])j;
                    int ti = 0;
                    while (ti < ja.length) {
                        if (ja[ti] instanceof HashMap) {
                            HashMap jmap = (HashMap)ja[ti];
                            map.put(jmap.get(dataCol), jmap.get(showCol));
                        }
                        ++ti;
                    }
                }
                if (j instanceof HashMap) {
                    HashMap jmap = (HashMap)j;
                    map.put(jmap.get(dataCol), jmap.get(showCol));
                }
                if (j instanceof String) {
                    String str = j.toString().trim();
                    if (str.startsWith("{")) {
                        str = "[" + str + "]";
                    }
                    FlowForm.$log("\u76f4\u63a5\u7684JSON\u6570\u636e");
                    JSONArray ja = new JSONArray(str);
                    int ji = 0;
                    while (ji < ja.length()) {
                        JSONObject jo = ja.getJSONObject(ji);
                        map.put(jo.get(dataCol, (Object)""), jo.get(showCol, (Object)""));
                        ++ji;
                    }
                }
            }
            catch (Exception exception) {
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
        return map;
    }

    public static LinkedHashMap buildMapFromJSONArray(WorkSheet sheet, String ddlbConfig, int innerRow, String HomeURL) {
        JSONObject config = new JSONObject(ddlbConfig);
        return ZExcelTool.buildMapFromJSONArray(sheet, config, innerRow, HomeURL);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String getDependedCellsValueListOfExpression(WorkSheet parseSheet, String expression) {
        String SP = ";";
        StringBuffer ret = new StringBuffer();
        ret.append(String.valueOf(expression) + SP);
        FlowForm.$log("\u8868\u8fbe\u5f0f:" + expression);
        ArrayList dependList = parseSheet.parseDependList(expression);
        if (dependList.size() == 0) {
            return ret.toString();
        }
        WorkBook book = parseSheet.getWorkBook();
        boolean ignore = false;
        int di = 0;
        while (di < dependList.size()) {
            block16: {
                boolean startRow = false;
                boolean endRow = false;
                boolean startCol = false;
                boolean endCol = false;
                WorkSheet checkSheet = null;
                Depend da = (Depend)dependList.get(di);
                ASTVarNode var = da.node;
                int varKind = var.getToken().kind;
                String varName = var.getName();
                System.out.print(String.valueOf(parseSheet.getName()) + "\u89e3\u6790\u8868\u8fbe\u5f0f" + expression + "\u5f15\u7528\u4e86\u5355\u5143\u683c:" + varName + "  sheetGuid=" + da.SheetGuid);
                Cell cell = null;
                switch (varKind) {
                    case 10: 
                    case 11: {
                        checkSheet = parseSheet;
                        cell = checkSheet.cells(varName);
                        break;
                    }
                    case 13: 
                    case 15: {
                        int p = varName.indexOf("!");
                        if (p <= 0) break;
                        String SheetName = varName.substring(0, p).trim();
                        checkSheet = book.getWorkSheet(SheetName);
                        if (checkSheet != null) {
                            cell = checkSheet.cells(varName.substring(p + 1, varName.length()));
                            break;
                        }
                        break block16;
                    }
                    case 12: {
                        checkSheet = parseSheet;
                        Range range = parseSheet.rangeNameToRange(varName);
                        if (range == null) break;
                        cell = checkSheet.cells(range.getStartRow(), range.getStartCol());
                        break;
                    }
                    case 14: {
                        int p = varName.indexOf("!");
                        if (p <= 0) break;
                        String SheetName = varName.substring(0, p).trim();
                        checkSheet = book.getWorkSheet(SheetName);
                        if (checkSheet == null) break block16;
                        Range range = checkSheet.rangeNameToRange(varName.substring(p + 1, varName.length()));
                        if (range == null) break;
                        cell = checkSheet.cells(range.getStartRow(), range.getStartCol());
                    }
                }
                if (cell != null) {
                    DBBindConfig dbc = cell.getBind();
                    DataSourceConfig dsc = null;
                    if (dbc == null) {
                        if (cell.getValue() instanceof Vector) {
                            dsc = checkSheet.getRowPropertyManage().getMaximalDataSourceConfig(cell.getRowIndex());
                        }
                    } else {
                        dsc = book.getDataSource(dbc.getDataSource());
                    }
                    if (dsc != null) {
                        if (dsc.getDataSourceType() != 1) {
                            int row = dsc.getCurrentBindRow();
                            ret.append(String.valueOf(varName) + ":" + cell.getValue(row) + SP);
                        }
                    } else {
                        ret.append(String.valueOf(varName) + ":" + cell.getValueString() + SP);
                    }
                }
            }
            ++di;
        }
        return ret.toString();
    }

    public static void InitBrick(WorkBook book, RPCParameter p, BrickisEnable be, String onlyWorkSheetGuid, String homeURL) {
        Element brickConfig = null;
        KXML xml = KXML.newInstance((byte[])((byte[])p.get("brick")));
        try {
            Document document = new Document();
            document.parse(xml);
            brickConfig = document.getRootElement();
            Element[] sheetsE = brickConfig.getElements("worksheet");
            int si = 0;
            while (si < sheetsE.length) {
                Element sheetE = sheetsE[si];
                String guid = sheetE.getAttributeValue("guid", DataStoreFactory.newGUID());
                WorkSheet sheet = book.getWorkSheetByGuid(guid);
                if (onlyWorkSheetGuid.endsWith("") || onlyWorkSheetGuid.equals(sheet.getGUID())) {
                    ZExcelTool.InitSheetBricks(sheet, sheetE, be, homeURL);
                }
                ++si;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void InitSheetBricks(WorkSheet sheet, Element sheetE, BrickisEnable be, String homeURL) {
        Element[] cellsE = sheetE.getElements("brick");
        int ci = 0;
        while (ci < cellsE.length) {
            Element cellE = cellsE[ci];
            ZExcelTool.InitSheetBrick(sheet, cellE, be, homeURL);
            ++ci;
        }
    }

    public static void InitSheetBrick(WorkSheet sheet, Element brickE, BrickisEnable be, String homeURL) {
        try {
            String to;
            VirtualButton brick;
            int H;
            int W;
            int Y;
            int X;
            String datasource;
            WorkBook book = sheet.getWorkBook();
            int row = brickE.getAttributeValue("row", 0);
            int col = brickE.getAttributeValue("col", 0);
            Vector attrs = brickE.getAttributes();
            String sheetGuid = sheet.getGUID();
            Cell cell = sheet.Cells(row, col);
            String brickName = brickE.getAttributeValue("name", "");
            String caption = brickE.getAttributeValue("caption", "");
            String type = brickE.getAttributeValue("type", "").toLowerCase();
            boolean enabled = true;
            if (be != null) {
                enabled = be.brickIsEnabled(sheetGuid, brickName);
            }
            if (type.equals("dbbar")) {
                datasource = brickE.getAttributeValue("datasource", "");
                if (datasource.equals("")) {
                    datasource = "default";
                }
                String action = brickE.getAttributeValue("action", "").trim().toLowerCase();
                int Action2 = 1;
                if (action.equals("insertbefore")) {
                    Action2 = 1;
                }
                if (action.equals("insertafter")) {
                    Action2 = 2;
                }
                if (action.equals("deleterow")) {
                    Action2 = 3;
                }
                if (action.equals("clonerow")) {
                    Action2 = 20;
                }
                DBBar brick2 = book.createDBBarBrick(brickName, datasource, Action2);
                X = brickE.getAttributeValue("x", 0);
                Y = brickE.getAttributeValue("y", 0);
                W = brickE.getAttributeValue("width", 0);
                H = brickE.getAttributeValue("height", 0);
                brick2.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick2);
                brick2.setEnabled(enabled);
            }
            if (type.equals("tree")) {
                Tree tree;
                String connection = brickE.getAttributeValue("connection", "");
                String sql = brickE.getElement("sql").getText();
                String rootValue = brickE.getAttributeValue("rootvalue", "");
                String rootLabel = brickE.getAttributeValue("rootlabel", "");
                boolean isMulti = brickE.getAttributeValue("multi", false);
                boolean isAutoLoad = brickE.getAttributeValue("autoload", true);
                boolean lazyloading = brickE.getAttributeValue("lazyloading", false);
                Object ja = null;
                if (!sheet.isDesignMode()) {
                    FlowFormTreeDataProvider tdp = new FlowFormTreeDataProvider(homeURL, sheet, connection, sql, rootValue, rootLabel);
                    tdp.tree = tree = book.createTreeBrick(brickName, isMulti, rootLabel, rootValue, (TreeDataProvider)tdp, false, lazyloading);
                } else {
                    tree = book.createTreeBrick(brickName, isMulti, rootLabel, rootValue, null);
                    tree.setAutoLoad(isAutoLoad);
                }
                tree.setConnection(connection);
                tree.setRootLabel(rootLabel);
                tree.setRootValue(rootValue);
                tree.setSelect(sql);
                tree.setLazyLoading(lazyloading);
                int X2 = brickE.getAttributeValue("x", 0);
                int Y2 = brickE.getAttributeValue("y", 0);
                int W2 = brickE.getAttributeValue("width", 0);
                int H2 = brickE.getAttributeValue("height", 0);
                tree.setBounds(X2, Y2, W2, H2);
                cell.addBrick((Brick)tree);
                tree.setEnabled(enabled);
                if (isAutoLoad) {
                    tree.reLoad();
                }
            }
            if (type.equals("pagebar")) {
                datasource = brickE.getAttributeValue("datasource", "");
                int rc = brickE.getAttributeValue("rowcount", 10);
                final PageBar brick3 = book.createPageBar(brickName, datasource, rc);
                brick3.setExportAllWithoutDataPageLimit(brickE.getAttributeValue("exportallwithoutdatapagelimit", false));
                final DataStore ds = book.getDataSource(datasource).getDataStore();
                ds.setOnceRetrieveCount(rc);
                ds.setTag("\u5206\u9875\u5de5\u5177\u6761", (Object)brick3);
                ds.getEvent().addDataStoreEventListener((DataStoreListener)new DataStoreActionAdapter(){

                    public void retrieveEnd(int rowCount, boolean withLastSelect) {
                        if (!withLastSelect) {
                            brick3.reset(ds.getDBRowCount());
                        }
                    }
                });
                X = brickE.getAttributeValue("x", 0);
                Y = brickE.getAttributeValue("y", 0);
                W = brickE.getAttributeValue("width", 0);
                H = brickE.getAttributeValue("height", 0);
                brick3.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick3);
                brick3.setEnabled(enabled);
            }
            if (type.equals("button")) {
                brick = book.createVirtualButton(brickName, caption);
                int X3 = brickE.getAttributeValue("x", 0);
                int Y3 = brickE.getAttributeValue("y", 0);
                int W3 = brickE.getAttributeValue("width", 0);
                int H3 = brickE.getAttributeValue("height", 0);
                brick.setBounds(X3, Y3, W3, H3);
                brick.setEnabled(enabled);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("chart")) {
                String chartType = brickE.getAttributeValue("charttype", "bar3d");
                String name = brickE.getAttributeValue("name", "");
                String categoryAxisLabel = brickE.getAttributeValue("categoryAxisLabel", "");
                String valueAxisLabel = brickE.getAttributeValue("valueAxisLabel", "");
                float alpha = (float)brickE.getAttributeValue("alpha", 50) / 100.0f;
                boolean serialAngled = brickE.getAttributeValue("serialAngled", true);
                String range = brickE.getAttributeValue("range", "");
                String serialCol = brickE.getAttributeValue("serialCol", "");
                String categoryCol = brickE.getAttributeValue("categoryCol", "");
                String valueCol = brickE.getAttributeValue("valueCol", "");
                String valueCol2 = brickE.getAttributeValue("valueCol2", "");
                Chart brick4 = book.createChart(chartType, name, caption, categoryAxisLabel, valueAxisLabel, alpha, serialAngled, range, serialCol, categoryCol, valueCol, valueCol2);
                String serialColMap = brickE.getAttributeValue("serialColMap", "");
                String categoryColMap = brickE.getAttributeValue("categoryColMap", "");
                brick4.setSeriesColMap(serialColMap);
                brick4.setCategoryColMap(categoryColMap);
                int X4 = brickE.getAttributeValue("x", 0);
                int Y4 = brickE.getAttributeValue("y", 0);
                int W4 = brickE.getAttributeValue("width", 0);
                int H4 = brickE.getAttributeValue("height", 0);
                brick4.setBounds(X4, Y4, W4, H4);
                brick4.setEnabled(enabled);
                cell.addBrick((Brick)brick4);
            }
            if (type.equals("rotatedtext")) {
                brick = book.createRotatedText(brickName, caption, brickE.getAttributeValue("angle", 0));
                int X5 = brickE.getAttributeValue("x", 0);
                int Y5 = brickE.getAttributeValue("y", 0);
                int W5 = brickE.getAttributeValue("width", 0);
                int H5 = brickE.getAttributeValue("height", 0);
                brick.setFontName(brickE.getAttributeValue("fontname", "\u5b8b\u4f53"));
                brick.setFontSize(brickE.getAttributeValue("fontsize", 12));
                brick.setFontColor((Object)Tools.Hex2Color(brickE.getAttributeValue("fontcolor", "0x000000")));
                brick.setBounds(X5, Y5, W5, H5);
                brick.setEnabled(enabled);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("retrievebutton")) {
                brick = book.createRetrieveButton(brickName, caption, brickE.getAttributeValue("datasource", ""));
                int X6 = brickE.getAttributeValue("x", 0);
                int Y6 = brickE.getAttributeValue("y", 0);
                int W6 = brickE.getAttributeValue("width", 0);
                int H6 = brickE.getAttributeValue("height", 0);
                brick.setBounds(X6, Y6, W6, H6);
                brick.setEnabled(enabled);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("line")) {
                brick = book.createLine(brickName, Tools.Hex2Color(brickE.getAttributeValue("color", "")), brickE.getAttributeValue("style", 1), brickE.getAttributeValue("size", 1));
                int X7 = brickE.getAttributeValue("x", 0);
                int Y7 = brickE.getAttributeValue("y", 0);
                int W7 = brickE.getAttributeValue("width", 0);
                int H7 = brickE.getAttributeValue("height", 0);
                brick.setBounds(X7, Y7, W7, H7);
                brick.setEnabled(enabled);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("loadimagebutton")) {
                to = brickE.getAttributeValue("to", "datastore");
                Object brick5 = null;
                brick5 = to.equals("datastore") ? book.createLoadImageToDSVirtualButton(brickName, caption, brickE.getAttributeValue("datasource", ""), brickE.getAttributeValue("tocol", "")) : book.createLoadImageToCellVirtualButton(brickName, caption, brickE.getAttributeValue("tosheetname", ""), brickE.getAttributeValue("torow", 0), brickE.getAttributeValue("tocol", 0));
                int X8 = brickE.getAttributeValue("x", 0);
                int Y8 = brickE.getAttributeValue("y", 0);
                int W8 = brickE.getAttributeValue("width", 0);
                int H8 = brickE.getAttributeValue("height", 0);
                brick5.setBounds(X8, Y8, W8, H8);
                brick5.setEnabled(enabled);
                cell.addBrick((Brick)brick5);
            }
            if (type.equals("loadcamerabutton")) {
                to = brickE.getAttributeValue("to", "datastore");
                int vw = brickE.getAttributeValue("vw", 0);
                int vh = brickE.getAttributeValue("vh", 0);
                int cw = brickE.getAttributeValue("cw", 0);
                int ch = brickE.getAttributeValue("ch", 0);
                Object brick6 = null;
                brick6 = to.equals("datastore") ? book.createLoadCameraToDSVirtualButton(brickName, caption, brickE.getAttributeValue("datasource", ""), brickE.getAttributeValue("tocol", ""), vw, vh, cw, ch) : book.createLoadCameraToCellVirtualButton(brickName, caption, brickE.getAttributeValue("tosheetname", ""), brickE.getAttributeValue("torow", 0), brickE.getAttributeValue("tocol", 0), vw, vh, cw, ch);
                int X9 = brickE.getAttributeValue("x", 0);
                int Y9 = brickE.getAttributeValue("y", 0);
                int W9 = brickE.getAttributeValue("width", 0);
                int H9 = brickE.getAttributeValue("height", 0);
                brick6.setBounds(X9, Y9, W9, H9);
                brick6.setEnabled(enabled);
                cell.addBrick((Brick)brick6);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static ArrayList LoadEditSecurity(Document document) {
        return ZExcelTool.LoadSecurity(document, "security");
    }

    public static ArrayList LoadVisibleSecurity(Document document) {
        return ZExcelTool.LoadSecurity(document, "visible");
    }

    public static ArrayList LoadCheckSecurity(Document document) {
        return ZExcelTool.LoadSecurity(document, "check");
    }

    public static ArrayList LoadSecurity(Document document, String what) {
        ArrayList<String> editableColumnList = new ArrayList<String>();
        try {
            Element securityConfig = document.getRootElement();
            Element securityE = securityConfig.getElement(what);
            if (securityE != null) {
                Element[] nodesE = securityE.getElements("node");
                int ni = 0;
                while (ni < nodesE.length) {
                    Element nodeE = nodesE[ni];
                    String nodeguid = nodeE.getAttributeValue("guid", "");
                    Element[] columnsE = nodeE.getElements("columns");
                    int ei = 0;
                    while (ei < columnsE.length) {
                        Element columnE = columnsE[ei];
                        String dataSource = columnE.getAttributeValue("datasource", "");
                        String columns = columnE.getAttributeValue("names", "");
                        StringTokenizer stk = new StringTokenizer(columns, ",");
                        while (stk.hasMoreTokens()) {
                            String col = stk.nextToken().trim().toLowerCase();
                            if (col.equals("")) continue;
                            editableColumnList.add(String.valueOf(nodeguid) + " " + dataSource + " " + col);
                        }
                        ++ei;
                    }
                    ++ni;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return editableColumnList;
    }

    public static HashMap LoadAutoFillValue(Document document) {
        HashMap<String, String> autoFillValueMap = new HashMap<String, String>();
        try {
            Element securityConfig = document.getRootElement();
            Element securityE = securityConfig.getElement("autofill");
            if (securityE != null) {
                Element[] nodesE = securityE.getElements("node");
                int ni = 0;
                while (ni < nodesE.length) {
                    Element nodeE = nodesE[ni];
                    String nodeguid = nodeE.getAttributeValue("guid", "");
                    Element[] columnsE = nodeE.getElements("column");
                    int ei = 0;
                    while (ei < columnsE.length) {
                        Element columnE = columnsE[ei];
                        String dataSource = columnE.getAttributeValue("datasource", "");
                        String col = columnE.getAttributeValue("col", "");
                        String value = columnE.getAttributeValue("value", "");
                        autoFillValueMap.put(String.valueOf(nodeguid) + " " + dataSource + " " + col, value);
                        ++ei;
                    }
                    ++ni;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return autoFillValueMap;
    }

    public static ArrayList LoadSheetVisibleList(Document document) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Element securityConfig = document.getRootElement();
            Element securityE = securityConfig.getElement("sheetvisible");
            if (securityE != null) {
                Element[] nodesE = securityE.getElements("node");
                int ni = 0;
                while (ni < nodesE.length) {
                    Element nodeE = nodesE[ni];
                    String nodeguid = nodeE.getAttributeValue("guid", "");
                    Element[] columnsE = nodeE.getElements("worksheet");
                    int ei = 0;
                    while (ei < columnsE.length) {
                        Element columnE = columnsE[ei];
                        String sheetGuid = columnE.getAttributeValue("sheetguid", "");
                        ret.add(String.valueOf(nodeguid) + " " + sheetGuid);
                        ++ei;
                    }
                    ++ni;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static ArrayList LoadCellClickDisabledList(Document document) {
        ArrayList<String> ret;
        block9: {
            ret = new ArrayList<String>();
            try {
                Element securityConfig = document.getRootElement();
                Element securityE = securityConfig.getElement("cellclickdisable");
                if (securityE == null) break block9;
                Element[] nodesE = securityE.getElements("node");
                int ni = 0;
                while (ni < nodesE.length) {
                    JSONArray ja;
                    JSONObject js;
                    Element nodeE = nodesE[ni];
                    String nodeguid = nodeE.getAttributeValue("guid", "");
                    String t = nodeE.getText();
                    try {
                        js = new JSONObject(t);
                    }
                    catch (Exception er) {
                        js = new JSONObject();
                    }
                    if (js.getBoolean("disabledall", false)) {
                        ret.add(String.valueOf(nodeguid) + " all");
                    }
                    if ((ja = js.getJSONArray("sheets", null)) != null) {
                        int ji = 0;
                        while (ji < ja.length()) {
                            String sheetGuid = ja.getJSONObject(ji).getString("sheetguid", "");
                            String cells = ja.getJSONObject(ji).getString("cells", "");
                            StringTokenizer stk = new StringTokenizer(cells, " ");
                            ret.add("config:" + nodeguid + ":" + sheetGuid + ":" + cells);
                            while (stk.hasMoreTokens()) {
                                String cellName = stk.nextToken();
                                if (cellName.equals("")) continue;
                                ret.add((String.valueOf(nodeguid) + " " + sheetGuid + " " + cellName).toLowerCase());
                            }
                            ++ji;
                        }
                    }
                    ++ni;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public static ArrayList LoadBrickEnabledList(Document document) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Element securityConfig = document.getRootElement();
            Element securityE = securityConfig.getElement("brickenabled");
            if (securityE != null) {
                Element[] nodesE = securityE.getElements("node");
                int ni = 0;
                while (ni < nodesE.length) {
                    Element nodeE = nodesE[ni];
                    String nodeguid = nodeE.getAttributeValue("guid", "");
                    Element[] columnsE = nodeE.getElements("brick");
                    int ei = 0;
                    while (ei < columnsE.length) {
                        Element columnE = columnsE[ei];
                        String sheetGuid = columnE.getAttributeValue("sheetguid", "");
                        String name = columnE.getAttributeValue("name", "");
                        ret.add(String.valueOf(nodeguid) + " " + sheetGuid + " " + name);
                        ++ei;
                    }
                    ++ni;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static void loadValueFromCellDefineAsDefaultValue(WorkBook book) {
        DataSourceConfig[] dscs = book.getDataSources();
        int i = 0;
        while (i < dscs.length) {
            DataSourceConfig dsc = dscs[i];
            dsc.loadValueFromCellDefineAsDefaultValue();
            ++i;
        }
    }
}

