/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import excel.brick.Brick;
import excel.brick.Chart;
import excel.brick.DBBar;
import excel.brick.OnlyBorder;
import excel.brick.PageBar;
import excel.brick.Tree;
import excel.brick.TreeDataProvider;
import excel.brick.VirtualButton;
import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.DBBindConfig;
import excel.core.EditStyle;
import excel.core.RowPropertyManage;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import jun.db.core.ObjectTool;
import org.json.JSONObject;
import org.kxml.Attribute;
import org.kxml.kdom.Document;
import org.kxml.kdom.Element;
import org.kxml.parser.KXML;
import wiseoa.flow.applet.FlowFormTreeDataProvider;
import wiseoa.flow.applet.Tools;

public class ZExcelCopyTool {
    public static final String ShowComma = "show-comma";
    public static final String DecimalCount = "decimal-count";
    public static final String DatetimeFormat = "datetime-format";
    public static final String DropDownListEditable = "ddlb-editable";
    public static final String DropDownDataMap = "ddlb-data-map";
    public static final String CheckOnValue = "check-on-value";
    public static final String CheckOffValue = "check-off-value";
    public static final String CheckBoxTipText = "checkbox-tip-text";

    public static void InitUI(WorkSheet toSheet, int startRow, int startCol, int fromSheetIndex, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, RPCParameter p, String HomeURL) {
        try {
            KXML xml = KXML.newInstance((byte[])((byte[])p.get("ui")));
            Document document = new Document();
            document.parse(xml);
            Element uiConfig = document.getRootElement();
            Element[] sheetsE = uiConfig.getElements("worksheet");
            if (fromSheetIndex > sheetsE.length - 1) {
                return;
            }
            Element sheetE = sheetsE[fromSheetIndex];
            String tag = sheetE.getAttributeValue("tag", "");
            if (!tag.equals("")) {
                toSheet.setTag((Object)tag);
            }
            ZExcelCopyTool.InitRowHeight(toSheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol);
            ZExcelCopyTool.InitColumnWidth(toSheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol);
            toSheet.UnMerge(startRow, startCol, startRow + fromEndRow - fromStartRow, startCol + fromEndCol - fromStartCol);
            ZExcelCopyTool.InitSheetAliasCells(toSheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol);
            ZExcelCopyTool.InitSheetCells(toSheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int TROW(int startRow, int sourceRow, int fromStartRow) {
        return startRow + sourceRow - fromStartRow;
    }

    public static int TCOL(int startCol, int sourceCol, int fromStartCol) {
        return startCol + sourceCol - fromStartCol;
    }

    public static void InitRowHeight(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol) {
        Element[] rowsE = sheetE.getElements("row");
        RowPropertyManage RPM = sheet.getRowPropertyManage();
        int delta = fromEndRow - fromStartRow + 1 - (RPM.getRowCount() - startRow);
        int i = 0;
        while (i < delta) {
            sheet.insertMultiRow(RPM.getRowCount(), RPM.getRowCount());
            ++i;
        }
        int ri = 0;
        while (ri < rowsE.length) {
            Element rowE = rowsE[ri];
            int index = rowE.getAttributeValue("index", 0);
            if (index >= fromStartRow && index <= fromEndRow) {
                int height = rowE.getAttributeValue("height", 21);
                int dbheight = rowE.getAttributeValue("dbrowheight", 21);
                boolean columnscrollenabled = rowE.getAttributeValue("columnscrollenabled", true);
                RPM.setRowHeight(ZExcelCopyTool.TROW(startRow, index, fromStartRow), height);
                RPM.setDBRowHeight(ZExcelCopyTool.TROW(startRow, index, fromStartRow), dbheight);
                RPM.setGroupRowHeight(ZExcelCopyTool.TROW(startRow, index, fromStartRow), dbheight);
                RPM.setColumnScrollEnable(ZExcelCopyTool.TROW(startRow, index, fromStartRow), columnscrollenabled);
            }
            ++ri;
        }
    }

    public static void InitColumnWidth(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol) {
        Element[] colsE = sheetE.getElements("column");
        ColumnPropertyManage CPM = sheet.getColumnPropertyManage();
        int delta = fromEndCol - fromStartCol + 1 - (CPM.getColumnCount() - startCol);
        int i = 0;
        while (i < delta) {
            sheet.insertMultiColumn(CPM.getColumnCount(), CPM.getColumnCount());
            ++i;
        }
        int ci = 0;
        while (ci < colsE.length) {
            Element colE = colsE[ci];
            int index = colE.getAttributeValue("index", 0);
            if (index >= fromStartCol && index <= fromEndCol) {
                int width = colE.getAttributeValue("width", 72);
                CPM.setColumnWidth(ZExcelCopyTool.TCOL(startCol, index, fromStartCol), width);
            }
            ++ci;
        }
    }

    public static boolean isNeedCopy(int row, int col, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol) {
        if (row < fromStartRow) {
            return false;
        }
        if (row > fromEndRow) {
            return false;
        }
        if (col < fromStartCol) {
            return false;
        }
        return col <= fromEndCol;
    }

    public static void InitSheetCells(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        Element[] cellsE = sheetE.getElements("cell");
        int ei = 0;
        while (ei < cellsE.length) {
            Element cellE = cellsE[ei];
            ZExcelCopyTool.InitSheetCell(sheet, startRow, startCol, cellE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
            ++ei;
        }
    }

    public static void InitSheetAliasCells(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol) {
        Element[] cellsE = sheetE.getElements("cell");
        int ei = 0;
        while (ei < cellsE.length) {
            Cell cell;
            String alias;
            int col;
            Element cellE = cellsE[ei];
            int row = cellE.getAttributeValue("row", 0);
            if (ZExcelCopyTool.isNeedCopy(row, col = cellE.getAttributeValue("col", 0), fromStartRow, fromStartCol, fromEndRow, fromEndCol) && (alias = cellE.getAttributeValue("alias", "")).length() > 0 && (cell = sheet.Cells(ZExcelCopyTool.TROW(startRow, row, fromStartRow), ZExcelCopyTool.TCOL(startCol, col, fromStartCol))) != null) {
                cell.setAlias(alias);
            }
            ++ei;
        }
    }

    public static void InitSheetCell(WorkSheet sheet, int startRow, int startCol, Element cellE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        try {
            int row = cellE.getAttributeValue("row", 0);
            int col = cellE.getAttributeValue("col", 0);
            if (!ZExcelCopyTool.isNeedCopy(row, col, fromStartRow, fromStartCol, fromEndRow, fromEndCol)) {
                return;
            }
            Vector attrs = cellE.getAttributes();
            Cell cell = sheet.Cells(ZExcelCopyTool.TROW(startRow, row, fromStartRow), ZExcelCopyTool.TCOL(startCol, col, fromStartCol));
            if (cell == null) {
                return;
            }
            String cvnl = cellE.getAttributeValue("customValueNameList", "");
            if (cvnl.length() > 0) {
                String[] cks = cvnl.split(",", 9999);
                int i = 0;
                while (i < cks.length) {
                    String key = cks[i];
                    if (!key.equals("")) {
                        String value = cellE.getAttributeValue(key, "");
                        cell.setCustomValue(key, value);
                    }
                    ++i;
                }
            }
            cell.setEditable(false);
            int ai = 0;
            while (ai < attrs.size()) {
                Attribute attr = (Attribute)attrs.get(ai);
                String attrName = attr.getName().toLowerCase().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("row") && !attrName.equals("col")) {
                    if (attrName.equals("value")) {
                        cell.setValue((Object)attrValue);
                    }
                    if (attrName.equals("tag")) {
                        cell.setTag((Object)attrValue);
                    }
                    if (attrName.equals("tooltip")) {
                        cell.setToolTip(attrValue);
                    }
                    if (attrName.equals("formulaispriority")) {
                        cell.setFormulaIsPriority(Tools.String2Int(attrValue));
                    }
                    if (attrName.equals("cellvaluetype")) {
                        cell.setCellValueType(Tools.String2Int(attrValue));
                    }
                    if (attrName.equals("rowspan")) {
                        int mr = ObjectTool.toInt((Object)cellE.getAttributeValue("rowspan", "1"));
                        int mc = ObjectTool.toInt((Object)cellE.getAttributeValue("colspan", "1"));
                        sheet.Merge(ZExcelCopyTool.TROW(startRow, row, fromStartRow), ZExcelCopyTool.TCOL(startCol, col, fromStartCol), ZExcelCopyTool.TROW(startRow, row + mr - 1, fromStartRow), ZExcelCopyTool.TCOL(startCol, col + mc - 1, fromStartCol));
                    }
                    if (attrName.equals("column")) {
                        String ds = cellE.getAttributeValue("datasource", "default");
                        cell.setBind(ds, attrValue);
                    }
                    WorkBook book = sheet.getWorkBook();
                    if (attrName.equals("border-left-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-left-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-left-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-right-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-right-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-right-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-top-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-top-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-top-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-bottom-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-bottom-style")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("border-bottom-width")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-bottom")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-left")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-right")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("padding-top")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-mode")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-image")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-position-x")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-position-y")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-repeat-x")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("background-repeat-y")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-name")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-size")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-bold")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-italic")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-underline")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("word-wrap")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("font-color")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("align-h")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                    if (attrName.equals("align-v")) {
                        cell.setProperty(attrName, (Object)attrValue);
                    }
                }
                ++ai;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }

    public static Element InitBind(WorkSheet sheet, int startRow, int startCol, int fromSheetIndex, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, RPCParameter p, String HomeURL) {
        Element[] sheetsE;
        Element bindConfig;
        block3: {
            bindConfig = null;
            KXML xml = KXML.newInstance((byte[])((byte[])p.get("bind")));
            Document document = new Document();
            document.parse(xml);
            bindConfig = document.getRootElement();
            sheetsE = bindConfig.getElements("worksheet");
            if (fromSheetIndex <= sheetsE.length - 1) break block3;
            return null;
        }
        try {
            Element sheetE = sheetsE[fromSheetIndex];
            ZExcelCopyTool.InitSheetBinds(sheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bindConfig;
    }

    public static void InitSheetBinds(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        Element[] cellsE = sheetE.getElements("bind");
        int ei = 0;
        while (ei < cellsE.length) {
            Element cellE = cellsE[ei];
            ZExcelCopyTool.InitSheetBind(sheet, startRow, startCol, cellE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
            ++ei;
        }
    }

    public static void InitSheetBind(WorkSheet sheet, int startRow, int startCol, Element bindE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        try {
            int row = bindE.getAttributeValue("row", 0);
            int col = bindE.getAttributeValue("col", 0);
            if (!ZExcelCopyTool.isNeedCopy(row, col, fromStartRow, fromStartCol, fromEndRow, fromEndCol)) {
                return;
            }
            Cell cell = sheet.Cells(ZExcelCopyTool.TROW(startRow, row, fromStartRow), ZExcelCopyTool.TCOL(startCol, col, fromStartCol));
            Vector attrs = bindE.getAttributes();
            int ai = 0;
            while (ai < attrs.size()) {
                Attribute attr = (Attribute)attrs.get(ai);
                String attrName = attr.getName().toLowerCase().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("row") && !attrName.equals("col") && attrName.equals("dbcol")) {
                    String ds = bindE.getAttributeValue("datasource", "default");
                    cell.setBind(ds, attrValue);
                }
                ++ai;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Element InitEditStyle(WorkSheet sheet, int startRow, int startCol, int fromSheetIndex, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, RPCParameter p, String HomeURL) {
        Element[] sheetsE;
        Element bindConfig;
        block3: {
            bindConfig = null;
            KXML xml = KXML.newInstance((byte[])((byte[])p.get("editstyle")));
            Document document = new Document();
            document.parse(xml);
            bindConfig = document.getRootElement();
            sheetsE = bindConfig.getElements("worksheet");
            if (fromSheetIndex <= sheetsE.length - 1) break block3;
            return null;
        }
        try {
            Element sheetE = sheetsE[fromSheetIndex];
            ZExcelCopyTool.InitSheetEditStyles(sheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bindConfig;
    }

    public static void InitSheetEditStyles(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        Element[] cellsE = sheetE.getElements("editstyle");
        int ei = 0;
        while (ei < cellsE.length) {
            Element cellE = cellsE[ei];
            ZExcelCopyTool.InitSheetEditStyle(sheet, startRow, startCol, cellE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
            ++ei;
        }
    }

    public static void InitSheetEditStyle(WorkSheet sheet, int startRow, int startCol, Element bindE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        try {
            int row = bindE.getAttributeValue("row", 0);
            int col = bindE.getAttributeValue("col", 0);
            if (!ZExcelCopyTool.isNeedCopy(row, col, fromStartRow, fromStartCol, fromEndRow, fromEndCol)) {
                return;
            }
            Cell cell = sheet.Cells(ZExcelCopyTool.TROW(startRow, row, fromStartRow), ZExcelCopyTool.TCOL(startCol, col, fromStartCol));
            Vector attrs = bindE.getAttributes();
            cell.setEditable(false);
            WorkBook book = sheet.getWorkBook();
            int ai = 0;
            while (ai < attrs.size()) {
                Attribute attr = (Attribute)attrs.get(ai);
                String attrName = attr.getName().toLowerCase().trim();
                String attrValue = attr.getValue();
                if (!attrName.equals("row") && !attrName.equals("col")) {
                    if (attrName.equals("editable")) {
                        boolean b = ObjectTool.toBool((Object)attrValue);
                        if (!b) {
                            cell.setEditable(false);
                        } else {
                            DBBindConfig dbc = cell.getBind();
                            if (dbc != null && (b = true) && dbc.getDataSourceType() == 1) {
                                OnlyBorder brick = book.createOnlyBorderBrick("EditableHightLight", new Color(16760220), 2, 1);
                                brick.setBounds(1, 1, 0, 0);
                                brick.setPrintable(false);
                                cell.addBrick((Brick)brick);
                            }
                            cell.setEditable(b);
                        }
                    }
                    if (attrName.equals("edittype")) {
                        EditStyle es;
                        String name;
                        if (attrValue.equalsIgnoreCase("normal")) {
                            cell.setEditStyle(null);
                        }
                        if (attrValue.equalsIgnoreCase("multiline")) {
                            String name2 = "multiline";
                            EditStyle es2 = book.getEditStyle(name2);
                            if (es2 == null) {
                                es2 = book.newEditStyle(book, name2, 2);
                                book.AddEditStyle(es2);
                            }
                            cell.setEditStyle(es2);
                        }
                        if (attrValue.equalsIgnoreCase("numeric")) {
                            boolean showComma = bindE.getAttributeValue(ShowComma, true);
                            int decimalCount = bindE.getAttributeValue(DecimalCount, 2);
                            boolean zeroVisibleWhenEditable = bindE.getAttributeValue("zerovisiblewheneditable", true);
                            boolean zeroVisibleWhenUneditable = bindE.getAttributeValue("zerovisiblewhenuneditable", true);
                            name = String.valueOf(attrValue.toLowerCase()) + String.valueOf(showComma) + String.valueOf(decimalCount);
                            es = book.getEditStyle(name);
                            if (es == null) {
                                es = book.newEditStyle(book, name, 1);
                                es.setShowComma(showComma);
                                es.setDecimalCount(decimalCount);
                                es.setZeroVisibleWhenEditable(zeroVisibleWhenEditable);
                                es.setZeroVisibleWhenUneditable(zeroVisibleWhenUneditable);
                                book.AddEditStyle(es);
                            }
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("datetime")) {
                            String datetime_format = bindE.getAttributeValue(DatetimeFormat, "YYYY.MM.DD");
                            String name3 = String.valueOf(attrValue.toLowerCase()) + datetime_format;
                            EditStyle es3 = book.getEditStyle(name3);
                            if (es3 == null) {
                                es3 = book.newEditStyle(book, name3, 3);
                                es3.setDatetimeFormat(datetime_format);
                                book.AddEditStyle(es3);
                            }
                            cell.setEditStyle(es3);
                        }
                        if (attrValue.equalsIgnoreCase("checkbox")) {
                            String CheckOnValue = bindE.getAttributeValue(CheckOnValue, "");
                            String CheckOffValue = bindE.getAttributeValue(CheckOffValue, "");
                            String CheckBoxTipText = bindE.getAttributeValue(CheckBoxTipText, "");
                            String name4 = String.valueOf(attrValue.toLowerCase()) + CheckOnValue + CheckOffValue + CheckBoxTipText;
                            EditStyle es4 = book.getEditStyle(name4);
                            if (es4 == null) {
                                es4 = book.newEditStyle(book, name4, 5);
                                es4.setCheckOnValue(CheckOnValue);
                                es4.setCheckOffValue((Object)CheckOffValue);
                                es4.setCheckBoxTipText(CheckBoxTipText);
                                book.AddEditStyle(es4);
                            }
                            cell.setEditStyle(es4);
                        }
                        if (attrValue.equalsIgnoreCase("ddlb")) {
                            String editstyle = bindE.getAttributeValue("editstyle", "");
                            String style = bindE.getAttributeValue("ddlb-style", "ddlb");
                            boolean ddlbeditable = bindE.getAttributeValue(DropDownListEditable, false);
                            String ddlbstyle = bindE.getAttributeValue("ddlb-style", "ddlb");
                            name = String.valueOf(attrValue.toLowerCase()) + editstyle + String.valueOf(ddlbeditable) + ddlbstyle;
                            es = book.getEditStyle(name);
                            if (es == null) {
                                es = book.newEditStyle(book, name, 4);
                                HashMap map = null;
                                RPCParameter p = new RPCParameter();
                                p.put("editstyle", editstyle);
                                p = RPC.Call(String.valueOf(HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "getDDLBMap", p);
                                if (p.Success) {
                                    map = (HashMap)p.get("map");
                                    JSONObject ddlbConfig = (JSONObject)p.get("ddlbconfig");
                                    if (ddlbConfig.getString("filterby", "").trim().length() > 0) {
                                        es.setDDLBFilterBy(ddlbConfig.toString());
                                    }
                                }
                                es.setDropDownData2ViewMap(map);
                                es.setDropDownListEditable(ddlbeditable);
                                book.AddEditStyle(es);
                            }
                            if (style.equals("radio")) {
                                es.setListShowAsRadioButton();
                            }
                            if (style.equals("checkbox")) {
                                es.setListShowAsCheckBox();
                            }
                            if (style.equals("ddlbcheckbox")) {
                                es.setListShowAsDropdownCheckBox();
                            }
                            es.setDDLBName(editstyle);
                            es.setColumnCountOnRow(bindE.getAttributeValue("columncount", 1));
                            es.setDDLBWidthPercent(bindE.getAttributeValue("DDLBWidthPercent", 100));
                            es.setShowRealData(bindE.getAttributeValue("isShowRealData", false));
                            es.setValueMustInDDLB(bindE.getAttributeValue("valueMustInDDLB", false));
                            cell.setEditStyle(es);
                        }
                        if (attrValue.equalsIgnoreCase("richedit")) {
                            String name5 = "htmlrichedit";
                            EditStyle es5 = book.getEditStyle(name5);
                            if (es5 == null) {
                                es5 = book.newEditStyle(book, name5, 7);
                                book.AddEditStyle(es5);
                            }
                            cell.setEditStyle(es5);
                        }
                    }
                }
                ++ai;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void InitBrick(WorkSheet sheet, int startRow, int startCol, int fromSheetIndex, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, RPCParameter p, String HomeURL) {
        Element brickConfig = null;
        KXML xml = KXML.newInstance((byte[])((byte[])p.get("brick")));
        try {
            Document document = new Document();
            document.parse(xml);
            brickConfig = document.getRootElement();
            Element[] sheetsE = brickConfig.getElements("worksheet");
            if (fromSheetIndex > sheetsE.length - 1) {
                return;
            }
            Element sheetE = sheetsE[fromSheetIndex];
            ZExcelCopyTool.InitSheetBricks(sheet, startRow, startCol, sheetE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void InitSheetBricks(WorkSheet sheet, int startRow, int startCol, Element sheetE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        Element[] cellsE = sheetE.getElements("brick");
        int ei = 0;
        while (ei < cellsE.length) {
            Element cellE = cellsE[ei];
            ZExcelCopyTool.InitSheetBrick(sheet, startRow, startCol, cellE, fromStartRow, fromStartCol, fromEndRow, fromEndCol, HomeURL);
            ++ei;
        }
    }

    public static void InitSheetBrick(WorkSheet sheet, int startRow, int startCol, Element brickE, int fromStartRow, int fromStartCol, int fromEndRow, int fromEndCol, String HomeURL) {
        try {
            String to;
            VirtualButton brick;
            String datasource;
            WorkBook book = sheet.getWorkBook();
            int row = brickE.getAttributeValue("row", 0);
            int col = brickE.getAttributeValue("col", 0);
            String brickName = brickE.getAttributeValue("name", "");
            if (!ZExcelCopyTool.isNeedCopy(row, col, fromStartRow, fromStartCol, fromEndRow, fromEndCol)) {
                return;
            }
            Cell cell = sheet.Cells(ZExcelCopyTool.TROW(startRow, row, fromStartRow), ZExcelCopyTool.TCOL(startCol, col, fromStartCol));
            Vector attrs = brickE.getAttributes();
            String type = brickE.getAttributeValue("type", "").toLowerCase();
            if (type.equals("dbbar")) {
                datasource = brickE.getAttributeValue("datasource", "");
                if (datasource.equals("")) {
                    datasource = "default";
                }
                String action = brickE.getAttributeValue("action", "").trim().toLowerCase();
                int Action2 = 1;
                if (action.equals("insertbefore")) {
                    Action2 = 1;
                }
                if (action.equals("insertafter")) {
                    Action2 = 2;
                }
                if (action.equals("deleterow")) {
                    Action2 = 3;
                }
                if (action.equals("clonerow")) {
                    Action2 = 20;
                }
                DBBar brick2 = book.createDBBarBrick(brickE.getAttributeValue("name", ""), datasource, Action2);
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick2.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick2);
            }
            if (type.equals("tree")) {
                Tree tree;
                String connection = brickE.getAttributeValue("connection", "");
                String sql = brickE.getElement("sql").getText();
                String rootValue = brickE.getAttributeValue("rootvalue", "");
                String rootLabel = brickE.getAttributeValue("rootlabel", "");
                boolean isMulti = brickE.getAttributeValue("multi", false);
                boolean isAutoLoad = brickE.getAttributeValue("autoload", true);
                boolean lazyloading = brickE.getAttributeValue("lazyloading", false);
                Object ja = null;
                if (!sheet.isDesignMode()) {
                    FlowFormTreeDataProvider tdp = new FlowFormTreeDataProvider(HomeURL, sheet, connection, sql, rootValue, rootLabel);
                    tree = book.createTreeBrick(brickName, isMulti, rootLabel, rootValue, (TreeDataProvider)tdp, isAutoLoad, lazyloading);
                } else {
                    tree = book.createTreeBrick(brickName, isMulti, rootLabel, rootValue, null);
                }
                tree.setConnection(connection);
                tree.setRootLabel(rootLabel);
                tree.setRootValue(rootValue);
                tree.setSelect(sql);
                tree.setLazyLoading(lazyloading);
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                tree.setBounds(X, Y, W, H);
                cell.addBrick((Brick)tree);
            }
            if (type.equals("pagebar")) {
                datasource = brickE.getAttributeValue("datasource", "");
                int rc = brickE.getAttributeValue("rowcount", 10);
                PageBar brick3 = book.createPageBar(brickE.getAttributeValue("name", ""), datasource, rc);
                brick3.setExportAllWithoutDataPageLimit(brickE.getAttributeValue("exportallwithoutdatapagelimit", false));
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick3.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick3);
            }
            if (type.equals("button")) {
                brick = book.createVirtualButton(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""));
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("chart")) {
                String chartType = brickE.getAttributeValue("charttype", "bar3d");
                String name = brickE.getAttributeValue("name", "");
                String caption = brickE.getAttributeValue("caption", "");
                String categoryAxisLabel = brickE.getAttributeValue("categoryAxisLabel", "");
                String valueAxisLabel = brickE.getAttributeValue("valueAxisLabel", "");
                float alpha = (float)brickE.getAttributeValue("alpha", 50) / 100.0f;
                boolean serialAngled = brickE.getAttributeValue("serialAngled", true);
                String range = brickE.getAttributeValue("range", "");
                String serialCol = brickE.getAttributeValue("serialCol", "");
                String categoryCol = brickE.getAttributeValue("categoryCol", "");
                String valueCol = brickE.getAttributeValue("valueCol", "");
                String valueCol2 = brickE.getAttributeValue("valueCol2", "");
                Chart brick4 = book.createChart(chartType, name, caption, categoryAxisLabel, valueAxisLabel, alpha, serialAngled, range, serialCol, categoryCol, valueCol, valueCol2);
                String serialColMap = brickE.getAttributeValue("serialColMap", "");
                String categoryColMap = brickE.getAttributeValue("categoryColMap", "");
                brick4.setSeriesColMap(serialColMap);
                brick4.setCategoryColMap(categoryColMap);
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick4.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick4);
            }
            if (type.equals("rotatedtext")) {
                brick = book.createRotatedText(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""), brickE.getAttributeValue("angle", 0));
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick.setFontName(brickE.getAttributeValue("fontname", "\u5b8b\u4f53"));
                brick.setFontSize(brickE.getAttributeValue("fontsize", 12));
                brick.setFontColor((Object)Tools.Hex2Color(brickE.getAttributeValue("fontcolor", "0x000000")));
                brick.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("retrievebutton")) {
                brick = book.createRetrieveButton(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""), brickE.getAttributeValue("datasource", ""));
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("line")) {
                brick = book.createLine(brickE.getAttributeValue("name", ""), Tools.Hex2Color(brickE.getAttributeValue("color", "")), brickE.getAttributeValue("style", 1), brickE.getAttributeValue("size", 1));
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick);
            }
            if (type.equals("loadimagebutton")) {
                to = brickE.getAttributeValue("to", "datastore");
                Object brick5 = null;
                brick5 = to.equals("datastore") ? book.createLoadImageToDSVirtualButton(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""), brickE.getAttributeValue("datasource", ""), brickE.getAttributeValue("tocol", "")) : book.createLoadImageToCellVirtualButton(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""), brickE.getAttributeValue("tosheetname", ""), brickE.getAttributeValue("torow", 0), brickE.getAttributeValue("tocol", 0));
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick5.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick5);
            }
            if (type.equals("loadcamerabutton")) {
                to = brickE.getAttributeValue("to", "datastore");
                int vw = brickE.getAttributeValue("vw", 0);
                int vh = brickE.getAttributeValue("vh", 0);
                int cw = brickE.getAttributeValue("cw", 0);
                int ch = brickE.getAttributeValue("ch", 0);
                Object brick6 = null;
                brick6 = to.equals("datastore") ? book.createLoadCameraToDSVirtualButton(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""), brickE.getAttributeValue("datasource", ""), brickE.getAttributeValue("tocol", ""), vw, vh, cw, ch) : book.createLoadCameraToCellVirtualButton(brickE.getAttributeValue("name", ""), brickE.getAttributeValue("caption", ""), brickE.getAttributeValue("tosheetname", ""), brickE.getAttributeValue("torow", 0), brickE.getAttributeValue("tocol", 0), vw, vh, cw, ch);
                int X = brickE.getAttributeValue("x", 0);
                int Y = brickE.getAttributeValue("y", 0);
                int W = brickE.getAttributeValue("width", 0);
                int H = brickE.getAttributeValue("height", 0);
                brick6.setBounds(X, Y, W, H);
                cell.addBrick((Brick)brick6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

