/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import excel.brick.Brick;
import excel.brick.Chart;
import excel.brick.StaticImage;
import excel.core.Cell;
import excel.core.DBBindConfig;
import excel.core.DataSourceConfig;
import excel.core.Depend;
import excel.core.EditStyle;
import excel.core.Range;
import excel.core.WorkBook;
import excel.core.WorkSheet;
import excel.core.WorkSheetView;
import excel.event.adapter.WorkBookAdapter;
import excel.jep.ASTVarNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingWorker;
import jun.db.core.DataBuffer;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import org.json.JSONArray;
import org.json.JSONObject;
import org2.mozilla.javascript.Context;
import org2.mozilla.javascript.Function;
import org2.mozilla.javascript.Scriptable;
import wiseoa.flow.applet.AutoComplete;
import wiseoa.flow.applet.CodeHelpConfig;
import wiseoa.flow.applet.CopyTo;
import wiseoa.flow.applet.FlowForm;
import wiseoa.flow.applet.PopData;
import wiseoa.flow.applet.RelativeData;
import wiseoa.flow.applet.RhinoTools;
import wiseoa.flow.applet.Tools;
import wiseoa.flow.applet.ZExcelTool;

class WorkBookEvent
extends WorkBookAdapter {
    String Script;
    FlowForm ff;
    HashMap buttonOnClickedMap = new HashMap();
    Scriptable scope;
    HashMap dsOrderBy = new HashMap();
    boolean cellClickOK = true;
    boolean cellDblClickOK = true;

    public WorkBookEvent(FlowForm b, Scriptable ss) {
        this.ff = b;
        this.scope = ss;
    }

    public void onTreeSelectionChanged(String treeName, String group, String text, String data) {
        final String $treeName = treeName;
        final String $group = group;
        final String $text = text;
        final String $data = data;
        boolean sync = false;
        if (sync) {
            this.$onTreeSelectionChanged($treeName, $group, $text, $data);
        } else {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    FlowForm.$log(new Date() + " onTreeSelectionChanged \u5f00\u59cb\u6267\u884c\u3002");
                    WorkBookEvent.this.$onTreeSelectionChanged($treeName, $group, $text, $data);
                    return "";
                }

                protected void done() {
                    FlowForm.$log(new Date() + " onTreeSelectionChanged \u6267\u884c\u5b8c\u6210\u3002");
                }
            };
            worker.execute();
        }
    }

    public void $onTreeSelectionChanged(String treeName, String group, String text, String data) {
        String $treeName = treeName;
        String $group = group;
        String $text = text;
        String $data = data;
        this.ff.RunScript("onTreeSelectionChanged", new Object[]{$treeName, $group, $text, $data});
    }

    public void endEdit(WorkSheet sheet, int row, int col, int dbRow, boolean enterKeyPressed, boolean isShiftDown, boolean isControlDown) {
        this.ff.RunScript("endEdit", new Object[]{sheet, new Integer(row), new Integer(col), new Integer(dbRow), enterKeyPressed, isShiftDown, isControlDown});
    }

    public void beginEdit(WorkSheet sheet, int row, int col, int dbRow) {
        this.ff.RunScript("beginEdit", new Object[]{sheet, new Integer(row), new Integer(col), new Integer(dbRow)});
    }

    public void editFocusChanged(WorkSheet sheet, int lastRow, int lastCol, int newRow, int newCol) {
        this.ff.RunScript("editFocusChanged", new Object[]{sheet, new Integer(lastRow), new Integer(lastCol), new Integer(newRow), new Integer(newCol)});
    }

    public void keyPressed(WorkSheet sheet, KeyEvent e, int editingRow, int editingCol, int dbRow) {
        if (e.isControlDown() && e.isShiftDown() && e.getKeyCode() == 118) {
            this.ff.showDebugWindow();
        }
        if (e.isControlDown() && e.isShiftDown() && e.getKeyCode() == 119) {
            this.ff.showDebugWindow2();
        }
        if (e.isControlDown() && e.isShiftDown() && e.getKeyCode() == 120) {
            this.ff.reloadScript();
        }
        this.ff.RunScript("keyPressed", new Object[]{sheet, e, new Integer(editingRow), new Integer(editingCol), new Integer(dbRow)});
    }

    public void keyReleased(WorkSheet sheet, KeyEvent e, int editingRow, int editingCol, int dbRow) {
        this.ff.RunScript("keyReleased", new Object[]{sheet, e, new Integer(editingRow), new Integer(editingCol), new Integer(dbRow)});
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getCurrentBindRowOfExpression(WorkSheet parseSheet, String expression) {
        int ret = -99;
        FlowForm.$log("\u53d6\u6570\u8868\u8fbe\u5f0f:" + expression);
        ArrayList dependList = parseSheet.parseDependList(expression);
        if (dependList.size() == 0) {
            return ret;
        }
        WorkBook book = parseSheet.getWorkBook();
        boolean ignore = false;
        int di = 0;
        while (di < dependList.size()) {
            block14: {
                boolean startRow = false;
                boolean endRow = false;
                boolean startCol = false;
                boolean endCol = false;
                WorkSheet checkSheet = null;
                Depend da = (Depend)dependList.get(di);
                ASTVarNode var = da.node;
                int varKind = var.getToken().kind;
                String varName = var.getName();
                System.out.print(String.valueOf(parseSheet.getName()) + "\u89e3\u6790\u8868\u8fbe\u5f0f" + expression + "\u5f15\u7528\u4e86\u5355\u5143\u683c:" + varName + "  sheetGuid=" + da.SheetGuid);
                Cell cell = null;
                switch (varKind) {
                    case 10: 
                    case 11: {
                        checkSheet = parseSheet;
                        cell = checkSheet.cells(varName);
                        break;
                    }
                    case 12: {
                        checkSheet = parseSheet;
                        Range range = parseSheet.rangeNameToRange(varName);
                        if (range == null) break;
                        cell = checkSheet.cells(range.getStartRow(), range.getStartCol());
                        break;
                    }
                    case 13: 
                    case 15: {
                        int p = varName.indexOf("!");
                        if (p <= 0) break;
                        String SheetName = varName.substring(0, p).trim();
                        checkSheet = book.getWorkSheet(SheetName);
                        if (checkSheet != null) {
                            cell = checkSheet.cells(varName.substring(p + 1, varName.length()));
                            break;
                        }
                        break block14;
                    }
                    case 14: {
                        int p = varName.indexOf("!");
                        if (p <= 0) break;
                        String SheetName = varName.substring(0, p).trim();
                        checkSheet = book.getWorkSheet(SheetName);
                        if (checkSheet == null) break block14;
                        Range range = checkSheet.rangeNameToRange(varName.substring(p + 1, varName.length()));
                        if (range == null) break;
                        cell = checkSheet.cells(range.getStartRow(), range.getStartCol());
                    }
                }
                if (cell == null) {
                    return -9999;
                }
                DBBindConfig dbc = cell.getBind();
                DataSourceConfig dsc = null;
                if (dbc == null) {
                    if (cell.getValue() instanceof Vector) {
                        dsc = checkSheet.getRowPropertyManage().getMaximalDataSourceConfig(cell.getRowIndex());
                    }
                } else {
                    dsc = book.getDataSource(dbc.getDataSource());
                }
                if (dsc != null && dsc.getDataSourceType() != 1) {
                    ret = dsc.getCurrentBindRow();
                    FlowForm.$log("\u7ed1\u5b9a\u884c\u53f7\u4e3a:" + ret);
                }
            }
            ++di;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean checkExpressionIsValid(WorkSheet parseSheet, String expression) {
        FlowForm.$log("\u68c0\u6d4b\u8868\u8fbe\u5f0f\u4f9d\u8d56\u7684\u5355\u5143\u683c\u662f\u5426\u662f\u5b58\u5728\u7684 :" + expression);
        ArrayList dependList = parseSheet.parseDependList(expression);
        if (dependList.size() == 0) {
            return true;
        }
        WorkBook book = parseSheet.getWorkBook();
        boolean ignore = false;
        int di = 0;
        while (di < dependList.size()) {
            block10: {
                boolean startRow = false;
                boolean endRow = false;
                boolean startCol = false;
                boolean endCol = false;
                WorkSheet checkSheet = null;
                Depend da = (Depend)dependList.get(di);
                ASTVarNode var = da.node;
                int varKind = var.getToken().kind;
                String varName = var.getName();
                System.out.print(String.valueOf(parseSheet.getName()) + "\u89e3\u6790\u8868\u8fbe\u5f0f" + expression + "\u5f15\u7528\u4e86\u5355\u5143\u683c:" + varName + "  sheetGuid=" + da.SheetGuid);
                Cell cell = null;
                switch (varKind) {
                    case 10: 
                    case 11: {
                        checkSheet = parseSheet;
                        cell = checkSheet.cells(varName);
                        break;
                    }
                    case 12: {
                        checkSheet = parseSheet;
                        Range range = parseSheet.rangeNameToRange(varName);
                        if (range == null) break;
                        cell = checkSheet.cells(range.getStartRow(), range.getStartCol());
                        break;
                    }
                    case 13: 
                    case 15: {
                        int p = varName.indexOf("!");
                        if (p <= 0) break;
                        String SheetName = varName.substring(0, p).trim();
                        checkSheet = book.getWorkSheet(SheetName);
                        if (checkSheet != null) {
                            cell = checkSheet.cells(varName.substring(p + 1, varName.length()));
                            break;
                        }
                        break block10;
                    }
                    case 14: {
                        int p = varName.indexOf("!");
                        if (p <= 0) break;
                        String SheetName = varName.substring(0, p).trim();
                        checkSheet = book.getWorkSheet(SheetName);
                        if (checkSheet == null) break block10;
                        Range range = checkSheet.rangeNameToRange(varName.substring(p + 1, varName.length()));
                        if (range == null) break;
                        cell = checkSheet.cells(range.getStartRow(), range.getStartCol());
                    }
                }
                if (cell == null) {
                    return false;
                }
            }
            ++di;
        }
        return true;
    }

    public Map buildDynamicDDLB(String ddlbConfig, int innerRow) {
        Object v;
        FlowForm.$log("build ddlg  " + ddlbConfig);
        JSONObject config = new JSONObject(ddlbConfig);
        String dataSource = config.getString("datasource", "");
        String sql = config.getString("sql", "");
        String filterBy = config.getString("filterby", "");
        if (dataSource.equals("script")) {
            filterBy = sql;
        }
        if (filterBy.equals("")) {
            return null;
        }
        String dataCol = config.getString("datacol", "");
        String showCol = config.getString("showcol", "");
        WorkSheet sheet = this.ff.book.getActiveSheet();
        if (dataSource.equals("script")) {
            String key = ZExcelTool.getDependedCellsValueListOfExpression(sheet, sql);
            FlowForm.$log(String.valueOf(sql) + "\u4f9d\u8d56\u5355\u5143\u683c\u7684\u503c\uff1a" + key);
            if (this.ff.dynamicDDLBMap.containsKey(key)) {
                FlowForm.$log("\u53ef\u4ee5\u4ece\u7f13\u5b58\u4e2d\u53d6\uff0c\u800c\u4e0d\u662f\u91cd\u65b0\u89e3\u6790");
                return (LinkedHashMap)this.ff.dynamicDDLBMap.get(key);
            }
            LinkedHashMap map = ZExcelTool.buildMapFromJSONArray(sheet, config, -99, this.ff.HomeURL);
            this.ff.dynamicDDLBMap.put(key, map);
            return map;
        }
        filterBy = Tools.replaceEscapeChar(filterBy);
        int currentRow = innerRow;
        if (innerRow < 0) {
            currentRow = WorkBookEvent.getCurrentBindRowOfExpression(sheet, filterBy);
        } else if (!WorkBookEvent.checkExpressionIsValid(sheet, filterBy)) {
            FlowForm.$log(String.valueOf(filterBy) + "\u4e0d\u5408\u6cd5\uff0c\u6240\u4ee5\u4e0d\u8fdb\u884c\u4ea4\u4e92\u8fc7\u6ee4\u3002");
            return null;
        }
        if (currentRow == -9999) {
            FlowForm.$log(String.valueOf(filterBy) + "\u4e2d\u5b9a\u4e49\u7684\u5355\u5143\u683c\u4e0d\u5b58\u5728\uff0c\u6240\u4ee5\u4e0d\u8fdb\u884c\u4ea4\u4e92\u8fc7\u6ee4\u3002");
            return null;
        }
        FlowForm.$log(" currentRow=" + currentRow);
        Object s = sheet.evaluate(filterBy, currentRow);
        if (sql.startsWith("\"") && (v = sheet.evaluate(sql, currentRow)) != null) {
            sql = v.toString();
        }
        if (s == null) {
            Tools.ShowInfo(this.ff, "\u4ea4\u4e92\u6761\u4ef6\uff1a" + filterBy + "\u5b9a\u4e49\u4e0d\u5408\u6cd5");
            return null;
        }
        FlowForm.$log(String.valueOf(filterBy) + "\u89e3\u6790\u7ed3\u679c\u662f\uff1a" + s);
        String key = String.valueOf(dataSource) + "/" + sql + "/" + dataCol + "/" + showCol + "/" + s;
        if (this.ff.dynamicDDLBMap.containsKey(key)) {
            return (LinkedHashMap)this.ff.dynamicDDLBMap.get(key);
        }
        config.put("filterby", s);
        RPCParameter p = new RPCParameter();
        p.put("ddlbConfig", config);
        p = RPC.Call(String.valueOf(this.ff.HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "getDDLBMap2", p);
        if (p.Success) {
            Map map = (Map)p.get("map");
            this.ff.dynamicDDLBMap.put(key, map);
            return map;
        }
        return null;
    }

    public void VirtualButtonClicked(WorkSheet sheet, Cell cell, String name) {
        Brick brick = cell.getBrick(name);
        if (brick != null) {
            brick.setLocked(true);
        }
        if (name.startsWith("codehelp_") && brick == null) {
            String key = name.substring(9);
            DBBindConfig dbc = cell.getBind();
            String dsn = dbc.getDataSource();
            boolean isBindSingleRowDataSource = dbc.getDataSourceType() == 1;
            int row = isBindSingleRowDataSource ? 0 : this.ff.book.getDataSource(dbc.getDataSource()).getCurrentBindRow();
            this.ff.onTreeCodeHelp(sheet, cell, key, row, null);
            return;
        }
        final WorkSheet $sheet = sheet;
        final Cell $cell = cell;
        final String $name = name;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                WorkBookEvent.this.$VirtualButtonClicked($sheet, $cell, $name);
                return "";
            }

            protected void done() {
                WorkBookEvent.this.ff.hideInfoPane();
                Brick brick = $cell.getBrick($name);
                if (brick != null) {
                    brick.setLocked(false);
                }
                WorkBookEvent.this.ff.repaint();
            }
        };
        worker.execute();
    }

    public void $VirtualButtonClicked(WorkSheet sheet, Cell cell, String name) {
        if (name.equals(FlowForm.cs_vb_paigong)) {
            this.ff.PaiGong();
            return;
        }
        this.ff.RunScript("VirtualButtonClicked", new Object[]{sheet, cell, name});
        Brick brick = cell.getBrick(name);
        if (brick != null && brick.getAction() == 13) {
            String dsn = cell.getBrick(name).getDataSource().trim();
            if (dsn.startsWith("{")) {
                JSONObject json = new JSONObject(dsn);
                dsn = json.getString("dsn", "");
                String sheetGuid = json.getString("sheetguid", "");
                WorkSheet sh = this.ff.book.getWorkSheetByGuid(sheetGuid);
                if (sh == null) {
                    sh = sheet;
                    FlowForm.$log("\u6307\u5b9a\u7684guid=" + sheetGuid + "\u7684worksheet\u4e0d\u5b58\u5728");
                }
                this.ff.book.getDataSource(dsn).getDataStore().setAbsolute(0);
                this.ff.smartRetrieve(sh, dsn);
            } else {
                this.ff.book.getDataSource(dsn).getDataStore().setAbsolute(0);
                this.ff.smartRetrieve(sheet, dsn);
            }
        }
        this.ff.RunScript(String.valueOf(name) + "_onclick", new Object[0]);
    }

    public void CellValueChangedByEdit(WorkSheet sheet, Cell cell, Object newValue, int innerRow) {
        this.ff.RunScript("CellValueChangedByEdit", new Object[]{sheet, cell, newValue, innerRow});
    }

    public void CellValueChanged(WorkSheet sheet, Cell cell, Object oldValue, Object newValue, int innerRow) {
        block74: {
            DBBindConfig dbc;
            String codeHelpKey = String.valueOf(sheet.getGUID()) + cell.getName();
            if (this.ff.codeHelpConfig.containsKey(codeHelpKey) && this.ff.isTreeCodeHelpEnabled()) {
                dbc = cell.getBind();
                String dsn = dbc.getDataSource();
                boolean isBindMultiRowDataSource = dbc.getDataSourceType() != 1;
                int row = isBindMultiRowDataSource ? this.ff.book.getDataSource(dbc.getDataSource()).getCurrentBindRow() : 0;
                String value = this.ff.getCurrentEditCellValue(sheet, cell);
                if (value.equals("")) {
                    this.ff.onTreeCodeClear(sheet, cell, codeHelpKey, row);
                } else {
                    CodeHelpConfig chc = (CodeHelpConfig)this.ff.codeHelpConfig.get(codeHelpKey);
                    String sql = "select id from " + chc.codeTable + " where " + "shortcut='" + value + "'  or classcode = '" + value + "'  or classname = '" + value + "'   or id='" + value + "' ";
                    FlowForm.$log(sql);
                    DataStore tds = this.ff.createDataStore("", sql);
                    tds.setOnceRetrieveCount(2);
                    tds.retrieve("isleaf=1");
                    if (tds.getRowCount() == 1) {
                        this.ff.onTreeCodeHelp(sheet, cell, codeHelpKey, row, new JSONArray("['" + tds.getString(0, "id") + "']"));
                    } else {
                        sql = "select id from " + chc.codeTable + " where " + "shortcut='" + value + "'  or classcode like '%" + value + "%'  or classname like '%" + value + "%'   or id='" + value + "' ";
                        FlowForm.$log(sql);
                        tds = this.ff.createDataStore("", sql);
                        tds.setOnceRetrieveCount(2);
                        tds.retrieve("isleaf=1");
                        if (tds.getRowCount() == 1) {
                            this.ff.onTreeCodeHelp(sheet, cell, codeHelpKey, row, new JSONArray("['" + tds.getString(0, "id") + "']"));
                        } else {
                            this.ff.onTreeCodeHelp(sheet, cell, codeHelpKey, row, null);
                        }
                    }
                    FlowForm.$log(String.valueOf(cell.getName()) + " code help end");
                }
            }
            if (this.ff.isAutoCompleteEnabled()) {
                try {
                    String[] keys = new String[]{"all" + cell.getAlias(), String.valueOf(sheet.getGUID()) + cell.getAlias()};
                    int ki = 0;
                    while (ki < keys.length) {
                        String key = keys[ki];
                        if (this.ff.autoCompleteConfig.containsKey(key) && cell.getValueString().trim().length() > 0) {
                            DBBindConfig dbc2 = cell.getBind();
                            if (dbc2 != null) {
                                int itemStatus;
                                DataSourceConfig tdsc = this.ff.book.getDataSource(dbc2.getDataSource());
                                if (tdsc.getDataSourceType() == 2) {
                                    if (innerRow < 0) {
                                        throw new Exception("innerRow<0 \u4e0d\u9700\u8981\u8865\u5168\u5904\u7406");
                                    }
                                    if (innerRow > tdsc.getDataStore().getRowCount() - 1) {
                                        throw new Exception("innerRow=" + innerRow + " . \u884c\u6570\u6709\uff1a" + tdsc.getDataStore().getRowCount() + " .\u53ef\u80fd\u662f\u88ab\u5220\u9664\u7684\u884c\uff0c \u4e0d\u9700\u8981\u8865\u5168\u5904\u7406");
                                    }
                                }
                                if ((itemStatus = tdsc.getDataStore().getPrimaryBuffer().getItemStatus(innerRow, dbc2.getDBCol())) == 2) {
                                    throw new Exception("\u65b0\u63d2\u5165\u7684\u884c\uff0c\u4e14" + dbc2.getDBCol() + "\u5b57\u6bb5\u6ca1\u6709\u6570\u636e\uff0c \u4e0d\u9700\u8981\u8865\u5168\u5904\u7406");
                                }
                            }
                            AutoComplete ac = (AutoComplete)this.ff.autoCompleteConfig.get(key);
                            if (!ac.enabled) {
                                throw new Exception("\u8865\u5168\u6682\u65f6\u88ab\u7981\u7528  ");
                            }
                            String sql = ac.sql;
                            sql = Tools.replaceEscapeChar(sql);
                            int currentRow = innerRow;
                            Object s = sheet.evaluate(sql, currentRow);
                            FlowForm.$log("\u8865\u5168\uff1a" + s);
                            if (s == null) {
                                throw new Exception("\u81ea\u52a8\u586b\u5145\uff1a" + sql + "\u5b9a\u4e49\u4e0d\u5408\u6cd5");
                            }
                            sql = s.toString();
                            DataStore ds = this.ff.createDataStore(ac.cons, sql);
                            ds.setOnceRetrieveCount(100);
                            ds.retrieve();
                            if (ds.getRowCount() > 0) {
                                String v = null;
                                if (ds.getRowCount() == 1) {
                                    v = ds.getString(0, ac.dataCol);
                                } else {
                                    PopData pd = new PopData(ds, ac.dataCol, ac.showCol);
                                    pd.setVisible(true);
                                    v = pd.ret;
                                }
                                if (dbc2 == null) {
                                    if (!cell.getValueString().equals(v)) {
                                        ac.enabled = false;
                                        cell.setValue((Object)v);
                                        ac.enabled = true;
                                        return;
                                    }
                                } else {
                                    int dbr = currentRow;
                                    DataStore bindDs = cell.getDataStore();
                                    if (!bindDs.getString(dbr, dbc2.getDBCol()).equals(v)) {
                                        ac.enabled = false;
                                        bindDs.setValue(dbr, dbc2.getDBCol(), (Object)v);
                                        ac.enabled = true;
                                        sheet.getWorkSheetView().requestFocus();
                                        return;
                                    }
                                }
                            }
                            ds = null;
                        }
                        ++ki;
                    }
                }
                catch (Exception e) {
                    FlowForm.$log(e.getMessage());
                }
            }
            if (this.ff.isRelativeDataEnabled()) {
                try {
                    dbc = cell.getBind();
                    if (dbc == null) break block74;
                    DataSourceConfig tdsc = this.ff.book.getDataSource(dbc.getDataSource());
                    String thisValue = cell.getDataStore().getString(tdsc.getCurrentBindRow(), dbc.getDBCol());
                    DataBuffer buffer = tdsc.getDataStore().getPrimaryBuffer();
                    int cr = tdsc.getCurrentBindRow();
                    String cc = dbc.getDBCol();
                    int itemStatus = 0;
                    if (cr >= 0 && cr < tdsc.getDataStore().getRowCount()) {
                        itemStatus = buffer.getItemStatus(cr, cc);
                    }
                    if (cr < 0 || cr >= tdsc.getDataStore().getRowCount() || !tdsc.getDataStore().isEdited(cr, cc)) break block74;
                    String key1 = RelativeData.buildKey("all", dbc.getDataSource(), dbc.getDBCol());
                    String key2 = RelativeData.buildKey(sheet.getGUID(), dbc.getDataSource(), dbc.getDBCol());
                    String[] keys = new String[]{key1, key2};
                    int ki = 0;
                    while (ki < keys.length) {
                        String key = keys[ki];
                        if (this.ff.relativeConfig.containsKey(key)) {
                            FlowForm.$log(String.valueOf(sheet.getName()) + "\u4e2d\u7684\u5355\u5143\u683c:" + cell.getAlias() + "\u53d8\u5316\u89e6\u53d1\u4e86\u76f8\u5173\u53d6\u6570\u529f\u80fd");
                            ArrayList list = (ArrayList)this.ff.relativeConfig.get(key);
                            int li = 0;
                            while (li < list.size()) {
                                DataStore ds;
                                int currentRow;
                                RelativeData rc;
                                block76: {
                                    rc = (RelativeData)list.get(li);
                                    String sql = rc.sql;
                                    sql = Tools.replaceEscapeChar(sql);
                                    currentRow = innerRow;
                                    Object s = sheet.evaluate(sql, currentRow);
                                    FlowForm.$log("\u53d6\u6570\uff1a" + s);
                                    if (s == null) {
                                        throw new Exception("\u76f8\u5173\u53d6\u6570\uff1a" + sql + "\u5b9a\u4e49\u4e0d\u5408\u6cd5");
                                    }
                                    ds = null;
                                    try {
                                        try {
                                            JSONArray ja;
                                            Context cx = Context.enter();
                                            Object j = RhinoTools.jsToJava(s, cx);
                                            if (j instanceof Object[]) {
                                                ds = this.createVirtualDSWith(rc);
                                                ja = (JSONArray)j;
                                                int ti = 0;
                                                while (ti < ((Object[])ja).length) {
                                                    if (ja[ti] instanceof HashMap) {
                                                        HashMap jmap = (HashMap)ja[ti];
                                                        int trow = ds.insertRow(9999);
                                                        int rci = 0;
                                                        while (rci < rc.copyTo.size()) {
                                                            CopyTo ct = (CopyTo)rc.copyTo.get(rci);
                                                            ds.setValue(trow, ct.from, jmap.get(ct.from));
                                                            ++rci;
                                                        }
                                                    }
                                                    ++ti;
                                                }
                                            }
                                            if (j instanceof HashMap) {
                                                ds = this.createVirtualDSWith(rc);
                                                HashMap jmap = (HashMap)j;
                                                FlowForm.$log(jmap.toString());
                                                int trow = ds.insertRow(9999);
                                                int rci = 0;
                                                while (rci < rc.copyTo.size()) {
                                                    CopyTo ct = (CopyTo)rc.copyTo.get(rci);
                                                    ds.setValue(trow, ct.from, jmap.get(ct.from));
                                                    ++rci;
                                                }
                                            }
                                            if (j instanceof String) {
                                                sql = (String)j;
                                                if (sql.startsWith("{")) {
                                                    sql = "[" + sql + "]";
                                                }
                                                if (sql.startsWith("[")) {
                                                    FlowForm.$log("\u76f4\u63a5\u7684JSON\u6570\u636e");
                                                    ds = this.createVirtualDSWith(rc);
                                                    ja = new JSONArray(sql);
                                                    int ji = 0;
                                                    while (ji < ja.length()) {
                                                        int trow = ds.insertRow(9999);
                                                        JSONObject jo = ja.getJSONObject(ji);
                                                        for (String col : jo.getMap().keySet()) {
                                                            ds.setValue(trow, col, jo.get(col));
                                                        }
                                                        ++ji;
                                                    }
                                                } else {
                                                    ds = this.ff.createDataStore(rc.cons, sql);
                                                    ds.setOnceRetrieveCount(1000);
                                                    if (thisValue.length() > 0) {
                                                        ds.retrieve();
                                                    }
                                                }
                                            }
                                        }
                                        catch (Exception j) {
                                            Context.exit();
                                            break block76;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Context.exit();
                                        throw throwable;
                                    }
                                    Context.exit();
                                }
                                ArrayList<DataStore> hadClearedDSList = new ArrayList<DataStore>();
                                int ci = 0;
                                while (ci < rc.copyTo.size()) {
                                    CopyTo ct = (CopyTo)rc.copyTo.get(ci);
                                    DataSourceConfig dsc = this.ff.book.getDataSource(ct.toDS);
                                    if (dsc == null) {
                                        throw new Exception("\u6307\u5b9a\u7684\u6570\u636e\u6e90" + ct.toDS + "\u4e0d\u5b58\u5728");
                                    }
                                    if (dsc.getDataSourceType() == 1) {
                                        dsc.getDataStore().setValue(0, ct.toCol, null);
                                    } else if (ct.toDS.equals(dbc.getDataSource())) {
                                        dsc.getDataStore().setValue(currentRow, ct.toCol, null);
                                    } else {
                                        DataStore tds = dsc.getDataStore();
                                        if (!hadClearedDSList.contains(tds)) {
                                            hadClearedDSList.add(tds);
                                            String cols = tds.getAsNoDataIfOnlySuchColumnsHoldData();
                                            int ti = tds.getRowCount() - 1;
                                            while (ti >= 0) {
                                                if (tds.isTheRowHoldNoDataExceptSuchColumns(ti, cols)) {
                                                    FlowForm.$log(String.valueOf(ti) + "\u884c\u4e2d\u9664" + cols + "\u5916\u7684\u5b57\u6bb5\u6ca1\u6709\u6709\u7528\u7684\u6570\u636e\uff0c\u6240\u4ee5\u4e0d\u6e05\u9664");
                                                } else {
                                                    tds.deleteRow(ti);
                                                }
                                                --ti;
                                            }
                                        }
                                    }
                                    ++ci;
                                }
                                hadClearedDSList.clear();
                                ArrayList<DataStore> changedDSList = new ArrayList<DataStore>();
                                int ni = 0;
                                while (ni < ds.getRowCount()) {
                                    int rci = 0;
                                    while (rci < rc.copyTo.size()) {
                                        CopyTo ct = (CopyTo)rc.copyTo.get(rci);
                                        String v = ds.getString(ni, ct.from);
                                        DataSourceConfig dsc = this.ff.book.getDataSource(ct.toDS);
                                        DataStore tds = dsc.getDataStore();
                                        if (dsc == null) {
                                            throw new Exception("\u6307\u5b9a\u7684\u6570\u636e\u6e90" + ct.toDS + "\u4e0d\u5b58\u5728");
                                        }
                                        if (dsc.getDataSourceType() == 1) {
                                            try {
                                                Thread.sleep(10L);
                                                tds.setValue(0, ct.toCol, (Object)v);
                                            }
                                            catch (Exception e) {
                                                FlowForm.$log("\u81ea\u52a8\u53d6\u6570\u65f6\u6570\u636e\u586b\u5145\u53d1\u751f\u5982\u4e0b\u9519\u8bef\uff1a");
                                                FlowForm.$log(e.getMessage());
                                            }
                                        } else if (ct.toDS.equals(dbc.getDataSource())) {
                                            tds.setValue(currentRow, ct.toCol, (Object)v);
                                        } else {
                                            if (tds.getRowCount() - 1 < ni) {
                                                tds.insertRow(tds.getRowCount());
                                            }
                                            tds.setValue(ni, ct.toCol, (Object)v);
                                            if (!changedDSList.contains(tds)) {
                                                changedDSList.add(tds);
                                            }
                                        }
                                        ++rci;
                                    }
                                    ++ni;
                                }
                                int di = 0;
                                while (di < changedDSList.size()) {
                                    int existsCount;
                                    DataStore tds = (DataStore)changedDSList.get(di);
                                    int defaultRowCount = Tools.String2Int(tds.getColumnProperty("id").getProperty("defaultrowcount").toString());
                                    int ti = existsCount = tds.getRowCount();
                                    while (ti < defaultRowCount) {
                                        tds.insertRow(tds.getRowCount());
                                        ++ti;
                                    }
                                    ++di;
                                }
                                changedDSList.clear();
                                ds = null;
                                ++li;
                            }
                        }
                        ++ki;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.ff.buildAutoTitle(cell);
        this.ff.RunScript("CellValueChanged", new Object[]{sheet, cell, oldValue, newValue, innerRow});
    }

    private DataStore createVirtualDSWith(RelativeData rc) {
        String tsql = "select ";
        int rci = 0;
        while (rci < rc.copyTo.size()) {
            CopyTo ct = (CopyTo)rc.copyTo.get(rci);
            tsql = String.valueOf(tsql) + " '' as  " + ct.from;
            if (rci != rc.copyTo.size() - 1) {
                tsql = String.valueOf(tsql) + ",";
            }
            ++rci;
        }
        tsql = String.valueOf(tsql) + "  from news_user";
        FlowForm.$log(tsql);
        DataStore ds = this.ff.createDataStore("", tsql);
        return ds;
    }

    public void LoadPrintConfig(WorkSheet sheet) {
        try {
            String host = InetAddress.getLocalHost().getHostAddress();
            String hostName = InetAddress.getLocalHost().getHostName();
            RPCParameter p = new RPCParameter();
            p.put("guid", sheet.getGUID());
            p.put("host", host);
            p.put("hostName", hostName);
            p = RPC.Call(String.valueOf(this.ff.HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "LoadPrintConfig", p);
            if (!p.Success) {
                throw new Exception(p.ErrorText);
            }
            String s = p.get("set", "");
            String device = p.get("servicename", "");
            sheet.setPrintServiceName(device);
            JSONObject js = new JSONObject(s);
            js.put("range", (Object)"all");
            sheet.setPageConfig(js.toString());
        }
        catch (Exception e) {
            FlowForm.$log("\u6253\u5370\u8bbe\u7f6e\u8c03\u53d6\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public void SavePrintConfig(WorkSheet sheet) {
        String ps = sheet.getPageConfig();
        try {
            JSONObject js = new JSONObject(ps);
            js.put("range", (Object)"all");
            String device = sheet.getPrintServiceName();
            String host = InetAddress.getLocalHost().getHostAddress();
            String hostName = InetAddress.getLocalHost().getHostName();
            RPCParameter p = new RPCParameter();
            p.put("guid", sheet.getGUID());
            p.put("host", host);
            p.put("hostName", hostName);
            p.put("templateid", this.ff.RedirectTemplateID.equals("") ? this.ff.TemplateID : this.ff.RedirectTemplateID);
            p.put("servicename", device);
            p.put("printscale", sheet.getPrintScale());
            p.put("set", ps);
            p = RPC.Call(String.valueOf(this.ff.HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "SavePrintConfig", p);
            if (!p.Success) {
                throw new Exception(p.ErrorText);
            }
        }
        catch (Exception e) {
            FlowForm.$log("\u6253\u5370\u8bbe\u7f6e\u4fdd\u5b58\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public void call(String program) {
        try {
            Process process = Runtime.getRuntime().exec(program);
        }
        catch (Exception e) {
            FlowForm.$log(e.getMessage());
        }
    }

    public void afterPrintWorkSheet(WorkSheet sheet) {
        this.ff.afterPrint(sheet);
    }

    public void onMouseMove(WorkSheetView pView, Cell cell, MouseEvent evt) {
        if (this.ff.doubleClickToSort) {
            WorkSheet sheet = pView.getWorkSheet();
            if (cell.getBind() == null) {
                Cell tcell;
                int row = cell.isMerged() ? cell.getRightBottomCorner().getRowIndex() : cell.getRowIndex();
                int col = cell.getColumnIndex();
                if ((tcell = sheet.cells(++row, col)) != null) {
                    DBBindConfig dbc;
                    if (tcell.isMerged()) {
                        tcell = tcell.getLeftTopCorner();
                    }
                    if ((dbc = tcell.getBind()) != null && dbc.getDataSourceType() == 2) {
                        pView.setCursor(excel.util.Tools.GetCursor((Component)this.ff, (String)"sort.gif", (Point)new Point(7, 1)));
                    }
                }
            }
        }
    }

    public void CellClicked(WorkSheet sheet, Cell cell, int innerRow) {
        if (!this.cellClickOK) {
            FlowForm.$log("CellClicked \u5728\u6267\u884c\u5b8c\u4e4b\u524d\uff0c \u4e0d\u5141\u8bb8\u518d\u6b21\u6267\u884c\u3002");
            return;
        }
        if (this.ff.cellClickNeedRightVerify(sheet, cell) && !this.ff.canCellClick(sheet, cell)) {
            FlowForm.$log(String.valueOf(sheet.getName()) + "\u4e2d\u7684 " + cell.getAlias() + "[" + cell.getName() + "]\u7684\u5355\u5143\u683c\u70b9\u51fb\u4e8b\u4ef6\u88ab\u7981\u7528\u4e86");
            this.ff.alert("\u5f53\u524d\u72b6\u6001\u60a8\u65e0\u6743\u6267\u884c\u672c\u529f\u80fd");
            return;
        }
        final WorkSheet $sheet = sheet;
        final Cell $cell = cell;
        final int $innerRow = innerRow;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    try {
                        WorkBookEvent.this.cellClickOK = false;
                        WorkBookEvent.this.$CellClicked($sheet, $cell, $innerRow);
                    }
                    catch (Exception exception) {
                        WorkBookEvent.this.cellClickOK = true;
                    }
                }
                finally {
                    WorkBookEvent.this.cellClickOK = true;
                }
                return "";
            }

            protected void done() {
                WorkBookEvent.this.cellClickOK = true;
            }
        };
        worker.execute();
    }

    public void CellRightClicked(WorkSheet sheet, Cell cell, int innerRow) {
        if (!this.cellClickOK) {
            FlowForm.$log("CellClicked \u5728\u6267\u884c\u5b8c\u4e4b\u524d\uff0c \u4e0d\u5141\u8bb8\u518d\u6b21\u6267\u884c\u3002");
            return;
        }
        final WorkSheet $sheet = sheet;
        final Cell $cell = cell;
        final int $innerRow = innerRow;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    try {
                        WorkBookEvent.this.cellClickOK = false;
                        WorkBookEvent.this.$CellRightClicked($sheet, $cell, $innerRow);
                    }
                    catch (Exception exception) {
                        WorkBookEvent.this.cellClickOK = true;
                    }
                }
                finally {
                    WorkBookEvent.this.cellClickOK = true;
                }
                return "";
            }

            protected void done() {
                WorkBookEvent.this.cellClickOK = true;
            }
        };
        worker.execute();
    }

    public void CellDblClicked(WorkSheet sheet, Cell cell, int innerRow) {
        if (!this.cellDblClickOK) {
            FlowForm.$log("CellDblClicked \u5728\u6267\u884c\u5b8c\u4e4b\u524d\uff0c \u4e0d\u5141\u8bb8\u518d\u6b21\u6267\u884c\u3002");
            return;
        }
        if (this.ff.cellClickNeedRightVerify(sheet, cell) && !this.ff.canCellClick(sheet, cell)) {
            FlowForm.$log(String.valueOf(sheet.getName()) + "\u4e2d\u7684 " + cell.getAlias() + "[" + cell.getName() + "]\u7684\u5355\u5143\u683c\u70b9\u51fb\u4e8b\u4ef6\u88ab\u7981\u7528\u4e86");
            this.ff.alert("\u5f53\u524d\u72b6\u6001\u60a8\u65e0\u6743\u6267\u884c\u672c\u529f\u80fd");
            return;
        }
        final WorkSheet $sheet = sheet;
        final Cell $cell = cell;
        final int $innerRow = innerRow;
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    try {
                        WorkBookEvent.this.cellDblClickOK = false;
                        WorkBookEvent.this.$CellDblClicked($sheet, $cell, $innerRow);
                    }
                    catch (Exception exception) {
                        WorkBookEvent.this.cellDblClickOK = true;
                    }
                }
                finally {
                    WorkBookEvent.this.cellDblClickOK = true;
                }
                return "";
            }

            protected void done() {
                WorkBookEvent.this.cellDblClickOK = true;
            }
        };
        worker.execute();
    }

    public void $CellClicked(WorkSheet sheet, Cell cell, int innerRow) {
        String s = cell.getDefine();
        this.ff.RunScript("cellClicked", new Object[]{sheet, cell, new Integer(innerRow)});
    }

    public void $CellRightClicked(WorkSheet sheet, Cell cell, int innerRow) {
        String s = cell.getDefine();
        this.ff.RunScript("cellRightClicked", new Object[]{sheet, cell, new Integer(innerRow)});
    }

    public void $CellDblClicked(WorkSheet sheet, Cell cell, int innerRow) {
        String s = cell.getDefine();
        this.ff.RunScript("cellDblClicked", new Object[]{sheet, cell, new Integer(innerRow)});
        if (this.ff.doubleClickToSort && cell.getBind() == null) {
            Cell tcell;
            String imgName = "excel/img/up2.gif";
            boolean needShowSortImg = false;
            int row = cell.isMerged() ? cell.getRightBottomCorner().getRowIndex() : cell.getRowIndex();
            int col = cell.getColumnIndex();
            if ((tcell = sheet.cells(++row, col)) != null) {
                DBBindConfig dbc;
                if (tcell.isMerged()) {
                    tcell = tcell.getLeftTopCorner();
                }
                if ((dbc = tcell.getBind()) != null) {
                    String dsname = dbc.getDataSource();
                    DataSourceConfig dsc = this.ff.book.getDataSource(dsname);
                    DataStore ds = dsc.getDataStore();
                    if (!ds.getGroupRole().equals("")) {
                        Tools.ShowInfo(this.ff, "\u5b58\u5728\u5206\u7c7b\u6c47\u603b\u65f6\uff0c\u6570\u636e\u5c06\u6309\u5206\u7c7b\u5217\u8fdb\u884c\u6392\u5e8f\uff0c\u7981\u6b62\u624b\u5de5\u6307\u5b9a\u6392\u5e8f");
                        return;
                    }
                    if (dbc.getDataSourceType() == 2) {
                        String orderBy = String.valueOf(dbc.getDBCol()) + " asc";
                        String oldOrderBy = "";
                        if (this.dsOrderBy.containsKey(dsname)) {
                            oldOrderBy = (String)this.dsOrderBy.get(dsname);
                        }
                        if (orderBy.equals(oldOrderBy)) {
                            orderBy = String.valueOf(dbc.getDBCol()) + " desc";
                            imgName = "excel/img/down2.gif";
                        }
                        this.dsOrderBy.put(dsname, orderBy);
                        this.ff.showInfoPane("<table border=0  align='center' ><tr><td height=55><img src='" + this.ff.getHomeURL() + "image/loadinfo_net2.gif' align='absmiddle'></td><td>&nbsp;<font size=3>\u6b63\u5728\u6392\u5e8f...</font></td></tr></table>", 300, 70);
                        ds.setOrderBy(orderBy);
                        dsc.getDataStore().sort();
                        this.ff.hideInfoPane();
                        needShowSortImg = true;
                    }
                }
            }
            String brickName = "flowform_inner_sort";
            if (needShowSortImg) {
                StaticImage si;
                row = cell.getRowIndex();
                col = 0;
                while (col < sheet.getColumnCount()) {
                    tcell = sheet.cells(row, col);
                    si = (StaticImage)(tcell = tcell.getLeftTopCorner()).getBrick(brickName);
                    if (si != null) {
                        si.setVisible(false);
                    }
                    ++col;
                }
                tcell = cell.getLeftTopCorner();
                si = (StaticImage)tcell.getBrick(brickName);
                if (si == null) {
                    si = sheet.getWorkBook().createStaticImage(brickName, imgName);
                    si.setBounds(-12, -10, 9, 6);
                    tcell.addBrick((Brick)si);
                }
                si.setImageFileName(imgName);
                si.setVisible(true);
            }
        }
    }

    public void chartDataDecorate(WorkSheet sheet, Chart chart, ArrayList data) {
        String mapName = chart.getSeriesColMap();
        if (!mapName.equals("")) {
            this.dataDecorate(data, "series", mapName);
        }
        if (!(mapName = chart.getCategoryColMap()).equals("")) {
            this.dataDecorate(data, "category", mapName);
        }
    }

    private void dataDecorate(ArrayList data, String keyName, String editstyle) {
        EditStyle es;
        boolean ddlbeditable = false;
        String name = "ddlb" + editstyle + String.valueOf(ddlbeditable);
        if (editstyle.equals("selfvalue")) {
            name = "ddlb_selfvalue_";
        }
        if ((es = this.ff.book.getEditStyle(name)) == null) {
            es = this.ff.book.newEditStyle(this.ff.book, name, 4);
            LinkedHashMap map = null;
            RPCParameter p = new RPCParameter();
            p.put("editstyle", editstyle);
            p = RPC.Call(String.valueOf(this.ff.HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "getDDLBMap", p);
            if (p.Success) {
                map = (LinkedHashMap)p.get("map");
                JSONObject ddlbConfig = (JSONObject)p.get("ddlbconfig");
                if (ddlbConfig.getString("filterby", "").trim().length() > 0) {
                    es.setDDLBFilterBy(ddlbConfig.toString());
                }
            }
            es.setDropDownData2ViewMap(map);
            this.ff.book.AddEditStyle(es);
        }
        HashMap showMap = (HashMap)es.getDropDownData2ViewMap();
        int n = data.size();
        int i = 0;
        while (i < n) {
            HashMap map = (HashMap)data.get(i);
            Object v = map.get(keyName);
            if (v != null && showMap.containsKey(v.toString())) {
                map.put(keyName, showMap.get(v.toString()));
            }
            ++i;
        }
    }

    public void refreshEditStyleOfCell(WorkSheet sheet, Cell cell, int innerRow) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                WorkBookEvent.this.ff.refreshEditStyleOfCell();
                return "";
            }

            protected void done() {
                super.done();
            }
        };
        worker.execute();
    }

    public void sheetActiveStateChanged(WorkSheet activeSheet, WorkSheet deActiveSheet) {
        if (!this.ff.uiInitOK) {
            return;
        }
        this.ff.RunScript("sheetActiveStateChanged", new Object[]{activeSheet, deActiveSheet});
    }

    public void onContextMenuClicked(WorkSheet sheet, Cell cell, int innerRow, String menuName) {
        this.ff.RunScript("contextMenuClicked", new Object[]{sheet, cell, new Integer(innerRow), menuName});
        this.ff.RunScript("menu_" + menuName + "_onclick", new Object[]{sheet, cell, new Integer(innerRow)});
        this.ff.RunScript(String.valueOf(menuName) + "_onclick", new Object[]{sheet, cell, new Integer(innerRow)});
    }

    public Object afterEditFocusLostAndBeforeWriteBackToCell(WorkSheet sheet, Cell cell, Object value, int innerRow) {
        Object v = value;
        String funcName = "afterEditFocusLostAndBeforeWriteBackToCell";
        Object fObj = this.scope.get(funcName, this.scope);
        if (fObj == null) {
            return v;
        }
        if (!(fObj instanceof Function)) {
            return v;
        }
        v = this.ff.RunScript(funcName, new Object[]{sheet, cell, v, new Integer(innerRow)});
        return v;
    }

    public boolean isCellEditable(WorkSheet sheet, Cell cell, int innerRow) {
        Object ret = this.ff.RunScript("isCellEditable", new Object[]{sheet, cell, new Integer(innerRow)});
        if (ret == null) {
            return true;
        }
        try {
            Context cx = Context.enter();
            ret = RhinoTools.jsToJava(ret, cx);
            boolean bl = (Boolean)ObjectTool.ChangeType((Object)ret, (String)"java.lang.Boolean");
            return bl;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            Context.exit();
        }
    }

    public void currentBindRowChanged(String dsname, int row) {
        HashMap tableTree;
        FlowForm.$log(String.valueOf(dsname) + " current BindRow changed");
        DataStore ds = this.ff.book.getDataSource(dsname).getDataStore();
        HashMap tree = this.ff.tableTree;
        if (tree == null) {
            return;
        }
        if (tree.containsKey(dsname) && row >= 0 && (tableTree = (HashMap)tree.get(dsname)).containsKey("sub")) {
            ArrayList subList = (ArrayList)tableTree.get("sub");
            String wise_parent_id = ds.getString(row, "id");
            FlowForm.$log(" current BindRow Id" + wise_parent_id);
            int i = 0;
            while (i < subList.size()) {
                String subTable = (String)subList.get(i);
                DataSourceConfig subdsc = this.ff.book.getDataSource(subTable);
                DataStore subDS = subdsc.getDataStore();
                subDS.fastFilter("wise_parent_id", (Object)wise_parent_id);
                int rc = subDS.getRowCount();
                int defaultRowCount = (Integer)subDS.getTag("defaultRowCount");
                int ti = rc;
                while (ti < defaultRowCount) {
                    int n = subDS.insertRow(9999999);
                    ++ti;
                }
                if (subDS.getRowCount() > 0) {
                    subdsc.setCurrentBindRow(0, true);
                }
                ++i;
            }
        }
        this.ff.RunScript("currentBindRowChanged", new Object[]{dsname, new Integer(row)});
    }

    public String buildToolTip(WorkSheet sheet, Cell cell, int innerRow) {
        String funcName = "buildToolTip";
        Object[] p = new Object[]{sheet, cell, new Integer(innerRow)};
        Object ret = this.ff.RunScript(funcName, p);
        if (ret == null) {
            return null;
        }
        try {
            Context cx = Context.enter();
            ret = RhinoTools.jsToJava(ret, cx);
            String t = (String)ObjectTool.ChangeType((Object)ret, (String)"java.lang.String");
            if (t.trim().equals("")) {
                return null;
            }
            String string = t;
            return string;
        }
        catch (Exception e) {
            return null;
        }
        finally {
            Context.exit();
        }
    }

    public void popupedWorkSheetOnOK(WorkSheet sheet) {
        this.ff.RunScript("popupedWorkSheetOnOK", new Object[]{sheet});
    }

    public void popupedWorkSheetOnCancel(WorkSheet sheet) {
        this.ff.RunScript("popupedWorkSheetOnCancel", new Object[]{sheet});
    }

    public boolean isBalloonTipEditPermit(String dsname, String dbcol, int innerRow) {
        Object ret = this.ff.RunScript("isBalloonTipEditPermit", new Object[]{dsname, innerRow, dbcol});
        if (ret == null) {
            return true;
        }
        try {
            Context cx = Context.enter();
            ret = RhinoTools.jsToJava(ret, cx);
            boolean bl = (Boolean)ObjectTool.ChangeType((Object)ret, (String)"java.lang.Boolean");
            return bl;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            Context.exit();
        }
    }
}

