/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.File;
import java.net.URL;
import java.security.MessageDigest;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class Tools {
    static final String IDC_WE = "WE.gif";
    static final String IDC_NS = "NS.gif";
    static final String IDC_ARROW = "DEFAULT";
    static final String IDC_SYS_WE = "SYS_WE";
    static final String IDC_SYS_NS = "SYS_NS";
    static final String IDC_MOVE = "MOVE.gif";
    static final String IDC_EXCHANGE = "EXCHANGE.gif";
    static HashMap m_FontMap = new HashMap();
    static HashMap m_CursorMap = new HashMap();

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign) {
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        if (s.length() == 0) {
            return;
        }
        g.setColor(textcolor);
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.intersection(oc));
        Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(s, font, frc);
        float drawPosY = rc.y;
        switch (vAlign) {
            case 1: {
                drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                break;
            }
            case 2: {
                drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                break;
            }
            default: {
                drawPosY += layout.getAscent();
            }
        }
        float drawPosX = rc.x;
        switch (hAlign) {
            case 1: {
                drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                break;
            }
            case 2: {
                drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                break;
            }
            default: {
                drawPosX = rc.x;
            }
        }
        layout.draw(g, drawPosX, drawPosY);
        if (oc != null) {
            g.setClip(oc.x, oc.y, oc.width, oc.height);
        }
    }

    public static void DrawCheckBoxString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean checkOn, boolean drawFocus) {
        float checkBoxX;
        int checkBoxSize = 15;
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        if (s.length() == 0) {
            return;
        }
        g.setColor(textcolor);
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.intersection(oc));
        Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(s, font, frc);
        float drawPosY = rc.y;
        switch (vAlign) {
            case 1: {
                drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                break;
            }
            case 2: {
                drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                break;
            }
            default: {
                drawPosY += layout.getAscent();
            }
        }
        float drawPosX = rc.x;
        switch (hAlign) {
            case 1: {
                drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                drawPosX -= (float)checkBoxSize;
                checkBoxX = rc.x + rc.width - checkBoxSize;
                break;
            }
            case 2: {
                drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                checkBoxX = (drawPosX += (float)(checkBoxSize / 2)) - (float)checkBoxSize;
                break;
            }
            default: {
                drawPosX = rc.x;
                drawPosX += (float)checkBoxSize;
                checkBoxX = rc.x;
            }
        }
        layout.draw(g, drawPosX, drawPosY);
        float checkBoxY = drawPosY - 9.0f;
        g.setColor(Color.GRAY);
        g.drawRect((int)(checkBoxX += 3.0f), (int)checkBoxY, checkBoxSize -= 5, checkBoxSize);
        if (checkOn) {
            int xx = (int)checkBoxX;
            int yy = (int)checkBoxY;
            g.setColor(new Color(186, 0, 0));
            g.drawLine(xx + 2, yy + 5, xx + 4, yy + 7);
            g.drawLine(xx + 4, yy + 7, xx + 8, yy + 3);
            g.drawLine(xx + 2, yy + 4, xx + 4, yy + 6);
            g.drawLine(xx + 4, yy + 6, xx + 8, yy + 2);
            g.setColor(new Color(210, 210, 210));
            g.drawLine(xx + 2, yy + 6, xx + 4, yy + 8);
            g.drawLine(xx + 4, yy + 8, xx + 8, yy + 4);
        }
        if (drawFocus) {
            Stroke oldStroke = g.getStroke();
            float[] dash = new float[]{1.0f};
            g.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 1.0f));
            g.setColor(new Color(217, 147, 0));
            g.drawRect(rc.x + 1, rc.y + 1, rc.width - 3, rc.height - 3);
            g.setStroke(oldStroke);
        }
        if (oc != null) {
            g.setClip(oc.x, oc.y, oc.width, oc.height);
        }
    }

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine) {
        if (s.trim().equals("")) {
            return;
        }
        if (rc.width <= 0 || rc.height <= 0) {
            return;
        }
        if (!MultiLine) {
            Tools.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Dimension size = rc.getSize();
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.intersection(oc));
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        AttributedString ss = new AttributedString(s, map);
        AttributedCharacterIterator text = ss.getIterator();
        FontRenderContext frc = g.getFontRenderContext();
        int paragraphStart = text.getBeginIndex();
        int paragraphEnd = text.getEndIndex();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(text, frc);
        float formatWidth = size.width;
        float drawPosY = rc.y;
        if (MultiLine && vAlign != 0) {
            double gg = 0.0;
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                gg += (double)(layout.getDescent() + layout.getLeading() + layout.getAscent());
            }
            if (gg < (double)rc.height) {
                if (vAlign == 2) {
                    drawPosY = (float)((double)drawPosY + ((double)rc.height - gg) / 2.0);
                }
                if (vAlign == 1) {
                    drawPosY = (float)((double)drawPosY + ((double)rc.height - gg));
                }
            }
        }
        lineMeasurer.setPosition(paragraphStart);
        while (lineMeasurer.getPosition() < paragraphEnd) {
            TextLayout layout = lineMeasurer.nextLayout(formatWidth);
            switch (vAlign) {
                case 1: {
                    if (!MultiLine) {
                        drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                        break;
                    }
                }
                case 2: {
                    if (!MultiLine) {
                        drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                        break;
                    }
                }
                default: {
                    drawPosY += layout.getAscent();
                }
            }
            float drawPosX = rc.x;
            switch (hAlign) {
                case 1: {
                    drawPosX = (float)rc.x + formatWidth - layout.getAdvance();
                    break;
                }
                case 2: {
                    drawPosX = (float)rc.x + (formatWidth - layout.getAdvance()) / 2.0f;
                    break;
                }
                default: {
                    drawPosX = rc.x;
                }
            }
            layout.draw(g, drawPosX, drawPosY);
            if ((drawPosY += layout.getDescent() + layout.getLeading()) >= (float)(rc.y + rc.height) || !MultiLine) break;
        }
        g.setClip(oc.x, oc.y, oc.width, oc.height);
    }

    public static Font GetFont(String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        String key = String.valueOf(FontName) + String.valueOf(FontSize) + String.valueOf(FontBold) + String.valueOf(FontItalic) + String.valueOf(FontUnderline);
        if (m_FontMap.containsKey(key)) {
            return (Font)m_FontMap.get(key);
        }
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(map);
        m_FontMap.put(key, font);
        return font;
    }

    public static Rectangle LeftPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle TopPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y, rc.width / 2, rc.height / 4);
    }

    public static Rectangle RightPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width * 3 / 4, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle BottomPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height * 3 / 4, rc.width / 2, rc.height / 4);
    }

    public static Rectangle MiddlePartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height / 4, rc.width / 2, rc.height / 2);
    }

    public static Container GetRootContainer(Container op) {
        Container ct = op;
        while (ct != null) {
            if (ct.getParent() == null) {
                return ct;
            }
            ct = ct.getParent();
        }
        return ct;
    }

    public static Applet ContainedByApplet(Component op) {
        Component ct = op;
        while (ct != null) {
            if (ct instanceof Applet) {
                return (Applet)ct;
            }
            ct = ct.getParent();
        }
        return null;
    }

    public static int RecursionAdd(int n) {
        if (n <= 0) {
            return 0;
        }
        return n + Tools.RecursionAdd(n - 1);
    }

    public static Cursor GetCursor(Component obj, String curName, Point hotPoint) {
        if (m_CursorMap.containsKey(curName)) {
            return (Cursor)m_CursorMap.get(curName);
        }
        Cursor cur = null;
        if (curName == IDC_ARROW) {
            cur = new Cursor(0);
        }
        if (curName == IDC_SYS_WE) {
            cur = new Cursor(10);
        }
        if (curName == IDC_SYS_NS) {
            cur = new Cursor(8);
        }
        if (cur == null) {
            Applet ContainedByApplet = Tools.ContainedByApplet(obj);
            Image img = null;
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = obj.getClass().getClassLoader().getResource("excel/res/" + curName);
            if (ContainedByApplet != null) {
                img = ContainedByApplet.getImage(url);
                if (img == null) {
                    return new Cursor(0);
                }
                MediaTracker tracker = new MediaTracker(ContainedByApplet);
                tracker.addImage(img, 0);
                cur = tk.createCustomCursor(img, hotPoint, curName);
            } else {
                img = tk.getImage(url);
                if (img == null) {
                    return new Cursor(0);
                }
                cur = tk.createCustomCursor(img, hotPoint, curName);
            }
        }
        if (cur == null) {
            return new Cursor(0);
        }
        m_CursorMap.put(curName, cur);
        return cur;
    }

    public static Image GetImageFromURL(Component Wnd, String imgURL) {
        MediaTracker tracker;
        Applet ContainedByApplet = Tools.ContainedByApplet(Wnd);
        Image img = null;
        URL url = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            url = Wnd.getClass().getClassLoader().getResource(imgURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ContainedByApplet != null) {
            img = ContainedByApplet.getImage(url);
            tracker = new MediaTracker(ContainedByApplet);
        } else {
            img = tk.getImage(url);
            tracker = new MediaTracker(Wnd);
        }
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public static Rectangle getStringBounds(Graphics2D g, String str, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        Rectangle ret = new Rectangle(0, 0, 0, 0);
        Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        if (g == null) {
            return ret;
        }
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, frc);
        ret.width = (int)layout.getAdvance();
        ret.height = (int)layout.getAscent();
        return ret;
    }

    public static void Delay(int mm) {
        try {
            Thread.sleep(mm);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ShowInfo(Component parentComponent, String info) {
        JOptionPane.showMessageDialog(parentComponent, info, "\u63d0\u793a", 2);
    }

    public static Point GetAbsolutePoint(Component obj, Point p) {
        Point ret = (Point)p.clone();
        SwingUtilities.convertPointToScreen(ret, obj);
        return ret;
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }

    public static void MoveToScreenCenter(Component jf) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((d.width - jf.getWidth()) / 2, (d.height - jf.getHeight()) / 2);
    }

    public static StringBuffer HTML2Text(String s) {
        StringBuffer sb = new StringBuffer(1024);
        int len = s.length();
        boolean inTag = false;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '<') {
                inTag = true;
            } else if (c == '>') {
                inTag = false;
            } else if (!inTag) {
                sb.append(c);
            }
            ++i;
        }
        return sb;
    }

    public static boolean MkDirs(String path) {
        File nextFile = new File(path);
        if (!nextFile.exists()) {
            nextFile.mkdirs();
        }
        return nextFile.exists();
    }

    public static String replaceEscapeChar(String s) {
        String ret = s;
        ret = ret.replaceAll("\r", " ");
        ret = ret.replaceAll("\n", " ");
        ret = ret.replaceAll("\t", " ");
        ret = ret.replaceAll("\u3000", " ");
        return ret;
    }

    public static int String2Int(String s) {
        try {
            return new Integer(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void initAllFontSon9() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Font f1 = new Font("SimSun", 0, 12);
        Font f2 = new Font("SimSun", 1, 12);
        Tools.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public static String appendWhere(String w, String s, String andor) {
        if (w == null) {
            w = "";
        }
        if (s == null) {
            s = "";
        }
        if (w.trim().equals("")) {
            return s;
        }
        if (s.trim().equals("")) {
            return w;
        }
        return "(" + w + ")  " + andor + "  (" + s + ")";
    }

    public static HashMap BuildNodeUserListMap(String toNodeGuidList) {
        HashMap<String, HashMap> ret = new HashMap<String, HashMap>();
        String chineseSpace = "\u3000";
        String englishSpace = " ";
        toNodeGuidList = toNodeGuidList.replaceAll(chineseSpace, englishSpace);
        StringTokenizer stk = new StringTokenizer(toNodeGuidList, " ");
        while (stk.hasMoreTokens()) {
            ArrayList al;
            HashMap map;
            String t = stk.nextToken().trim();
            String needdays = "0";
            int p = t.indexOf(";");
            if (p > 0) {
                needdays = t.substring(p + 1);
                t = t.substring(0, p);
            } else {
                needdays = "10";
            }
            String[] ts = t.split(",");
            String guid = "";
            ArrayList<Integer> userid = new ArrayList<Integer>();
            guid = ts[0].trim();
            int i = 1;
            while (i < ts.length) {
                int uid = Tools.String2Int(ts[i]);
                if (uid > 0) {
                    userid.add(new Integer(uid));
                }
                ++i;
            }
            if (ret.containsKey(guid)) {
                map = (HashMap)ret.get(guid);
                map.put("needdays", needdays);
                al = (ArrayList)map.get("userlist");
            } else {
                map = new HashMap();
                al = new ArrayList();
                map.put("userlist", al);
                map.put("needdays", needdays);
                ret.put(guid, map);
            }
            al.addAll(userid);
        }
        return ret;
    }

    public static final String MD5(String s, String charset) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] strTemp = s.getBytes(charset);
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            int i = 0;
            while (i < j) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
                ++i;
            }
            return new String(str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String xml2json(String str) {
        try {
            return XML.toJSONObject((String)str).toString(4);
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            return "";
        }
    }

    public static String json2xml(String str) {
        try {
            JSONObject jsonObj = new JSONObject(str);
            return XML.toString((Object)jsonObj);
        }
        catch (JSONException e) {
            System.out.println(e.getMessage());
            return "";
        }
    }
}

