/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import excel.brick.Tree;
import excel.brick.TreeDataProvider;
import excel.core.WorkSheet;
import java.util.ArrayList;
import org.json.JSONArray;
import wiseoa.flow.applet.FlowForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowFormTreeDataProvider
implements TreeDataProvider {
    WorkSheet sheet;
    String dataSource;
    String sql;
    String rootValue;
    String rootLabel;
    String homeURL;
    Tree tree = null;

    public FlowFormTreeDataProvider(String homeURL_, WorkSheet sheet_, String dataSource_, String sql_, String rootValue_, String rootLabel_) {
        this.sheet = sheet_;
        this.dataSource = dataSource_;
        this.sql = sql_;
        this.rootValue = rootValue_;
        this.rootLabel = rootLabel_;
        this.homeURL = homeURL_;
    }

    public JSONArray buildData(String group) {
        return this.buildLevelData(group, null);
    }

    public ArrayList<String> getGroups() {
        String[] s = this.rootLabel.split(";");
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < s.length) {
            if (!s[i].trim().equals("")) {
                ret.add(s[i].trim());
            }
            ++i;
        }
        return ret;
    }

    public JSONArray buildLevelData(String group, String id) {
        RPCParameter p = new RPCParameter();
        JSONArray ja = null;
        p.put("dataSource", this.tree == null ? this.dataSource : this.tree.getConnection());
        String tsql = this.sheet.evaluate(this.sql, false, (Object)this.sql).toString();
        FlowForm.$log("\u4e3a\u6811\u6784\u5efa\u6570\u636e " + tsql + "  \u5176\u4e2did=" + id);
        p.put("sql", tsql);
        p.put("rootValue", this.parseRootValue(this.rootValue));
        p.put("rootLabel", this.rootLabel);
        p.put("group", group);
        if (id != null) {
            p.put("id", id);
        }
        p = RPC.Call(String.valueOf(this.homeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "buildTreeJSONData", p);
        if (p.Success) {
            ja = (JSONArray)p.get("treedata");
            String log = p.get("log", "");
            if (!log.equals("")) {
                FlowForm.$log(log);
            }
        } else {
            ja = new JSONArray();
            ja = new JSONArray("[  {text:\"" + p.ErrorText + "\", value:1,group:\"" + group + "\"  }]");
        }
        return ja;
    }

    public String parseRootValue(String rootValue) {
        String trootValue = this.sheet.evaluate(rootValue, false, (Object)rootValue).toString();
        return trootValue;
    }
}

