/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jun.db.core.ObjectTool;
import wiseoa.flow.applet.DateToolI;

public class DateTool
implements DateToolI {
    public Date createDate(Object year, Object month, Object day) {
        return this.createDate(year, month, day, "0", "0", "0");
    }

    public Date createDate(Object year, Object month, Object day, Object hour, Object minute, Object second) {
        if (year == null) {
            return null;
        }
        if (month == null) {
            return null;
        }
        if (day == null) {
            return null;
        }
        if (hour == null) {
            return null;
        }
        if (minute == null) {
            return null;
        }
        if (second == null) {
            return null;
        }
        int y = DateTool.String2Int(year.toString());
        int m = DateTool.String2Int(month.toString());
        int d = DateTool.String2Int(day.toString());
        int h = DateTool.String2Int(hour.toString());
        int M = DateTool.String2Int(minute.toString());
        int s = DateTool.String2Int(second.toString());
        if (year instanceof Number) {
            y = ((Number)year).intValue();
        }
        if (month instanceof Number) {
            m = ((Number)month).intValue();
        }
        if (day instanceof Number) {
            d = ((Number)day).intValue();
        }
        if (hour instanceof Number) {
            h = ((Number)hour).intValue();
        }
        if (minute instanceof Number) {
            M = ((Number)minute).intValue();
        }
        if (second instanceof Number) {
            s = ((Number)second).intValue();
        }
        Calendar cal = Calendar.getInstance();
        cal.set(y, m - 1, d, h, M, s);
        return cal.getTime();
    }

    public String date2yyyymmdd(Object d) {
        Date dd;
        if (d == null) {
            return "";
        }
        if (d instanceof Date) {
            dd = (Date)d;
        } else {
            try {
                dd = (Date)ObjectTool.ChangeType((Object)d, (String)"java.util.Date");
            }
            catch (Exception e) {
                return null;
            }
        }
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd");
        return SDF.format(dd);
    }

    public int hoursBetween(Date big, Date small) {
        if (big == null || small == null) {
            return 0;
        }
        long betweenHours = (long)Math.floor((double)(big.getTime() - small.getTime()) * 1.0 / 3600000.0);
        return (int)betweenHours;
    }

    public int minutesBetween(Date big, Date small) {
        if (big == null || small == null) {
            return 0;
        }
        long betweenMinute = (long)Math.floor((double)(big.getTime() - small.getTime()) * 1.0 / 60000.0);
        return (int)betweenMinute;
    }

    public int secondsBetween(Date big, Date small) {
        if (big == null || small == null) {
            return 0;
        }
        long betweenMinute = (long)Math.floor((double)(big.getTime() - small.getTime()) * 1.0 / 1000.0);
        return (int)betweenMinute;
    }

    public int daysBetween(Date big, Date small) {
        if (big == null || small == null) {
            return 0;
        }
        if (big == null) {
            return 0;
        }
        if (small == null) {
            return 0;
        }
        long betweenDays = (long)Math.floor((double)(big.getTime() - small.getTime()) * 1.0 / 8.64E7);
        return (int)betweenDays;
    }

    public Date yyyyMMdd2Date(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        ParsePosition p = new ParsePosition(0);
        try {
            Date d = sdf.parse(s, p);
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getDayOfWeek(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int week = cal.get(7);
        if (week == 7) {
            return 6;
        }
        if (week == 1) {
            return 7;
        }
        return week - 2 + 1;
    }

    public boolean isMonday(Date d) {
        return this.getDayOfWeek(d) == 1;
    }

    public boolean isTuesday(Date d) {
        return this.getDayOfWeek(d) == 2;
    }

    public boolean isWednesday(Date d) {
        return this.getDayOfWeek(d) == 3;
    }

    public boolean isThursday(Date d) {
        return this.getDayOfWeek(d) == 4;
    }

    public boolean isFriday(Date d) {
        return this.getDayOfWeek(d) == 5;
    }

    public boolean isSaturday(Date d) {
        return this.getDayOfWeek(d) == 6;
    }

    public boolean isSunday(Date d) {
        return this.getDayOfWeek(d) == 7;
    }

    public int getDayOfMonth(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public int getDayOfYear(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(6);
    }

    public int getHourOfDay(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(11);
    }

    public int getSecond(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(13);
    }

    public int getMinute(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(12);
    }

    public int getWeekOfMonth(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(4);
    }

    public int getWeekOfYear(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(3);
    }

    public boolean isAfterDate(Date d1, Date d2) {
        if (d1 == null) {
            return false;
        }
        if (d2 == null) {
            return false;
        }
        return d1.after(d2);
    }

    public boolean isBeforeDate(Date d1, Date d2) {
        if (d1 == null) {
            return false;
        }
        if (d2 == null) {
            return false;
        }
        return d1.before(d2);
    }

    public Date nextDate(Date d, int n) {
        if (d == null) {
            return null;
        }
        return this.nextDate(d, n, "day");
    }

    public Date nextDate(Date d, int n, String what) {
        if (d == null) {
            return null;
        }
        Date ret = (Date)d.clone();
        Calendar cal = Calendar.getInstance();
        cal.setTime(ret);
        if (what.equals("day")) {
            cal.add(5, n);
        }
        if (what.equals("minute")) {
            cal.add(12, n);
        }
        if (what.equals("second")) {
            cal.add(13, n);
        }
        if (what.equals("hour")) {
            cal.add(11, n);
        }
        if (what.equals("month")) {
            cal.add(2, n);
        }
        if (what.equals("year")) {
            cal.add(1, n);
        }
        return cal.getTime();
    }

    public int getYear(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(1);
    }

    public int getMonth(Date d) {
        if (d == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(2) + 1;
    }

    public static int String2Int(String s) {
        try {
            return new Integer(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        cal.set(2006, 0, 1);
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy.MM.dd");
        System.out.println(SDF.format(cal.getTime()));
        System.exit(0);
    }
}

