/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import excel.brick.Brick;
import excel.brick.SwitchHandle;
import excel.core.Cell;
import excel.core.ColumnPropertyManage;
import excel.core.DataSourceConfig;
import excel.core.Depend;
import excel.core.EditStyle;
import excel.core.Property;
import excel.core.Range;
import excel.core.RowPropertyManage;
import excel.core.WorkSheet;
import excel.core.ZExcel;
import excel.jep.ASTVarNode;
import excel.jep.function.JepFunctionProxy;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import jun.db.core.DataStore;
import jun.db.core.DataStoreActionAdapter;
import jun.db.core.DataStoreListener;
import jun.db.core.ObjectTool;
import jun.db.impl.DataStoreFactory;
import jun.db.util.TimeMark;
import org.json.JSONArray;
import org.json.JSONObject;
import wiseoa.flow.applet.CellTagConfig;
import wiseoa.flow.applet.CrossAnalysis_Cumulative;
import wiseoa.flow.applet.FlowForm;

public class CrossAnalysis {
    public static String $Band_row = "row";
    public static String $Band_col = "col";
    public static String $Band_data = "data";
    public static String $crossSwitch = "crossSwitch";
    FlowForm ff;
    String g_where = "";
    String g_select = "";
    String _dsn = "";
    boolean groupColAllowNullValue = false;
    WorkSheet sheet = null;
    CrossAnalysis_Cumulative cumulativeProxy = new CrossAnalysis_Cumulative(this);
    HashMap rowAreaMap = new HashMap();
    HashMap colAreaMap = new HashMap();
    public JSONObject rowAppendMap2 = new JSONObject();

    public CrossAnalysis(FlowForm ff_, WorkSheet sheet_) {
        this.ff = ff_;
        this.sheet = sheet_;
        this.sheet.getWorkBook().setJepFunctionProxy("cumulative", (JepFunctionProxy)this.cumulativeProxy);
    }

    public void analyze(String sql, String where) {
        this.analyze(sql, where, true);
    }

    public void expandAll() {
        for (String colGroupGuid : this.colAreaMap.keySet()) {
            HashMap switchHandleMap = (HashMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("switchHandleMap");
            Object[] nodekeys = switchHandleMap.keySet().toArray();
            int i = 0;
            while (i < nodekeys.length) {
                Cell cell = (Cell)nodekeys[i];
                CellTagConfig ctc = (CellTagConfig)switchHandleMap.get(cell);
                SwitchHandle sh = (SwitchHandle)cell.getBrick($crossSwitch);
                if (sh != null) {
                    sh.expand();
                }
                ++i;
            }
        }
    }

    public void collapseAll() {
        Iterator it_colGroupGuid = this.colAreaMap.keySet().iterator();
        ColumnPropertyManage CPM = this.sheet.getColumnPropertyManage();
        RowPropertyManage RPM = this.sheet.getRowPropertyManage();
        while (it_colGroupGuid.hasNext()) {
            String colGroupGuid = (String)it_colGroupGuid.next();
            HashMap switchHandleMap = (HashMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("switchHandleMap");
            Object[] nodekeys = switchHandleMap.keySet().toArray();
            int i = nodekeys.length - 1;
            while (i >= 0) {
                Cell cell = (Cell)nodekeys[i];
                CellTagConfig ctc = (CellTagConfig)switchHandleMap.get(cell);
                SwitchHandle sh = (SwitchHandle)cell.getBrick($crossSwitch);
                if (sh != null) {
                    int w = 0;
                    if (cell.isMerged()) {
                        int startCol = cell.getColumnIndex();
                        int endCol = cell.getRightBottomCorner().getColumnIndex();
                        int k = startCol;
                        while (k <= endCol) {
                            w += CPM.getColumnWidth(k);
                            ++k;
                        }
                    } else {
                        w = CPM.getColumnWidth(cell.getColumnIndex());
                    }
                    if (w != 0) {
                        sh.collapse();
                    }
                }
                --i;
            }
        }
    }

    public void analyze(String sql, String where, boolean retryIfError) {
        try {
            this.ff.showInfoPane("<p align=center>\u6b63\u5728\u8fdb\u884c\u900f\u89c6\u5206\u6790...</p>", 300, 75);
            this.g_where = where;
            this.g_select = sql;
            TimeMark tm = new TimeMark();
            HashMap<String, ArrayList<CellTagConfig>> areaDataDefineMap = new HashMap<String, ArrayList<CellTagConfig>>();
            HashMap<String, String> areaOrderByMap = new HashMap<String, String>();
            tm.stamp("\u5f00\u59cb\u5b57\u6bb5\u914d\u7f6e\u5206\u6790");
            Point crossPoint = null;
            this.sheet.setPaintPermit(false);
            this.sheet.setRebuildCellDefineAfterInsertOrDeleteRow(false);
            int row = 0;
            while (row < this.sheet.getRowCount()) {
                int col = 0;
                while (col < this.sheet.getColumnCount()) {
                    block131: {
                        Cell cell;
                        Object o;
                        if (!this.sheet.isCellNull(row, col) && (o = (cell = this.sheet.cells(row, col)).getTag()) != null) {
                            String s;
                            Integer key;
                            HashMap map;
                            HashMap<String, Integer> dbcolsPositionMap;
                            JSONObject tag;
                            try {
                                tag = new JSONObject(o.toString());
                            }
                            catch (Exception e) {
                                break block131;
                            }
                            CellTagConfig ctc = new CellTagConfig();
                            ctc.band = tag.getString("band", "");
                            ctc.dsn = tag.getString("dsn", "");
                            ctc.column = tag.getString("column", "");
                            ctc.aggregateType = tag.getString("aggregateType", "");
                            ctc.orderType = tag.getString("orderType", "");
                            ctc.customOrderColumn = tag.getString("customOrderType", "");
                            if (ctc.band.equals($Band_col) && !ctc.column.equals("")) {
                                this.calcColGroupLevel(this.sheet, cell, ctc);
                                this._dsn = ctc.dsn;
                                TreeMap<Integer, CellTagConfig> colGroupColsMap = null;
                                dbcolsPositionMap = null;
                                if (this.colAreaMap.containsKey(ctc.groupGuid)) {
                                    map = (HashMap)this.colAreaMap.get(ctc.groupGuid);
                                    colGroupColsMap = (TreeMap<Integer, CellTagConfig>)map.get("cols");
                                    dbcolsPositionMap = (HashMap<String, Integer>)map.get("position");
                                } else {
                                    map = new HashMap();
                                    this.colAreaMap.put(ctc.groupGuid, map);
                                    colGroupColsMap = new TreeMap<Integer, CellTagConfig>();
                                    dbcolsPositionMap = new HashMap<String, Integer>();
                                    HashMap colAppendMap = new HashMap();
                                    map.put("cols", colGroupColsMap);
                                    map.put("position", dbcolsPositionMap);
                                    map.put("appendMap", colAppendMap);
                                    map.put("switchHandleMap", new LinkedHashMap());
                                }
                                key = new Integer(ctc.groupLevel);
                                if (colGroupColsMap.containsKey(key)) {
                                    s = ((CellTagConfig)colGroupColsMap.get((Object)key)).column;
                                    throw new Exception("\u5b9a\u4e49\u4e2d\u5904\u4e8e\u5217\u5b57\u6bb5\u533a\u7684" + s + "\u4e0e" + ctc.column + "\u5904\u4e8e\u540c\u4e00\u4e2a\u5206\u7ec4\u7247\u533a\u4e2d\uff0c\u5e76\u4e14\u5b83\u4eec\u7684\u5206\u7ec4\u7ea7\u522b\u76f8\u540c\uff0c\u8fd9\u662f\u4e0d\u5141\u8bb8\u7684\u3002");
                                }
                                colGroupColsMap.put(key, ctc);
                                dbcolsPositionMap.put(ctc.column, new Integer(cell.getRowIndex()));
                            }
                            if (ctc.band.equals($Band_row) && !ctc.column.equals("")) {
                                this.calcRowGroupLevel(this.sheet, cell, ctc);
                                this._dsn = ctc.dsn;
                                TreeMap<Integer, CellTagConfig> rowGroupColsMap = null;
                                dbcolsPositionMap = null;
                                if (this.rowAreaMap.containsKey(ctc.groupGuid)) {
                                    map = (HashMap)this.rowAreaMap.get(ctc.groupGuid);
                                    rowGroupColsMap = (TreeMap<Integer, CellTagConfig>)map.get("cols");
                                    dbcolsPositionMap = (HashMap<String, Integer>)map.get("position");
                                } else {
                                    map = new HashMap();
                                    this.rowAreaMap.put(ctc.groupGuid, map);
                                    rowGroupColsMap = new TreeMap<Integer, CellTagConfig>();
                                    dbcolsPositionMap = new HashMap<String, Integer>();
                                    HashMap rowAppendMap = new HashMap();
                                    map.put("cols", rowGroupColsMap);
                                    map.put("position", dbcolsPositionMap);
                                    map.put("appendMap", rowAppendMap);
                                    map.put("switchHandleMap", new LinkedHashMap());
                                }
                                key = new Integer(ctc.groupLevel);
                                if (rowGroupColsMap.containsKey(key)) {
                                    s = ((CellTagConfig)rowGroupColsMap.get((Object)key)).column;
                                    throw new Exception("\u5b9a\u4e49\u4e2d\u5904\u4e8e\u884c\u5b57\u6bb5\u533a\u7684" + s + "\u4e0e" + ctc.column + "\u5904\u4e8e\u540c\u4e00\u4e2a\u5206\u7ec4\u7247\u533a\u4e2d\uff0c\u5e76\u4e14\u5b83\u4eec\u7684\u5206\u7ec4\u7ea7\u522b\u76f8\u540c\uff0c\u8fd9\u662f\u4e0d\u5141\u8bb8\u7684\u3002");
                                }
                                rowGroupColsMap.put(key, ctc);
                                dbcolsPositionMap.put(ctc.column, new Integer(cell.getColumnIndex()));
                            }
                            if (ctc.band.equals($Band_data)) {
                                if (crossPoint == null) {
                                    crossPoint = new Point();
                                    crossPoint.x = cell.getColumnIndex();
                                    crossPoint.y = cell.getRowIndex();
                                    Cell cc = this.sheet.cells(crossPoint.y - 1, crossPoint.x - 1);
                                    if (cc.isMerged()) {
                                        cc = cc.mergedBy();
                                    }
                                    final SwitchHandle sh = this.ff.book.createSwitchHandle(String.valueOf($crossSwitch) + "_crossPoint");
                                    sh.setBounds(-17, -17, 16, 16);
                                    sh.setStateExpanded(true);
                                    sh.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent e) {
                                            if (sh.isCollapsed()) {
                                                CrossAnalysis.this.collapseAll();
                                            } else {
                                                CrossAnalysis.this.expandAll();
                                            }
                                        }
                                    });
                                    cc.addBrick((Brick)sh);
                                }
                                if (!ctc.column.equals("") && !ctc.aggregateType.equals("")) {
                                    this.calcRowColGroupLevel(this.sheet, cell, ctc);
                                    ArrayList<CellTagConfig> dataDefineList = (ArrayList<CellTagConfig>)areaDataDefineMap.get(ctc.groupGuid);
                                    if (dataDefineList == null) {
                                        dataDefineList = new ArrayList<CellTagConfig>();
                                        areaDataDefineMap.put(ctc.groupGuid, dataDefineList);
                                    }
                                    dataDefineList.add(ctc);
                                }
                            }
                            cell.setTag((Object)ctc);
                        }
                    }
                    ++col;
                }
                ++row;
            }
            System.out.println(this.colAreaMap.toString());
            System.out.println(this.rowAreaMap.toString());
            System.out.println(areaDataDefineMap.toString());
            tm.stamp("\u521d\u5206\u6790\u5b8c\u6210");
            HashMap<String, DataStore> dsMap = new HashMap<String, DataStore>();
            HashMap<String, String> selectColsMap = new HashMap<String, String>();
            HashMap selectColsListMap = new HashMap();
            DataSourceConfig dsc = this.ff.book.getDataSource(this._dsn);
            if (dsc == null) {
                if (!retryIfError) {
                    throw new Exception("\u900f\u89c6\u5206\u6790\u5df2\u7ecf\u5b8c\u6210\uff0c\u5982\u679c\u9700\u8981\u518d\u6b21\u5206\u6790\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u672c\u9875\u9762\u3002");
                }
                this.sheet = this.ff.reCreateWorkSheet(this.sheet);
                this.sheet.getWorkBook().setActiveSheet(this.sheet.getIndex());
                this.sheet.getRowPropertyManage().setRowHeadWidth(0);
                this.sheet.getColumnPropertyManage().setColumnHeadHeight(0);
                this.sheet.setGridLineVisible(false);
                System.out.println("\u91cd\u65b0\u521b\u5efa\u4ea4\u53c9\u5206\u6790\u7684\u5de5\u4f5c\u8868\u540e\u91cd\u65b0\u5206\u6790");
                this.analyze(sql, where, false);
                return;
            }
            try {
                DataStore ds;
                CellTagConfig ctc;
                Object key;
                StringBuffer whereSb;
                StringBuffer orderSb;
                StringBuffer colSb;
                StringBuffer sb;
                Object[] keys;
                String sourceSQL = dsc.getDataStore().getSelect();
                if (!this.g_select.equals("")) {
                    sourceSQL = this.g_select;
                }
                if (sourceSQL.indexOf(" order by ") > 0 && sourceSQL.indexOf(" top ") < 0) {
                    System.out.println("\u5728\u6570\u636e\u6e90\u5b9a\u4e49\u4e2d\u5b58\u5728order by\uff0c\u800c\u6ca1\u6709\u4f7f\u7528top ,\u6709\u53ef\u80fd\u65e0\u6cd5\u7edf\u8ba1");
                }
                sourceSQL = DataStoreFactory.LinkUpWhere((String)sourceSQL, (String)this.g_where);
                for (String rowGroupGuid : this.rowAreaMap.keySet()) {
                    TreeMap rowGroupColsMap = (TreeMap)((HashMap)this.rowAreaMap.get(rowGroupGuid)).get("cols");
                    keys = rowGroupColsMap.keySet().toArray();
                    sb = new StringBuffer();
                    colSb = new StringBuffer();
                    orderSb = new StringBuffer();
                    whereSb = new StringBuffer();
                    ArrayList<String> rowGroupCols = new ArrayList<String>();
                    selectColsListMap.put(rowGroupGuid, rowGroupCols);
                    int i = 0;
                    while (i < keys.length) {
                        key = keys[i];
                        ctc = (CellTagConfig)rowGroupColsMap.get(key);
                        sb.append(ctc.column);
                        colSb.append(" '' as " + ctc.column);
                        rowGroupCols.add(ctc.column);
                        if (ctc.orderType.equals("asc")) {
                            orderSb.append(ctc.column).append(" asc");
                        }
                        if (ctc.orderType.equals("desc")) {
                            orderSb.append(ctc.column).append(" desc");
                        }
                        if (ctc.orderType.equals("col-asc")) {
                            orderSb.append(" max(").append(ctc.customOrderColumn).append(") asc");
                        }
                        if (ctc.orderType.equals("col-desc")) {
                            orderSb.append(" max(").append(ctc.customOrderColumn).append(") desc");
                        }
                        if (!this.groupColAllowNullValue) {
                            whereSb.append(" (not ( " + ctc.column + " is null )) ");
                        }
                        if (i != keys.length - 1) {
                            sb.append(",");
                            colSb.append(",");
                            orderSb.append(",");
                            if (whereSb.length() > 0) {
                                whereSb.append(" and ");
                            }
                        }
                        ++i;
                    }
                    String rowCols = sb.toString();
                    selectColsMap.put(rowGroupGuid, rowCols);
                    if (whereSb.length() > 0) {
                        whereSb.insert(0, "  where  ");
                    }
                    String rowSQL = "select  " + sb.toString() + "  from  ( " + sourceSQL + "  )  wiseoa_crossanalysis_temp   " + whereSb.toString() + "  group by " + sb.toString() + " order by " + orderSb.toString();
                    System.out.println(dsc.getDBPoolName());
                    ds = this.ff.createDataStore("", "select  " + colSb.toString() + "  from  news_user");
                    System.out.println(rowSQL);
                    dsMap.put(rowGroupGuid, ds);
                    areaOrderByMap.put(rowGroupGuid, orderSb.toString());
                }
                for (String colGroupGuid : this.colAreaMap.keySet()) {
                    TreeMap colGroupColsMap = (TreeMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("cols");
                    keys = colGroupColsMap.keySet().toArray();
                    sb = new StringBuffer();
                    colSb = new StringBuffer();
                    orderSb = new StringBuffer();
                    whereSb = new StringBuffer();
                    ArrayList<String> colGroupCols = new ArrayList<String>();
                    selectColsListMap.put(colGroupGuid, colGroupCols);
                    int i = 0;
                    while (i < keys.length) {
                        key = keys[i];
                        ctc = (CellTagConfig)colGroupColsMap.get(key);
                        sb.append(ctc.column);
                        colSb.append(" '' as " + ctc.column);
                        colGroupCols.add(ctc.column);
                        if (ctc.orderType.equals("asc")) {
                            orderSb.append(ctc.column).append(" asc");
                        }
                        if (ctc.orderType.equals("desc")) {
                            orderSb.append(ctc.column).append(" desc");
                        }
                        if (ctc.orderType.equals("col-asc")) {
                            orderSb.append(" max(").append(ctc.customOrderColumn).append(") asc");
                        }
                        if (ctc.orderType.equals("col-desc")) {
                            orderSb.append(" max(").append(ctc.customOrderColumn).append(") desc");
                        }
                        if (!this.groupColAllowNullValue) {
                            whereSb.append(" (not ( " + ctc.column + " is null )) ");
                        }
                        if (i != keys.length - 1) {
                            sb.append(",");
                            colSb.append(",");
                            orderSb.append(",");
                            if (whereSb.length() > 0) {
                                whereSb.append(" and ");
                            }
                        }
                        ++i;
                    }
                    String colCols = sb.toString();
                    selectColsMap.put(colGroupGuid, colCols);
                    if (whereSb.length() > 0) {
                        whereSb.insert(0, "  where  ");
                    }
                    String colSQL = "select  " + sb.toString() + "  from  ( " + sourceSQL + "  )  wiseoa_crossanalysis_temp  " + whereSb.toString() + "  group by " + sb.toString() + " order by " + orderSb.toString();
                    ds = this.ff.createDataStore(dsc.getDBPoolName(), colSQL);
                    ds.setOrderBy(orderSb.toString());
                    System.out.println(colSQL);
                    dsMap.put(colGroupGuid, ds);
                    areaOrderByMap.put(colGroupGuid, orderSb.toString());
                }
                tm.stamp("\u884c\u5206\u7ec4\uff0c\u5217\u5206\u7ec4\u5206\u6790\u5b8c\u6210");
                HashMap<String, Integer> key2Row = new HashMap<String, Integer>();
                for (String groupGuid : areaDataDefineMap.keySet()) {
                    String colGroupOrderBy;
                    String dataSQL;
                    ArrayList dataDefineList = (ArrayList)areaDataDefineMap.get(groupGuid);
                    sb = new StringBuffer();
                    int an = dataDefineList.size();
                    if (an == 0) {
                        throw new Exception("\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u6570\u636e\u9879");
                    }
                    int i = 0;
                    while (i < an) {
                        CellTagConfig ctc2 = (CellTagConfig)dataDefineList.get(i);
                        if (ctc2.aggregateType.equals("sum")) {
                            sb.append("sum(").append(ctc2.column).append(") as  sum_").append(ctc2.column);
                        }
                        if (ctc2.aggregateType.equals("count")) {
                            sb.append("count(").append(ctc2.column).append(") as  count_").append(ctc2.column);
                        }
                        if (ctc2.aggregateType.equals("dsum")) {
                            sb.append("sum( distinct ").append(ctc2.column).append(") as  dsum_").append(ctc2.column);
                        }
                        if (ctc2.aggregateType.equals("dcount")) {
                            sb.append("count(  distinct ").append(ctc2.column).append(") as  dcount_").append(ctc2.column);
                        }
                        if (ctc2.aggregateType.equals("max")) {
                            sb.append("max(").append(ctc2.column).append(") as  max_").append(ctc2.column);
                        }
                        if (ctc2.aggregateType.equals("min")) {
                            sb.append("min(").append(ctc2.column).append(") as  min_").append(ctc2.column);
                        }
                        if (ctc2.aggregateType.equals("avg")) {
                            sb.append("avg(").append(ctc2.column).append(") as  count_").append(ctc2.column);
                        }
                        if (i != an - 1) {
                            sb.append(",");
                        }
                        ++i;
                    }
                    String dataCols = sb.toString();
                    JSONObject json = new JSONObject(groupGuid);
                    String rowGroupGuid = json.getString("row", "");
                    String colGroupGuid = json.getString("col", "");
                    String rowCols = (String)selectColsMap.get(rowGroupGuid);
                    String colCols = (String)selectColsMap.get(colGroupGuid);
                    DataStore rowGroupDs = (DataStore)dsMap.get(rowGroupGuid);
                    DataStore colGroupDs = (DataStore)dsMap.get(colGroupGuid);
                    sb = new StringBuffer();
                    sb.append("select ");
                    if (rowCols != null) {
                        sb.append(rowCols).append(",");
                    }
                    if (colCols != null) {
                        sb.append(colCols).append(",");
                    }
                    sb.append(dataCols);
                    sb.append("  from  ( ").append(sourceSQL).append("  )   wiseoa_crossanalysis_temp  group by ");
                    if (rowCols != null) {
                        sb.append(rowCols).append(",");
                    }
                    if (colCols != null) {
                        sb.append(colCols).append(",");
                    }
                    if ((dataSQL = sb.toString().trim()).endsWith(",")) {
                        dataSQL = dataSQL.substring(0, dataSQL.length() - 1);
                    }
                    sb = new StringBuffer(dataSQL);
                    String rowGroupOrderBy = (String)areaOrderByMap.get(rowGroupGuid);
                    if (rowGroupOrderBy == null) {
                        rowGroupOrderBy = "";
                    }
                    if ((colGroupOrderBy = (String)areaOrderByMap.get(colGroupGuid)) == null) {
                        colGroupOrderBy = "";
                    }
                    sb.append(" order by ");
                    if (rowGroupOrderBy.length() > 0) {
                        sb.append(rowGroupOrderBy).append(",");
                    }
                    if (colGroupOrderBy.length() > 0) {
                        sb.append(colGroupOrderBy).append(",");
                    }
                    if ((dataSQL = sb.toString().trim()).endsWith(",")) {
                        dataSQL = dataSQL.substring(0, dataSQL.length() - 1);
                    }
                    DataStore dsData = this.ff.createDataStore(dsc.getDBPoolName(), dataSQL);
                    dsData.getEvent().addDataStoreEventListener((DataStoreListener)new DataStoreActionAdapter(){

                        public String parseInnerParameter(String parameterName) {
                            WorkSheet sheet = CrossAnalysis.this.ff.book.getWorkSheet(0);
                            Object v = sheet.evaluate("=" + parameterName);
                            Object v2 = CrossAnalysis.this.ff.RunScript("parseInnerParameter", new Object[]{"crossAnalysis", parameterName});
                            if (v2 != null) {
                                return v2.toString();
                            }
                            if (v != null) {
                                return v.toString();
                            }
                            return null;
                        }
                    });
                    System.out.println(dataSQL);
                    dsData.retrieve();
                    tm.stamp("\u68c0\u7d22\u6570\u636e");
                    dsMap.put(groupGuid, dsData);
                    ArrayList rowGroupCols = (ArrayList)selectColsListMap.get(rowGroupGuid);
                    ArrayList colGroupCols = (ArrayList)selectColsListMap.get(colGroupGuid);
                    HashMap<StringBuffer, Boolean> groupRowDataMap = new HashMap<StringBuffer, Boolean>();
                    HashMap<StringBuffer, Boolean> groupColDataMap = new HashMap<StringBuffer, Boolean>();
                    int i2 = 0;
                    while (i2 < dsData.getRowCount()) {
                        String s;
                        String col;
                        int row2;
                        String s2;
                        String col2;
                        int ci;
                        StringBuffer tkey;
                        boolean groupValueIsNull;
                        StringBuffer key2 = new StringBuffer();
                        key2.append(rowGroupGuid).append(";");
                        key2.append(colGroupGuid).append(";");
                        if (rowGroupCols != null) {
                            groupValueIsNull = false;
                            tkey = new StringBuffer();
                            ci = 0;
                            while (ci < rowGroupCols.size()) {
                                col2 = (String)rowGroupCols.get(ci);
                                s2 = this.getStringFromDS(dsData, i2, col2);
                                key2.append(col2).append("=").append(s2).append(";");
                                tkey.append(col2).append("=").append(s2).append(";");
                                if (s2.equals("")) {
                                    groupValueIsNull = true;
                                }
                                ++ci;
                            }
                            if (!groupRowDataMap.containsKey(tkey) && (!groupValueIsNull || groupValueIsNull && this.groupColAllowNullValue)) {
                                groupRowDataMap.put(tkey, Boolean.TRUE);
                                row2 = rowGroupDs.insertRow(99999);
                                int ci2 = 0;
                                while (ci2 < rowGroupCols.size()) {
                                    col = (String)rowGroupCols.get(ci2);
                                    s = this.getStringFromDS(dsData, i2, col);
                                    rowGroupDs.setValue(row2, col, (Object)s);
                                    ++ci2;
                                }
                            }
                        }
                        if (colGroupCols != null) {
                            groupValueIsNull = false;
                            tkey = new StringBuffer();
                            ci = 0;
                            while (ci < colGroupCols.size()) {
                                col2 = (String)colGroupCols.get(ci);
                                s2 = this.getStringFromDS(dsData, i2, col2);
                                key2.append(col2).append("=").append(s2).append(";");
                                tkey.append(col2).append("=").append(s2).append(";");
                                if (s2.equals("")) {
                                    groupValueIsNull = true;
                                }
                                ++ci;
                            }
                            if (!groupColDataMap.containsKey(tkey) && (!groupValueIsNull || groupValueIsNull && this.groupColAllowNullValue)) {
                                groupColDataMap.put(tkey, Boolean.TRUE);
                                row2 = colGroupDs.insertRow(99999);
                                int ci3 = 0;
                                while (ci3 < colGroupCols.size()) {
                                    col = (String)colGroupCols.get(ci3);
                                    s = this.getStringFromDS(dsData, i2, col);
                                    colGroupDs.setValue(row2, col, (Object)s);
                                    ++ci3;
                                }
                            }
                        }
                        key2Row.put(key2.toString(), new Integer(i2));
                        ++i2;
                    }
                    colGroupDs.sort();
                }
                System.out.println(dsMap);
                System.out.println(selectColsMap);
                System.out.println(selectColsListMap);
                System.out.println(key2Row);
                tm.stamp("\u51c6\u5907\u6570\u636e\u533a\u6570\u636e\u6620\u5c04\u5b8c\u6210");
                int row3 = 0;
                while (row3 < crossPoint.y) {
                    Cell cell = this.sheet.cells(row3, crossPoint.x);
                    while (cell != null) {
                        Object ttag = cell.getTag();
                        if (cell.isMerged() && cell != cell.mergedBy()) {
                            cell = this.getRightCell(this.sheet, cell);
                            continue;
                        }
                        Cell rightCell = this.getRightCell(this.sheet, cell);
                        if (ttag instanceof CellTagConfig) {
                            CellTagConfig ctc3 = (CellTagConfig)ttag;
                            if (ctc3.band.equals($Band_col) && !ctc3.column.equals("")) {
                                TreeMap colGroupColsMap = (TreeMap)((HashMap)this.colAreaMap.get(ctc3.groupGuid)).get("cols");
                                HashMap dbcolsPositionMap = (HashMap)((HashMap)this.colAreaMap.get(ctc3.groupGuid)).get("position");
                                HashMap colAppendMap = (HashMap)((HashMap)this.colAreaMap.get(ctc3.groupGuid)).get("appendMap");
                                HashMap switchHandleMap = (HashMap)((HashMap)this.colAreaMap.get(ctc3.groupGuid)).get("switchHandleMap");
                                DataStore dsCol = (DataStore)dsMap.get(ctc3.groupGuid);
                                this.colAppend(this.sheet, cell, dbcolsPositionMap, colGroupColsMap, dsCol, ctc3, colAppendMap, crossPoint, switchHandleMap);
                            }
                        }
                        cell = rightCell;
                    }
                    ++row3;
                }
                JSONObject colAppendMap2 = new JSONObject();
                JSONObject col2GroupLevel = new JSONObject();
                colAppendMap2.put("grouplevel", (Object)col2GroupLevel);
                for (String colGroupGuid : this.colAreaMap.keySet()) {
                    HashMap colAppendMap = (HashMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("appendMap");
                    for (Cell cell : colAppendMap.keySet()) {
                        HashMap map = (HashMap)colAppendMap.get(cell);
                        CellTagConfig ctc4 = (CellTagConfig)map.get("ctc");
                        ArrayList appendList = (ArrayList)map.get("appendList");
                        int colIndex = cell.getColumnIndex();
                        int rowIndex = cell.getRowIndex();
                        JSONObject js = colAppendMap2.getJSONObject("col_" + colIndex, null);
                        if (js == null) {
                            js = new JSONObject();
                            colAppendMap2.put("col_" + colIndex, (Object)js);
                        }
                        JSONArray ja = new JSONArray();
                        js.put("groupLevel_" + ctc4.groupLevel, (Object)ja);
                        ja.put(colIndex);
                        if (col2GroupLevel.getJSONObject("col_" + colIndex, null) == null) {
                            col2GroupLevel.put("col_" + colIndex, (Object)new JSONObject());
                        }
                        col2GroupLevel.getJSONObject("col_" + colIndex, null).put("row_" + rowIndex, ctc4.groupLevel);
                        int i = 0;
                        while (i < appendList.size()) {
                            Cell tc = (Cell)appendList.get(i);
                            int c = tc.getColumnIndex();
                            ja.put(c);
                            if (col2GroupLevel.getJSONObject("col_" + c, null) == null) {
                                col2GroupLevel.put("col_" + c, (Object)new JSONObject());
                            }
                            col2GroupLevel.getJSONObject("col_" + c, null).put("row_" + tc.getRowIndex(), ctc4.groupLevel);
                            ++i;
                        }
                    }
                }
                System.out.println(colAppendMap2.toString());
                for (String colGroupGuid : this.colAreaMap.keySet()) {
                    TreeMap colGroupColsMap = (TreeMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("cols");
                    HashMap switchHandleMap = (HashMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("switchHandleMap");
                    int groupLevelCount = colGroupColsMap.keySet().size();
                    for (Cell cell : switchHandleMap.keySet()) {
                        int lastCol;
                        ctc = (CellTagConfig)switchHandleMap.get(cell);
                        SwitchHandle sh = (SwitchHandle)cell.getBrick($crossSwitch);
                        if (sh == null || ctc.groupLevel == groupLevelCount) continue;
                        int colIndex = cell.getColumnIndex();
                        int rowIndex = cell.getRowIndex();
                        JSONArray subCells = colAppendMap2.getJSONObject("col_" + colIndex, null).getJSONArray("groupLevel_" + (ctc.groupLevel + 1), null);
                        int nextRow = this.getDownCell(this.sheet, cell).getRowIndex();
                        Cell lastSubCell = this.sheet.cells(nextRow, lastCol = subCells.getInt(subCells.length() - 1));
                        if (lastSubCell.isMerged()) {
                            lastSubCell = lastSubCell.getRightBottomCorner();
                        }
                        sh.addColumns(colIndex, lastSubCell.getColumnIndex());
                    }
                }
                tm.stamp("\u5217\u6269\u5c55\u5b8c\u6210");
                int col = 0;
                while (col < crossPoint.x) {
                    Cell cell = this.sheet.cells(crossPoint.y, col);
                    while (cell != null) {
                        Object ttag = cell.getTag();
                        if (cell.isMerged() && cell != cell.mergedBy()) {
                            cell = this.getDownCell(this.sheet, cell);
                            continue;
                        }
                        Cell downCell = this.getDownCell(this.sheet, cell);
                        if (ttag instanceof CellTagConfig) {
                            CellTagConfig ctc5 = (CellTagConfig)ttag;
                            if (ctc5.band.equals($Band_row) && !ctc5.column.equals("")) {
                                TreeMap rowGroupColsMap = (TreeMap)((HashMap)this.rowAreaMap.get(ctc5.groupGuid)).get("cols");
                                HashMap dbcolsPositionMap = (HashMap)((HashMap)this.rowAreaMap.get(ctc5.groupGuid)).get("position");
                                HashMap rowAppendMap = (HashMap)((HashMap)this.rowAreaMap.get(ctc5.groupGuid)).get("appendMap");
                                HashMap switchHandleMap = (HashMap)((HashMap)this.rowAreaMap.get(ctc5.groupGuid)).get("switchHandleMap");
                                DataStore dsRow = (DataStore)dsMap.get(ctc5.groupGuid);
                                TimeMark tm1 = new TimeMark(false);
                                this.rowAppend(this.sheet, cell, dbcolsPositionMap, rowGroupColsMap, dsRow, ctc5, rowAppendMap, crossPoint, switchHandleMap);
                                tm1.stamp(" rowappend  " + cell.getName() + " ok");
                            }
                        }
                        cell = downCell;
                    }
                    ++col;
                }
                tm.stamp("\u884c\u6269\u5c55\u5b8c\u6210");
                JSONObject row2GroupLevel = new JSONObject();
                this.rowAppendMap2.put("grouplevel", (Object)row2GroupLevel);
                for (String rowGroupGuid : this.rowAreaMap.keySet()) {
                    HashMap rowAppendMap = (HashMap)((HashMap)this.rowAreaMap.get(rowGroupGuid)).get("appendMap");
                    for (Cell cell : rowAppendMap.keySet()) {
                        HashMap map = (HashMap)rowAppendMap.get(cell);
                        CellTagConfig ctc6 = (CellTagConfig)map.get("ctc");
                        ArrayList appendList = (ArrayList)map.get("appendList");
                        int colIndex = cell.getColumnIndex();
                        int rowIndex = cell.getRowIndex();
                        JSONObject js = this.rowAppendMap2.getJSONObject("row_" + rowIndex, null);
                        if (js == null) {
                            js = new JSONObject();
                            this.rowAppendMap2.put("row_" + rowIndex, (Object)js);
                        }
                        JSONArray ja = new JSONArray();
                        js.put("groupLevel_" + ctc6.groupLevel, (Object)ja);
                        ja.put(rowIndex);
                        if (row2GroupLevel.getJSONObject("row_" + rowIndex, null) == null) {
                            row2GroupLevel.put("row_" + rowIndex, (Object)new JSONObject());
                        }
                        row2GroupLevel.getJSONObject("row_" + rowIndex, null).put("col_" + colIndex, ctc6.groupLevel);
                        int i = 0;
                        while (i < appendList.size()) {
                            Cell tc = (Cell)appendList.get(i);
                            int r = tc.getRowIndex();
                            ja.put(r);
                            if (row2GroupLevel.getJSONObject("row_" + r, null) == null) {
                                row2GroupLevel.put("row_" + r, (Object)new JSONObject());
                            }
                            row2GroupLevel.getJSONObject("row_" + r, null).put("col_" + tc.getColumnIndex(), ctc6.groupLevel);
                            ++i;
                        }
                    }
                }
                System.out.println(this.rowAppendMap2.toString());
                for (String rowGroupGuid : this.rowAreaMap.keySet()) {
                    TreeMap rowGroupColsMap = (TreeMap)((HashMap)this.rowAreaMap.get(rowGroupGuid)).get("cols");
                    HashMap switchHandleMap = (HashMap)((HashMap)this.rowAreaMap.get(rowGroupGuid)).get("switchHandleMap");
                    int groupLevelCount = rowGroupColsMap.keySet().size();
                    for (Cell cell : switchHandleMap.keySet()) {
                        CellTagConfig ctc7 = (CellTagConfig)switchHandleMap.get(cell);
                        SwitchHandle sh = (SwitchHandle)cell.getBrick($crossSwitch);
                        if (sh == null || ctc7.groupLevel == groupLevelCount) continue;
                        int colIndex = cell.getColumnIndex();
                        int rowIndex = cell.getRowIndex();
                        JSONArray subCells = this.rowAppendMap2.getJSONObject("row_" + rowIndex, null).getJSONArray("groupLevel_" + (ctc7.groupLevel + 1), null);
                        int nextCol = this.getRightCell(this.sheet, cell).getColumnIndex();
                        int lastRow = subCells.getInt(subCells.length() - 1);
                        Cell lastSubCell = this.sheet.cells(lastRow, nextCol);
                        if (lastSubCell.isMerged()) {
                            lastSubCell = lastSubCell.getRightBottomCorner();
                        }
                        sh.addRows(rowIndex, lastSubCell.getRowIndex());
                    }
                }
                tm.stamp("\u4f38\u5c55\u6309\u94ae\u8bbe\u7f6e\u5b8c\u6210");
                int row4 = crossPoint.y;
                while (row4 < this.sheet.getRowCount()) {
                    int col3 = crossPoint.x;
                    while (col3 < this.sheet.getColumnCount()) {
                        Cell cell = this.sheet.cells(row4, col3);
                        Object ttag = cell.getTag();
                        if ((!cell.isMerged() || cell == cell.mergedBy()) && ttag instanceof CellTagConfig) {
                            ctc = (CellTagConfig)ttag;
                            if (ctc.band.equals($Band_data) && !ctc.column.equals("") && !ctc.aggregateType.equals("")) {
                                Object dataRow;
                                String s;
                                Cell gcell;
                                String colName;
                                StringBuffer key3 = new StringBuffer();
                                JSONObject json = new JSONObject(ctc.groupGuid);
                                String rowGroupGuid = json.getString("row", "");
                                String colGroupGuid = json.getString("col", "");
                                ArrayList rowGroupCols = (ArrayList)selectColsListMap.get(rowGroupGuid);
                                ArrayList colGroupCols = (ArrayList)selectColsListMap.get(colGroupGuid);
                                HashMap rowdbcolsPositionMap = null;
                                HashMap coldbcolsPositionMap = null;
                                if (this.rowAreaMap.containsKey(rowGroupGuid)) {
                                    rowdbcolsPositionMap = (HashMap)((HashMap)this.rowAreaMap.get(rowGroupGuid)).get("position");
                                }
                                if (this.colAreaMap.containsKey(colGroupGuid)) {
                                    coldbcolsPositionMap = (HashMap)((HashMap)this.colAreaMap.get(colGroupGuid)).get("position");
                                }
                                DataStore dsData = (DataStore)dsMap.get(ctc.groupGuid);
                                key3.append(rowGroupGuid).append(";");
                                key3.append(colGroupGuid).append(";");
                                if (rowGroupCols != null) {
                                    int ci = 0;
                                    while (ci < rowGroupCols.size()) {
                                        colName = (String)rowGroupCols.get(ci);
                                        int gcol = (Integer)rowdbcolsPositionMap.get(colName);
                                        gcell = this.sheet.cells(row4, gcol);
                                        if (gcell.isMerged()) {
                                            gcell = gcell.mergedBy();
                                        }
                                        s = gcell.getTag().toString();
                                        key3.append(colName).append("=").append(s).append(";");
                                        ++ci;
                                    }
                                }
                                if (colGroupCols != null) {
                                    int ci = 0;
                                    while (ci < colGroupCols.size()) {
                                        colName = (String)colGroupCols.get(ci);
                                        int grow = (Integer)coldbcolsPositionMap.get(colName);
                                        gcell = this.sheet.cells(grow, col3);
                                        if (gcell.isMerged()) {
                                            gcell = gcell.mergedBy();
                                        }
                                        s = gcell.getTag().toString();
                                        key3.append(colName).append("=").append(s).append(";");
                                        ++ci;
                                    }
                                }
                                if ((dataRow = key2Row.get(key3.toString())) == null) {
                                    cell.setValue(null);
                                } else {
                                    String dataColName = ctc.getAggregateColumnName();
                                    cell.setValue(dsData.getValue(((Integer)dataRow).intValue(), dataColName));
                                }
                            }
                        }
                        ++col3;
                    }
                    ++row4;
                }
                tm.stamp("\u6570\u636e\u586b\u5145\u5b8c\u6210");
                int rc = this.sheet.getRowCount();
                int cc = this.sheet.getColumnCount();
                ArrayList<Cell> checkedCellList = new ArrayList<Cell>();
                int row5 = 0;
                while (row5 < rc) {
                    int col4 = 0;
                    while (col4 < cc) {
                        int dn;
                        ArrayList list;
                        Cell cell;
                        if (!this.sheet.isCellNull(row5, col4) && (list = (cell = this.sheet.cells(row5, col4)).getDependList()) != null && (dn = list.size()) != 0) {
                            checkedCellList.clear();
                            cell.redefine(0, 0);
                            list = cell.getDependList();
                            if (list != null) {
                                dn = list.size();
                                int i = 0;
                                while (i < dn) {
                                    String varName;
                                    Cell dependCell;
                                    WorkSheet tsheet;
                                    Depend depend = (Depend)list.get(i);
                                    ASTVarNode var = depend.node;
                                    int varKind = var.getToken().kind;
                                    if (!(varKind != 11 && varKind != 10 || (tsheet = this.sheet.getWorkBook().getWorkSheetByGuid(depend.SheetGuid)) == null || tsheet != this.sheet || checkedCellList.contains(dependCell = this.sheet.cells(varName = var.getName())))) {
                                        checkedCellList.add(dependCell);
                                        int drow = dependCell.getRowIndex();
                                        int dcol = dependCell.getColumnIndex();
                                        if (drow == row5 && dcol != col4) {
                                            this.formulaColExpand(this.sheet, cell, dependCell, varName, crossPoint, colAppendMap2, col2GroupLevel);
                                        }
                                        if (dcol == col4 && drow != row5) {
                                            this.formulaRowExpand(this.sheet, cell, dependCell, varName, crossPoint, this.rowAppendMap2, row2GroupLevel);
                                        }
                                        if (dcol != col4 && drow != row5) {
                                            this.formulaRowColExpand(this.sheet, cell, dependCell, varName, crossPoint, this.rowAppendMap2, row2GroupLevel, colAppendMap2, col2GroupLevel);
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }
                        ++col4;
                    }
                    ++row5;
                }
                tm.stamp("\u516c\u5f0f\u4fee\u6b63\u7ed3\u675f");
                tm.stamp("\u4ea4\u53c9\u5206\u6790\u5168\u90e8\u7ed3\u675f");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            this.ff.hideInfoPane();
            this.sheet.setPaintPermit(true);
            this.sheet.getWorkSheetView().repaint();
        }
    }

    private String getStringFromDS(DataStore ds, int row, String col) {
        int colIndex = ds.col2Index(col);
        return this.getStringFromDS(ds, row, colIndex);
    }

    private String getStringFromDS(DataStore ds, int row, int col) {
        String vs = ds.getString(row, col);
        if (ds.getColumnProperty(col).getUniformDataType() == 4 && vs.length() > 10) {
            vs = vs.substring(0, 10);
        }
        return vs;
    }

    void calcRowGroupLevel(WorkSheet sheet, Cell cell, CellTagConfig ctc) {
        int col = cell.getColumnIndex();
        int row = cell.getRowIndex();
        int groupLevel = 0;
        String groupGuid = DataStoreFactory.newGUID();
        int i = 0;
        Cell tcell = sheet.cells(row, i);
        while (tcell != null) {
            if (tcell.getColumnIndex() > col) break;
            ++i;
            Cell ltCell = tcell;
            if (tcell.isMerged()) {
                ltCell = tcell.getLeftTopCorner();
            }
            JSONObject tag = null;
            Object o = ltCell.getTag();
            String band = "";
            try {
                if (o instanceof CellTagConfig) {
                    band = ((CellTagConfig)o).band;
                    if (band.equals($Band_row)) {
                        groupGuid = ((CellTagConfig)o).groupGuid;
                    }
                } else {
                    tag = new JSONObject(o.toString());
                    band = tag.getString("band", "");
                }
            }
            catch (Exception e) {
                tcell = sheet.cells(row, i);
                continue;
            }
            if (band.equals($Band_row)) {
                ++groupLevel;
            }
            tcell = sheet.cells(row, i);
        }
        ctc.groupLevel = groupLevel;
        ctc.groupGuid = groupGuid;
    }

    void calcColGroupLevel(WorkSheet sheet, Cell cell, CellTagConfig ctc) {
        int col = cell.getColumnIndex();
        int row = cell.getRowIndex();
        int groupLevel = 0;
        String groupGuid = DataStoreFactory.newGUID();
        int i = 0;
        Cell tcell = sheet.cells(0, col);
        while (tcell != null) {
            if (tcell.getRowIndex() > row) break;
            ++i;
            Cell ltCell = tcell;
            if (tcell.isMerged()) {
                ltCell = tcell.getLeftTopCorner();
            }
            JSONObject tag = null;
            Object o = ltCell.getTag();
            String band = "";
            try {
                if (o instanceof CellTagConfig) {
                    band = ((CellTagConfig)o).band;
                    if (band.equals($Band_col)) {
                        groupGuid = ((CellTagConfig)o).groupGuid;
                    }
                } else {
                    tag = new JSONObject(o.toString());
                    band = tag.getString("band", "");
                }
            }
            catch (Exception e) {
                tcell = sheet.cells(i, col);
                continue;
            }
            if (band.equals($Band_col)) {
                ++groupLevel;
            }
            tcell = sheet.cells(i, col);
        }
        ctc.groupLevel = groupLevel;
        ctc.groupGuid = groupGuid;
    }

    void calcRowColGroupLevel(WorkSheet sheet, Cell cell, CellTagConfig ctc) {
        String band;
        Object o;
        Cell ltCell;
        int col = cell.getColumnIndex();
        int row = cell.getRowIndex();
        String rowGroupGuid = null;
        String colGroupGuid = null;
        int i = 0;
        Cell tcell = sheet.cells(row, 0);
        while (tcell != null) {
            if (tcell.getColumnIndex() > col) break;
            ++i;
            ltCell = tcell;
            if (tcell.isMerged()) {
                ltCell = tcell.getLeftTopCorner();
            }
            if ((o = ltCell.getTag()) instanceof CellTagConfig && (band = ((CellTagConfig)o).band).equals($Band_row)) {
                rowGroupGuid = ((CellTagConfig)o).groupGuid;
                break;
            }
            tcell = sheet.cells(row, i);
        }
        i = 0;
        tcell = sheet.cells(0, col);
        while (tcell != null) {
            if (tcell.getRowIndex() > row) break;
            ++i;
            ltCell = tcell;
            if (tcell.isMerged()) {
                ltCell = tcell.getLeftTopCorner();
            }
            if ((o = ltCell.getTag()) instanceof CellTagConfig && (band = ((CellTagConfig)o).band).equals($Band_col)) {
                colGroupGuid = ((CellTagConfig)o).groupGuid;
                break;
            }
            tcell = sheet.cells(i, col);
        }
        JSONObject json = new JSONObject();
        json.put("row", rowGroupGuid);
        json.put("col", colGroupGuid);
        ctc.groupGuid = json.toString();
    }

    void formulaRowColExpand(WorkSheet sheet, Cell cell, Cell dependCell, String varName, Point crossPoint, JSONObject rowAppendMap2, JSONObject row2GroupLevel, JSONObject colAppendMap2, JSONObject col2GroupLevel) {
        int gl2;
        int row = cell.getRowIndex();
        int col = cell.getColumnIndex();
        int drow = dependCell.getRowIndex();
        int dcol = dependCell.getColumnIndex();
        int gl1 = this.getColGroupLevel(col2GroupLevel, row, col, crossPoint);
        if (gl1 >= (gl2 = this.getColGroupLevel(col2GroupLevel, drow, dcol, crossPoint))) {
            return;
        }
        ArrayList cols = this.getColExpandListOnLevel(colAppendMap2, dcol, drow, gl1 + 1, gl2);
        gl1 = this.getRowGroupLevel(row2GroupLevel, row, col, crossPoint);
        if (gl1 >= (gl2 = this.getRowGroupLevel(row2GroupLevel, drow, dcol, crossPoint))) {
            return;
        }
        ArrayList rows = this.getRowExpandListOnLevel(rowAppendMap2, drow, dcol, gl1 + 1, gl2);
        StringBuffer tsb = new StringBuffer();
        int rr = 0;
        while (rr < rows.size()) {
            int trow = (Integer)rows.get(rr);
            int cc = 0;
            while (cc < cols.size()) {
                int tcol = (Integer)cols.get(cc);
                tsb.append(ZExcel.rowColToName((int)trow, (int)tcol));
                if (cc != cols.size() - 1 || rr != rows.size() - 1) {
                    tsb.append(",");
                }
                ++cc;
            }
            ++rr;
        }
        String replaceTo = tsb.toString();
        cell.redefineReplace(varName, replaceTo);
    }

    void formulaColExpand(WorkSheet sheet, Cell cell, Cell dependCell, String varName, Point crossPoint, JSONObject colAppendMap2, JSONObject col2GroupLevel) {
        int gl2;
        int row = cell.getRowIndex();
        int col = cell.getColumnIndex();
        int drow = dependCell.getRowIndex();
        int dcol = dependCell.getColumnIndex();
        int gl1 = this.getColGroupLevel(col2GroupLevel, row, col, crossPoint);
        if (gl1 >= (gl2 = this.getColGroupLevel(col2GroupLevel, drow, dcol, crossPoint))) {
            return;
        }
        ArrayList cols = this.getColExpandListOnLevel(colAppendMap2, dcol, drow, gl1 + 1, gl2);
        StringBuffer tsb = new StringBuffer();
        int cci = 0;
        while (cci < cols.size()) {
            int tcol = (Integer)cols.get(cci);
            tsb.append(ZExcel.rowColToName((int)drow, (int)tcol));
            if (cci != cols.size() - 1) {
                tsb.append(",");
            }
            ++cci;
        }
        String replaceTo = tsb.toString();
        cell.redefineReplace(varName, replaceTo);
    }

    void formulaRowExpand(WorkSheet sheet, Cell cell, Cell dependCell, String varName, Point crossPoint, JSONObject rowAppendMap2, JSONObject row2GroupLevel) {
        int gl2;
        int row = cell.getRowIndex();
        int col = cell.getColumnIndex();
        int drow = dependCell.getRowIndex();
        int dcol = dependCell.getColumnIndex();
        int gl1 = this.getRowGroupLevel(row2GroupLevel, row, col, crossPoint);
        if (gl1 >= (gl2 = this.getRowGroupLevel(row2GroupLevel, drow, dcol, crossPoint))) {
            return;
        }
        ArrayList rows = this.getRowExpandListOnLevel(rowAppendMap2, drow, dcol, gl1 + 1, gl2);
        StringBuffer tsb = new StringBuffer();
        int cci = 0;
        while (cci < rows.size()) {
            int trow = (Integer)rows.get(cci);
            tsb.append(ZExcel.rowColToName((int)trow, (int)dcol));
            if (cci != rows.size() - 1) {
                tsb.append(",");
            }
            ++cci;
        }
        String replaceTo = tsb.toString();
        cell.redefineReplace(varName, replaceTo);
    }

    ArrayList getColExpandListOnLevel(JSONObject colAppendMap2, int col, int row, int startGroupLevel, int endGroupLevel) {
        JSONObject js = colAppendMap2.getJSONObject("col_" + col, null);
        if (js == null) {
            return null;
        }
        JSONArray ja = js.getJSONArray("groupLevel_" + startGroupLevel, null);
        if (ja == null) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int n = ja.length();
        int i = 0;
        while (i < n) {
            ret.add(new Integer(ja.getInt(i)));
            ++i;
        }
        if (startGroupLevel == endGroupLevel) {
            return ret;
        }
        ++startGroupLevel;
        ArrayList newRet = new ArrayList();
        int i2 = 0;
        while (i2 < ret.size()) {
            int tcol = (Integer)ret.get(i2);
            ArrayList tlist = this.getColExpandListOnLevel(colAppendMap2, tcol, row, startGroupLevel, endGroupLevel);
            newRet.addAll(tlist);
            ++i2;
        }
        return newRet;
    }

    ArrayList getRowExpandListOnLevel(JSONObject rowAppendMap2, int row, int col, int startGroupLevel, int endGroupLevel) {
        JSONObject js = rowAppendMap2.getJSONObject("row_" + row, null);
        if (js == null) {
            return null;
        }
        JSONArray ja = js.getJSONArray("groupLevel_" + startGroupLevel, null);
        if (ja == null) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int n = ja.length();
        int i = 0;
        while (i < n) {
            ret.add(new Integer(ja.getInt(i)));
            ++i;
        }
        if (startGroupLevel == endGroupLevel) {
            return ret;
        }
        ++startGroupLevel;
        ArrayList newRet = new ArrayList();
        int i2 = 0;
        while (i2 < ret.size()) {
            int trow = (Integer)ret.get(i2);
            ArrayList tlist = this.getRowExpandListOnLevel(rowAppendMap2, trow, col, startGroupLevel, endGroupLevel);
            newRet.addAll(tlist);
            ++i2;
        }
        return newRet;
    }

    /*
     * Unable to fully structure code
     */
    int getColGroupLevel(JSONObject col2GroupLevel, int row, int col, Point crossPoint) {
        if (row >= crossPoint.y) {
            row = crossPoint.y;
        }
        if ((js = col2GroupLevel.getJSONObject("col_" + col, null)) != null) ** GOTO lbl7
        return 0;
lbl-1000:
        // 1 sources

        {
            if ((ret = js.getInt("row_" + --row, -1)) < 0) continue;
            return ret;
lbl7:
            // 2 sources

            ** while (row >= 0)
        }
lbl8:
        // 1 sources

        return 0;
    }

    /*
     * Unable to fully structure code
     */
    int getRowGroupLevel(JSONObject row2GroupLevel, int row, int col, Point crossPoint) {
        if (col >= crossPoint.x) {
            col = crossPoint.x;
        }
        if ((js = row2GroupLevel.getJSONObject("row_" + row, null)) != null) ** GOTO lbl7
        return 0;
lbl-1000:
        // 1 sources

        {
            if ((ret = js.getInt("col_" + --col, -1)) < 0) continue;
            return ret;
lbl7:
            // 2 sources

            ** while (col >= 0)
        }
lbl8:
        // 1 sources

        return 0;
    }

    public Cell getRightCell(WorkSheet sheet, Cell cell) {
        int nextColIndex = !cell.isMerged() ? cell.getColumnIndex() + 1 : cell.getMergedRange().getEndCol() + 1;
        if (nextColIndex == sheet.getColumnCount()) {
            return null;
        }
        Cell nextCell = sheet.cells(cell.getRowIndex(), nextColIndex);
        if (nextCell.isMerged()) {
            if (nextCell != nextCell.mergedBy()) {
                return this.getRightCell(sheet, nextCell);
            }
            return nextCell;
        }
        return nextCell;
    }

    public Cell getDownCell(WorkSheet sheet, Cell cell) {
        int nextRowIndex = !cell.isMerged() ? cell.getRowIndex() + 1 : cell.getMergedRange().getEndRow() + 1;
        if (nextRowIndex == sheet.getRowCount()) {
            return null;
        }
        Cell nextCell = sheet.cells(nextRowIndex, cell.getColumnIndex());
        if (nextCell.isMerged()) {
            if (nextCell != nextCell.mergedBy()) {
                return this.getDownCell(sheet, nextCell);
            }
            return nextCell;
        }
        return nextCell;
    }

    private void colAppend(WorkSheet sheet, Cell cell, HashMap dbcolsPositionMap, TreeMap colGroupColsMap, DataStore dsCol, CellTagConfig ctc, HashMap colAppendMap, Point crossPoint, HashMap switchHandleMap) {
        Range r;
        ArrayList data = new ArrayList();
        ArrayList sdata = new ArrayList();
        int udt = dsCol.getColumnProperty(ctc.column).getUniformDataType();
        this.filterData(sheet, cell, dbcolsPositionMap, colGroupColsMap, dsCol, ctc, data, sdata);
        int rc = sheet.getRowCount();
        boolean needAddSwitchHandle = ctc.groupLevel < colGroupColsMap.keySet().size();
        int mr = 0;
        int mc = 0;
        boolean merged = cell.isMerged();
        Property prop = cell.getProperty();
        EditStyle es = cell.getEditStyle();
        if (merged) {
            Range r2 = cell.getMergedRange();
            mr = r2.getEndRow() - r2.getStartRow();
            mc = r2.getEndCol() - r2.getStartCol();
        }
        int startRow = cell.getRowIndex();
        int startCol = cell.getColumnIndex();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ctc", ctc);
        ArrayList<Cell> appendList = new ArrayList<Cell>();
        map.put("appendList", appendList);
        colAppendMap.put(cell, map);
        if (data.size() == 0) {
            String value = "--";
            cell.setValue((Object)value);
            cell.setTag((Object)"--");
            return;
        }
        if (startRow + mr + 1 < rc) {
            int i = 0;
            while (i <= mc) {
                Cell ncell = sheet.cells(startRow + mr + 1, startCol + i);
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                nmap.put("ctc", ctc);
                ArrayList nappendList = new ArrayList();
                nmap.put("appendList", nappendList);
                colAppendMap.put(ncell, nmap);
                ++i;
            }
        }
        ColumnPropertyManage CP = sheet.getColumnPropertyManage();
        Object value = data.get(0);
        cell.setCellValueType(udt);
        cell.setValue(value);
        if (needAddSwitchHandle) {
            SwitchHandle sh = this.ff.book.createSwitchHandle($crossSwitch);
            sh.setBounds(0, 0, 16, 16);
            cell.addBrick((Brick)sh);
            cell.setProperty("padding-left", (Object)new Integer(16));
            switchHandleMap.put(cell, ctc);
        }
        cell.setTag(sdata.get(0));
        int di = 1;
        while (di < data.size()) {
            int toStartCol = startCol + (mc + 1) * di;
            int toEndCol = startCol + (mc + 1) * (di + 1) - 1;
            sheet.insertMultiColumn(toStartCol, toEndCol);
            appendList.add(sheet.cells(startRow, toStartCol));
            int ci = toStartCol;
            while (ci <= toEndCol) {
                CP.setColumnWidth(ci, CP.getColumnWidth(startCol + ci - toStartCol));
                if (startRow + mr + 1 < rc) {
                    Cell tcell = sheet.cells(startRow + mr + 1, startCol + ci - toStartCol);
                    ((ArrayList)((HashMap)colAppendMap.get(tcell)).get("appendList")).add(sheet.cells(startRow + mr + 1, ci));
                }
                ++ci;
            }
            if (merged) {
                sheet.Merge(startRow, toStartCol, startRow + mr, toEndCol);
            }
            Cell tcell = sheet.cells(startRow, toStartCol);
            tcell.setCellValueType(udt);
            tcell.setValue(data.get(di));
            if (needAddSwitchHandle) {
                SwitchHandle tsh = this.ff.book.createSwitchHandle($crossSwitch);
                tsh.setBounds(0, 0, 16, 16);
                tcell.addBrick((Brick)tsh);
                tcell.setProperty("padding-left", (Object)new Integer(16));
                switchHandleMap.put(tcell, ctc);
            }
            tcell.setTag(sdata.get(di));
            tcell.setProperty(prop);
            tcell.setEditStyle(es);
            if (startRow + mr + 1 < rc) {
                this.cloneColumn(sheet, startRow + mr + 1, startCol, startCol + mc, toStartCol, toEndCol, crossPoint);
            }
            ++di;
        }
        int lastInsertedColIndex = startCol + (mc + 1) * data.size() - 1;
        int upRow = startRow - 1;
        Cell upCell = sheet.cells(upRow, startCol);
        if (startRow >= 0) {
            if (!upCell.isMerged()) {
                sheet.Merge(upRow, startCol, upRow, lastInsertedColIndex);
            } else {
                r = upCell.getMergedRange();
                if (r.getEndRow() != lastInsertedColIndex) {
                    sheet.Merge(r.getStartRow(), r.getStartCol(), r.getEndRow(), lastInsertedColIndex);
                }
            }
        }
        while (upRow > 0) {
            upRow = upCell.isMerged() ? upCell.getLeftTopCorner().getRowIndex() - 1 : --upRow;
            upCell = sheet.cells(upRow, startCol);
            if (!upCell.isMerged()) {
                sheet.Merge(upRow, startCol, upRow, lastInsertedColIndex);
                continue;
            }
            r = upCell.getMergedRange();
            if (r.getEndRow() == lastInsertedColIndex) continue;
            sheet.Merge(r.getStartRow(), r.getStartCol(), r.getEndRow(), lastInsertedColIndex);
        }
    }

    private void rowAppend(WorkSheet sheet, Cell cell, HashMap dbcolsPositionMap, TreeMap rowGroupColsMap, DataStore dsRow, CellTagConfig ctc, HashMap rowAppendMap, Point crossPoint, HashMap switchHandleMap) {
        Range r;
        TimeMark tm1 = new TimeMark(false);
        TimeMark tm = new TimeMark(false);
        int udt = dsRow.getColumnProperty(ctc.column).getUniformDataType();
        ArrayList data = new ArrayList();
        ArrayList sdata = new ArrayList();
        this.filterData(sheet, cell, dbcolsPositionMap, rowGroupColsMap, dsRow, ctc, data, sdata);
        int cc = sheet.getColumnCount();
        tm1.stamp("append row " + cell.getName() + "  filter data  cost");
        boolean needAddSwitchHandle = ctc.groupLevel < rowGroupColsMap.keySet().size();
        needAddSwitchHandle = false;
        int mr = 0;
        int mc = 0;
        boolean merged = cell.isMerged();
        Property prop = cell.getProperty();
        EditStyle es = cell.getEditStyle();
        if (merged) {
            Range r2 = cell.getMergedRange();
            mr = r2.getEndRow() - r2.getStartRow();
            mc = r2.getEndCol() - r2.getStartCol();
        }
        int startRow = cell.getRowIndex();
        int startCol = cell.getColumnIndex();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ctc", ctc);
        ArrayList<Cell> appendList = new ArrayList<Cell>();
        map.put("appendList", appendList);
        rowAppendMap.put(cell, map);
        if (data.size() == 0) {
            String value = "--";
            cell.setValue((Object)value);
            cell.setTag((Object)"--");
            return;
        }
        if (startCol + mc + 1 < cc) {
            int i = 0;
            while (i <= mr) {
                Cell ncell = sheet.cells(startRow + i, startCol + mc + 1);
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                nmap.put("ctc", ctc);
                ArrayList nappendList = new ArrayList();
                nmap.put("appendList", nappendList);
                rowAppendMap.put(ncell, nmap);
                ++i;
            }
        }
        RowPropertyManage RP = sheet.getRowPropertyManage();
        Object value = data.get(0);
        cell.setCellValueType(udt);
        cell.setValue(value);
        cell.setTag(sdata.get(0));
        if (needAddSwitchHandle) {
            SwitchHandle sh = this.ff.book.createSwitchHandle($crossSwitch);
            sh.setBounds(0, 0, 16, 16);
            cell.addBrick((Brick)sh);
            cell.setProperty("padding-left", (Object)new Integer(16));
            switchHandleMap.put(cell, ctc);
        }
        tm1.stamp("before  append");
        int di = 1;
        while (di < data.size()) {
            int toStartRow = startRow + (mr + 1) * di;
            int toEndRow = startRow + (mr + 1) * (di + 1) - 1;
            tm1.stamp("before  insert  Multi Row");
            sheet.insertMultiRow(toStartRow, toEndRow);
            tm1.stamp("after  insert  Multi Row");
            appendList.add(sheet.cells(toStartRow, startCol));
            int ci = toStartRow;
            while (ci <= toEndRow) {
                RP.setRowHeight(ci, RP.getRowHeight(startRow + ci - toStartRow));
                tm1.stamp("after  set Row  height ");
                if (startCol + mc + 1 < cc) {
                    Cell tcell = sheet.cells(startRow + ci - toStartRow, startCol + mc + 1);
                    ((ArrayList)((HashMap)rowAppendMap.get(tcell)).get("appendList")).add(sheet.cells(ci, startCol + mc + 1));
                }
                ++ci;
            }
            if (merged) {
                sheet.Merge(toStartRow, startCol, toEndRow, startCol + mc);
                tm1.stamp("after merge cell ");
            }
            Cell tcell = sheet.cells(toStartRow, startCol);
            tcell.setCellValueType(udt);
            tcell.setValue(data.get(di));
            tcell.setTag(sdata.get(di));
            tm1.stamp("after  set value and tag");
            if (needAddSwitchHandle) {
                SwitchHandle tsh = this.ff.book.createSwitchHandle($crossSwitch);
                tsh.setBounds(0, 0, 16, 16);
                tcell.addBrick((Brick)tsh);
                tcell.setProperty("padding-left", (Object)new Integer(16));
                switchHandleMap.put(tcell, ctc);
            }
            tcell.setProperty(prop);
            tm1.stamp("after set property");
            tcell.setEditStyle(es);
            tm1.stamp("after  set edit style");
            if (startCol + mc + 1 < cc) {
                this.cloneRow(sheet, startCol + mc + 1, startRow, startRow + mr, toStartRow, toEndRow, crossPoint);
                tm1.stamp("after  clone Row");
            }
            ++di;
        }
        tm1.stamp("after append");
        int lastInsertedRowIndex = startRow + (mr + 1) * data.size() - 1;
        int leftCol = startCol - 1;
        Cell leftCell = null;
        if (leftCol >= 0) {
            leftCell = sheet.cells(startRow, leftCol);
            if (!leftCell.isMerged()) {
                sheet.Merge(startRow, leftCol, lastInsertedRowIndex, leftCol);
            } else {
                r = leftCell.getMergedRange();
                if (r.getEndRow() != lastInsertedRowIndex) {
                    sheet.Merge(r.getStartRow(), r.getStartCol(), lastInsertedRowIndex, r.getEndCol());
                }
            }
        }
        tm1.stamp("check left col   merge  property  ");
        while (leftCol > 0) {
            leftCol = leftCell.isMerged() ? leftCell.getLeftTopCorner().getColumnIndex() - 1 : --leftCol;
            leftCell = sheet.cells(startRow, leftCol);
            if (!leftCell.isMerged()) {
                sheet.Merge(startRow, leftCol, lastInsertedRowIndex, leftCol);
                continue;
            }
            r = leftCell.getMergedRange();
            if (r.getEndRow() >= lastInsertedRowIndex) continue;
            sheet.UnMerge(r);
            sheet.Merge(r.getStartRow(), r.getStartCol(), lastInsertedRowIndex, r.getEndCol());
        }
        tm1.stamp(String.valueOf(cell.getName()) + "  append over");
        tm.stamp(String.valueOf(cell.getName()) + "  append over");
    }

    private void cloneRow(WorkSheet sheet, int startCol, int fromStartRow, int fromEndRow, int toStartRow, int toEndRow, Point crossPoint) {
        TimeMark tm1 = new TimeMark(false);
        tm1.stamp(" \u5f00\u59cbcloneRow");
        int rowOffset = toStartRow - fromStartRow;
        int cc = sheet.getColumnCount();
        int col = startCol;
        while (col < cc) {
            int row = fromStartRow;
            int toRow = toStartRow;
            while (row <= fromEndRow) {
                Cell sCell = sheet.cells(row, col);
                if (!sCell.isMerged() || sCell.mergedBy() == sCell) {
                    Cell dCell = sheet.cells(toRow, col);
                    sCell.redefine(0, 0);
                    String define = sCell.getDefine().trim();
                    dCell.setValue((Object)define);
                    tm1.stamp(String.valueOf(dCell.getName()) + " set Value " + define);
                    if (define.startsWith("=")) {
                        dCell.redefine(rowOffset, 0, crossPoint.y - 1, crossPoint.x - 1);
                        tm1.stamp(" redefine ");
                    }
                    dCell.setProperty(sCell.getProperty());
                    dCell.setEditStyle(sCell.getEditStyle());
                    if (sCell.isMerged()) {
                        Range r = sCell.getMergedRange();
                        int mr = r.getEndRow() - r.getStartRow();
                        int mc = r.getEndCol() - r.getStartCol();
                        sheet.Merge(toRow, col, toRow + mr, col + mc);
                        tm1.stamp("merte cell ");
                    }
                    dCell.setTag(sCell.getTag());
                    tm1.stamp(String.valueOf(dCell.getName()) + "    ok===============");
                }
                ++row;
                ++toRow;
            }
            ++col;
        }
        tm1.stamp(" cloneRow\u7ed3\u675f");
    }

    private void cloneColumn(WorkSheet sheet, int startRow, int fromStartCol, int fromEndCol, int toStartCol, int toEndCol, Point crossPoint) {
        int colOffset = toStartCol - fromStartCol;
        int rc = sheet.getRowCount();
        int row = startRow;
        while (row < rc) {
            int col = fromStartCol;
            int toCol = toStartCol;
            while (col <= fromEndCol) {
                Cell sCell = sheet.cells(row, col);
                if (!sCell.isMerged() || sCell.mergedBy() == sCell) {
                    Cell dCell = sheet.cells(row, toCol);
                    sCell.redefine(0, 0);
                    String define = sCell.getDefine().trim();
                    dCell.setValue((Object)define);
                    if (define.startsWith("=")) {
                        dCell.redefine(0, colOffset, crossPoint.y - 1, crossPoint.x - 1);
                    }
                    dCell.setProperty(sCell.getProperty());
                    dCell.setEditStyle(sCell.getEditStyle());
                    if (sCell.isMerged()) {
                        Range r = sCell.getMergedRange();
                        int mr = r.getEndRow() - r.getStartRow();
                        int mc = r.getEndCol() - r.getStartCol();
                        sheet.Merge(row, toCol, row + mr, toCol + mc);
                    }
                    dCell.setTag(sCell.getTag());
                }
                ++col;
                ++toCol;
            }
            ++row;
        }
    }

    private void filterData(WorkSheet sheet, Cell cell, HashMap dbcolsPositionMap, TreeMap colGroupColsMap, DataStore ds, CellTagConfig ctc, ArrayList ret, ArrayList sret) {
        if (ret == null) {
            ret = new ArrayList<Object>();
        }
        if (sret == null) {
            sret = new ArrayList<String>();
        }
        if (ctc.column.equals("")) {
            return;
        }
        int col = ctc.band.equals($Band_col) ? cell.getColumnIndex() : 0;
        int row = ctc.band.equals($Band_row) ? cell.getRowIndex() : 0;
        int rc = ds.getRowCount();
        String[] dbcols = new String[ctc.groupLevel];
        String[] pClassValue = new String[ctc.groupLevel];
        int gi = 1;
        while (gi < ctc.groupLevel) {
            String v;
            Cell tcell;
            String colName;
            dbcols[gi - 1] = colName = ((CellTagConfig)colGroupColsMap.get((Object)new Integer((int)gi))).column;
            if (ctc.band.equals($Band_col)) {
                row = (Integer)dbcolsPositionMap.get(colName);
            }
            if (ctc.band.equals($Band_row)) {
                col = (Integer)dbcolsPositionMap.get(colName);
            }
            if ((tcell = sheet.cells(row, col)).isMerged()) {
                tcell = tcell.getLeftTopCorner();
            }
            pClassValue[gi - 1] = v = tcell.getTag().toString();
            ++gi;
        }
        int i = 0;
        while (i < rc) {
            Object v;
            boolean ok = true;
            int gi2 = 1;
            while (gi2 < ctc.groupLevel) {
                String v2 = pClassValue[gi2 - 1];
                String v22 = ds.getString(i, dbcols[gi2 - 1]);
                if (!v2.equals(v22)) {
                    ok = false;
                    break;
                }
                ++gi2;
            }
            if (ok && ((v = ds.getValue(i, ctc.column)) != null || this.groupColAllowNullValue) && !ret.contains(v)) {
                ret.add(v);
                sret.add(this.getStringFromDS(ds, i, ctc.column));
            }
            ++i;
        }
    }

    boolean ObjectEqual(Object v1, Object v2) {
        Double d2;
        block10: {
            block9: {
                block8: {
                    try {
                        if (v1 != null || v2 == null) break block8;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (v1 == null || v2 != null) break block9;
                return false;
            }
            if (v1 != null || v2 != null) break block10;
            return true;
        }
        if (v1 instanceof String) {
            return ((String)v1).compareTo((String)v2) == 0;
        }
        if (v1 instanceof Date) {
            Date d22;
            Date d1 = (Date)ObjectTool.ChangeType((Object)v1, (String)"java.util.Date");
            return d1.compareTo(d22 = (Date)ObjectTool.ChangeType((Object)v2, (String)"java.util.Date")) == 0;
        }
        if (v1 instanceof Number) {
            double d23;
            double d1 = ((Number)v1).doubleValue();
            return d1 == (d23 = ((Number)v2).doubleValue());
        }
        Double d1 = (Double)ObjectTool.ChangeType((Object)v1, (String)"java.lang.Double");
        return d1.compareTo(d2 = (Double)ObjectTool.ChangeType((Object)v2, (String)"java.lang.Double")) == 0;
    }
}

