/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.flow.applet;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class CnToSpell {
    private static LinkedHashMap spellMap = null;

    static {
        if (spellMap == null) {
            spellMap = new LinkedHashMap(400);
        }
        CnToSpell.initialize();
    }

    private CnToSpell() {
    }

    private static void spellPut(String spell, int ascii) {
        spellMap.put(spell, new Integer(ascii));
    }

    private static void initialize() {
        CnToSpell.spellPut("a", -20319);
        CnToSpell.spellPut("ai", -20317);
        CnToSpell.spellPut("an", -20304);
        CnToSpell.spellPut("ang", -20295);
        CnToSpell.spellPut("ao", -20292);
        CnToSpell.spellPut("ba", -20283);
        CnToSpell.spellPut("bai", -20265);
        CnToSpell.spellPut("ban", -20257);
        CnToSpell.spellPut("bang", -20242);
        CnToSpell.spellPut("bao", -20230);
        CnToSpell.spellPut("bei", -20051);
        CnToSpell.spellPut("ben", -20036);
        CnToSpell.spellPut("beng", -20032);
        CnToSpell.spellPut("bi", -20026);
        CnToSpell.spellPut("bian", -20002);
        CnToSpell.spellPut("biao", -19990);
        CnToSpell.spellPut("bie", -19986);
        CnToSpell.spellPut("bin", -19982);
        CnToSpell.spellPut("bing", -19976);
        CnToSpell.spellPut("bo", -19805);
        CnToSpell.spellPut("bu", -19784);
        CnToSpell.spellPut("ca", -19775);
        CnToSpell.spellPut("cai", -19774);
        CnToSpell.spellPut("can", -19763);
        CnToSpell.spellPut("cang", -19756);
        CnToSpell.spellPut("cao", -19751);
        CnToSpell.spellPut("ce", -19746);
        CnToSpell.spellPut("ceng", -19741);
        CnToSpell.spellPut("cha", -19739);
        CnToSpell.spellPut("chai", -19728);
        CnToSpell.spellPut("chan", -19725);
        CnToSpell.spellPut("chang", -19715);
        CnToSpell.spellPut("chao", -19540);
        CnToSpell.spellPut("che", -19531);
        CnToSpell.spellPut("chen", -19525);
        CnToSpell.spellPut("cheng", -19515);
        CnToSpell.spellPut("chi", -19500);
        CnToSpell.spellPut("chong", -19484);
        CnToSpell.spellPut("chou", -19479);
        CnToSpell.spellPut("chu", -19467);
        CnToSpell.spellPut("chuai", -19289);
        CnToSpell.spellPut("chuan", -19288);
        CnToSpell.spellPut("chuang", -19281);
        CnToSpell.spellPut("chui", -19275);
        CnToSpell.spellPut("chun", -19270);
        CnToSpell.spellPut("chuo", -19263);
        CnToSpell.spellPut("ci", -19261);
        CnToSpell.spellPut("cong", -19249);
        CnToSpell.spellPut("cou", -19243);
        CnToSpell.spellPut("cu", -19242);
        CnToSpell.spellPut("cuan", -19238);
        CnToSpell.spellPut("cui", -19235);
        CnToSpell.spellPut("cun", -19227);
        CnToSpell.spellPut("cuo", -19224);
        CnToSpell.spellPut("da", -19218);
        CnToSpell.spellPut("dai", -19212);
        CnToSpell.spellPut("dan", -19038);
        CnToSpell.spellPut("dang", -19023);
        CnToSpell.spellPut("dao", -19018);
        CnToSpell.spellPut("de", -19006);
        CnToSpell.spellPut("deng", -19003);
        CnToSpell.spellPut("di", -18996);
        CnToSpell.spellPut("dian", -18977);
        CnToSpell.spellPut("diao", -18961);
        CnToSpell.spellPut("die", -18952);
        CnToSpell.spellPut("ding", -18783);
        CnToSpell.spellPut("diu", -18774);
        CnToSpell.spellPut("dong", -18773);
        CnToSpell.spellPut("dou", -18763);
        CnToSpell.spellPut("du", -18756);
        CnToSpell.spellPut("duan", -18741);
        CnToSpell.spellPut("dui", -18735);
        CnToSpell.spellPut("dun", -18731);
        CnToSpell.spellPut("duo", -18722);
        CnToSpell.spellPut("e", -18710);
        CnToSpell.spellPut("en", -18697);
        CnToSpell.spellPut("er", -18696);
        CnToSpell.spellPut("fa", -18526);
        CnToSpell.spellPut("fan", -18518);
        CnToSpell.spellPut("fang", -18501);
        CnToSpell.spellPut("fei", -18490);
        CnToSpell.spellPut("fen", -18478);
        CnToSpell.spellPut("feng", -18463);
        CnToSpell.spellPut("fo", -18448);
        CnToSpell.spellPut("fou", -18447);
        CnToSpell.spellPut("fu", -18446);
        CnToSpell.spellPut("ga", -18239);
        CnToSpell.spellPut("gai", -18237);
        CnToSpell.spellPut("gan", -18231);
        CnToSpell.spellPut("gang", -18220);
        CnToSpell.spellPut("gao", -18211);
        CnToSpell.spellPut("ge", -18201);
        CnToSpell.spellPut("gei", -18184);
        CnToSpell.spellPut("gen", -18183);
        CnToSpell.spellPut("geng", -18181);
        CnToSpell.spellPut("gong", -18012);
        CnToSpell.spellPut("gou", -17997);
        CnToSpell.spellPut("gu", -17988);
        CnToSpell.spellPut("gua", -17970);
        CnToSpell.spellPut("guai", -17964);
        CnToSpell.spellPut("guan", -17961);
        CnToSpell.spellPut("guang", -17950);
        CnToSpell.spellPut("gui", -17947);
        CnToSpell.spellPut("gun", -17931);
        CnToSpell.spellPut("guo", -17928);
        CnToSpell.spellPut("ha", -17922);
        CnToSpell.spellPut("hai", -17759);
        CnToSpell.spellPut("han", -17752);
        CnToSpell.spellPut("hang", -17733);
        CnToSpell.spellPut("hao", -17730);
        CnToSpell.spellPut("he", -17721);
        CnToSpell.spellPut("hei", -17703);
        CnToSpell.spellPut("hen", -17701);
        CnToSpell.spellPut("heng", -17697);
        CnToSpell.spellPut("hong", -17692);
        CnToSpell.spellPut("hou", -17683);
        CnToSpell.spellPut("hu", -17676);
        CnToSpell.spellPut("hua", -17496);
        CnToSpell.spellPut("huai", -17487);
        CnToSpell.spellPut("huan", -17482);
        CnToSpell.spellPut("huang", -17468);
        CnToSpell.spellPut("hui", -17454);
        CnToSpell.spellPut("hun", -17433);
        CnToSpell.spellPut("huo", -17427);
        CnToSpell.spellPut("ji", -17417);
        CnToSpell.spellPut("jia", -17202);
        CnToSpell.spellPut("jian", -17185);
        CnToSpell.spellPut("jiang", -16983);
        CnToSpell.spellPut("jiao", -16970);
        CnToSpell.spellPut("jie", -16942);
        CnToSpell.spellPut("jin", -16915);
        CnToSpell.spellPut("jing", -16733);
        CnToSpell.spellPut("jiong", -16708);
        CnToSpell.spellPut("jiu", -16706);
        CnToSpell.spellPut("ju", -16689);
        CnToSpell.spellPut("juan", -16664);
        CnToSpell.spellPut("jue", -16657);
        CnToSpell.spellPut("jun", -16647);
        CnToSpell.spellPut("ka", -16474);
        CnToSpell.spellPut("kai", -16470);
        CnToSpell.spellPut("kan", -16465);
        CnToSpell.spellPut("kang", -16459);
        CnToSpell.spellPut("kao", -16452);
        CnToSpell.spellPut("ke", -16448);
        CnToSpell.spellPut("ken", -16433);
        CnToSpell.spellPut("keng", -16429);
        CnToSpell.spellPut("kong", -16427);
        CnToSpell.spellPut("kou", -16423);
        CnToSpell.spellPut("ku", -16419);
        CnToSpell.spellPut("kua", -16412);
        CnToSpell.spellPut("kuai", -16407);
        CnToSpell.spellPut("kuan", -16403);
        CnToSpell.spellPut("kuang", -16401);
        CnToSpell.spellPut("kui", -16393);
        CnToSpell.spellPut("kun", -16220);
        CnToSpell.spellPut("kuo", -16216);
        CnToSpell.spellPut("la", -16212);
        CnToSpell.spellPut("lai", -16205);
        CnToSpell.spellPut("lan", -16202);
        CnToSpell.spellPut("lang", -16187);
        CnToSpell.spellPut("lao", -16180);
        CnToSpell.spellPut("le", -16171);
        CnToSpell.spellPut("lei", -16169);
        CnToSpell.spellPut("leng", -16158);
        CnToSpell.spellPut("li", -16155);
        CnToSpell.spellPut("lia", -15959);
        CnToSpell.spellPut("lian", -15958);
        CnToSpell.spellPut("liang", -15944);
        CnToSpell.spellPut("liao", -15933);
        CnToSpell.spellPut("lie", -15920);
        CnToSpell.spellPut("lin", -15915);
        CnToSpell.spellPut("ling", -15903);
        CnToSpell.spellPut("liu", -15889);
        CnToSpell.spellPut("long", -15878);
        CnToSpell.spellPut("lou", -15707);
        CnToSpell.spellPut("lu", -15701);
        CnToSpell.spellPut("lv", -15681);
        CnToSpell.spellPut("luan", -15667);
        CnToSpell.spellPut("lue", -15661);
        CnToSpell.spellPut("lun", -15659);
        CnToSpell.spellPut("luo", -15652);
        CnToSpell.spellPut("ma", -15640);
        CnToSpell.spellPut("mai", -15631);
        CnToSpell.spellPut("man", -15625);
        CnToSpell.spellPut("mang", -15454);
        CnToSpell.spellPut("mao", -15448);
        CnToSpell.spellPut("me", -15436);
        CnToSpell.spellPut("mei", -15435);
        CnToSpell.spellPut("men", -15419);
        CnToSpell.spellPut("meng", -15416);
        CnToSpell.spellPut("mi", -15408);
        CnToSpell.spellPut("mian", -15394);
        CnToSpell.spellPut("miao", -15385);
        CnToSpell.spellPut("mie", -15377);
        CnToSpell.spellPut("min", -15375);
        CnToSpell.spellPut("ming", -15369);
        CnToSpell.spellPut("miu", -15363);
        CnToSpell.spellPut("mo", -15362);
        CnToSpell.spellPut("mou", -15183);
        CnToSpell.spellPut("mu", -15180);
        CnToSpell.spellPut("na", -15165);
        CnToSpell.spellPut("nai", -15158);
        CnToSpell.spellPut("nan", -15153);
        CnToSpell.spellPut("nang", -15150);
        CnToSpell.spellPut("nao", -15149);
        CnToSpell.spellPut("ne", -15144);
        CnToSpell.spellPut("nei", -15143);
        CnToSpell.spellPut("nen", -15141);
        CnToSpell.spellPut("neng", -15140);
        CnToSpell.spellPut("ni", -15139);
        CnToSpell.spellPut("nian", -15128);
        CnToSpell.spellPut("niang", -15121);
        CnToSpell.spellPut("niao", -15119);
        CnToSpell.spellPut("nie", -15117);
        CnToSpell.spellPut("nin", -15110);
        CnToSpell.spellPut("ning", -15109);
        CnToSpell.spellPut("niu", -14941);
        CnToSpell.spellPut("nong", -14937);
        CnToSpell.spellPut("nu", -14933);
        CnToSpell.spellPut("nv", -14930);
        CnToSpell.spellPut("nuan", -14929);
        CnToSpell.spellPut("nue", -14928);
        CnToSpell.spellPut("nuo", -14926);
        CnToSpell.spellPut("o", -14922);
        CnToSpell.spellPut("ou", -14921);
        CnToSpell.spellPut("pa", -14914);
        CnToSpell.spellPut("pai", -14908);
        CnToSpell.spellPut("pan", -14902);
        CnToSpell.spellPut("pang", -14894);
        CnToSpell.spellPut("pao", -14889);
        CnToSpell.spellPut("pei", -14882);
        CnToSpell.spellPut("pen", -14873);
        CnToSpell.spellPut("peng", -14871);
        CnToSpell.spellPut("pi", -14857);
        CnToSpell.spellPut("pian", -14678);
        CnToSpell.spellPut("piao", -14674);
        CnToSpell.spellPut("pie", -14670);
        CnToSpell.spellPut("pin", -14668);
        CnToSpell.spellPut("ping", -14663);
        CnToSpell.spellPut("po", -14654);
        CnToSpell.spellPut("pu", -14645);
        CnToSpell.spellPut("qi", -14630);
        CnToSpell.spellPut("qia", -14594);
        CnToSpell.spellPut("qian", -14429);
        CnToSpell.spellPut("qiang", -14407);
        CnToSpell.spellPut("qiao", -14399);
        CnToSpell.spellPut("qie", -14384);
        CnToSpell.spellPut("qin", -14379);
        CnToSpell.spellPut("qing", -14368);
        CnToSpell.spellPut("qiong", -14355);
        CnToSpell.spellPut("qiu", -14353);
        CnToSpell.spellPut("qu", -14345);
        CnToSpell.spellPut("quan", -14170);
        CnToSpell.spellPut("que", -14159);
        CnToSpell.spellPut("qun", -14151);
        CnToSpell.spellPut("ran", -14149);
        CnToSpell.spellPut("rang", -14145);
        CnToSpell.spellPut("rao", -14140);
        CnToSpell.spellPut("re", -14137);
        CnToSpell.spellPut("ren", -14135);
        CnToSpell.spellPut("reng", -14125);
        CnToSpell.spellPut("ri", -14123);
        CnToSpell.spellPut("rong", -14122);
        CnToSpell.spellPut("rou", -14112);
        CnToSpell.spellPut("ru", -14109);
        CnToSpell.spellPut("ruan", -14099);
        CnToSpell.spellPut("rui", -14097);
        CnToSpell.spellPut("run", -14094);
        CnToSpell.spellPut("ruo", -14092);
        CnToSpell.spellPut("sa", -14090);
        CnToSpell.spellPut("sai", -14087);
        CnToSpell.spellPut("san", -14083);
        CnToSpell.spellPut("sang", -13917);
        CnToSpell.spellPut("sao", -13914);
        CnToSpell.spellPut("se", -13910);
        CnToSpell.spellPut("sen", -13907);
        CnToSpell.spellPut("seng", -13906);
        CnToSpell.spellPut("sha", -13905);
        CnToSpell.spellPut("shai", -13896);
        CnToSpell.spellPut("shan", -13894);
        CnToSpell.spellPut("shang", -13878);
        CnToSpell.spellPut("shao", -13870);
        CnToSpell.spellPut("she", -13859);
        CnToSpell.spellPut("shen", -13847);
        CnToSpell.spellPut("sheng", -13831);
        CnToSpell.spellPut("shi", -13658);
        CnToSpell.spellPut("shou", -13611);
        CnToSpell.spellPut("shu", -13601);
        CnToSpell.spellPut("shua", -13406);
        CnToSpell.spellPut("shuai", -13404);
        CnToSpell.spellPut("shuan", -13400);
        CnToSpell.spellPut("shuang", -13398);
        CnToSpell.spellPut("shui", -13395);
        CnToSpell.spellPut("shun", -13391);
        CnToSpell.spellPut("shuo", -13387);
        CnToSpell.spellPut("si", -13383);
        CnToSpell.spellPut("song", -13367);
        CnToSpell.spellPut("sou", -13359);
        CnToSpell.spellPut("su", -13356);
        CnToSpell.spellPut("suan", -13343);
        CnToSpell.spellPut("sui", -13340);
        CnToSpell.spellPut("sun", -13329);
        CnToSpell.spellPut("suo", -13326);
        CnToSpell.spellPut("ta", -13318);
        CnToSpell.spellPut("tai", -13147);
        CnToSpell.spellPut("tan", -13138);
        CnToSpell.spellPut("tang", -13120);
        CnToSpell.spellPut("tao", -13107);
        CnToSpell.spellPut("te", -13096);
        CnToSpell.spellPut("teng", -13095);
        CnToSpell.spellPut("ti", -13091);
        CnToSpell.spellPut("tian", -13076);
        CnToSpell.spellPut("tiao", -13068);
        CnToSpell.spellPut("tie", -13063);
        CnToSpell.spellPut("ting", -13060);
        CnToSpell.spellPut("tong", -12888);
        CnToSpell.spellPut("tou", -12875);
        CnToSpell.spellPut("tu", -12871);
        CnToSpell.spellPut("tuan", -12860);
        CnToSpell.spellPut("tui", -12858);
        CnToSpell.spellPut("tun", -12852);
        CnToSpell.spellPut("tuo", -12849);
        CnToSpell.spellPut("wa", -12838);
        CnToSpell.spellPut("wai", -12831);
        CnToSpell.spellPut("wan", -12829);
        CnToSpell.spellPut("wang", -12812);
        CnToSpell.spellPut("wei", -12802);
        CnToSpell.spellPut("wen", -12607);
        CnToSpell.spellPut("weng", -12597);
        CnToSpell.spellPut("wo", -12594);
        CnToSpell.spellPut("wu", -12585);
        CnToSpell.spellPut("xi", -12556);
        CnToSpell.spellPut("xia", -12359);
        CnToSpell.spellPut("xian", -12346);
        CnToSpell.spellPut("xiang", -12320);
        CnToSpell.spellPut("xiao", -12300);
        CnToSpell.spellPut("xie", -12120);
        CnToSpell.spellPut("xin", -12099);
        CnToSpell.spellPut("xing", -12089);
        CnToSpell.spellPut("xiong", -12074);
        CnToSpell.spellPut("xiu", -12067);
        CnToSpell.spellPut("xu", -12058);
        CnToSpell.spellPut("xuan", -12039);
        CnToSpell.spellPut("xue", -11867);
        CnToSpell.spellPut("xun", -11861);
        CnToSpell.spellPut("ya", -11847);
        CnToSpell.spellPut("yan", -11831);
        CnToSpell.spellPut("yang", -11798);
        CnToSpell.spellPut("yao", -11781);
        CnToSpell.spellPut("ye", -11604);
        CnToSpell.spellPut("yi", -11589);
        CnToSpell.spellPut("yin", -11536);
        CnToSpell.spellPut("ying", -11358);
        CnToSpell.spellPut("yo", -11340);
        CnToSpell.spellPut("yong", -11339);
        CnToSpell.spellPut("you", -11324);
        CnToSpell.spellPut("yu", -11303);
        CnToSpell.spellPut("yuan", -11097);
        CnToSpell.spellPut("yue", -11077);
        CnToSpell.spellPut("yun", -11067);
        CnToSpell.spellPut("za", -11055);
        CnToSpell.spellPut("zai", -11052);
        CnToSpell.spellPut("zan", -11045);
        CnToSpell.spellPut("zang", -11041);
        CnToSpell.spellPut("zao", -11038);
        CnToSpell.spellPut("ze", -11024);
        CnToSpell.spellPut("zei", -11020);
        CnToSpell.spellPut("zen", -11019);
        CnToSpell.spellPut("zeng", -11018);
        CnToSpell.spellPut("zha", -11014);
        CnToSpell.spellPut("zhai", -10838);
        CnToSpell.spellPut("zhan", -10832);
        CnToSpell.spellPut("zhang", -10815);
        CnToSpell.spellPut("zhao", -10800);
        CnToSpell.spellPut("zhe", -10790);
        CnToSpell.spellPut("zhen", -10780);
        CnToSpell.spellPut("zheng", -10764);
        CnToSpell.spellPut("zhi", -10587);
        CnToSpell.spellPut("zhong", -10544);
        CnToSpell.spellPut("zhou", -10533);
        CnToSpell.spellPut("zhu", -10519);
        CnToSpell.spellPut("zhua", -10331);
        CnToSpell.spellPut("zhuai", -10329);
        CnToSpell.spellPut("zhuan", -10328);
        CnToSpell.spellPut("zhuang", -10322);
        CnToSpell.spellPut("zhui", -10315);
        CnToSpell.spellPut("zhun", -10309);
        CnToSpell.spellPut("zhuo", -10307);
        CnToSpell.spellPut("zi", -10296);
        CnToSpell.spellPut("zong", -10281);
        CnToSpell.spellPut("zou", -10274);
        CnToSpell.spellPut("zu", -10270);
        CnToSpell.spellPut("zuan", -10262);
        CnToSpell.spellPut("zui", -10260);
        CnToSpell.spellPut("zun", -10256);
        CnToSpell.spellPut("zuo", -10254);
        CnToSpell.spellPut("zzz", -10249);
    }

    public static int getCnAscii(char cn) {
        byte[] bytes = String.valueOf(cn).getBytes();
        if (bytes == null || bytes.length > 2 || bytes.length <= 0) {
            return 0;
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        if (bytes.length == 2) {
            int hightByte = 256 + bytes[0];
            int lowByte = 256 + bytes[1];
            int ascii = 256 * hightByte + lowByte - 65536;
            return ascii;
        }
        return 0;
    }

    public static String getSpellByAscii(int ascii) {
        if (ascii > 0 && ascii < 160) {
            return String.valueOf((char)ascii);
        }
        if (ascii < -20319 || ascii > -10247) {
            return null;
        }
        Set keySet = spellMap.keySet();
        Iterator it = keySet.iterator();
        String spell0 = null;
        String spell = null;
        int asciiRang0 = -20319;
        while (it.hasNext()) {
            spell = (String)it.next();
            Object valObj = spellMap.get(spell);
            if (!(valObj instanceof Integer)) continue;
            int asciiRang = (Integer)valObj;
            if (ascii >= asciiRang0 && ascii < asciiRang) {
                return spell0 == null ? spell : spell0;
            }
            spell0 = spell;
            asciiRang0 = asciiRang;
        }
        return null;
    }

    public static String getFullSpell(String cnStr) {
        if (cnStr == null || "".equals(cnStr.trim())) {
            return cnStr;
        }
        char[] chars = cnStr.toCharArray();
        StringBuffer retuBuf = new StringBuffer();
        int i = 0;
        int Len = chars.length;
        while (i < Len) {
            int ascii = CnToSpell.getCnAscii(chars[i]);
            if (ascii == 0) {
                retuBuf.append(chars[i]);
            } else {
                String spell = CnToSpell.getSpellByAscii(ascii);
                if (spell == null) {
                    retuBuf.append(chars[i]);
                } else {
                    retuBuf.append(spell);
                }
            }
            ++i;
        }
        return retuBuf.toString();
    }

    public static String getFirstSpell(String cnStr) {
        if (cnStr == null || "".equals(cnStr.trim())) {
            return cnStr;
        }
        char[] chars = cnStr.toCharArray();
        StringBuffer retuBuf = new StringBuffer();
        int i = 0;
        int Len = chars.length;
        while (i < Len) {
            int ascii = CnToSpell.getCnAscii(chars[i]);
            if (ascii == 0) {
                retuBuf.append(chars[i]);
            } else {
                String spell = CnToSpell.getSpellByAscii(ascii);
                if (spell == null) {
                    retuBuf.append(chars[i]);
                } else {
                    retuBuf.append(spell.substring(0, 1));
                }
            }
            ++i;
        }
        return retuBuf.toString();
    }

    public static void main(String[] args) {
        String str = null;
        str = "\u505a";
        System.out.println("Spell=" + CnToSpell.getFirstSpell("\u7459"));
        System.out.println("Spell=" + CnToSpell.getFullSpell(str));
        System.out.println("Spell=" + CnToSpell.getFirstSpell(str));
        str = "\u5f20\u7259\u821e\u722a\u300b\u3002\uff0c";
        System.out.println("Spell=" + CnToSpell.getFullSpell(str));
        str = "\u53ef\u803b\u4e0b\u573a\u3002";
        System.out.println("Spell=" + CnToSpell.getFullSpell(str));
        str = "\u732a\u6cb9\uff0c\u732a\u516b\u6212\u3002";
        System.out.println("Spell=" + CnToSpell.getFullSpell(str));
    }
}

