/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringConverter {
    public static final String COLUMN_NAME = "@STRINGCONVERTER";
    private String dateFormat;
    private SimpleDateFormat simpleTimeFormat;
    private String timeFormat;
    private GregorianCalendar calendar;
    private Pattern timestampPattern;
    private SimpleDateFormat timestampFormat;
    private SimpleDateFormat simpleDateFormat;
    private static Map<String, Class<?>> forSQLNameMap = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = -3037117163532338893L;
        {
            this.put("string", String.class);
            this.put("boolean", Boolean.class);
            this.put("byte", Byte.class);
            this.put("short", Short.class);
            this.put("int", Integer.class);
            this.put("integer", Integer.class);
            this.put("long", Long.class);
            this.put("float", Float.class);
            this.put("double", Double.class);
            this.put("bigdecimal", BigDecimal.class);
            this.put("date", Date.class);
            this.put("time", Time.class);
            this.put("timestamp", Timestamp.class);
            this.put("asciistream", InputStream.class);
        }
    };

    public StringConverter(String string, String string2, String string3, String string4) {
        this.init(string, string2, string3, string4, null);
    }

    public StringConverter(String string, String string2, String string3, String string4, Locale locale) {
        this.init(string, string2, string3, string4, locale);
    }

    private void init(String string, String string2, String string3, String string4, Locale locale) {
        Object object;
        this.dateFormat = string;
        if (string != null) {
            object = string.toUpperCase();
            boolean bl = false;
            if (((String)object).contains("MMM")) {
                bl = true;
            } else {
                for (int i = 0; i < ((String)object).length(); ++i) {
                    char c = ((String)object).charAt(i);
                    if (!Character.isLetter(c) || c == 'D' || c == 'M' || c == 'Y') continue;
                    bl = true;
                }
            }
            if (bl) {
                if (locale != null) {
                    DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
                    this.simpleDateFormat = new SimpleDateFormat(string, dateFormatSymbols);
                } else {
                    this.simpleDateFormat = new SimpleDateFormat(string);
                }
            }
        }
        this.timeFormat = string2;
        if (locale != null) {
            object = DateFormatSymbols.getInstance(locale);
            this.simpleTimeFormat = new SimpleDateFormat(string2, (DateFormatSymbols)object);
        } else {
            this.simpleTimeFormat = new SimpleDateFormat(string2);
        }
        object = TimeZone.getTimeZone(string4);
        this.calendar = new GregorianCalendar();
        this.calendar.clear();
        this.calendar.setTimeZone((TimeZone)object);
        if (string3 != null && string3.length() > 0) {
            if (locale != null) {
                DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
                this.timestampFormat = new SimpleDateFormat(string3, dateFormatSymbols);
            } else {
                this.timestampFormat = new SimpleDateFormat(string3);
            }
            this.timestampFormat.setTimeZone((TimeZone)object);
        } else {
            this.timestampPattern = Pattern.compile("([0-9][0-9][0-9][0-9])-([0-9]?[0-9])-([0-9]?[0-9])[ T]([0-9]?[0-9]):([0-9]?[0-9]):([0-9]?[0-9]).*");
        }
    }

    public String parseString(String string) {
        return string;
    }

    public Boolean parseBoolean(String string) {
        boolean bl = string != null && string.equals("1") ? true : (string != null && string.equals("0") ? false : Boolean.valueOf(string));
        return bl;
    }

    public Byte parseByte(String string) {
        try {
            Byte by = string == null || string.length() == 0 ? null : Byte.valueOf(Byte.parseByte(string));
            return by;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Short parseShort(String string) {
        try {
            Short s = string == null || string.length() == 0 ? null : Short.valueOf(Short.parseShort(string));
            return s;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Integer parseInt(String string) {
        try {
            Integer n = string == null || string.length() == 0 ? null : Integer.valueOf(Integer.parseInt(string));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Long parseLong(String string) {
        try {
            Long l = string == null || string.length() == 0 ? null : Long.valueOf(Long.parseLong(string));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Float parseFloat(String string) {
        try {
            Float f;
            if (string == null || string.length() == 0) {
                f = null;
            } else {
                string = string.replace(",", ".");
                f = Float.valueOf(Float.parseFloat(string));
            }
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Double parseDouble(String string) {
        try {
            Double d;
            if (string == null || string.length() == 0) {
                d = null;
            } else {
                string = string.replace(",", ".");
                d = Double.parseDouble(string);
            }
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public byte[] parseBytes(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            return byArray;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public BigDecimal parseBigDecimal(String string) {
        try {
            BigDecimal bigDecimal = string == null || string.length() == 0 ? null : new BigDecimal(string);
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private String makeISODate(String string, String string2) {
        Pattern pattern;
        string2 = string2.toLowerCase();
        int n = string2.indexOf(100);
        int n2 = string2.indexOf(109);
        int n3 = string2.indexOf(121);
        int n4 = 1;
        int n5 = 1;
        int n6 = 1;
        if (n > n2) {
            ++n4;
        } else {
            ++n5;
        }
        if (n > n3) {
            ++n4;
        } else {
            ++n6;
        }
        if (n2 > n3) {
            ++n5;
        } else {
            ++n6;
        }
        Pattern pattern2 = Pattern.compile("d+");
        Matcher matcher = pattern2.matcher(string2);
        if (matcher.find()) {
            string2 = string2.replace(matcher.group(), "([0-9]{" + (matcher.end() - matcher.start()) + ",2})");
        }
        if ((matcher = (pattern2 = Pattern.compile("m+")).matcher(string2)).find()) {
            string2 = string2.replace(matcher.group(), "([0-9]{" + (matcher.end() - matcher.start()) + ",2})");
        }
        if ((matcher = (pattern2 = Pattern.compile("y+")).matcher(string2)).find()) {
            string2 = string2.replace(matcher.group(), "([0-9]{" + (matcher.end() - matcher.start()) + ",4})");
        }
        if ((matcher = (pattern = Pattern.compile(string2 = string2 + ".*")).matcher(string)).matches()) {
            String string3;
            String string4 = matcher.group(n6);
            String string5 = matcher.group(n5);
            if (string5.length() < 2) {
                string5 = "0" + string5;
            }
            if ((string3 = matcher.group(n4)).length() < 2) {
                string3 = "0" + string3;
            }
            String string6 = string4 + "-" + string5 + "-" + string3;
            return string6;
        }
        return null;
    }

    public Date parseDate(String string) {
        try {
            Date date = null;
            if (string != null && string.length() > 0) {
                if (this.simpleDateFormat != null) {
                    java.util.Date date2 = this.simpleDateFormat.parse(string);
                    long l = date2.getTime();
                    date = new Date(l);
                    return date;
                }
                String string2 = this.makeISODate(string, this.dateFormat);
                if (string2 != null) {
                    date = Date.valueOf(string2);
                }
            }
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public Time parseTime(String string) {
        try {
            Time time = null;
            if (string != null && string.length() > 0) {
                string = string.trim();
                while (string.length() < this.timeFormat.length()) {
                    string = "0" + string;
                }
                java.util.Date date = this.simpleTimeFormat.parse(string);
                long l = date.getTime();
                time = new Time(l);
            }
            return time;
        }
        catch (ParseException parseException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public Timestamp parseTimestamp(String string) {
        Timestamp timestamp = null;
        try {
            if (string != null && string.length() > 0) {
                if (this.timestampFormat != null) {
                    java.util.Date date = this.timestampFormat.parse(string);
                    timestamp = new Timestamp(date.getTime());
                } else {
                    Matcher matcher = this.timestampPattern.matcher(string);
                    if (matcher.matches()) {
                        int n = Integer.parseInt(matcher.group(1));
                        int n2 = Integer.parseInt(matcher.group(2)) - 1;
                        int n3 = Integer.parseInt(matcher.group(3));
                        int n4 = Integer.parseInt(matcher.group(4));
                        int n5 = Integer.parseInt(matcher.group(5));
                        int n6 = Integer.parseInt(matcher.group(6));
                        this.calendar.set(n, n2, n3, n4, n5, n6);
                        timestamp = new Timestamp(this.calendar.getTimeInMillis());
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return timestamp;
    }

    public InputStream parseAsciiStream(String string) {
        return string == null ? null : new ByteArrayInputStream(string.getBytes());
    }

    public Object convert(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string.equalsIgnoreCase("string")) {
            return string2;
        }
        if (string.equalsIgnoreCase("boolean")) {
            return this.parseBoolean(string2);
        }
        if (string.equalsIgnoreCase("byte")) {
            return this.parseByte(string2);
        }
        if (string.equalsIgnoreCase("short")) {
            return this.parseShort(string2);
        }
        if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
            return this.parseInt(string2);
        }
        if (string.equalsIgnoreCase("long")) {
            return this.parseLong(string2);
        }
        if (string.equalsIgnoreCase("float")) {
            return this.parseFloat(string2);
        }
        if (string.equalsIgnoreCase("double")) {
            return this.parseDouble(string2);
        }
        if (string.equalsIgnoreCase("bigdecimal")) {
            return this.parseBigDecimal(string2);
        }
        if (string.equalsIgnoreCase("date")) {
            return this.parseDate(string2);
        }
        if (string.equalsIgnoreCase("time")) {
            return this.parseTime(string2);
        }
        if (string.equalsIgnoreCase("timestamp")) {
            return this.parseTimestamp(string2);
        }
        if (string.equalsIgnoreCase("asciistream")) {
            return this.parseAsciiStream(string2);
        }
        return string2;
    }

    public Class<?> forSQLName(String string) {
        string = string.toLowerCase();
        return forSQLNameMap.get(string);
    }

    public static Object getLiteralForTypeName(String string) {
        Object object = null;
        if ((string = string.toLowerCase()).equals("string")) {
            object = "";
        } else if (string.equals("boolean")) {
            object = Boolean.FALSE;
        } else if (string.equals("byte")) {
            object = (byte)1;
        } else if (string.equals("short")) {
            object = (short)1;
        } else if (string.equals("int") || string.equals("integer")) {
            object = 1;
        } else if (string.equals("long")) {
            object = 1L;
        } else if (string.equals("float")) {
            object = Float.valueOf(1.0f);
        } else if (string.equals("double")) {
            object = 1.0;
        } else if (string.equals("bigdecimal")) {
            object = BigDecimal.valueOf(1L);
        } else if (string.equals("date")) {
            object = Date.valueOf("1970-01-01");
        } else if (string.equals("time")) {
            object = Time.valueOf("00:00:00");
        } else if (string.equals("timestamp")) {
            object = Timestamp.valueOf("1970-01-01 00:00:00");
        } else if (string.equals("asciistream")) {
            object = new ByteArrayInputStream(new byte[0]);
        }
        return object;
    }

    public static String getTypeNameForLiteral(Object object) {
        String string = null;
        if (object instanceof String) {
            string = "String";
        } else if (object instanceof Boolean) {
            string = "Boolean";
        } else if (object instanceof Byte) {
            string = "Byte";
        } else if (object instanceof Short) {
            string = "Short";
        } else if (object instanceof Integer) {
            string = "Int";
        } else if (object instanceof Long) {
            string = "Long";
        } else if (object instanceof Float) {
            string = "Float";
        } else if (object instanceof Double) {
            string = "Double";
        } else if (object instanceof BigDecimal) {
            string = "BigDecimal";
        } else if (object instanceof Date) {
            string = "Date";
        } else if (object instanceof Time) {
            string = "Time";
        } else if (object instanceof Timestamp) {
            string = "Timestamp";
        } else if (object instanceof InputStream) {
            string = "AsciiStream";
        }
        return string;
    }

    public static List<Object[]> getTypeInfo() {
        Integer n = 0;
        Short s = 0;
        Short s2 = Short.MAX_VALUE;
        Short s3 = 3;
        Short s4 = 1;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"String", 12, s2, "'", "'", null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Boolean", 16, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Byte", -6, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Short", 5, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Integer", 4, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Long", -5, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Float", 6, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Double", 8, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"BigDecimal", 3, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Date", 91, s2, "'", "'", null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Time", 92, s2, "'", "'", null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Timestamp", 93, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        arrayList.add(new Object[]{"Asciistream", 2005, s2, null, null, null, s4, Boolean.TRUE, s3, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, null, s, s2, n, n, n});
        return arrayList;
    }

    public static String removeQuotes(String string) {
        return string.replace("\"", "");
    }
}

