/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLRoundFunction
extends Expression {
    Expression expression;

    public SQLRoundFunction(Expression expression) {
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object = this.expression.eval(map);
        if (object != null) {
            if (!(object instanceof Number)) {
                try {
                    object = new Double(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    object = null;
                }
            }
            if (object != null) {
                if (object instanceof Short) {
                    object = new Integer(((Short)object).intValue());
                } else if (!(object instanceof Integer) && !(object instanceof Long)) {
                    double d = ((Number)object).doubleValue();
                    object = d < -2.147483648E9 || d > 2.147483647E9 ? (Number)new Double(Math.round(d)) : (Number)new Integer((int)Math.round(d));
                }
            }
        }
        return object;
    }

    public String toString() {
        return "ROUND(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.expression.aggregateFunctions());
        return linkedList;
    }
}

