/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.Expression;

class SQLCoalesceFunction
extends Expression {
    List<Expression> expressions;

    public SQLCoalesceFunction(List<Expression> list) {
        this.expressions = list;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Object object = null;
        Iterator<Expression> iterator = this.expressions.iterator();
        while (object == null && iterator.hasNext()) {
            Expression expression = iterator.next();
            object = expression.eval(map);
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("COALESCE(");
        String string = "";
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(iterator.next().toString());
            string = ",";
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().usedColumns(set));
        }
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        Iterator<Expression> iterator = this.expressions.iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(iterator.next().aggregateFunctions());
        }
        return linkedList;
    }
}

