/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.ColumnName;
import org.relique.jdbc.csv.Expression;
import org.relique.jdbc.csv.StringConverter;

class SQLCalendarFunction
extends Expression {
    String functionName;
    int calendarField;
    Expression expression;

    public SQLCalendarFunction(String string, int n, Expression expression) {
        this.functionName = string;
        this.calendarField = n;
        this.expression = expression;
    }

    @Override
    public Object eval(Map<String, Object> map) throws SQLException {
        Integer n = null;
        Object object = this.expression.eval(map);
        if (object != null) {
            Object object2;
            Date date = null;
            if (object instanceof Date) {
                date = (Date)object;
            } else {
                object2 = new ColumnName("@STRINGCONVERTER");
                StringConverter stringConverter = (StringConverter)((Expression)object2).eval(map);
                date = stringConverter.parseTimestamp(object.toString());
                if (date == null) {
                    date = this.calendarField == 5 || this.calendarField == 2 || this.calendarField == 1 ? stringConverter.parseDate(object.toString()) : stringConverter.parseTime(object.toString());
                }
            }
            if (date != null) {
                object2 = Calendar.getInstance();
                ((Calendar)object2).setTime(date);
                int n2 = ((Calendar)object2).get(this.calendarField);
                if (this.calendarField == 2) {
                    ++n2;
                }
                n = n2;
            }
        }
        return n;
    }

    public String toString() {
        return this.functionName + "(" + this.expression + ")";
    }

    @Override
    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.addAll(this.expression.usedColumns(set));
        return linkedList;
    }

    @Override
    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        linkedList.addAll(this.expression.aggregateFunctions());
        return linkedList;
    }
}

