/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.relique.jdbc.csv.AggregateFunction;
import org.relique.jdbc.csv.JoinType;
import org.relique.jdbc.csv.ParsedExpression;
import org.relique.jdbc.csv.ParsedTable;
import org.relique.jdbc.csv.QueryEnvEntry;

class ParsedStatement {
    List<ParsedExpression> queryEntries;
    boolean isDistinct;
    List<ParsedTable> tableEntries;
    ParsedExpression whereClause;
    List<ParsedExpression> groupByEntries;
    ParsedExpression havingClause;
    List<ParsedExpression> orderByEntries;
    int limit;
    int offset;

    public ParsedStatement(List<ParsedExpression> list, boolean bl, List<ParsedTable> list2, ParsedExpression parsedExpression, List<ParsedExpression> list3, ParsedExpression parsedExpression2, List<ParsedExpression> list4, int n, int n2) {
        this.queryEntries = list;
        this.isDistinct = bl;
        this.tableEntries = list2;
        this.whereClause = parsedExpression;
        this.groupByEntries = list3;
        this.havingClause = parsedExpression2;
        this.orderByEntries = list4;
        this.limit = n;
        this.offset = n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT");
        if (this.isDistinct) {
            stringBuilder.append(" DISTINCT");
        }
        String string = " ";
        for (ParsedExpression iterator : this.queryEntries) {
            stringBuilder.append(string);
            string = ", ";
            QueryEnvEntry queryEnvEntry = (QueryEnvEntry)iterator.content;
            stringBuilder.append(queryEnvEntry.expression.toString());
        }
        if (this.tableEntries != null) {
            int n = 0;
            for (ParsedTable parsedTable : this.tableEntries) {
                Object object;
                if (n == 0) {
                    stringBuilder.append(" FROM");
                } else {
                    object = parsedTable.getJoinType();
                    if (object == JoinType.CROSS) {
                        stringBuilder.append(" CROSS JOIN");
                    } else if (object == JoinType.INNER) {
                        stringBuilder.append(" INNER JOIN");
                    } else if (object == JoinType.LEFT_OUTER) {
                        stringBuilder.append(" LEFT OUTER JOIN");
                    } else if (object == JoinType.RIGHT_OUTER) {
                        stringBuilder.append(" RIGHT OUTER JOIN");
                    } else if (object == JoinType.FULL_OUTER) {
                        stringBuilder.append(" FULL OUTER JOIN");
                    }
                }
                stringBuilder.append(" ");
                stringBuilder.append(parsedTable.getTableName());
                object = parsedTable.getTableAlias();
                if (object != null) {
                    stringBuilder.append(" ");
                    stringBuilder.append((String)object);
                }
                if (n > 0 && parsedTable.getJoinType() != JoinType.CROSS) {
                    stringBuilder.append(" ON ");
                    stringBuilder.append(parsedTable.getJoinClause().toString());
                }
                ++n;
            }
            if (this.whereClause != null) {
                stringBuilder.append(" WHERE ").append(this.whereClause.toString());
            }
            if (this.groupByEntries != null && this.groupByEntries.size() > 0) {
                stringBuilder.append(" GROUP BY");
                string = " ";
                for (ParsedExpression parsedExpression : this.groupByEntries) {
                    stringBuilder.append(string);
                    string = ", ";
                    stringBuilder.append(parsedExpression.toString());
                }
                if (this.havingClause != null) {
                    stringBuilder.append(" HAVING ");
                    stringBuilder.append(this.havingClause.toString());
                }
            }
            if (this.orderByEntries != null && this.orderByEntries.size() > 0) {
                stringBuilder.append(" ORDER BY");
                string = " ";
                for (ParsedExpression parsedExpression : this.orderByEntries) {
                    stringBuilder.append(string);
                    string = ", ";
                    stringBuilder.append(parsedExpression.toString());
                }
            }
        }
        if (this.limit >= 0) {
            stringBuilder.append(" LIMIT ").append(this.limit);
        }
        if (this.offset > 0) {
            stringBuilder.append(" OFFSET ").append(this.offset);
        }
        return stringBuilder.toString();
    }

    public List<String> usedColumns(Set<String> set) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.queryEntries != null) {
            for (ParsedExpression parsedExpression : this.queryEntries) {
                QueryEnvEntry queryEnvEntry = (QueryEnvEntry)parsedExpression.content;
                List<String> list = queryEnvEntry.expression.usedColumns(set);
                linkedList.addAll(list);
            }
        }
        if (this.whereClause != null) {
            linkedList.addAll(this.whereClause.usedColumns(set));
        }
        if (this.groupByEntries != null) {
            for (ParsedExpression parsedExpression : this.groupByEntries) {
                linkedList.addAll(parsedExpression.usedColumns(set));
            }
        }
        if (this.havingClause != null) {
            linkedList.addAll(this.havingClause.usedColumns(set));
        }
        if (this.orderByEntries != null) {
            for (ParsedExpression parsedExpression : this.orderByEntries) {
                linkedList.addAll(parsedExpression.usedColumns(set));
            }
        }
        return linkedList;
    }

    public List<AggregateFunction> aggregateFunctions() {
        LinkedList<AggregateFunction> linkedList = new LinkedList<AggregateFunction>();
        if (this.queryEntries != null) {
            for (ParsedExpression parsedExpression : this.queryEntries) {
                QueryEnvEntry queryEnvEntry = (QueryEnvEntry)parsedExpression.content;
                List<AggregateFunction> list = queryEnvEntry.expression.aggregateFunctions();
                linkedList.addAll(list);
            }
        }
        if (this.whereClause != null) {
            linkedList.addAll(this.whereClause.aggregateFunctions());
        }
        if (this.groupByEntries != null) {
            for (ParsedExpression parsedExpression : this.groupByEntries) {
                linkedList.addAll(parsedExpression.aggregateFunctions());
            }
        }
        if (this.havingClause != null) {
            linkedList.addAll(this.havingClause.aggregateFunctions());
        }
        if (this.orderByEntries != null) {
            for (ParsedExpression parsedExpression : this.orderByEntries) {
                linkedList.addAll(parsedExpression.aggregateFunctions());
            }
        }
        return linkedList;
    }
}

