/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.relique.io.CryptoFilter;
import org.relique.io.DataReader;
import org.relique.io.EncryptedFileInputStream;
import org.relique.io.FileSetInputStream;
import org.relique.io.ListDataReader;
import org.relique.io.TableReader;
import org.relique.jdbc.csv.CsvConnection;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvRawReader;
import org.relique.jdbc.csv.CsvReader;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvResultSet;
import org.relique.jdbc.csv.MultipleSqlParser;
import org.relique.jdbc.csv.SqlParser;
import org.relique.jdbc.dbf.DbfReader;

public class CsvStatement
implements Statement {
    public static final String STATEMENT_COLUMN_NAME = "@STATEMENT";
    private CsvConnection connection;
    protected ResultSet lastResultSet = null;
    protected List<SqlParser> multipleParsers = null;
    private int maxRows = 0;
    private int fetchSize = 1;
    private int queryTimeout = Integer.MAX_VALUE;
    private int fetchDirection = 1000;
    private boolean closed;
    protected int resultSetType = 1004;

    protected CsvStatement(CsvConnection csvConnection, int n) {
        CsvDriver.writeLog("CsvStatement() - connection=" + csvConnection);
        CsvDriver.writeLog("CsvStatement() - Asked for " + (n == 1005 ? "Scrollable" : "Not Scrollable"));
        this.connection = csvConnection;
        this.resultSetType = n;
    }

    protected void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(CsvResources.getString("statementClosed"));
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setMaxFieldSize(int)");
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        this.checkOpen();
        this.maxRows = n;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setEscapeProcessing(boolean)");
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": setCursorName(String)");
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.checkOpen();
        if (n != 1000 && n != 1001 && n != 1002) {
            throw new SQLException(CsvResources.getString("unsupportedDirection") + ": " + n);
        }
        this.fetchDirection = n;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this.checkOpen();
        this.fetchSize = n;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": getMaxFieldSize()");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkOpen();
        return this.maxRows;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkOpen();
        return this.queryTimeout;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkOpen();
        return this.lastResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkOpen();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMoreResults() throws SQLException {
        boolean bl;
        this.checkOpen();
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
        }
        if (this.multipleParsers != null && this.multipleParsers.size() > 0) {
            this.lastResultSet = this.executeParsedQuery(this.multipleParsers.remove(0));
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkOpen();
        return this.resultSetType;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkOpen();
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkOpen();
        CsvDriver.writeLog("CsvStatement:executeQuery() - sql= " + string);
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
            this.multipleParsers = null;
        }
        SqlParser sqlParser = new SqlParser();
        try {
            sqlParser.parse(string);
        }
        catch (Exception exception) {
            throw new SQLException(CsvResources.getString("syntaxError") + ": " + exception.getMessage());
        }
        return this.executeParsedQuery(sqlParser);
    }

    protected ResultSet executeParsedQuery(SqlParser sqlParser) throws SQLException {
        ResultSet resultSet;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.lastResultSet = resultSet = this.executeParsedQuery(sqlParser, hashMap);
        return resultSet;
    }

    protected ResultSet executeParsedQuery(SqlParser sqlParser, Map<String, Object> map) throws SQLException {
        Object object;
        Object object2;
        if (sqlParser.getTableNames().size() > 1) {
            throw new SQLException(CsvResources.getString("joinNotSupported"));
        }
        String string = null;
        if (sqlParser.getTableNames().size() > 0) {
            string = sqlParser.getTableNames().get(0);
        }
        String string2 = null;
        if (sqlParser.getTableAliases().size() > 0) {
            string2 = sqlParser.getTableAliases().get(0);
        }
        String string3 = this.connection.getPath();
        TableReader tableReader = this.connection.getTableReader();
        if (string3 != null) {
            CsvDriver.writeLog("Connection Path: " + string3);
        } else {
            CsvDriver.writeLog("Connection TableReader: " + tableReader.getClass().getName());
        }
        CsvDriver.writeLog("Parser Table Name: " + string);
        CsvDriver.writeLog("Connection Extension: " + this.connection.getExtension());
        DataReader dataReader = null;
        String string4 = null;
        if (string == null) {
            object2 = new String[]{};
            object = new String[]{};
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            arrayList.add(new Object[0]);
            dataReader = new ListDataReader((String[])object2, (String[])object, (List<Object[]>)arrayList);
        } else {
            if (string3 != null && !this.connection.isIndexedFiles()) {
                string4 = string3 + string + this.connection.getExtension();
                CsvDriver.writeLog("CSV file name: " + string4);
                object2 = new File(string4);
                if (!((File)object2).exists()) {
                    throw new SQLException(CsvResources.getString("fileNotFound") + ": " + string4);
                }
                if (!((File)object2).canRead()) {
                    throw new SQLException(CsvResources.getString("fileNotReadable") + ": " + string4);
                }
            }
            try {
                if (this.connection.getExtension().equalsIgnoreCase(".dbf")) {
                    dataReader = new DbfReader(string4, string, string2, this.connection.getCharset());
                } else {
                    Object object3;
                    if (tableReader == null) {
                        object3 = this.connection.getDecryptingCodec();
                        if (this.connection.isIndexedFiles()) {
                            String string5 = string + this.connection.getFileNamePattern() + this.connection.getExtension();
                            String[] stringArray = this.connection.getNameParts();
                            String string6 = this.connection.getPath();
                            object = new FileSetInputStream(string6, string5, stringArray, this.connection.getSeparator(), this.connection.isFileTailPrepend(), this.connection.isSuppressHeaders(), (CryptoFilter)object3, this.connection.getSkipLeadingDataLines() + this.connection.getTransposedLines());
                        } else if (object3 == null) {
                            object = new FileInputStream(string4);
                        } else {
                            object3.reset();
                            object = new EncryptedFileInputStream(string4, (CryptoFilter)object3);
                        }
                        object2 = this.connection.getCharset() != null ? new LineNumberReader(new InputStreamReader((InputStream)object, this.connection.getCharset())) : new LineNumberReader(new InputStreamReader((InputStream)object));
                    } else {
                        object2 = new LineNumberReader(tableReader.getReader(this, string));
                    }
                    object = this.connection.getHeaderline(string);
                    object3 = new CsvRawReader((LineNumberReader)object2, string, string2, this.connection.getSeparator(), this.connection.isSuppressHeaders(), this.connection.isHeaderFixedWidth(), this.connection.getQuotechar(), this.connection.getCommentChar(), (String)object, this.connection.getTrimHeaders(), this.connection.getTrimValues(), this.connection.getSkipLeadingLines(), this.connection.isIgnoreUnparseableLines(), this.connection.getMissingValue(), this.connection.isDefectiveHeaders(), this.connection.getSkipLeadingDataLines(), this.connection.getQuoteStyle(), this.connection.getFixedWidthColumns());
                    dataReader = new CsvReader((CsvRawReader)object3, this.connection.getTransposedLines(), this.connection.getTransposedFieldsToSkip(), (String)object);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(CsvResources.getString("fileReadError") + ": " + iOException);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException(CsvResources.getString("dataReaderError") + ": " + exception);
            }
        }
        object2 = null;
        try {
            this.lastResultSet = object2 = new CsvResultSet(this, dataReader, string, sqlParser.getColumns(), sqlParser.isDistinct(), this.resultSetType, sqlParser.getWhereClause(), sqlParser.getGroupByColumns(), sqlParser.getHavingClause(), sqlParser.getOrderByColumns(), sqlParser.getLimit(), sqlParser.getOffset(), this.connection.getColumnTypes(string), this.connection.getSkipLeadingLines(), map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            CsvDriver.writeLog("" + classNotFoundException);
        }
        return object2;
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
            this.multipleParsers = null;
            this.closed = true;
            this.connection.removeStatement(this);
        }
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.cancel()");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        CsvDriver.writeLog("CsvStatement:execute() - sql= " + string);
        try {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
            }
        }
        finally {
            this.lastResultSet = null;
            this.multipleParsers = null;
        }
        MultipleSqlParser multipleSqlParser = new MultipleSqlParser();
        try {
            List<SqlParser> list = multipleSqlParser.parse(string);
            this.lastResultSet = this.executeParsedQuery(list.remove(0));
            this.multipleParsers = list;
        }
        catch (Exception exception) {
            throw new SQLException(CsvResources.getString("syntaxError") + ": " + exception.getMessage());
        }
        return true;
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.addBatch(String)");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.clearBatch()");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException(CsvResources.getString("methodNotSupported") + ": Statement.executeBatch()");
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.getMoreResults(int)");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.getGeneratedKeys()");
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String,int)");
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String,int[])");
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.executeUpdate(String,String[])");
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.execute(String,int)");
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.execute(String,int[])");
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.execute(String,String[])");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.getResultSetHoldability()");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Statement.closeOnCompletion()");
    }
}

