/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Executor;
import org.relique.io.CryptoFilter;
import org.relique.io.TableReader;
import org.relique.jdbc.csv.CsvDatabaseMetaData;
import org.relique.jdbc.csv.CsvDriver;
import org.relique.jdbc.csv.CsvPreparedStatement;
import org.relique.jdbc.csv.CsvResources;
import org.relique.jdbc.csv.CsvStatement;
import org.relique.jdbc.csv.StringConverter;
import org.relique.jdbc.csv.ZipFileTableReader;

public class CsvConnection
implements Connection {
    private String path;
    private String urlProperties;
    private TableReader tableReader;
    private String extension = ".csv";
    private String separator = ",";
    private Character quotechar = Character.valueOf('\"');
    private HashMap<String, String> headerlines = new HashMap();
    private boolean suppressHeaders = false;
    private boolean isHeaderFixedWidth = true;
    private boolean trimHeaders = true;
    private boolean trimValues = false;
    private boolean indexedFiles = false;
    private HashMap<String, String> columnTypes = new HashMap();
    private Vector<Statement> statements = new Vector();
    private String charset = null;
    private boolean closed;
    private String fileNamePattern;
    private String[] nameParts;
    private String timestampFormat;
    private String dateFormat;
    private String timeFormat;
    private String timeZoneName;
    private Locale locale = null;
    private String commentChar;
    private int skipLeadingLines = 0;
    private boolean ignoreUnparseableLines;
    private String missingValue;
    private boolean fileTailPrepend;
    private CryptoFilter decryptingFilter;
    private boolean defectiveHeaders;
    private int skipLeadingDataLines;
    private int transposedLines;
    private int transposedFieldsToSkip;
    private boolean autoCommit;
    private String quoteStyle;
    private ArrayList<int[]> fixedWidthColumns = null;
    private HashMap<String, Method> sqlFunctions = new HashMap();

    private void init() {
        this.headerlines.put(null, CsvDriver.DEFAULT_HEADERLINE);
        this.columnTypes.put(null, "String");
    }

    private Map<String, String> getMatchingProperties(Properties properties, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object : properties.keySet()) {
            String string2 = object.toString();
            if (!string2.startsWith(string)) continue;
            String string3 = properties.getProperty(string2);
            string2 = string2.substring(string.length());
            hashMap.put(string2, string3);
        }
        return hashMap;
    }

    private void setFunctions(Properties properties) throws SQLException {
        String string = "function.";
        for (Map.Entry<String, String> entry : this.getMatchingProperties(properties, string).entrySet()) {
            String string2 = entry.getKey().toUpperCase();
            String string3 = entry.getValue();
            try {
                int n;
                int n2;
                for (n2 = 0; n2 < string2.length(); ++n2) {
                    char c = string2.charAt(n2);
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '.') continue;
                    throw new SQLException(CsvResources.getString("invalidFunction") + ": " + string2);
                }
                n2 = string3.indexOf(40);
                if (n2 < 0) {
                    throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + string3);
                }
                String string4 = string3.substring(0, n2).trim();
                String string5 = string3.substring(n2 + 1);
                int n3 = string5.lastIndexOf(41);
                if (n3 < 0) {
                    throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + string3);
                }
                string5 = string5.substring(0, n3).trim();
                int n4 = string4.lastIndexOf(46);
                if (n4 < 0) {
                    throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + string4);
                }
                String string6 = string4.substring(0, n4);
                Class<?> clazz = Class.forName(string6);
                String string7 = string4.substring(n4 + 1);
                String[] stringArray = new String[]{};
                boolean bl = false;
                if (string5.length() > 0) {
                    stringArray = string5.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        n = stringArray[i].indexOf("...");
                        if (i == stringArray.length - 1 && n >= 0) {
                            stringArray[i] = stringArray[i].substring(0, n) + "[]";
                            bl = true;
                        }
                        stringArray[i] = stringArray[i].trim();
                        String[] stringArray2 = stringArray[i].split("\\s+");
                        if (stringArray2.length <= 1) continue;
                        stringArray[i] = stringArray2[0];
                    }
                }
                Method[] methodArray = clazz.getMethods();
                n = 0;
                for (int i = 0; i < methodArray.length && n == 0; ++i) {
                    if (!methodArray[i].getName().equals(string7) || (methodArray[i].getModifiers() & 8) == 0) continue;
                    Class<?>[] classArray = methodArray[i].getParameterTypes();
                    boolean bl2 = classArray.length == stringArray.length && methodArray[i].isVarArgs() == bl;
                    for (int j = 0; j < classArray.length && bl2; ++j) {
                        String string8 = classArray[j].getSimpleName();
                        if (string8.equals(stringArray[j])) continue;
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    this.sqlFunctions.put(string2, methodArray[i]);
                    n = 1;
                }
                if (n != 0) continue;
                throw new SQLException(CsvResources.getString("noFunctionMethod") + ": " + string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(CsvResources.getString("noFunctionClass") + ": " + string3, classNotFoundException);
            }
        }
    }

    private void setProperties(Properties properties) throws SQLException {
        Object object;
        Object[] objectArray;
        String string;
        String string2;
        if (properties.getProperty("fileExtension") != null) {
            this.extension = properties.getProperty("fileExtension");
        }
        if (properties.getProperty("separator") != null) {
            this.separator = properties.getProperty("separator");
            if (this.separator.length() == 0) {
                throw new SQLException(CsvResources.getString("invalid") + " " + "separator" + ": " + this.separator);
            }
        }
        if ((string2 = properties.getProperty("quotechar")) != null) {
            if (string2.length() == 1) {
                this.quotechar = Character.valueOf(string2.charAt(0));
            } else if (string2.length() == 0) {
                this.quotechar = null;
            } else {
                throw new SQLException(CsvResources.getString("invalid") + " " + "quotechar" + ": " + string2);
            }
        }
        if (properties.getProperty("headerline") != null) {
            this.headerlines.put(null, properties.getProperty("headerline"));
        }
        this.headerlines.putAll(this.getMatchingProperties(properties, "headerline."));
        if (properties.getProperty("suppressHeaders") != null) {
            this.suppressHeaders = Boolean.valueOf(properties.getProperty("suppressHeaders"));
        }
        if (properties.getProperty("isHeaderFixedWidth") != null) {
            this.isHeaderFixedWidth = Boolean.valueOf(properties.getProperty("isHeaderFixedWidth"));
        }
        if (properties.getProperty("trimValues") != null) {
            this.trimValues = Boolean.valueOf(properties.getProperty("trimValues"));
        }
        if (properties.getProperty("charset") != null) {
            this.charset = properties.getProperty("charset");
        }
        if (properties.getProperty("columnTypes") != null) {
            this.columnTypes.put(null, properties.getProperty("columnTypes"));
        }
        this.columnTypes.putAll(this.getMatchingProperties(properties, "columnTypes."));
        if (properties.getProperty("indexedFiles") != null) {
            this.indexedFiles = Boolean.valueOf(properties.getProperty("indexedFiles"));
            this.fileNamePattern = properties.getProperty("fileTailPattern");
            string = properties.getProperty("fileTailParts", "");
            if (!string.isEmpty()) {
                this.nameParts = string.split(",");
            }
            this.setFileTailPrepend(Boolean.parseBoolean(properties.getProperty("fileTailPrepend", "False")));
        }
        this.decryptingFilter = null;
        if (properties.getProperty("cryptoFilterClassName") != null) {
            string = properties.getProperty("cryptoFilterClassName");
            try {
                objectArray = Class.forName(string);
                String[] stringArray = properties.getProperty("cryptoFilterParameterTypes", "String").split(",");
                object = properties.getProperty("cryptoFilterParameters", "").split(",");
                StringConverter stringConverter = new StringConverter("", "", "", "", null);
                Class[] classArray = new Class[((String[])object).length];
                Object[] objectArray2 = new Object[((String[])object).length];
                for (int i = 0; i < ((String[])object).length; ++i) {
                    classArray[i] = stringConverter.forSQLName(stringArray[i]);
                    objectArray2[i] = stringConverter.convert(stringArray[i], object[i]);
                }
                Constructor constructor = objectArray.getConstructor(classArray);
                this.decryptingFilter = (CryptoFilter)constructor.newInstance(objectArray2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(CsvResources.getString("noCodecClass") + ": " + string);
            }
            if (this.decryptingFilter == null) {
                throw new SQLException(CsvResources.getString("noCryptoFilter"));
            }
        }
        this.setFunctions(properties);
        string = properties.getProperty("fixedWidths");
        if (string != null) {
            this.fixedWidthColumns = new ArrayList();
            objectArray = string.split(",");
            for (int i = 0; i < objectArray.length; ++i) {
                int n;
                int n2;
                int n3 = objectArray[i].indexOf(45);
                if (n3 < 0) {
                    n = n2 = Integer.parseInt(objectArray[i].trim());
                } else {
                    n = Integer.parseInt(objectArray[i].substring(0, n3).trim());
                    n2 = Integer.parseInt(objectArray[i].substring(n3 + 1).trim());
                }
                this.fixedWidthColumns.add(new int[]{n - 1, n2 - 1});
            }
        }
        this.setTransposedLines(Integer.parseInt(properties.getProperty("transposedLines", "0")));
        this.setTransposedFieldsToSkip(Integer.parseInt(properties.getProperty("transposedFieldsToSkip", "0")));
        this.setTimestampFormat(properties.getProperty("timestampFormat", CsvDriver.DEFAULT_TIMESTAMP_FORMAT));
        this.setDateFormat(properties.getProperty("dateFormat", "YYYY-MM-DD"));
        this.setTimeFormat(properties.getProperty("timeFormat", "HH:mm:ss"));
        this.setTimeZoneName(properties.getProperty("timeZoneName", "UTC"));
        if (properties.getProperty("locale") != null) {
            string2 = properties.getProperty("locale");
            objectArray = Locale.getAvailableLocales();
            for (int i = 0; i < objectArray.length && this.locale == null; ++i) {
                object = ((Locale)objectArray[i]).toString();
                if (!((String)object).equals(string2)) continue;
                this.locale = objectArray[i];
            }
            if (this.locale == null) {
                throw new SQLException(CsvResources.getString("noLocale") + ": " + string2);
            }
        }
        this.setCommentChar(properties.getProperty("commentChar", CsvDriver.DEFAULT_COMMENT_CHAR));
        this.setDefectiveHeaders(properties.getProperty("defectiveHeaders", "False"));
        this.setSkipLeadingDataLines(properties.getProperty("skipLeadingDataLines", "0"));
        this.setSkipLeadingLines(properties.getProperty("skipLeadingLines", CsvDriver.DEFAULT_SKIP_LEADING_LINES));
        this.setQuoteStyle(properties.getProperty("quoteStyle", "SQL"));
        this.setIgnoreUnparseableLines(Boolean.parseBoolean(properties.getProperty("ignoreNonParseableLines", "False")));
        this.setMissingValue(properties.getProperty("missingValue", CsvDriver.DEFAULT_MISSING_VALUE));
    }

    protected CsvConnection(String string, Properties properties, String string2) throws SQLException {
        this.init();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(CsvResources.getString("noPath"));
        }
        this.path = string;
        this.urlProperties = string2;
        if (properties != null) {
            this.setProperties(properties);
        }
    }

    protected CsvConnection(TableReader tableReader, Properties properties, String string) throws SQLException {
        this.init();
        this.tableReader = tableReader;
        this.urlProperties = string;
        if (properties != null) {
            this.setProperties(properties);
        }
    }

    private void setQuoteStyle(String string) {
        this.quoteStyle = string;
    }

    public String getQuoteStyle() {
        return this.quoteStyle;
    }

    private void setTimeZoneName(String string) {
        this.timeZoneName = string;
    }

    public String getTimeZoneName() {
        return this.timeZoneName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(CsvResources.getString("closedConnection"));
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        CsvStatement csvStatement = new CsvStatement(this, 1003);
        this.statements.add(csvStatement);
        return csvStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        CsvPreparedStatement csvPreparedStatement = new CsvPreparedStatement(this, string, 1003);
        this.statements.add(csvPreparedStatement);
        return csvPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareCall(String)");
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.nativeSQL(String)");
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        this.autoCommit = bl;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    private synchronized void closeStatements() throws SQLException {
        while (this.statements.size() > 0) {
            this.statements.firstElement().close();
        }
        this.statements.clear();
    }

    @Override
    public void close() throws SQLException {
        this.closeStatements();
        this.closed = true;
    }

    public void removeStatement(Statement statement) {
        this.statements.remove(statement);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new CsvDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setTransactionIsolation(int)");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        CsvStatement csvStatement = new CsvStatement(this, n);
        this.statements.add(csvStatement);
        return csvStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        CsvPreparedStatement csvPreparedStatement = new CsvPreparedStatement(this, string, n);
        this.statements.add(csvPreparedStatement);
        return csvPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareCall(String, int, int)");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.getTypeMap()");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setTypeMap(Map)");
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        if (n != 1) {
            throw new SQLFeatureNotSupportedException(CsvResources.getString("unsupportedHoldability") + ": " + n);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        CsvStatement csvStatement = new CsvStatement(this, n);
        this.statements.add(csvStatement);
        return csvStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        CsvPreparedStatement csvPreparedStatement = new CsvPreparedStatement(this, string, n);
        this.statements.add(csvPreparedStatement);
        return csvPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareCall(String,int,int,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareStatement(String,int)");
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareStatement(String,int[])");
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.prepareStatement(String,String[])");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.releaseSavepoint(Savepoint)");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.rollback(Savepoint)");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setSavepoint()");
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.setSavepoint(String)");
    }

    protected String getPath() {
        return this.path;
    }

    protected TableReader getTableReader() {
        return this.tableReader;
    }

    protected String getURL() {
        String string = this.path != null ? "jdbc:relique:csv:" + this.path : (this.tableReader instanceof ZipFileTableReader ? "jdbc:relique:csv:zip:" + ((ZipFileTableReader)this.tableReader).getZipFilename() : "jdbc:relique:csv:class:" + this.tableReader.getClass().getName());
        return string + this.urlProperties;
    }

    protected String getExtension() {
        return this.extension;
    }

    protected String getSeparator() {
        return this.separator;
    }

    public String getHeaderline(String string) {
        String string2 = this.headerlines.get(string);
        if (string2 == null) {
            string2 = this.headerlines.get(null);
        }
        return string2;
    }

    public Character getQuotechar() {
        return this.quotechar;
    }

    protected boolean isSuppressHeaders() {
        return this.suppressHeaders;
    }

    protected boolean isHeaderFixedWidth() {
        return this.isHeaderFixedWidth;
    }

    public ArrayList<int[]> getFixedWidthColumns() {
        return this.fixedWidthColumns;
    }

    protected boolean isDefectiveHeaders() {
        return this.defectiveHeaders;
    }

    protected int getSkipLeadingDataLines() {
        return this.skipLeadingDataLines;
    }

    protected String getCharset() {
        return this.charset;
    }

    public boolean getTrimHeaders() {
        return this.trimHeaders;
    }

    public boolean getTrimValues() {
        return this.trimValues;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        return !this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    private void setDefectiveHeaders(String string) {
        this.defectiveHeaders = Boolean.parseBoolean(string);
    }

    private void setSkipLeadingDataLines(String string) {
        this.skipLeadingDataLines = Integer.parseInt(string);
    }

    @Deprecated
    public void setColumnTypes(String string) {
        this.columnTypes.put(null, string);
    }

    public String getColumnTypes(String string) {
        String string2 = this.columnTypes.get(string);
        if (string2 == null) {
            string2 = this.columnTypes.get(null);
        }
        return string2;
    }

    @Deprecated
    public void setIndexedFiles(boolean bl) {
        this.indexedFiles = bl;
    }

    public boolean isIndexedFiles() {
        return this.indexedFiles;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }

    public String[] getNameParts() {
        return this.nameParts;
    }

    public void setTimestampFormat(String string) {
        this.timestampFormat = string;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setTimeFormat(String string) {
        this.timeFormat = string;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setCommentChar(String string) {
        this.commentChar = string == null ? null : (string.equals("") ? null : string);
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    private void setSkipLeadingLines(String string) {
        try {
            this.skipLeadingLines = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.skipLeadingLines = 0;
        }
    }

    public int getSkipLeadingLines() {
        return this.skipLeadingLines;
    }

    public void setSkipLeadingLines(int n) {
        this.skipLeadingLines = n;
    }

    public boolean isIgnoreUnparseableLines() {
        return this.ignoreUnparseableLines;
    }

    public void setIgnoreUnparseableLines(boolean bl) {
        this.ignoreUnparseableLines = bl;
    }

    public String getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(String string) {
        this.missingValue = string;
    }

    public void setFileTailPrepend(boolean bl) {
        this.fileTailPrepend = bl;
    }

    public boolean isFileTailPrepend() {
        return this.fileTailPrepend;
    }

    public CryptoFilter getDecryptingCodec() {
        return this.decryptingFilter;
    }

    public HashMap<String, Method> getSqlFunctions() {
        return this.sqlFunctions;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException(CsvResources.getString("methodNotSupported") + ": Connection.setNetworkTimeout(Executor,int)");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException(CsvResources.getString("methodNotSupported") + ": Connection.abort(Executor)");
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void setSchema(String string) throws SQLException {
        this.checkOpen();
    }

    public int getTransposedLines() {
        return this.transposedLines;
    }

    private void setTransposedLines(int n) {
        this.transposedLines = n;
    }

    public int getTransposedFieldsToSkip() {
        return this.transposedFieldsToSkip;
    }

    public void setTransposedFieldsToSkip(int n) {
        this.transposedFieldsToSkip = n;
    }

    public List<String> getTableNames() throws SQLException {
        List<String> list = new ArrayList<String>();
        if (this.path != null) {
            File[] fileArray = new File(this.path).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(CsvConnection.this.extension);
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || !fileArray[i].canRead()) continue;
                String string = fileArray[i].getName();
                String string2 = string.substring(0, string.length() - this.extension.length());
                list.add(string2);
            }
        } else {
            List<String> list2 = this.tableReader.getTableNames(this);
            if (list2 != null) {
                list = list2;
            }
        }
        return list;
    }
}

