/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsql143.ByteArray;
import org.hsql143.Column;
import org.hsql143.Record;
import org.hsql143.Result;
import org.hsql143.Trace;

public class jdbcResultSet
implements ResultSet,
ResultSetMetaData {
    private Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;

    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    public void close() {
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    public boolean wasNull() {
        return this.bWasNull;
    }

    public int findColumn(String columnName) throws SQLException {
        int i = 0;
        while (i < this.iColumnCount) {
            if (columnName.equalsIgnoreCase(this.rResult.sLabel[i])) {
                return i + 1;
            }
            ++i;
        }
        throw Trace.error(27);
    }

    public String getString(int column) throws SQLException {
        this.checkColumn(--column);
        this.checkAvailable();
        Object o = this.nCurrent.data[column];
        this.checkNull(o);
        return o == null ? null : o.toString();
    }

    public boolean getBoolean(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, -7)) == null ? false : (Boolean)o;
    }

    public byte getByte(int column) throws SQLException {
        return (byte)this.getShort(column);
    }

    public short getShort(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, 5)) == null ? (short)0 : (Short)o;
    }

    public int getInt(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, 4)) == null ? 0 : (Integer)o;
    }

    public long getLong(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, -5)) == null ? 0L : (Long)o;
    }

    public float getFloat(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, 7)) == null ? 0.0f : ((Float)o).floatValue();
    }

    public double getDouble(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, 8)) == null ? 0.0 : (Double)o;
    }

    public BigDecimal getBigDecimal(int column, int scale) throws SQLException {
        return (BigDecimal)this.getColumnInType(--column, 3);
    }

    public byte[] getBytes(int column) throws SQLException {
        Object o;
        return (o = this.getColumnInType(--column, -2)) == null ? null : ((ByteArray)o).byteValue();
    }

    public Date getDate(int column) throws SQLException {
        return (Date)this.getColumnInType(--column, 91);
    }

    public Time getTime(int column) throws SQLException {
        return (Time)this.getColumnInType(--column, 92);
    }

    public Timestamp getTimestamp(int column) throws SQLException {
        return (Timestamp)this.getColumnInType(--column, 93);
    }

    public InputStream getAsciiStream(int column) throws SQLException {
        return this.getUnicodeStream(column);
    }

    public InputStream getUnicodeStream(int column) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(column));
    }

    public InputStream getBinaryStream(int column) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(column));
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public String getCursorName() throws SQLException {
        throw Trace.error(19);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(int column) throws SQLException {
        this.checkColumn(--column);
        this.checkAvailable();
        Object o = this.nCurrent.data[column];
        this.checkNull(o);
        if (o == null) {
            return null;
        }
        if (this.rResult.iType[column] == 1111) {
            o = ((ByteArray)o).deserialize();
        } else if (o instanceof ByteArray) {
            o = ((ByteArray)o).byteValue();
        }
        return o == null ? null : o;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int column) throws SQLException {
        return this.getBigDecimal(column, 0);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() {
        return !this.bInit;
    }

    public boolean isAfterLast() {
        if (!this.bInit) {
            return false;
        }
        return this.nCurrent == null;
    }

    public boolean isFirst() {
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        throw Trace.error(19);
    }

    public void beforeFirst() throws SQLException {
        throw Trace.error(19);
    }

    public void afterLast() throws SQLException {
        throw Trace.error(19);
    }

    public boolean first() throws SQLException {
        throw Trace.error(19);
    }

    public boolean last() throws SQLException {
        throw Trace.error(19);
    }

    public int getRow() {
        return this.iCurrentRow;
    }

    public boolean absolute(int row) throws SQLException {
        throw Trace.error(19);
    }

    /*
     * Unable to fully structure code
     */
    public boolean relative(int rows) throws SQLException {
        if (rows >= 0) ** GOTO lbl5
        throw Trace.error(19);
lbl-1000:
        // 1 sources

        {
            this.next();
lbl5:
            // 2 sources

            ** while (rows-- > 0)
        }
lbl6:
        // 1 sources

        return this.nCurrent != null;
    }

    public boolean previous() throws SQLException {
        throw Trace.error(19);
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw Trace.error(19);
        }
    }

    public int getFetchDirection() {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public int getFetchSize() {
        return 1;
    }

    public int getType() {
        return 1003;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowUpdated() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowDeleted() {
        return false;
    }

    public void updateNull(int column) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBoolean(int column, boolean x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateByte(int column, byte x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateShort(int column, short x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateInt(int column, int x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateLong(int column, long x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateFloat(int column, float x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateDouble(int column, double x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBigDecimal(int column, BigDecimal x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateString(int column, String x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBytes(int column, byte[] x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateDate(int column, Date x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateTime(int column, Time x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateTimestamp(int column, Timestamp x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateAsciiStream(int column, InputStream x, int length) throws SQLException {
        throw Trace.error(19);
    }

    public void updateBinaryStream(int column, InputStream x, int length) throws SQLException {
        throw Trace.error(19);
    }

    public void updateCharacterStream(int column, Reader x, int length) throws SQLException {
        throw Trace.error(19);
    }

    public void updateObject(int column, Object x, int scale) throws SQLException {
        throw Trace.error(19);
    }

    public void updateObject(int column, Object x) throws SQLException {
        throw Trace.error(19);
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), x, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        throw Trace.error(19);
    }

    public void updateRow() throws SQLException {
        throw Trace.error(19);
    }

    public void deleteRow() throws SQLException {
        throw Trace.error(19);
    }

    public void refreshRow() throws SQLException {
    }

    public void cancelRowUpdates() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw Trace.error(19);
    }

    public void moveToCurrentRow() throws SQLException {
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public Object getObject(int column, Map map) throws SQLException {
        return this.getObject(column);
    }

    public Ref getRef(int column) throws SQLException {
        throw Trace.error(19);
    }

    public Blob getBlob(int column) throws SQLException {
        throw Trace.error(19);
    }

    public Clob getClob(int column) throws SQLException {
        throw Trace.error(19);
    }

    public Array getArray(int column) throws SQLException {
        throw Trace.error(19);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        return this.getObject(this.findColumn(columnName), map);
    }

    public Ref getRef(String columnName) throws SQLException {
        return this.getRef(this.findColumn(columnName));
    }

    public Blob getBlob(String columnName) throws SQLException {
        return this.getBlob(this.findColumn(columnName));
    }

    public Clob getClob(String columnName) throws SQLException {
        return this.getClob(this.findColumn(columnName));
    }

    public Array getArray(String columnName) throws SQLException {
        return this.getArray(this.findColumn(columnName));
    }

    public Date getDate(int column, Calendar cal) throws SQLException {
        return this.getDate(column);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int column, Calendar cal) throws SQLException {
        return this.getTime(column);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int column, Calendar cal) throws SQLException {
        return this.getTimestamp(column);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public Reader getCharacterStream(int column) throws SQLException {
        throw Trace.error(19);
    }

    jdbcResultSet(Result r) throws SQLException {
        if (r.iMode == 0) {
            this.iUpdateCount = r.iUpdateCount;
        } else {
            if (r.iMode == 1) {
                throw Trace.getError(r.sError);
            }
            this.iUpdateCount = -1;
            this.rResult = r;
            this.iColumnCount = r.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }

    private void checkColumn(int column) throws SQLException {
        if (column < 0 || column >= this.iColumnCount) {
            Trace.error(27, column);
        }
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            Trace.error(33);
        }
    }

    private Object getColumnInType(int column, int type) throws SQLException {
        this.checkColumn(column);
        this.checkAvailable();
        int t = this.rResult.iType[column];
        Object o = this.nCurrent.data[column];
        this.checkNull(o);
        if (type == t) {
            return o;
        }
        try {
            return Column.convertObject(o, type);
        }
        catch (Exception e) {
            String s = "type: " + Column.getType(t) + " (" + t + ") expected: " + Column.getType(type) + " value: " + o.toString();
            throw Trace.error(15, s);
        }
    }

    private void checkNull(Object o) {
        this.bWasNull = o == null;
    }

    public int getColumnCount() {
        return this.iColumnCount;
    }

    public boolean isAutoIncrement(int column) {
        return false;
    }

    public boolean isCaseSensitive(int column) {
        return true;
    }

    public boolean isSearchable(int column) {
        return true;
    }

    public boolean isCurrency(int column) {
        return false;
    }

    public int isNullable(int column) {
        return 1;
    }

    public boolean isSigned(int column) {
        return true;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        this.checkColumn(--column);
        return 0;
    }

    public String getColumnLabel(int column) throws SQLException {
        this.checkColumn(--column);
        return this.rResult.sLabel[column];
    }

    public String getColumnName(int column) throws SQLException {
        this.checkColumn(--column);
        return this.rResult.sName[column];
    }

    public String getSchemaName(int column) {
        return "";
    }

    public int getPrecision(int column) {
        return 0;
    }

    public int getScale(int column) {
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        this.checkColumn(--column);
        return this.rResult.sTable[column];
    }

    public String getCatalogName(int column) {
        return "";
    }

    public int getColumnType(int column) throws SQLException {
        this.checkColumn(--column);
        return this.rResult.iType[column];
    }

    public String getColumnTypeName(int column) throws SQLException {
        this.checkColumn(--column);
        return Column.getType(this.rResult.iType[column]);
    }

    public boolean isReadOnly(int column) {
        return false;
    }

    public boolean isWritable(int column) {
        return true;
    }

    public boolean isDefinitelyWritable(int column) {
        return true;
    }

    public String getColumnClassName(int column) throws SQLException {
        throw Trace.error(19);
    }

    public URL getURL(int columnIndex) throws SQLException {
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        return null;
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    public void updateArray(String columnName, Array x) throws SQLException {
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
    }
}

