/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.DriverManager;
import java.util.Properties;
import org.hsql143.Database;
import org.hsql143.WebServerConnection;

public class WebServer {
    static final String mServerName = "HypersonicSQL/1.0";
    String mRoot;
    String mDefaultFile;
    char mPathSeparatorChar;
    boolean mSilent;
    Database mDatabase;
    Properties mProperties;

    public static void main(String[] arg) {
        WebServer w = new WebServer();
        w.run(arg);
    }

    private void run(String[] arg) {
        ServerSocket socket = null;
        try {
            Properties prop;
            this.mProperties = prop = new Properties();
            File f = new File("WebServer.properties");
            if (f.exists()) {
                FileInputStream fi = new FileInputStream(f);
                prop.load(fi);
                fi.close();
            }
            int i = 0;
            while (i < arg.length) {
                String p = arg[i];
                if (p.equals("-?")) {
                    this.printHelp();
                }
                if (p.charAt(0) == '-') {
                    prop.put(p.substring(1), arg[i + 1]);
                    ++i;
                }
                ++i;
            }
            int port = Integer.parseInt(prop.getProperty("port", "80"));
            String database = prop.getProperty("database", "test");
            this.mRoot = prop.getProperty("root", "./");
            this.mDefaultFile = prop.getProperty("default", "index.html");
            this.mSilent = prop.getProperty("silent", "true").equalsIgnoreCase("true");
            if (prop.getProperty("trace", "false").equalsIgnoreCase("true")) {
                DriverManager.setLogStream(System.out);
            }
            socket = new ServerSocket(port);
            this.mPathSeparatorChar = File.separatorChar;
            this.trace("port    =" + port);
            this.trace("database=" + database);
            this.trace("root    =" + this.mRoot);
            this.trace("default =" + this.mDefaultFile);
            this.trace("silent  =" + this.mSilent);
            this.mDatabase = new Database(database);
            System.out.println("WebServer 1.4 is running");
            System.out.println("Press [Ctrl]+[C] to abort");
        }
        catch (Exception e) {
            this.traceError("WebServer.run/init: " + e);
            return;
        }
        try {
            while (true) {
                Socket s = socket.accept();
                WebServerConnection c = new WebServerConnection(s, this);
                c.start();
            }
        }
        catch (IOException e) {
            this.traceError("WebServer.run/loop: " + e.getMessage());
            return;
        }
    }

    void printHelp() {
        System.out.println("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default <file>       default file when filename is missing\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display print JDBC trace messages\nThe command line arguments override the values in the properties file.");
        System.exit(0);
    }

    void trace(String s) {
        if (!this.mSilent) {
            System.out.println(s);
        }
    }

    void traceError(String s) {
        System.out.println(s);
    }
}

