/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.io.File;
import java.io.PrintWriter;
import java.sql.SQLException;

class Trace
extends PrintWriter {
    public static final boolean TRACE = false;
    public static final boolean STOP = false;
    public static final boolean ASSERT = false;
    private static Trace tTracer = new Trace();
    private static int iLine;
    private static String sTrace;
    private static int iStop;
    static final int DATABASE_ALREADY_IN_USE = 0;
    static final int CONNECTION_IS_CLOSED = 1;
    static final int CONNECTION_IS_BROKEN = 2;
    static final int DATABASE_IS_SHUTDOWN = 3;
    static final int COLUMN_COUNT_DOES_NOT_MATCH = 4;
    static final int DIVISION_BY_ZERO = 5;
    static final int INVALID_ESCAPE = 6;
    static final int INTEGRITY_CONSTRAINT_VIOLATION = 7;
    static final int VIOLATION_OF_UNIQUE_INDEX = 8;
    static final int TRY_TO_INSERT_NULL = 9;
    static final int UNEXPECTED_TOKEN = 10;
    static final int UNEXPECTED_END_OF_COMMAND = 11;
    static final int UNKNOWN_FUNCTION = 12;
    static final int NEED_AGGREGATE = 13;
    static final int SUM_OF_NON_NUMERIC = 14;
    static final int WRONG_DATA_TYPE = 15;
    static final int SINGLE_VALUE_EXPECTED = 16;
    static final int SERIALIZATION_FAILURE = 17;
    static final int TRANSFER_CORRUPTED = 18;
    static final int FUNCTION_NOT_SUPPORTED = 19;
    static final int TABLE_ALREADY_EXISTS = 20;
    static final int TABLE_NOT_FOUND = 21;
    static final int INDEX_ALREADY_EXISTS = 22;
    static final int SECOND_PRIMARY_KEY = 23;
    static final int DROP_PRIMARY_KEY = 24;
    static final int INDEX_NOT_FOUND = 25;
    static final int COLUMN_ALREADY_EXISTS = 26;
    static final int COLUMN_NOT_FOUND = 27;
    static final int FILE_IO_ERROR = 28;
    static final int WRONG_DATABASE_FILE_VERSION = 29;
    static final int DATABASE_IS_READONLY = 30;
    static final int ACCESS_IS_DENIED = 31;
    static final int INPUTSTREAM_ERROR = 32;
    static final int NO_DATA_IS_AVAILABLE = 33;
    static final int USER_ALREADY_EXISTS = 34;
    static final int USER_NOT_FOUND = 35;
    static final int ASSERT_FAILED = 36;
    static final int EXTERNAL_STOP = 37;
    static final int GENERAL_ERROR = 38;
    static final int WRONG_OUT_PARAMETER = 39;
    static final int ERROR_IN_FUNCTION = 40;
    private static String[] sDescription;

    static {
        iStop = 0;
        sDescription = new String[]{"08001 The database is already in use by another process", "08003 Connection is closed", "08003 Connection is broken", "08003 The database is shutdown", "21S01 Column count does not match", "22012 Division by zero", "22019 Invalid escape character", "23000 Integrity constraint violation", "23000 Violation of unique index", "23000 Try to insert null into a non-nullable column", "37000 Unexpected token", "37000 Unexpected end of command", "37000 Unknown function", "37000 Need aggregate function or group by", "37000 Sum on non-numeric data not allowed", "37000 Wrong data type", "37000 Single value expected", "40001 Serialization failure", "40001 Transfer corrupted", "IM001 This function is not supported", "S0001 Table already exists", "S0002 Table not found", "S0011 Index already exists", "S0011 Attempt to define a second primary key", "S0011 Attempt to drop the primary key", "S0012 Index not found", "S0021 Column already exists", "S0022 Column not found", "S1000 File input/output error", "S1000 Wrong database file version", "S1000 The database is in read only mode", "S1000 Access is denied", "S1000 InputStream error", "S1000 No data is available", "S1000 User already exists", "S1000 User not found", "S1000 Assert failed", "S1000 External stop request", "S1000 General error", "S1009 Wrong OUT parameter", "S1010 Error in function"};
    }

    static SQLException getError(int code, String add) {
        String s = Trace.getMessage(code);
        if (add != null) {
            s = String.valueOf(s) + ": " + add;
        }
        return Trace.getError(s);
    }

    static String getMessage(int code) {
        return sDescription[code];
    }

    static String getMessage(SQLException e) {
        return String.valueOf(e.getSQLState()) + " " + e.getMessage();
    }

    static SQLException getError(String msg) {
        return new SQLException(msg.substring(6), msg.substring(0, 5));
    }

    static SQLException error(int code) {
        return Trace.getError(code, null);
    }

    static SQLException error(int code, String s) {
        return Trace.getError(code, s);
    }

    static SQLException error(int code, int i) {
        return Trace.getError(code, "" + i);
    }

    static void Assert(boolean condition) throws SQLException {
        Trace.Assert(condition, null);
    }

    static void Assert(boolean condition, String error) throws SQLException {
        if (!condition) {
            Trace.printStack();
            throw Trace.getError(36, error);
        }
    }

    static void check(boolean condition, int code) throws SQLException {
        Trace.check(condition, code, null);
    }

    static void check(boolean condition, int code, String s) throws SQLException {
        if (!condition) {
            throw Trace.getError(code, s);
        }
    }

    public void println(char[] c) {
        if (iLine++ == 2) {
            String s = new String(c);
            int i = s.indexOf(46);
            if (i != -1) {
                s = s.substring(i + 1);
            }
            if ((i = s.indexOf(40)) != -1) {
                s = s.substring(0, i);
            }
            sTrace = s;
        }
    }

    Trace() {
        super(System.out);
    }

    static void trace(long l) {
        Trace.traceCaller("" + l);
    }

    static void trace(int i) {
        Trace.traceCaller("" + i);
    }

    static void trace() {
        Trace.traceCaller("");
    }

    static void trace(String s) {
        Trace.traceCaller(s);
    }

    static void stop() throws SQLException {
        Trace.stop(null);
    }

    static void stop(String s) throws SQLException {
        if (iStop++ % 10000 != 0) {
            return;
        }
        if (new File("trace.stop").exists()) {
            Trace.printStack();
            throw Trace.getError(37, s);
        }
    }

    private static void printStack() {
        Exception e = new Exception();
        e.printStackTrace();
    }

    private static void traceCaller(String s) {
        Exception e = new Exception();
        iLine = 0;
        e.printStackTrace(tTracer);
        s = String.valueOf(sTrace) + "\t" + s;
        System.out.println(s);
    }
}

