/*
 * Decompiled with CFR 0.152.
 */
package org.hsql143;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import org.hsql143.Trace;

class Tokenizer {
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int QUOTED_IDENTIFIER = 9;
    private static final int REMARK_LINE = 10;
    private static final int REMARK = 11;
    private String sCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private String sLongNameLast;
    private boolean bWait;
    private static Hashtable hKeyword = new Hashtable(67);

    static {
        String[] keyword = new String[]{"AND", "ALL", "AVG", "BY", "BETWEEN", "COUNT", "CASEWHEN", "DISTINCT", "EXISTS", "EXCEPT", "FALSE", "FROM", "GROUP", "IF", "INTO", "IFNULL", "IS", "IN", "INTERSECT", "INNER", "LEFT", "LIKE", "MAX", "MIN", "NULL", "NOT", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "SELECT", "SET", "SUM", "TO", "TRUE", "UNIQUE", "UNION", "VALUES", "WHERE", "CONVERT", "CAST", "CONCAT", "MINUS", "CALL"};
        int i = 0;
        while (i < keyword.length) {
            hKeyword.put(keyword[i], hKeyword);
            ++i;
        }
    }

    Tokenizer(String s) {
        this.sCommand = s;
        this.iLength = s.length();
        this.iIndex = 0;
    }

    void back() throws SQLException {
        Trace.Assert(!this.bWait, "back");
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.tokenIndex;
        this.bWait = true;
    }

    void getThis(String match) throws SQLException {
        this.getToken();
        if (!this.sToken.equals(match)) {
            throw Trace.error(10, this.sToken);
        }
    }

    String getStringToken() throws SQLException {
        this.getToken();
        if (this.iType == 6) {
            return this.sToken.toUpperCase();
        }
        if (this.iType == 1) {
            return this.sToken;
        }
        if (this.iType == 9) {
            return this.sToken.toUpperCase();
        }
        throw Trace.error(10, this.sToken);
    }

    boolean wasValue() {
        if (this.iType == 6 || this.iType == 4 || this.iType == 5 || this.iType == 7 || this.iType == 8) {
            return true;
        }
        return this.sToken.equals("NULL") || this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }

    boolean wasQuotedIdentifier() {
        return this.iType == 9;
    }

    boolean wasLongName() {
        return this.iType == 2;
    }

    boolean wasName() {
        if (this.iType == 9) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !hKeyword.containsKey(this.sToken);
    }

    String getLongNameFirst() {
        return this.sLongNameFirst;
    }

    String getLongNameLast() {
        return this.sLongNameLast;
    }

    String getName() throws SQLException {
        this.getToken();
        if (!this.wasName()) {
            throw Trace.error(10, this.sToken);
        }
        return this.sToken;
    }

    String getString() throws SQLException {
        this.getToken();
        return this.sToken;
    }

    int getType() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    Object getAsValue() throws SQLException {
        if (!this.wasValue()) {
            throw Trace.error(10, this.sToken);
        }
        if (this.iType == 6) {
            return this.sToken;
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 4) {
            if (this.sToken.length() < 10) {
                return new Integer(this.sToken);
            }
            if (this.sToken.length() == 10) {
                try {
                    return new Integer(this.sToken);
                }
                catch (Exception e1) {
                    this.iType = 7;
                    return new Long(this.sToken);
                }
            }
            if (this.sToken.length() < 19) {
                this.iType = 7;
                return new Long(this.sToken);
            }
            if (this.sToken.length() == 19) {
                try {
                    return new Long(this.sToken);
                }
                catch (Exception e2) {
                    this.iType = 8;
                    return new BigDecimal(this.sToken);
                }
            }
            this.iType = 8;
            return new BigDecimal(this.sToken);
        }
        if (this.iType == 5) {
            return new Double(this.sToken);
        }
        if (this.iType == 8) {
            return new BigDecimal(this.sToken);
        }
        return this.sToken;
    }

    int getPosition() {
        return this.iIndex;
    }

    String getPart(int begin, int end) {
        return this.sCommand.substring(begin, end);
    }

    int getPartMarker() {
        return this.beginIndex;
    }

    void setPartMarker() {
        this.beginIndex = this.iIndex;
    }

    void setPartMarker(int position) {
        this.beginIndex = position;
    }

    String getLastPart() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() throws SQLException {
        if (!this.bWait) ** GOTO lbl6
        this.bWait = false;
        this.iIndex = this.nextTokenIndex;
        return;
lbl-1000:
        // 1 sources

        {
            ++this.iIndex;
lbl6:
            // 2 sources

            ** while (this.iIndex < this.iLength && Character.isWhitespace((char)this.sCommand.charAt((int)this.iIndex)))
        }
lbl7:
        // 1 sources

        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        c = this.sCommand.charAt(this.iIndex);
        point = false;
        digit = false;
        exp = false;
        afterexp = false;
        end = false;
        cfirst = '\u0000';
        if (Character.isJavaIdentifierStart(c)) {
            this.iType = 1;
        } else if (Character.isDigit(c)) {
            this.iType = 4;
            digit = true;
        } else {
            switch (c) {
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '=': {
                    this.iType = 3;
                    ++this.iIndex;
                    this.sToken = String.valueOf(c);
                    return;
                }
                case '\"': {
                    this.iType = 9;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    c = this.sCommand.charAt(this.iIndex);
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        sb = new StringBuffer(this.sLongNameFirst.length() + 1 + this.sLongNameLast.length());
                        sb.append(this.sLongNameFirst);
                        sb.append('.');
                        sb.append(this.sLongNameLast);
                        this.sToken = sb.toString();
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    cfirst = c;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    point = true;
                    break;
                }
                default: {
                    throw Trace.error(10, String.valueOf(c));
                }
            }
        }
        start = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                c = ' ';
                end = true;
                Trace.check(this.iType != 6 && this.iType != 9, 11);
            } else {
                c = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(c)) break;
                    this.sToken = this.sCommand.substring(start, this.iIndex).toUpperCase();
                    if (c == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        this.sToken = String.valueOf(this.sLongNameFirst) + "." + this.sLongNameLast;
                    }
                    return;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 11: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 10: {
                    if (end) {
                        this.iType = 0;
                        return;
                    }
                    if (c != '\r' && c != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (c == '/' && cfirst == '/') {
                        this.iType = 10;
                        break;
                    }
                    if (c == '-' && cfirst == '-') {
                        this.iType = 10;
                        break;
                    }
                    if (c == '*' && cfirst == '/') {
                        this.iType = 11;
                        break;
                    }
                    if (c == '>' || c == '=' || c == '|') break;
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(c)) {
                        digit = true;
                        break;
                    }
                    if (c == '.') {
                        this.iType = 8;
                        if (point) {
                            throw Trace.error(10, ".");
                        }
                        point = true;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        if (exp) {
                            throw Trace.error(10, "E");
                        }
                        this.iType = 5;
                        afterexp = true;
                        point = true;
                        exp = true;
                        break;
                    }
                    if (c == '-' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    if (c == '+' && afterexp) {
                        afterexp = false;
                        break;
                    }
                    afterexp = false;
                    if (!digit) {
                        if (point && start == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(10, String.valueOf(c));
                    }
                    this.sToken = this.sCommand.substring(start, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char quoteChar) throws SQLException {
        try {
            int nextIndex = this.iIndex;
            boolean quoteInside = false;
            while (true) {
                if ((nextIndex = this.sCommand.indexOf(quoteChar, nextIndex)) < 0) {
                    throw Trace.error(11);
                }
                if (nextIndex >= this.iLength - 1 || this.sCommand.charAt(nextIndex + 1) != quoteChar) break;
                quoteInside = true;
                nextIndex += 2;
            }
            char[] chBuffer = new char[nextIndex - this.iIndex];
            this.sCommand.getChars(this.iIndex, nextIndex, chBuffer, 0);
            int j = chBuffer.length;
            if (quoteInside) {
                j = 0;
                int i = 0;
                while (i < chBuffer.length) {
                    if (chBuffer[i] == quoteChar) {
                        ++i;
                    }
                    chBuffer[j] = chBuffer[i];
                    ++i;
                    ++j;
                }
            }
            this.iIndex = ++nextIndex;
            return new String(chBuffer, 0, j);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            e.getMessage();
            return null;
        }
    }

    void setString(String s, int pos) {
        this.sCommand = s;
        this.iLength = s.length();
        this.bWait = false;
        this.iIndex = pos;
    }

    int getLength() {
        return this.iLength;
    }
}

